# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dapp_manager', 'dapp_manager.autocomplete']

package_data = \
{'': ['*'], 'dapp_manager.autocomplete': ['scripts/*']}

install_requires = \
['appdirs>=1.4,<2.0',
 'click>=8.1,<9.0',
 'dapp-runner>=0.0.0a3,<0.0.0',
 'psutil>=5.9,<6.0']

entry_points = \
{'console_scripts': ['dapp-manager = dapp_manager.__main__:main']}

setup_kwargs = {
    'name': 'dapp-manager',
    'version': '0.0.0a3',
    'description': "Golem dapp-manager - run decetralized apps on the Golem Network using a 'docker-compose'-like interface",
    'long_description': '# Golem dApp Manager\n\n`dapp-manager` is a purposefully minimalistic manager for decentralized applications running on\nGolem. It works together with the [dapp-runner](https://github.com/golemfactory/dapp-runner/).\nWhile the responsibility of the latter is to run a single Golem application, `dapp-manager` takes\ncare of spawning, interacting with, and stopping the running instances of the `dapp-runner`.\n\n## Quick start\n\n### Yagna daemon\n\nAs the `dapp-manager` uses the `dapp-runner`, which in turn requires a properly configured\n[yagna](https://github.com/golemfactory/yagna) daemon, you\'ll need to have it set up.\n\nFor now, please follow the ["Requestor development: a quick primer"](https://handbook.golem.network/requestor-tutorials/flash-tutorial-of-requestor-development)\ntutorial and ensure that your `yagna` is up and running. Only the first part of this\ntutorial is required - you don\'t need to run the blender example.\n\nMost importantly, make sure you have set the `YAGNA_APPKEY` in your environment, e.g. with:\n\n```bash\nexport YAGNA_APPKEY=insert-your-32-char-app-key-here\n```\n\nor, on Windows:\n\n```bash\nset YAGNA_APPKEY=insert-your-32-char-app-key-here\n```\n\nand if you don\'t know what your app-key is, you can always query `yagna` with:\n\n```bash\nyagna app-key list\n```\n\n### Python environment\n\nFirst, ensure you have Python 3.8 or later:\n\n```bash\npython3 --version\n```\n\n[ depending on the platform, it may be just `python` instead of `python3` ]\n\nIf your Python version is older, consider using [pyenv](https://github.com/pyenv/pyenv-installer).\n\nOnce your python interpreter reports a version 3.8 or later, you can set up your virtual\nenvironment:\n\n```bash\npython3 -m venv ~/.envs/dapp-manager\nsource ~/.envs/dapp-manager/bin/activate\n```\n\nor, if you\'re on Windows:\n\n```shell\npython -m venv --clear %HOMEDRIVE%%HOMEPATH%\\.envs\\dapp-manager\n%HOMEDRIVE%%HOMEPATH%\\.envs\\dapp-manager\\Scripts\\activate.bat\n```\n\n### DApp manager\n\n#### Clone the repository:\n\n```bash\ngit clone --recurse-submodules https://github.com/golemfactory/dapp-manager.git\n```\n\n#### Install the dependencies\n\n```\ncd dapp-manager\npip install -U pip poetry\npoetry install\n```\n\n#### Run an example application:\n\nMake sure your `yagna` daemon is running,\nyou have initialized the payment driver with `yagna payment init --sender`,\nand that you have set the `YAGNA_APPKEY` environment variable.\n\nThen run:\n\n```bash\ndapp-manager start --config sample_config.yml dapp-store/apps/webapp.yaml\n```\n\nThe app is started in a background `dapp-runner` process, and you\'re returned an application ID in\nthe form of a hexadecimal string. You can use this ID to query the state and other output streams\nusing `dapp-manager`\'s `read` command, e.g.:\n\n```bash\ndapp-manager read state <the-hex-string>\n```\n\nwill display the contents of the `state` stream of the running app:\n\n```\n{"db": {"0": "pending"}}\n{"db": {"0": "starting"}}\n{"db": {"0": "running"}}\n{"db": {"0": "running"}, "http": {"0": "pending"}}\n{"db": {"0": "running"}, "http": {"0": "starting"}}\n```\n\nIn case something goes amiss, `dapp-manager` will output:\n```App <the-hex-string> is not running.```\n\nWhatever the reason, you can still query the various streams of a terminated dapp by adding the\n`--no-ensure-alive` option, e.g.:\n\n```bash\ndapp-manager read stderr <the-hex-string> --no-ensure-alive\n```\n\n## Full usage\n\n```\nUsage: dapp-manager [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  autocomplete  Enable CLI shell completion for the given shell.\n  kill          Stop the given app forcibly.\n  list          List known app IDs (both active and dead).\n  prune         Remove data for non-running apps.\n  read          Read output from the given app.\n  start         Start a new app using the provided descriptor and config...\n  stop          Stop the given app gracefully.\n```\n\n### Start\n\nThe `start` command launches a new instance of the `dapp-runner` in a background process and\nreturns the hexadecimal string that is the identifier of the running `dapp-runner` instance.\n\n```\nUsage: dapp-manager start [OPTIONS] DESCRIPTORS...\n\n  Start a new app using the provided descriptor and config files.\n\nOptions:\n  -c, --config PATH  Path to the file containing yagna-specific config.\n                     [required]\n  --help             Show this message and exit.\n```\n\nImportantly, it requires a config file which contains the parameters used to connect to the `yagna`\ndaemon and initialize the requestor engine. We\'re providing a default, sample configuration as\n`sample_config.yml` in the root of the `dapp-manager` repository.\n\nOf course, it also requires one or more descriptor files that are used by the `dapp-runner` to\ndeploy the specified applications on Golem.\n\n### Stop / Kill\n\nThe `stop` and `kill` commands terminate the given `dapp-runner` instance, the main difference\nbeing the signal that\'s sent to do that. Essentially, `stop` should be enough and should give the\n`dapp-runner` a chance to shut the app down gracefully, correctly terminating the services,\nclosing the agreements and paying for them.\n\nIn case `stop` is stuck for whatever reason, you might want to resort to `kill` which terminates\nthe `dapp-runner` immediately without allowing for any graceful shutdown.\n\n### List\n\nThe `list` command shows the identifiers of all the previously-started apps, whether they\'re still\nrunning or not.\n\n### Prune\n\n`prune` causes `dapp-manager` to remove the data for those apps that it had previously identified as\ndefunct. Consequently, those apps will no longer appear on the list.\n\nUnless an app has been explicitly stopped with a `stop` or `kill` command, the `dapp-manager` \nwill not purge it until it has had a chance to notice the termination, e.g. by issuing a `read` \ncommand to the defunct app.\n\n### Read\n\nThe `read` command outputs the full contents of the specified stream. There are five streams as\nspecified by the usage below:\n\n```\nUsage: dapp-manager read [OPTIONS] COMMAND [ARGS]...\n\n  Read output from the given app.\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  data    Read the data stream of the given app.\n  log     Read the log stream of a given app.\n  state   Read the state stream of the given app.\n  stderr  Read the stderr of a given app.\n  stdout  Read the stdout of a given app.\n```\n\nBy default, the stream will only be output if the app is currently running. Otherwise, you\'ll get\nthe ```App <the-hex-string> is not running.``` message and no stream.\n\nIf you wish to query a stream of a terminated app, add the `--no-ensure-alive` parameter to the\nspecific `read` command.\n\n### Shell completion\n\nThis program supports shell completion for all of its commands, as well as existing dApp IDs (where applicable).\n\nTo enable completion, use the `autocomplete` command with your shell of choice:\n* **bash**:\n    ```\n    $ dapp-manager autocomplete bash\n    ```\n\n* **zsh**:\n    ```\n    $ dapp-manager autocomplete zsh\n    ```\n\n* **fish**:\n    ```\n    $ dapp-manager autocomplete fish\n    ```\n\nThe completion functions are defined in `dapp_manager/autocomplete/scripts`.\n\nShould the entrypoint name ever change, those files will need to be updated as well.\n\n**WARNING** Completion will **NOT WORK** when `autocomplete` is invoked with `python -m dapp_manager`.\nOnly the installed entrypoint (i.e. `dapp-manager`) is supported. To have it available, run `poetry install`.\n',
    'author': 'Golem Factory',
    'author_email': 'contact@golem.network',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/golemfactory/dapp-manager',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
