/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.properties.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropsReplacer {
    private List<String> paths;

    public PropsReplacer(String[] paths) {
        this.paths = Arrays.asList(paths);
    }

    public PropsReplacer replaceProps(String pattern, Properties properties) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String path : this.paths) {
            replaced.add(this.replaceProps(pattern, path, properties));
        }
        this.setPaths(replaced);
        return this;
    }

    private String replaceProps(String pattern, String path, Properties properties) {
        Matcher matcher = Pattern.compile(pattern).matcher(path);
        String replaced = path;
        while (matcher.find()) {
            replaced = replaced.replace(matcher.group(0), properties.getProperty(matcher.group(1), ""));
        }
        return replaced;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public String[] getPathsAsArray() {
        return this.paths.toArray(new String[this.paths.size()]);
    }
}

