import logging  # noqa: INP001
import sqlite3

from .table import QolsysTable

LOGGER = logging.getLogger(__name__)


class QolsysTableQolsysSettings(QolsysTable):

    def __init__(self, db: sqlite3.Connection, cursor: sqlite3.Cursor) -> None:
        super().__init__(db, cursor)
        self._uri = "content://com.qolsys.qolsysprovider.QolsysSettingsProvider/qolsyssettings"
        self._table = "qolsyssettings"
        self._abort_on_error = True
        self._implemented = True


        self._columns = [
            "_id",
            "version",
            "opr",
            "partition_id",
            "name",
            "value",
        ]

        self._create_table()
