# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class WorkbookProtectionRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'password': 'str',
        'protection_type': 'str'
    }

    attribute_map = {
        'password': 'Password',
        'protection_type': 'ProtectionType'
    }
    
    @staticmethod
    def get_swagger_types():
        return WorkbookProtectionRequest.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return WorkbookProtectionRequest.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, password=None, protection_type=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        WorkbookProtectionRequest - a model defined in Swagger
        """

        self.container['password'] = None
        self.container['protection_type'] = None

        if password is not None:
          self.password = password
        if protection_type is not None:
          self.protection_type = protection_type

    @property
    def password(self):
        """
        Gets the password of this WorkbookProtectionRequest.
        Encription password.

        :return: The password of this WorkbookProtectionRequest.
        :rtype: str
        """
        return self.container['password']

    @password.setter
    def password(self, password):
        """
        Sets the password of this WorkbookProtectionRequest.
        Encription password.

        :param password: The password of this WorkbookProtectionRequest.
        :type: str
        """

        self.container['password'] = password

    @property
    def protection_type(self):
        """
        Gets the protection_type of this WorkbookProtectionRequest.
        Protection type. Can be ALL, CONTENTS, NONE, OBJECTS, SCENARIOS, STRUCTURE, WINDOWS  

        :return: The protection_type of this WorkbookProtectionRequest.
        :rtype: str
        """
        return self.container['protection_type']

    @protection_type.setter
    def protection_type(self, protection_type):
        """
        Sets the protection_type of this WorkbookProtectionRequest.
        Protection type. Can be ALL, CONTENTS, NONE, OBJECTS, SCENARIOS, STRUCTURE, WINDOWS  

        :param protection_type: The protection_type of this WorkbookProtectionRequest.
        :type: str
        """

        self.container['protection_type'] = protection_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, WorkbookProtectionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
