# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class Workbook(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'links': 'list[Link]',
        'settings': 'LinkElement',
        'is_protected': 'str',
        'is_write_protected': 'str',
        'file_name': 'str',
        'document_properties': 'LinkElement',
        'names': 'LinkElement',
        'default_style': 'LinkElement',
        'is_encryption': 'str',
        'worksheets': 'LinkElement',
        'password': 'str'
    }

    attribute_map = {
        'links': 'Links',
        'settings': 'Settings',
        'is_protected': 'IsProtected',
        'is_write_protected': 'IsWriteProtected',
        'file_name': 'FileName',
        'document_properties': 'DocumentProperties',
        'names': 'Names',
        'default_style': 'DefaultStyle',
        'is_encryption': 'IsEncryption',
        'worksheets': 'Worksheets',
        'password': 'Password'
    }
    
    @staticmethod
    def get_swagger_types():
        return Workbook.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return Workbook.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, links=None, settings=None, is_protected=None, is_write_protected=None, file_name=None, document_properties=None, names=None, default_style=None, is_encryption=None, worksheets=None, password=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        Workbook - a model defined in Swagger
        """

        self.container['links'] = None
        self.container['settings'] = None
        self.container['is_protected'] = None
        self.container['is_write_protected'] = None
        self.container['file_name'] = None
        self.container['document_properties'] = None
        self.container['names'] = None
        self.container['default_style'] = None
        self.container['is_encryption'] = None
        self.container['worksheets'] = None
        self.container['password'] = None

        if links is not None:
          self.links = links
        if settings is not None:
          self.settings = settings
        if is_protected is not None:
          self.is_protected = is_protected
        if is_write_protected is not None:
          self.is_write_protected = is_write_protected
        if file_name is not None:
          self.file_name = file_name
        if document_properties is not None:
          self.document_properties = document_properties
        if names is not None:
          self.names = names
        if default_style is not None:
          self.default_style = default_style
        if is_encryption is not None:
          self.is_encryption = is_encryption
        if worksheets is not None:
          self.worksheets = worksheets
        if password is not None:
          self.password = password

    @property
    def links(self):
        """
        Gets the links of this Workbook.

        :return: The links of this Workbook.
        :rtype: list[Link]
        """
        return self.container['links']

    @links.setter
    def links(self, links):
        """
        Sets the links of this Workbook.

        :param links: The links of this Workbook.
        :type: list[Link]
        """

        self.container['links'] = links

    @property
    def settings(self):
        """
        Gets the settings of this Workbook.

        :return: The settings of this Workbook.
        :rtype: LinkElement
        """
        return self.container['settings']

    @settings.setter
    def settings(self, settings):
        """
        Sets the settings of this Workbook.

        :param settings: The settings of this Workbook.
        :type: LinkElement
        """

        self.container['settings'] = settings

    @property
    def is_protected(self):
        """
        Gets the is_protected of this Workbook.

        :return: The is_protected of this Workbook.
        :rtype: str
        """
        return self.container['is_protected']

    @is_protected.setter
    def is_protected(self, is_protected):
        """
        Sets the is_protected of this Workbook.

        :param is_protected: The is_protected of this Workbook.
        :type: str
        """

        self.container['is_protected'] = is_protected

    @property
    def is_write_protected(self):
        """
        Gets the is_write_protected of this Workbook.

        :return: The is_write_protected of this Workbook.
        :rtype: str
        """
        return self.container['is_write_protected']

    @is_write_protected.setter
    def is_write_protected(self, is_write_protected):
        """
        Sets the is_write_protected of this Workbook.

        :param is_write_protected: The is_write_protected of this Workbook.
        :type: str
        """

        self.container['is_write_protected'] = is_write_protected

    @property
    def file_name(self):
        """
        Gets the file_name of this Workbook.

        :return: The file_name of this Workbook.
        :rtype: str
        """
        return self.container['file_name']

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this Workbook.

        :param file_name: The file_name of this Workbook.
        :type: str
        """

        self.container['file_name'] = file_name

    @property
    def document_properties(self):
        """
        Gets the document_properties of this Workbook.

        :return: The document_properties of this Workbook.
        :rtype: LinkElement
        """
        return self.container['document_properties']

    @document_properties.setter
    def document_properties(self, document_properties):
        """
        Sets the document_properties of this Workbook.

        :param document_properties: The document_properties of this Workbook.
        :type: LinkElement
        """

        self.container['document_properties'] = document_properties

    @property
    def names(self):
        """
        Gets the names of this Workbook.

        :return: The names of this Workbook.
        :rtype: LinkElement
        """
        return self.container['names']

    @names.setter
    def names(self, names):
        """
        Sets the names of this Workbook.

        :param names: The names of this Workbook.
        :type: LinkElement
        """

        self.container['names'] = names

    @property
    def default_style(self):
        """
        Gets the default_style of this Workbook.

        :return: The default_style of this Workbook.
        :rtype: LinkElement
        """
        return self.container['default_style']

    @default_style.setter
    def default_style(self, default_style):
        """
        Sets the default_style of this Workbook.

        :param default_style: The default_style of this Workbook.
        :type: LinkElement
        """

        self.container['default_style'] = default_style

    @property
    def is_encryption(self):
        """
        Gets the is_encryption of this Workbook.

        :return: The is_encryption of this Workbook.
        :rtype: str
        """
        return self.container['is_encryption']

    @is_encryption.setter
    def is_encryption(self, is_encryption):
        """
        Sets the is_encryption of this Workbook.

        :param is_encryption: The is_encryption of this Workbook.
        :type: str
        """

        self.container['is_encryption'] = is_encryption

    @property
    def worksheets(self):
        """
        Gets the worksheets of this Workbook.

        :return: The worksheets of this Workbook.
        :rtype: LinkElement
        """
        return self.container['worksheets']

    @worksheets.setter
    def worksheets(self, worksheets):
        """
        Sets the worksheets of this Workbook.

        :param worksheets: The worksheets of this Workbook.
        :type: LinkElement
        """

        self.container['worksheets'] = worksheets

    @property
    def password(self):
        """
        Gets the password of this Workbook.

        :return: The password of this Workbook.
        :rtype: str
        """
        return self.container['password']

    @password.setter
    def password(self, password):
        """
        Sets the password of this Workbook.

        :param password: The password of this Workbook.
        :type: str
        """

        self.container['password'] = password

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Workbook):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
