# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re
from . import SaveOptions

class SpreadsheetML2003SaveOptions(SaveOptions):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'export_column_index_of_cell': 'bool',
        'is_indented_formatting': 'bool',
        'limit_as_xls': 'bool'
    }

    attribute_map = {
        'export_column_index_of_cell': 'ExportColumnIndexOfCell',
        'is_indented_formatting': 'IsIndentedFormatting',
        'limit_as_xls': 'LimitAsXls'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(SpreadsheetML2003SaveOptions.swagger_types, **SaveOptions.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(SpreadsheetML2003SaveOptions.attribute_map, **SaveOptions.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, export_column_index_of_cell=None, is_indented_formatting=None, limit_as_xls=None, **kw):
        super(SpreadsheetML2003SaveOptions, self).__init__(**kw)
		    
        """
        SpreadsheetML2003SaveOptions - a model defined in Swagger
        """

        self.container['export_column_index_of_cell'] = None
        self.container['is_indented_formatting'] = None
        self.container['limit_as_xls'] = None

        if export_column_index_of_cell is not None:
          self.export_column_index_of_cell = export_column_index_of_cell
        if is_indented_formatting is not None:
          self.is_indented_formatting = is_indented_formatting
        if limit_as_xls is not None:
          self.limit_as_xls = limit_as_xls

    @property
    def export_column_index_of_cell(self):
        """
        Gets the export_column_index_of_cell of this SpreadsheetML2003SaveOptions.

        :return: The export_column_index_of_cell of this SpreadsheetML2003SaveOptions.
        :rtype: bool
        """
        return self.container['export_column_index_of_cell']

    @export_column_index_of_cell.setter
    def export_column_index_of_cell(self, export_column_index_of_cell):
        """
        Sets the export_column_index_of_cell of this SpreadsheetML2003SaveOptions.

        :param export_column_index_of_cell: The export_column_index_of_cell of this SpreadsheetML2003SaveOptions.
        :type: bool
        """

        self.container['export_column_index_of_cell'] = export_column_index_of_cell

    @property
    def is_indented_formatting(self):
        """
        Gets the is_indented_formatting of this SpreadsheetML2003SaveOptions.

        :return: The is_indented_formatting of this SpreadsheetML2003SaveOptions.
        :rtype: bool
        """
        return self.container['is_indented_formatting']

    @is_indented_formatting.setter
    def is_indented_formatting(self, is_indented_formatting):
        """
        Sets the is_indented_formatting of this SpreadsheetML2003SaveOptions.

        :param is_indented_formatting: The is_indented_formatting of this SpreadsheetML2003SaveOptions.
        :type: bool
        """

        self.container['is_indented_formatting'] = is_indented_formatting

    @property
    def limit_as_xls(self):
        """
        Gets the limit_as_xls of this SpreadsheetML2003SaveOptions.

        :return: The limit_as_xls of this SpreadsheetML2003SaveOptions.
        :rtype: bool
        """
        return self.container['limit_as_xls']

    @limit_as_xls.setter
    def limit_as_xls(self, limit_as_xls):
        """
        Sets the limit_as_xls of this SpreadsheetML2003SaveOptions.

        :param limit_as_xls: The limit_as_xls of this SpreadsheetML2003SaveOptions.
        :type: bool
        """

        self.container['limit_as_xls'] = limit_as_xls

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SpreadsheetML2003SaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
