# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class SaveResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source_document': 'Link',
        'dest_document': 'Link',
        'additional_items': 'list[Link]'
    }

    attribute_map = {
        'source_document': 'SourceDocument',
        'dest_document': 'DestDocument',
        'additional_items': 'AdditionalItems'
    }
    
    @staticmethod
    def get_swagger_types():
        return SaveResult.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return SaveResult.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, source_document=None, dest_document=None, additional_items=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        SaveResult - a model defined in Swagger
        """

        self.container['source_document'] = None
        self.container['dest_document'] = None
        self.container['additional_items'] = None

        if source_document is not None:
          self.source_document = source_document
        if dest_document is not None:
          self.dest_document = dest_document
        if additional_items is not None:
          self.additional_items = additional_items

    @property
    def source_document(self):
        """
        Gets the source_document of this SaveResult.

        :return: The source_document of this SaveResult.
        :rtype: Link
        """
        return self.container['source_document']

    @source_document.setter
    def source_document(self, source_document):
        """
        Sets the source_document of this SaveResult.

        :param source_document: The source_document of this SaveResult.
        :type: Link
        """

        self.container['source_document'] = source_document

    @property
    def dest_document(self):
        """
        Gets the dest_document of this SaveResult.

        :return: The dest_document of this SaveResult.
        :rtype: Link
        """
        return self.container['dest_document']

    @dest_document.setter
    def dest_document(self, dest_document):
        """
        Sets the dest_document of this SaveResult.

        :param dest_document: The dest_document of this SaveResult.
        :type: Link
        """

        self.container['dest_document'] = dest_document

    @property
    def additional_items(self):
        """
        Gets the additional_items of this SaveResult.

        :return: The additional_items of this SaveResult.
        :rtype: list[Link]
        """
        return self.container['additional_items']

    @additional_items.setter
    def additional_items(self, additional_items):
        """
        Sets the additional_items of this SaveResult.

        :param additional_items: The additional_items of this SaveResult.
        :type: list[Link]
        """

        self.container['additional_items'] = additional_items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SaveResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
