# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class FormatCondition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'link': 'Link',
        'above_average': 'AboveAverage',
        'formula2': 'str',
        'style': 'Style',
        'formula1': 'str',
        'color_scale': 'ColorScale',
        'data_bar': 'DataBar',
        'text': 'str',
        'stop_if_true': 'bool',
        'priority': 'int',
        'top10': 'Top10',
        'operator': 'str',
        'icon_set': 'IconSet',
        'type': 'str',
        'time_period': 'str'
    }

    attribute_map = {
        'link': 'link',
        'above_average': 'AboveAverage',
        'formula2': 'Formula2',
        'style': 'Style',
        'formula1': 'Formula1',
        'color_scale': 'ColorScale',
        'data_bar': 'DataBar',
        'text': 'Text',
        'stop_if_true': 'StopIfTrue',
        'priority': 'Priority',
        'top10': 'Top10',
        'operator': 'Operator',
        'icon_set': 'IconSet',
        'type': 'Type',
        'time_period': 'TimePeriod'
    }
    
    @staticmethod
    def get_swagger_types():
        return FormatCondition.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return FormatCondition.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, link=None, above_average=None, formula2=None, style=None, formula1=None, color_scale=None, data_bar=None, text=None, stop_if_true=None, priority=None, top10=None, operator=None, icon_set=None, type=None, time_period=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        FormatCondition - a model defined in Swagger
        """

        self.container['link'] = None
        self.container['above_average'] = None
        self.container['formula2'] = None
        self.container['style'] = None
        self.container['formula1'] = None
        self.container['color_scale'] = None
        self.container['data_bar'] = None
        self.container['text'] = None
        self.container['stop_if_true'] = None
        self.container['priority'] = None
        self.container['top10'] = None
        self.container['operator'] = None
        self.container['icon_set'] = None
        self.container['type'] = None
        self.container['time_period'] = None

        if link is not None:
          self.link = link
        if above_average is not None:
          self.above_average = above_average
        if formula2 is not None:
          self.formula2 = formula2
        if style is not None:
          self.style = style
        if formula1 is not None:
          self.formula1 = formula1
        if color_scale is not None:
          self.color_scale = color_scale
        if data_bar is not None:
          self.data_bar = data_bar
        if text is not None:
          self.text = text
        if stop_if_true is not None:
          self.stop_if_true = stop_if_true
        if priority is not None:
          self.priority = priority
        if top10 is not None:
          self.top10 = top10
        if operator is not None:
          self.operator = operator
        if icon_set is not None:
          self.icon_set = icon_set
        if type is not None:
          self.type = type
        if time_period is not None:
          self.time_period = time_period

    @property
    def link(self):
        """
        Gets the link of this FormatCondition.

        :return: The link of this FormatCondition.
        :rtype: Link
        """
        return self.container['link']

    @link.setter
    def link(self, link):
        """
        Sets the link of this FormatCondition.

        :param link: The link of this FormatCondition.
        :type: Link
        """

        self.container['link'] = link

    @property
    def above_average(self):
        """
        Gets the above_average of this FormatCondition.

        :return: The above_average of this FormatCondition.
        :rtype: AboveAverage
        """
        return self.container['above_average']

    @above_average.setter
    def above_average(self, above_average):
        """
        Sets the above_average of this FormatCondition.

        :param above_average: The above_average of this FormatCondition.
        :type: AboveAverage
        """

        self.container['above_average'] = above_average

    @property
    def formula2(self):
        """
        Gets the formula2 of this FormatCondition.

        :return: The formula2 of this FormatCondition.
        :rtype: str
        """
        return self.container['formula2']

    @formula2.setter
    def formula2(self, formula2):
        """
        Sets the formula2 of this FormatCondition.

        :param formula2: The formula2 of this FormatCondition.
        :type: str
        """

        self.container['formula2'] = formula2

    @property
    def style(self):
        """
        Gets the style of this FormatCondition.

        :return: The style of this FormatCondition.
        :rtype: Style
        """
        return self.container['style']

    @style.setter
    def style(self, style):
        """
        Sets the style of this FormatCondition.

        :param style: The style of this FormatCondition.
        :type: Style
        """

        self.container['style'] = style

    @property
    def formula1(self):
        """
        Gets the formula1 of this FormatCondition.

        :return: The formula1 of this FormatCondition.
        :rtype: str
        """
        return self.container['formula1']

    @formula1.setter
    def formula1(self, formula1):
        """
        Sets the formula1 of this FormatCondition.

        :param formula1: The formula1 of this FormatCondition.
        :type: str
        """

        self.container['formula1'] = formula1

    @property
    def color_scale(self):
        """
        Gets the color_scale of this FormatCondition.

        :return: The color_scale of this FormatCondition.
        :rtype: ColorScale
        """
        return self.container['color_scale']

    @color_scale.setter
    def color_scale(self, color_scale):
        """
        Sets the color_scale of this FormatCondition.

        :param color_scale: The color_scale of this FormatCondition.
        :type: ColorScale
        """

        self.container['color_scale'] = color_scale

    @property
    def data_bar(self):
        """
        Gets the data_bar of this FormatCondition.

        :return: The data_bar of this FormatCondition.
        :rtype: DataBar
        """
        return self.container['data_bar']

    @data_bar.setter
    def data_bar(self, data_bar):
        """
        Sets the data_bar of this FormatCondition.

        :param data_bar: The data_bar of this FormatCondition.
        :type: DataBar
        """

        self.container['data_bar'] = data_bar

    @property
    def text(self):
        """
        Gets the text of this FormatCondition.

        :return: The text of this FormatCondition.
        :rtype: str
        """
        return self.container['text']

    @text.setter
    def text(self, text):
        """
        Sets the text of this FormatCondition.

        :param text: The text of this FormatCondition.
        :type: str
        """

        self.container['text'] = text

    @property
    def stop_if_true(self):
        """
        Gets the stop_if_true of this FormatCondition.
        True, no rules with lower priority may be applied over this rule, when this     rule evaluates to true.  Only applies for Excel 2007;

        :return: The stop_if_true of this FormatCondition.
        :rtype: bool
        """
        return self.container['stop_if_true']

    @stop_if_true.setter
    def stop_if_true(self, stop_if_true):
        """
        Sets the stop_if_true of this FormatCondition.
        True, no rules with lower priority may be applied over this rule, when this     rule evaluates to true.  Only applies for Excel 2007;

        :param stop_if_true: The stop_if_true of this FormatCondition.
        :type: bool
        """

        self.container['stop_if_true'] = stop_if_true

    @property
    def priority(self):
        """
        Gets the priority of this FormatCondition.
        The priority of this conditional formatting rule. This value is used to determine     which format should be evaluated and rendered. Lower numeric values are higher     priority than higher numeric values, where '1' is the highest priority.

        :return: The priority of this FormatCondition.
        :rtype: int
        """
        return self.container['priority']

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this FormatCondition.
        The priority of this conditional formatting rule. This value is used to determine     which format should be evaluated and rendered. Lower numeric values are higher     priority than higher numeric values, where '1' is the highest priority.

        :param priority: The priority of this FormatCondition.
        :type: int
        """

        self.container['priority'] = priority

    @property
    def top10(self):
        """
        Gets the top10 of this FormatCondition.

        :return: The top10 of this FormatCondition.
        :rtype: Top10
        """
        return self.container['top10']

    @top10.setter
    def top10(self, top10):
        """
        Sets the top10 of this FormatCondition.

        :param top10: The top10 of this FormatCondition.
        :type: Top10
        """

        self.container['top10'] = top10

    @property
    def operator(self):
        """
        Gets the operator of this FormatCondition.

        :return: The operator of this FormatCondition.
        :rtype: str
        """
        return self.container['operator']

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this FormatCondition.

        :param operator: The operator of this FormatCondition.
        :type: str
        """

        self.container['operator'] = operator

    @property
    def icon_set(self):
        """
        Gets the icon_set of this FormatCondition.

        :return: The icon_set of this FormatCondition.
        :rtype: IconSet
        """
        return self.container['icon_set']

    @icon_set.setter
    def icon_set(self, icon_set):
        """
        Sets the icon_set of this FormatCondition.

        :param icon_set: The icon_set of this FormatCondition.
        :type: IconSet
        """

        self.container['icon_set'] = icon_set

    @property
    def type(self):
        """
        Gets the type of this FormatCondition.
        Gets and sets whether the conditional format Type.             

        :return: The type of this FormatCondition.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this FormatCondition.
        Gets and sets whether the conditional format Type.             

        :param type: The type of this FormatCondition.
        :type: str
        """

        self.container['type'] = type

    @property
    def time_period(self):
        """
        Gets the time_period of this FormatCondition.

        :return: The time_period of this FormatCondition.
        :rtype: str
        """
        return self.container['time_period']

    @time_period.setter
    def time_period(self, time_period):
        """
        Sets the time_period of this FormatCondition.

        :param time_period: The time_period of this FormatCondition.
        :type: str
        """

        self.container['time_period'] = time_period

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FormatCondition):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
