# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class FillFormat(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'texture_fill': 'TextureFill',
        'image_data': 'str',
        'pattern_fill': 'PatternFill',
        'solid_fill': 'SolidFill',
        'gradient_fill': 'GradientFill',
        'type': 'str'
    }

    attribute_map = {
        'texture_fill': 'TextureFill',
        'image_data': 'ImageData',
        'pattern_fill': 'PatternFill',
        'solid_fill': 'SolidFill',
        'gradient_fill': 'GradientFill',
        'type': 'Type'
    }
    
    @staticmethod
    def get_swagger_types():
        return FillFormat.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return FillFormat.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, texture_fill=None, image_data=None, pattern_fill=None, solid_fill=None, gradient_fill=None, type=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        FillFormat - a model defined in Swagger
        """

        self.container['texture_fill'] = None
        self.container['image_data'] = None
        self.container['pattern_fill'] = None
        self.container['solid_fill'] = None
        self.container['gradient_fill'] = None
        self.container['type'] = None

        if texture_fill is not None:
          self.texture_fill = texture_fill
        if image_data is not None:
          self.image_data = image_data
        if pattern_fill is not None:
          self.pattern_fill = pattern_fill
        if solid_fill is not None:
          self.solid_fill = solid_fill
        if gradient_fill is not None:
          self.gradient_fill = gradient_fill
        if type is not None:
          self.type = type

    @property
    def texture_fill(self):
        """
        Gets the texture_fill of this FillFormat.

        :return: The texture_fill of this FillFormat.
        :rtype: TextureFill
        """
        return self.container['texture_fill']

    @texture_fill.setter
    def texture_fill(self, texture_fill):
        """
        Sets the texture_fill of this FillFormat.

        :param texture_fill: The texture_fill of this FillFormat.
        :type: TextureFill
        """

        self.container['texture_fill'] = texture_fill

    @property
    def image_data(self):
        """
        Gets the image_data of this FillFormat.

        :return: The image_data of this FillFormat.
        :rtype: str
        """
        return self.container['image_data']

    @image_data.setter
    def image_data(self, image_data):
        """
        Sets the image_data of this FillFormat.

        :param image_data: The image_data of this FillFormat.
        :type: str
        """
        if image_data is not None and not re.search('^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', image_data):
            raise ValueError("Invalid value for `image_data`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")

        self.container['image_data'] = image_data

    @property
    def pattern_fill(self):
        """
        Gets the pattern_fill of this FillFormat.

        :return: The pattern_fill of this FillFormat.
        :rtype: PatternFill
        """
        return self.container['pattern_fill']

    @pattern_fill.setter
    def pattern_fill(self, pattern_fill):
        """
        Sets the pattern_fill of this FillFormat.

        :param pattern_fill: The pattern_fill of this FillFormat.
        :type: PatternFill
        """

        self.container['pattern_fill'] = pattern_fill

    @property
    def solid_fill(self):
        """
        Gets the solid_fill of this FillFormat.

        :return: The solid_fill of this FillFormat.
        :rtype: SolidFill
        """
        return self.container['solid_fill']

    @solid_fill.setter
    def solid_fill(self, solid_fill):
        """
        Sets the solid_fill of this FillFormat.

        :param solid_fill: The solid_fill of this FillFormat.
        :type: SolidFill
        """

        self.container['solid_fill'] = solid_fill

    @property
    def gradient_fill(self):
        """
        Gets the gradient_fill of this FillFormat.

        :return: The gradient_fill of this FillFormat.
        :rtype: GradientFill
        """
        return self.container['gradient_fill']

    @gradient_fill.setter
    def gradient_fill(self, gradient_fill):
        """
        Sets the gradient_fill of this FillFormat.

        :param gradient_fill: The gradient_fill of this FillFormat.
        :type: GradientFill
        """

        self.container['gradient_fill'] = gradient_fill

    @property
    def type(self):
        """
        Gets the type of this FillFormat.

        :return: The type of this FillFormat.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this FillFormat.

        :param type: The type of this FillFormat.
        :type: str
        """

        self.container['type'] = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FillFormat):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
