# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from pprint import pformat
from six import iteritems
import re


class ConditionalFormattingIcon(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'index': 'int',
        'type': 'str',
        'image_data': 'str'
    }

    attribute_map = {
        'index': 'Index',
        'type': 'Type',
        'image_data': 'ImageData'
    }
    
    @staticmethod
    def get_swagger_types():
        return ConditionalFormattingIcon.swagger_types
    
    @staticmethod
    def get_attribute_map():
        return ConditionalFormattingIcon.attribute_map
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, index=None, type=None, image_data=None, **kw):
        """
        Associative dict for storing property values
        """
        self.container = {}
		    
        """
        ConditionalFormattingIcon - a model defined in Swagger
        """

        self.container['index'] = None
        self.container['type'] = None
        self.container['image_data'] = None

        if index is not None:
          self.index = index
        if type is not None:
          self.type = type
        if image_data is not None:
          self.image_data = image_data

    @property
    def index(self):
        """
        Gets the index of this ConditionalFormattingIcon.
        Gets and sets the icon's index in the icon set.             

        :return: The index of this ConditionalFormattingIcon.
        :rtype: int
        """
        return self.container['index']

    @index.setter
    def index(self, index):
        """
        Sets the index of this ConditionalFormattingIcon.
        Gets and sets the icon's index in the icon set.             

        :param index: The index of this ConditionalFormattingIcon.
        :type: int
        """

        self.container['index'] = index

    @property
    def type(self):
        """
        Gets the type of this ConditionalFormattingIcon.
        Gets and sets the icon set type.             

        :return: The type of this ConditionalFormattingIcon.
        :rtype: str
        """
        return self.container['type']

    @type.setter
    def type(self, type):
        """
        Sets the type of this ConditionalFormattingIcon.
        Gets and sets the icon set type.             

        :param type: The type of this ConditionalFormattingIcon.
        :type: str
        """

        self.container['type'] = type

    @property
    def image_data(self):
        """
        Gets the image_data of this ConditionalFormattingIcon.
        Gets the icon set data.             

        :return: The image_data of this ConditionalFormattingIcon.
        :rtype: str
        """
        return self.container['image_data']

    @image_data.setter
    def image_data(self, image_data):
        """
        Sets the image_data of this ConditionalFormattingIcon.
        Gets the icon set data.             

        :param image_data: The image_data of this ConditionalFormattingIcon.
        :type: str
        """
        if image_data is not None and not re.search('^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$', image_data):
            raise ValueError("Invalid value for `image_data`, must be a follow pattern or equal to `/^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{2}==|[A-Za-z0-9+\/]{3}=)?$/`")

        self.container['image_data'] = image_data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConditionalFormattingIcon):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
