# coding: utf-8

"""
Copyright (c) 2020 Aspose.Cells Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all 
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
"""


from __future__ import absolute_import

import sys
import os
import re
import time

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class CellsApi(object):

    def __init__(self,appsid, appkey, version='v3.0', api_client=None):
        self.appsid = appsid
        self.appkey = appkey
        self.version = version 
        self.api_client =  ApiClient('https://api.aspose.cloud')
        self.access_token = self.api_client.get_access_token("client_credentials", appsid, appkey,version)
        # self.auth_data = self.o_auth_post("client_credentials", appsid, appkey)
        config = Configuration()
        if version == 'v1.1':
            config.host = "https://api.aspose.cloud/v1.1"
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
        self.api_client.set_default_header("Authorization", "Bearer " + self.access_token)
        self.get_access_token_time = time.clock()
        # self.api_client.set_default_header("Authorization", "Bearer " + self.auth_data.access_token)

    def check_access_token(self):
        if self.access_token:
            timediff = time.clock() - self.get_access_token_time
            if timediff > 86300 :
                api_client =  ApiClient('https://api.aspose.cloud')
                self.access_token = api_client.get_access_token("client_credentials", self.appsid, self.appkey,self.version)
                self.api_client.set_default_header("Authorization", "Bearer " + self.access_token)
                self.get_access_token_time = time.clock()

    def cells_auto_filter_delete_worksheet_date_filter(self, name, sheet_name, field_index, date_time_grouping_type, **kwargs):
        """
        Removes a date filter.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_delete_worksheet_date_filter(name, sheet_name, field_index, date_time_grouping_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str date_time_grouping_type: (required)
        :param int year:
        :param int month:
        :param int day:
        :param int hour:
        :param int minute:
        :param int second:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_delete_worksheet_date_filter_with_http_info(name, sheet_name, field_index, date_time_grouping_type, **kwargs)
        else:
            (data) = self.cells_auto_filter_delete_worksheet_date_filter_with_http_info(name, sheet_name, field_index, date_time_grouping_type, **kwargs)
            return data

    def cells_auto_filter_delete_worksheet_date_filter_with_http_info(self, name, sheet_name, field_index, date_time_grouping_type, **kwargs):
        """
        Removes a date filter.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_delete_worksheet_date_filter_with_http_info(name, sheet_name, field_index, date_time_grouping_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str date_time_grouping_type: (required)
        :param int year:
        :param int month:
        :param int day:
        :param int hour:
        :param int minute:
        :param int second:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'field_index', 'date_time_grouping_type', 'year', 'month', 'day', 'hour', 'minute', 'second', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_delete_worksheet_date_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_delete_worksheet_date_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_delete_worksheet_date_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_delete_worksheet_date_filter`")
        # verify the required parameter 'date_time_grouping_type' is set
        if ('date_time_grouping_type' not in params) or (params['date_time_grouping_type'] is None):
            raise ValueError("Missing the required parameter `date_time_grouping_type` when calling `cells_auto_filter_delete_worksheet_date_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'date_time_grouping_type' in params:
            query_params.append(('dateTimeGroupingType', params['date_time_grouping_type']))
        if 'year' in params:
            query_params.append(('year', params['year']))
        if 'month' in params:
            query_params.append(('month', params['month']))
        if 'day' in params:
            query_params.append(('day', params['day']))
        if 'hour' in params:
            query_params.append(('hour', params['hour']))
        if 'minute' in params:
            query_params.append(('minute', params['minute']))
        if 'second' in params:
            query_params.append(('second', params['second']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_delete_worksheet_filter(self, name, sheet_name, field_index, **kwargs):
        """
        Delete a filter for a filter column.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_delete_worksheet_filter(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str criteria:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_delete_worksheet_filter_with_http_info(name, sheet_name, field_index, **kwargs)
        else:
            (data) = self.cells_auto_filter_delete_worksheet_filter_with_http_info(name, sheet_name, field_index, **kwargs)
            return data

    def cells_auto_filter_delete_worksheet_filter_with_http_info(self, name, sheet_name, field_index, **kwargs):
        """
        Delete a filter for a filter column.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_delete_worksheet_filter_with_http_info(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str criteria:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'field_index', 'criteria', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_delete_worksheet_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_delete_worksheet_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_delete_worksheet_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_delete_worksheet_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'criteria' in params:
            query_params.append(('criteria', params['criteria']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/filter', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_get_worksheet_auto_filter(self, name, sheet_name, **kwargs):
        """
        Get Auto filter Description
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_get_worksheet_auto_filter(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: AutoFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_get_worksheet_auto_filter_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_auto_filter_get_worksheet_auto_filter_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_auto_filter_get_worksheet_auto_filter_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get Auto filter Description
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_get_worksheet_auto_filter_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: AutoFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_get_worksheet_auto_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_get_worksheet_auto_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_get_worksheet_auto_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AutoFilterResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_post_worksheet_auto_filter_refresh(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_auto_filter_refresh(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_post_worksheet_auto_filter_refresh_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_auto_filter_post_worksheet_auto_filter_refresh_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_auto_filter_post_worksheet_auto_filter_refresh_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_auto_filter_refresh_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_post_worksheet_auto_filter_refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_post_worksheet_auto_filter_refresh`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_post_worksheet_auto_filter_refresh`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/refresh', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_post_worksheet_match_blanks(self, name, sheet_name, field_index, **kwargs):
        """
        Match all blank cell in the list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_match_blanks(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_post_worksheet_match_blanks_with_http_info(name, sheet_name, field_index, **kwargs)
        else:
            (data) = self.cells_auto_filter_post_worksheet_match_blanks_with_http_info(name, sheet_name, field_index, **kwargs)
            return data

    def cells_auto_filter_post_worksheet_match_blanks_with_http_info(self, name, sheet_name, field_index, **kwargs):
        """
        Match all blank cell in the list.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_match_blanks_with_http_info(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'field_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_post_worksheet_match_blanks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_post_worksheet_match_blanks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_post_worksheet_match_blanks`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_post_worksheet_match_blanks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/matchBlanks', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_post_worksheet_match_non_blanks(self, name, sheet_name, field_index, **kwargs):
        """
        Match all not blank cell in the list.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_match_non_blanks(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_post_worksheet_match_non_blanks_with_http_info(name, sheet_name, field_index, **kwargs)
        else:
            (data) = self.cells_auto_filter_post_worksheet_match_non_blanks_with_http_info(name, sheet_name, field_index, **kwargs)
            return data

    def cells_auto_filter_post_worksheet_match_non_blanks_with_http_info(self, name, sheet_name, field_index, **kwargs):
        """
        Match all not blank cell in the list.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_post_worksheet_match_non_blanks_with_http_info(name, sheet_name, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int field_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'field_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_post_worksheet_match_non_blanks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_post_worksheet_match_non_blanks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_post_worksheet_match_non_blanks`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_post_worksheet_match_non_blanks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/matchNonBlanks', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_color_filter(self, name, sheet_name, range, field_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_color_filter(name, sheet_name, range, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param ColorFilterRequest color_filter:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_color_filter_with_http_info(name, sheet_name, range, field_index, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_color_filter_with_http_info(name, sheet_name, range, field_index, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_color_filter_with_http_info(self, name, sheet_name, range, field_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_color_filter_with_http_info(name, sheet_name, range, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param ColorFilterRequest color_filter:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'color_filter', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_color_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_color_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_color_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_color_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_color_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'color_filter' in params:
            body_params = params['color_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/colorFilter', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_custom_filter(self, name, sheet_name, range, field_index, operator_type1, criteria1, **kwargs):
        """
        Filters a list with a custom criteria.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_custom_filter(name, sheet_name, range, field_index, operator_type1, criteria1, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str operator_type1: (required)
        :param str criteria1: (required)
        :param bool is_and:
        :param str operator_type2:
        :param str criteria2:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_custom_filter_with_http_info(name, sheet_name, range, field_index, operator_type1, criteria1, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_custom_filter_with_http_info(name, sheet_name, range, field_index, operator_type1, criteria1, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_custom_filter_with_http_info(self, name, sheet_name, range, field_index, operator_type1, criteria1, **kwargs):
        """
        Filters a list with a custom criteria.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_custom_filter_with_http_info(name, sheet_name, range, field_index, operator_type1, criteria1, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str operator_type1: (required)
        :param str criteria1: (required)
        :param bool is_and:
        :param str operator_type2:
        :param str criteria2:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'operator_type1', 'criteria1', 'is_and', 'operator_type2', 'criteria2', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_custom_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_custom_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_custom_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_custom_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_custom_filter`")
        # verify the required parameter 'operator_type1' is set
        if ('operator_type1' not in params) or (params['operator_type1'] is None):
            raise ValueError("Missing the required parameter `operator_type1` when calling `cells_auto_filter_put_worksheet_custom_filter`")
        # verify the required parameter 'criteria1' is set
        if ('criteria1' not in params) or (params['criteria1'] is None):
            raise ValueError("Missing the required parameter `criteria1` when calling `cells_auto_filter_put_worksheet_custom_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'operator_type1' in params:
            query_params.append(('operatorType1', params['operator_type1']))
        if 'criteria1' in params:
            query_params.append(('criteria1', params['criteria1']))
        if 'is_and' in params:
            query_params.append(('isAnd', params['is_and']))
        if 'operator_type2' in params:
            query_params.append(('operatorType2', params['operator_type2']))
        if 'criteria2' in params:
            query_params.append(('criteria2', params['criteria2']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/custom', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_date_filter(self, name, sheet_name, range, field_index, date_time_grouping_type, **kwargs):
        """
        add date filter in worksheet 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_date_filter(name, sheet_name, range, field_index, date_time_grouping_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str date_time_grouping_type: (required)
        :param int year:
        :param int month:
        :param int day:
        :param int hour:
        :param int minute:
        :param int second:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_date_filter_with_http_info(name, sheet_name, range, field_index, date_time_grouping_type, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_date_filter_with_http_info(name, sheet_name, range, field_index, date_time_grouping_type, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_date_filter_with_http_info(self, name, sheet_name, range, field_index, date_time_grouping_type, **kwargs):
        """
        add date filter in worksheet 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_date_filter_with_http_info(name, sheet_name, range, field_index, date_time_grouping_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str date_time_grouping_type: (required)
        :param int year:
        :param int month:
        :param int day:
        :param int hour:
        :param int minute:
        :param int second:
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'date_time_grouping_type', 'year', 'month', 'day', 'hour', 'minute', 'second', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_date_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_date_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_date_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_date_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_date_filter`")
        # verify the required parameter 'date_time_grouping_type' is set
        if ('date_time_grouping_type' not in params) or (params['date_time_grouping_type'] is None):
            raise ValueError("Missing the required parameter `date_time_grouping_type` when calling `cells_auto_filter_put_worksheet_date_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'date_time_grouping_type' in params:
            query_params.append(('dateTimeGroupingType', params['date_time_grouping_type']))
        if 'year' in params:
            query_params.append(('year', params['year']))
        if 'month' in params:
            query_params.append(('month', params['month']))
        if 'day' in params:
            query_params.append(('day', params['day']))
        if 'hour' in params:
            query_params.append(('hour', params['hour']))
        if 'minute' in params:
            query_params.append(('minute', params['minute']))
        if 'second' in params:
            query_params.append(('second', params['second']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/dateFilter', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_dynamic_filter(self, name, sheet_name, range, field_index, dynamic_filter_type, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_dynamic_filter(name, sheet_name, range, field_index, dynamic_filter_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str dynamic_filter_type: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_dynamic_filter_with_http_info(name, sheet_name, range, field_index, dynamic_filter_type, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_dynamic_filter_with_http_info(name, sheet_name, range, field_index, dynamic_filter_type, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_dynamic_filter_with_http_info(self, name, sheet_name, range, field_index, dynamic_filter_type, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_dynamic_filter_with_http_info(name, sheet_name, range, field_index, dynamic_filter_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str dynamic_filter_type: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'dynamic_filter_type', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_dynamic_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_dynamic_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_dynamic_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_dynamic_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_dynamic_filter`")
        # verify the required parameter 'dynamic_filter_type' is set
        if ('dynamic_filter_type' not in params) or (params['dynamic_filter_type'] is None):
            raise ValueError("Missing the required parameter `dynamic_filter_type` when calling `cells_auto_filter_put_worksheet_dynamic_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'dynamic_filter_type' in params:
            query_params.append(('dynamicFilterType', params['dynamic_filter_type']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/dynamicFilter', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_filter(self, name, sheet_name, range, field_index, criteria, **kwargs):
        """
        Adds a filter for a filter column.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_filter(name, sheet_name, range, field_index, criteria, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str criteria: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_filter_with_http_info(name, sheet_name, range, field_index, criteria, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_filter_with_http_info(name, sheet_name, range, field_index, criteria, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_filter_with_http_info(self, name, sheet_name, range, field_index, criteria, **kwargs):
        """
        Adds a filter for a filter column.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_filter_with_http_info(name, sheet_name, range, field_index, criteria, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str criteria: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'criteria', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_filter`")
        # verify the required parameter 'criteria' is set
        if ('criteria' not in params) or (params['criteria'] is None):
            raise ValueError("Missing the required parameter `criteria` when calling `cells_auto_filter_put_worksheet_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'criteria' in params:
            query_params.append(('criteria', params['criteria']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/filter', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_filter_top10(self, name, sheet_name, range, field_index, is_top, is_percent, item_count, **kwargs):
        """
        Filter the top 10 item in the list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_filter_top10(name, sheet_name, range, field_index, is_top, is_percent, item_count, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param bool is_top: (required)
        :param bool is_percent: (required)
        :param int item_count: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_filter_top10_with_http_info(name, sheet_name, range, field_index, is_top, is_percent, item_count, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_filter_top10_with_http_info(name, sheet_name, range, field_index, is_top, is_percent, item_count, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_filter_top10_with_http_info(self, name, sheet_name, range, field_index, is_top, is_percent, item_count, **kwargs):
        """
        Filter the top 10 item in the list
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_filter_top10_with_http_info(name, sheet_name, range, field_index, is_top, is_percent, item_count, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param bool is_top: (required)
        :param bool is_percent: (required)
        :param int item_count: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'is_top', 'is_percent', 'item_count', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_filter_top10" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'is_top' is set
        if ('is_top' not in params) or (params['is_top'] is None):
            raise ValueError("Missing the required parameter `is_top` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'is_percent' is set
        if ('is_percent' not in params) or (params['is_percent'] is None):
            raise ValueError("Missing the required parameter `is_percent` when calling `cells_auto_filter_put_worksheet_filter_top10`")
        # verify the required parameter 'item_count' is set
        if ('item_count' not in params) or (params['item_count'] is None):
            raise ValueError("Missing the required parameter `item_count` when calling `cells_auto_filter_put_worksheet_filter_top10`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'is_top' in params:
            query_params.append(('isTop', params['is_top']))
        if 'is_percent' in params:
            query_params.append(('isPercent', params['is_percent']))
        if 'item_count' in params:
            query_params.append(('itemCount', params['item_count']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/filterTop10', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_auto_filter_put_worksheet_icon_filter(self, name, sheet_name, range, field_index, icon_set_type, icon_id, **kwargs):
        """
        Adds an icon filter.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_icon_filter(name, sheet_name, range, field_index, icon_set_type, icon_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str icon_set_type: (required)
        :param int icon_id: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_auto_filter_put_worksheet_icon_filter_with_http_info(name, sheet_name, range, field_index, icon_set_type, icon_id, **kwargs)
        else:
            (data) = self.cells_auto_filter_put_worksheet_icon_filter_with_http_info(name, sheet_name, range, field_index, icon_set_type, icon_id, **kwargs)
            return data

    def cells_auto_filter_put_worksheet_icon_filter_with_http_info(self, name, sheet_name, range, field_index, icon_set_type, icon_id, **kwargs):
        """
        Adds an icon filter.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_auto_filter_put_worksheet_icon_filter_with_http_info(name, sheet_name, range, field_index, icon_set_type, icon_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str range: (required)
        :param int field_index: (required)
        :param str icon_set_type: (required)
        :param int icon_id: (required)
        :param bool match_blanks:
        :param bool refresh:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'field_index', 'icon_set_type', 'icon_id', 'match_blanks', 'refresh', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_auto_filter_put_worksheet_icon_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_auto_filter_put_worksheet_icon_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_auto_filter_put_worksheet_icon_filter`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_auto_filter_put_worksheet_icon_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_auto_filter_put_worksheet_icon_filter`")
        # verify the required parameter 'icon_set_type' is set
        if ('icon_set_type' not in params) or (params['icon_set_type'] is None):
            raise ValueError("Missing the required parameter `icon_set_type` when calling `cells_auto_filter_put_worksheet_icon_filter`")
        # verify the required parameter 'icon_id' is set
        if ('icon_id' not in params) or (params['icon_id'] is None):
            raise ValueError("Missing the required parameter `icon_id` when calling `cells_auto_filter_put_worksheet_icon_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'icon_set_type' in params:
            query_params.append(('iconSetType', params['icon_set_type']))
        if 'icon_id' in params:
            query_params.append(('iconId', params['icon_id']))
        if 'match_blanks' in params:
            query_params.append(('matchBlanks', params['match_blanks']))
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoFilter/iconFilter', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_autoshapes_get_worksheet_autoshape(self, name, sheet_name, autoshape_number, **kwargs):
        """
        Get autoshape info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_autoshapes_get_worksheet_autoshape(name, sheet_name, autoshape_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int autoshape_number: The autoshape number. (required)
        :param str format: Exported format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_autoshapes_get_worksheet_autoshape_with_http_info(name, sheet_name, autoshape_number, **kwargs)
        else:
            (data) = self.cells_autoshapes_get_worksheet_autoshape_with_http_info(name, sheet_name, autoshape_number, **kwargs)
            return data

    def cells_autoshapes_get_worksheet_autoshape_with_http_info(self, name, sheet_name, autoshape_number, **kwargs):
        """
        Get autoshape info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_autoshapes_get_worksheet_autoshape_with_http_info(name, sheet_name, autoshape_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int autoshape_number: The autoshape number. (required)
        :param str format: Exported format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'autoshape_number', 'format', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_autoshapes_get_worksheet_autoshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_autoshapes_get_worksheet_autoshape`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_autoshapes_get_worksheet_autoshape`")
        # verify the required parameter 'autoshape_number' is set
        if ('autoshape_number' not in params) or (params['autoshape_number'] is None):
            raise ValueError("Missing the required parameter `autoshape_number` when calling `cells_autoshapes_get_worksheet_autoshape`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'autoshape_number' in params:
            path_params['autoshapeNumber'] = params['autoshape_number']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoshapes/{autoshapeNumber}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_autoshapes_get_worksheet_autoshapes(self, name, sheet_name, **kwargs):
        """
        Get worksheet autoshapes info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_autoshapes_get_worksheet_autoshapes(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: AutoShapesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_autoshapes_get_worksheet_autoshapes_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_autoshapes_get_worksheet_autoshapes_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_autoshapes_get_worksheet_autoshapes_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet autoshapes info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_autoshapes_get_worksheet_autoshapes_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: AutoShapesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_autoshapes_get_worksheet_autoshapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_autoshapes_get_worksheet_autoshapes`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_autoshapes_get_worksheet_autoshapes`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/autoshapes', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AutoShapesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_chart_area_get_chart_area(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: ChartAreaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_chart_area_get_chart_area_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_chart_area_get_chart_area_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_chart_area_get_chart_area_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: ChartAreaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_chart_area_get_chart_area" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_chart_area_get_chart_area`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_chart_area_get_chart_area`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_chart_area_get_chart_area`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChartAreaResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_chart_area_get_chart_area_border(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area border info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area_border(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: LineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_chart_area_get_chart_area_border_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_chart_area_get_chart_area_border_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_chart_area_get_chart_area_border_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area border info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area_border_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: LineResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_chart_area_get_chart_area_border" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_chart_area_get_chart_area_border`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_chart_area_get_chart_area_border`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_chart_area_get_chart_area_border`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/border', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LineResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_chart_area_get_chart_area_fill_format(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area fill format info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area_fill_format(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: FillFormatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_chart_area_get_chart_area_fill_format_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_chart_area_get_chart_area_fill_format_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_chart_area_get_chart_area_fill_format_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart area fill format info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_chart_area_get_chart_area_fill_format_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: FillFormatResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_chart_area_get_chart_area_fill_format" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_chart_area_get_chart_area_fill_format`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_chart_area_get_chart_area_fill_format`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_chart_area_get_chart_area_fill_format`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/chartArea/fillFormat', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FillFormatResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_delete_worksheet_chart_legend(self, name, sheet_name, chart_index, **kwargs):
        """
        Hide legend in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_chart_legend(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_delete_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_delete_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_delete_worksheet_chart_legend_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Hide legend in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_delete_worksheet_chart_legend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_delete_worksheet_chart_legend`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_delete_worksheet_chart_legend`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_delete_worksheet_chart_legend`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_delete_worksheet_chart_title(self, name, sheet_name, chart_index, **kwargs):
        """
        Hide title in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_chart_title(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_delete_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_delete_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_delete_worksheet_chart_title_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Hide title in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_delete_worksheet_chart_title" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_delete_worksheet_chart_title`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_delete_worksheet_chart_title`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_delete_worksheet_chart_title`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_delete_worksheet_clear_charts(self, name, sheet_name, **kwargs):
        """
        Clear the charts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_clear_charts(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_delete_worksheet_clear_charts_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_charts_delete_worksheet_clear_charts_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_charts_delete_worksheet_clear_charts_with_http_info(self, name, sheet_name, **kwargs):
        """
        Clear the charts.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_clear_charts_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_delete_worksheet_clear_charts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_delete_worksheet_clear_charts`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_delete_worksheet_clear_charts`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_delete_worksheet_delete_chart(self, name, sheet_name, chart_index, **kwargs):
        """
        Delete worksheet chart by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_delete_chart(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_delete_worksheet_delete_chart_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_delete_worksheet_delete_chart_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_delete_worksheet_delete_chart_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Delete worksheet chart by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_delete_worksheet_delete_chart_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_delete_worksheet_delete_chart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_delete_worksheet_delete_chart`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_delete_worksheet_delete_chart`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_delete_worksheet_delete_chart`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChartsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_get_worksheet_chart(self, name, sheet_name, chart_number, **kwargs):
        """
        Get chart info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart(name, sheet_name, chart_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_number: The chart number. (required)
        :param str format: The exported file format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_get_worksheet_chart_with_http_info(name, sheet_name, chart_number, **kwargs)
        else:
            (data) = self.cells_charts_get_worksheet_chart_with_http_info(name, sheet_name, chart_number, **kwargs)
            return data

    def cells_charts_get_worksheet_chart_with_http_info(self, name, sheet_name, chart_number, **kwargs):
        """
        Get chart info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart_with_http_info(name, sheet_name, chart_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_number: The chart number. (required)
        :param str format: The exported file format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_number', 'format', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_get_worksheet_chart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_get_worksheet_chart`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_get_worksheet_chart`")
        # verify the required parameter 'chart_number' is set
        if ('chart_number' not in params) or (params['chart_number'] is None):
            raise ValueError("Missing the required parameter `chart_number` when calling `cells_charts_get_worksheet_chart`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_number' in params:
            path_params['chartNumber'] = params['chart_number']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartNumber}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_get_worksheet_chart_legend(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart legend
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart_legend(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: LegendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_get_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_get_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_get_worksheet_chart_legend_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart legend
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: LegendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_get_worksheet_chart_legend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_get_worksheet_chart_legend`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_get_worksheet_chart_legend`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_get_worksheet_chart_legend`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LegendResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_get_worksheet_chart_title(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart title
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart_title(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_get_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_get_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_get_worksheet_chart_title_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Get chart title
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_get_worksheet_chart_title" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_get_worksheet_chart_title`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_get_worksheet_chart_title`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_get_worksheet_chart_title`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TitleResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_get_worksheet_charts(self, name, sheet_name, **kwargs):
        """
        Get worksheet charts info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_charts(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_get_worksheet_charts_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_charts_get_worksheet_charts_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_charts_get_worksheet_charts_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet charts info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_get_worksheet_charts_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_get_worksheet_charts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_get_worksheet_charts`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_get_worksheet_charts`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChartsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_post_worksheet_chart(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart propreties
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int chart_index: (required)
        :param Chart chart:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_post_worksheet_chart_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_post_worksheet_chart_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_post_worksheet_chart_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart propreties
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int chart_index: (required)
        :param Chart chart:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'chart', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_post_worksheet_chart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_post_worksheet_chart`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_post_worksheet_chart`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_post_worksheet_chart`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'chart' in params:
            body_params = params['chart']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_post_worksheet_chart_legend(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart legend
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart_legend(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Legend legend:
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: LegendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_post_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_post_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_post_worksheet_chart_legend_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart legend
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Legend legend:
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: LegendResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'legend', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_post_worksheet_chart_legend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_post_worksheet_chart_legend`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_post_worksheet_chart_legend`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_post_worksheet_chart_legend`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'legend' in params:
            body_params = params['legend']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='LegendResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_post_worksheet_chart_title(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart title
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart_title(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Title title: Chart title
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_post_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_post_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_post_worksheet_chart_title_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Update chart title
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_post_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Title title: Chart title
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'title', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_post_worksheet_chart_title" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_post_worksheet_chart_title`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_post_worksheet_chart_title`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_post_worksheet_chart_title`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'title' in params:
            body_params = params['title']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TitleResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_put_worksheet_add_chart(self, name, sheet_name, chart_type, **kwargs):
        """
        Add new chart to worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_add_chart(name, sheet_name, chart_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str chart_type: Chart type, please refer property Type in chart resource. (required)
        :param int upper_left_row: New chart upper left row.
        :param int upper_left_column: New chart upperleft column.
        :param int lower_right_row: New chart lower right row.
        :param int lower_right_column: New chart lower right column.
        :param str area: Specifies values from which to plot the data series. 
        :param bool is_vertical: Specifies whether to plot the series from a range of cell values by row or by column. 
        :param str category_data: Gets or sets the range of category Axis values. It can be a range of cells (such as, \"d1:e10\"). 
        :param bool is_auto_get_serial_name: Specifies whether auto update serial name. 
        :param str title: Specifies chart title name.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_put_worksheet_add_chart_with_http_info(name, sheet_name, chart_type, **kwargs)
        else:
            (data) = self.cells_charts_put_worksheet_add_chart_with_http_info(name, sheet_name, chart_type, **kwargs)
            return data

    def cells_charts_put_worksheet_add_chart_with_http_info(self, name, sheet_name, chart_type, **kwargs):
        """
        Add new chart to worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_add_chart_with_http_info(name, sheet_name, chart_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str chart_type: Chart type, please refer property Type in chart resource. (required)
        :param int upper_left_row: New chart upper left row.
        :param int upper_left_column: New chart upperleft column.
        :param int lower_right_row: New chart lower right row.
        :param int lower_right_column: New chart lower right column.
        :param str area: Specifies values from which to plot the data series. 
        :param bool is_vertical: Specifies whether to plot the series from a range of cell values by row or by column. 
        :param str category_data: Gets or sets the range of category Axis values. It can be a range of cells (such as, \"d1:e10\"). 
        :param bool is_auto_get_serial_name: Specifies whether auto update serial name. 
        :param str title: Specifies chart title name.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ChartsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_type', 'upper_left_row', 'upper_left_column', 'lower_right_row', 'lower_right_column', 'area', 'is_vertical', 'category_data', 'is_auto_get_serial_name', 'title', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_put_worksheet_add_chart" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_put_worksheet_add_chart`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_put_worksheet_add_chart`")
        # verify the required parameter 'chart_type' is set
        if ('chart_type' not in params) or (params['chart_type'] is None):
            raise ValueError("Missing the required parameter `chart_type` when calling `cells_charts_put_worksheet_add_chart`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'chart_type' in params:
            query_params.append(('chartType', params['chart_type']))
        if 'upper_left_row' in params:
            query_params.append(('upperLeftRow', params['upper_left_row']))
        if 'upper_left_column' in params:
            query_params.append(('upperLeftColumn', params['upper_left_column']))
        if 'lower_right_row' in params:
            query_params.append(('lowerRightRow', params['lower_right_row']))
        if 'lower_right_column' in params:
            query_params.append(('lowerRightColumn', params['lower_right_column']))
        if 'area' in params:
            query_params.append(('area', params['area']))
        if 'is_vertical' in params:
            query_params.append(('isVertical', params['is_vertical']))
        if 'category_data' in params:
            query_params.append(('categoryData', params['category_data']))
        if 'is_auto_get_serial_name' in params:
            query_params.append(('isAutoGetSerialName', params['is_auto_get_serial_name']))
        if 'title' in params:
            query_params.append(('title', params['title']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ChartsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_put_worksheet_chart_legend(self, name, sheet_name, chart_index, **kwargs):
        """
        Show legend in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_chart_legend(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_put_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_put_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_put_worksheet_chart_legend_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Show legend in chart
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_chart_legend_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_put_worksheet_chart_legend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_put_worksheet_chart_legend`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_put_worksheet_chart_legend`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_put_worksheet_chart_legend`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/legend', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_charts_put_worksheet_chart_title(self, name, sheet_name, chart_index, **kwargs):
        """
        Add chart title / Set chart title visible
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_chart_title(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Title title: Chart title.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_charts_put_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
        else:
            (data) = self.cells_charts_put_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, **kwargs)
            return data

    def cells_charts_put_worksheet_chart_title_with_http_info(self, name, sheet_name, chart_index, **kwargs):
        """
        Add chart title / Set chart title visible
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_charts_put_worksheet_chart_title_with_http_info(name, sheet_name, chart_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int chart_index: The chart index. (required)
        :param Title title: Chart title.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: TitleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'chart_index', 'title', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_charts_put_worksheet_chart_title" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_charts_put_worksheet_chart_title`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_charts_put_worksheet_chart_title`")
        # verify the required parameter 'chart_index' is set
        if ('chart_index' not in params) or (params['chart_index'] is None):
            raise ValueError("Missing the required parameter `chart_index` when calling `cells_charts_put_worksheet_chart_title`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'chart_index' in params:
            path_params['chartIndex'] = params['chart_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'title' in params:
            body_params = params['title']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/charts/{chartIndex}/title', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TitleResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_delete_worksheet_conditional_formatting(self, name, sheet_name, index, **kwargs):
        """
        Remove conditional formatting
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formatting(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_delete_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_delete_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_conditional_formattings_delete_worksheet_conditional_formatting_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        Remove conditional formatting
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_delete_worksheet_conditional_formatting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_delete_worksheet_conditional_formatting_area(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Remove cell area from conditional formatting.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formatting_area(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int start_row: (required)
        :param int start_column: (required)
        :param int total_rows: (required)
        :param int total_columns: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_delete_worksheet_conditional_formatting_area_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_delete_worksheet_conditional_formatting_area_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
            return data

    def cells_conditional_formattings_delete_worksheet_conditional_formatting_area_with_http_info(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Remove cell area from conditional formatting.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formatting_area_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int start_row: (required)
        :param int start_column: (required)
        :param int total_rows: (required)
        :param int total_columns: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'start_row', 'start_column', 'total_rows', 'total_columns', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_delete_worksheet_conditional_formatting_area" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")
        # verify the required parameter 'start_row' is set
        if ('start_row' not in params) or (params['start_row'] is None):
            raise ValueError("Missing the required parameter `start_row` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")
        # verify the required parameter 'start_column' is set
        if ('start_column' not in params) or (params['start_column'] is None):
            raise ValueError("Missing the required parameter `start_column` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_conditional_formattings_delete_worksheet_conditional_formatting_area`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/area', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_delete_worksheet_conditional_formattings(self, name, sheet_name, **kwargs):
        """
        Clear all condition formattings
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formattings(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_delete_worksheet_conditional_formattings_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_delete_worksheet_conditional_formattings_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_conditional_formattings_delete_worksheet_conditional_formattings_with_http_info(self, name, sheet_name, **kwargs):
        """
        Clear all condition formattings
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_delete_worksheet_conditional_formattings_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_delete_worksheet_conditional_formattings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formattings`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_delete_worksheet_conditional_formattings`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_get_worksheet_conditional_formatting(self, name, sheet_name, index, **kwargs):
        """
        Get conditional formatting
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_get_worksheet_conditional_formatting(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: ConditionalFormattingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_get_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_get_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_conditional_formattings_get_worksheet_conditional_formatting_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        Get conditional formatting
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_get_worksheet_conditional_formatting_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: ConditionalFormattingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_get_worksheet_conditional_formatting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_get_worksheet_conditional_formatting`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_get_worksheet_conditional_formatting`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_conditional_formattings_get_worksheet_conditional_formatting`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ConditionalFormattingResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_get_worksheet_conditional_formattings(self, name, sheet_name, **kwargs):
        """
        Get conditional formattings 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_get_worksheet_conditional_formattings(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: ConditionalFormattingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_get_worksheet_conditional_formattings_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_get_worksheet_conditional_formattings_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_conditional_formattings_get_worksheet_conditional_formattings_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get conditional formattings 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_get_worksheet_conditional_formattings_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: ConditionalFormattingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_get_worksheet_conditional_formattings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_get_worksheet_conditional_formattings`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_get_worksheet_conditional_formattings`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ConditionalFormattingsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_put_worksheet_conditional_formatting(self, name, sheet_name, cell_area, **kwargs):
        """
        Add a condition formatting.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_conditional_formatting(name, sheet_name, cell_area, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_area: (required)
        :param FormatCondition format_condition:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_put_worksheet_conditional_formatting_with_http_info(name, sheet_name, cell_area, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_put_worksheet_conditional_formatting_with_http_info(name, sheet_name, cell_area, **kwargs)
            return data

    def cells_conditional_formattings_put_worksheet_conditional_formatting_with_http_info(self, name, sheet_name, cell_area, **kwargs):
        """
        Add a condition formatting.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_conditional_formatting_with_http_info(name, sheet_name, cell_area, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_area: (required)
        :param FormatCondition format_condition:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_area', 'format_condition', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_put_worksheet_conditional_formatting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_put_worksheet_conditional_formatting`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_put_worksheet_conditional_formatting`")
        # verify the required parameter 'cell_area' is set
        if ('cell_area' not in params) or (params['cell_area'] is None):
            raise ValueError("Missing the required parameter `cell_area` when calling `cells_conditional_formattings_put_worksheet_conditional_formatting`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'cell_area' in params:
            query_params.append(('cellArea', params['cell_area']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'format_condition' in params:
            body_params = params['format_condition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_put_worksheet_format_condition(self, name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, **kwargs):
        """
        Add a format condition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition(name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str cell_area: (required)
        :param str type: (required)
        :param str operator_type: (required)
        :param str formula1: (required)
        :param str formula2: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_put_worksheet_format_condition_with_http_info(name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_put_worksheet_format_condition_with_http_info(name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, **kwargs)
            return data

    def cells_conditional_formattings_put_worksheet_format_condition_with_http_info(self, name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, **kwargs):
        """
        Add a format condition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition_with_http_info(name, sheet_name, index, cell_area, type, operator_type, formula1, formula2, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str cell_area: (required)
        :param str type: (required)
        :param str operator_type: (required)
        :param str formula1: (required)
        :param str formula2: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'cell_area', 'type', 'operator_type', 'formula1', 'formula2', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_put_worksheet_format_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'cell_area' is set
        if ('cell_area' not in params) or (params['cell_area'] is None):
            raise ValueError("Missing the required parameter `cell_area` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'operator_type' is set
        if ('operator_type' not in params) or (params['operator_type'] is None):
            raise ValueError("Missing the required parameter `operator_type` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'formula1' is set
        if ('formula1' not in params) or (params['formula1'] is None):
            raise ValueError("Missing the required parameter `formula1` when calling `cells_conditional_formattings_put_worksheet_format_condition`")
        # verify the required parameter 'formula2' is set
        if ('formula2' not in params) or (params['formula2'] is None):
            raise ValueError("Missing the required parameter `formula2` when calling `cells_conditional_formattings_put_worksheet_format_condition`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'cell_area' in params:
            query_params.append(('cellArea', params['cell_area']))
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'operator_type' in params:
            query_params.append(('operatorType', params['operator_type']))
        if 'formula1' in params:
            query_params.append(('formula1', params['formula1']))
        if 'formula2' in params:
            query_params.append(('formula2', params['formula2']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_put_worksheet_format_condition_area(self, name, sheet_name, index, cell_area, **kwargs):
        """
        add a cell area for format condition             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition_area(name, sheet_name, index, cell_area, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str cell_area: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_put_worksheet_format_condition_area_with_http_info(name, sheet_name, index, cell_area, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_put_worksheet_format_condition_area_with_http_info(name, sheet_name, index, cell_area, **kwargs)
            return data

    def cells_conditional_formattings_put_worksheet_format_condition_area_with_http_info(self, name, sheet_name, index, cell_area, **kwargs):
        """
        add a cell area for format condition             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition_area_with_http_info(name, sheet_name, index, cell_area, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str cell_area: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'cell_area', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_put_worksheet_format_condition_area" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_put_worksheet_format_condition_area`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_put_worksheet_format_condition_area`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_conditional_formattings_put_worksheet_format_condition_area`")
        # verify the required parameter 'cell_area' is set
        if ('cell_area' not in params) or (params['cell_area'] is None):
            raise ValueError("Missing the required parameter `cell_area` when calling `cells_conditional_formattings_put_worksheet_format_condition_area`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'cell_area' in params:
            query_params.append(('cellArea', params['cell_area']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/area', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_conditional_formattings_put_worksheet_format_condition_condition(self, name, sheet_name, index, type, operator_type, formula1, formula2, **kwargs):
        """
        Add a condition for format condition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition_condition(name, sheet_name, index, type, operator_type, formula1, formula2, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str type: (required)
        :param str operator_type: (required)
        :param str formula1: (required)
        :param str formula2: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_conditional_formattings_put_worksheet_format_condition_condition_with_http_info(name, sheet_name, index, type, operator_type, formula1, formula2, **kwargs)
        else:
            (data) = self.cells_conditional_formattings_put_worksheet_format_condition_condition_with_http_info(name, sheet_name, index, type, operator_type, formula1, formula2, **kwargs)
            return data

    def cells_conditional_formattings_put_worksheet_format_condition_condition_with_http_info(self, name, sheet_name, index, type, operator_type, formula1, formula2, **kwargs):
        """
        Add a condition for format condition.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_conditional_formattings_put_worksheet_format_condition_condition_with_http_info(name, sheet_name, index, type, operator_type, formula1, formula2, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str type: (required)
        :param str operator_type: (required)
        :param str formula1: (required)
        :param str formula2: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'type', 'operator_type', 'formula1', 'formula2', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_conditional_formattings_put_worksheet_format_condition_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'operator_type' is set
        if ('operator_type' not in params) or (params['operator_type'] is None):
            raise ValueError("Missing the required parameter `operator_type` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'formula1' is set
        if ('formula1' not in params) or (params['formula1'] is None):
            raise ValueError("Missing the required parameter `formula1` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")
        # verify the required parameter 'formula2' is set
        if ('formula2' not in params) or (params['formula2'] is None):
            raise ValueError("Missing the required parameter `formula2` when calling `cells_conditional_formattings_put_worksheet_format_condition_condition`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'operator_type' in params:
            query_params.append(('operatorType', params['operator_type']))
        if 'formula1' in params:
            query_params.append(('formula1', params['formula1']))
        if 'formula2' in params:
            query_params.append(('formula2', params['formula2']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/condition', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_delete_worksheet_columns(self, name, sheet_name, column_index, columns, update_reference, **kwargs):
        """
        Delete worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_columns(name, sheet_name, column_index, columns, update_reference, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param int columns: The columns. (required)
        :param bool update_reference: The update reference. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_delete_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, update_reference, **kwargs)
        else:
            (data) = self.cells_delete_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, update_reference, **kwargs)
            return data

    def cells_delete_worksheet_columns_with_http_info(self, name, sheet_name, column_index, columns, update_reference, **kwargs):
        """
        Delete worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, update_reference, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param int columns: The columns. (required)
        :param bool update_reference: The update reference. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column_index', 'columns', 'update_reference', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_delete_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_delete_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_delete_worksheet_columns`")
        # verify the required parameter 'column_index' is set
        if ('column_index' not in params) or (params['column_index'] is None):
            raise ValueError("Missing the required parameter `column_index` when calling `cells_delete_worksheet_columns`")
        # verify the required parameter 'columns' is set
        if ('columns' not in params) or (params['columns'] is None):
            raise ValueError("Missing the required parameter `columns` when calling `cells_delete_worksheet_columns`")
        # verify the required parameter 'update_reference' is set
        if ('update_reference' not in params) or (params['update_reference'] is None):
            raise ValueError("Missing the required parameter `update_reference` when calling `cells_delete_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'column_index' in params:
            path_params['columnIndex'] = params['column_index']

        query_params = []
        if 'columns' in params:
            query_params.append(('columns', params['columns']))
        if 'update_reference' in params:
            query_params.append(('updateReference', params['update_reference']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ColumnsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_delete_worksheet_row(self, name, sheet_name, row_index, **kwargs):
        """
        Delete worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_row(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet bame. (required)
        :param int row_index: The row index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_delete_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
        else:
            (data) = self.cells_delete_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
            return data

    def cells_delete_worksheet_row_with_http_info(self, name, sheet_name, row_index, **kwargs):
        """
        Delete worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_row_with_http_info(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet bame. (required)
        :param int row_index: The row index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_delete_worksheet_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_delete_worksheet_row`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_delete_worksheet_row`")
        # verify the required parameter 'row_index' is set
        if ('row_index' not in params) or (params['row_index'] is None):
            raise ValueError("Missing the required parameter `row_index` when calling `cells_delete_worksheet_row`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'row_index' in params:
            path_params['rowIndex'] = params['row_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_delete_worksheet_rows(self, name, sheet_name, startrow, **kwargs):
        """
        Delete several worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_rows(name, sheet_name, startrow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet bame. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated.
        :param bool update_reference: Indicates if update references in other worksheets.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_delete_worksheet_rows_with_http_info(name, sheet_name, startrow, **kwargs)
        else:
            (data) = self.cells_delete_worksheet_rows_with_http_info(name, sheet_name, startrow, **kwargs)
            return data

    def cells_delete_worksheet_rows_with_http_info(self, name, sheet_name, startrow, **kwargs):
        """
        Delete several worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_delete_worksheet_rows_with_http_info(name, sheet_name, startrow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet bame. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated.
        :param bool update_reference: Indicates if update references in other worksheets.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'startrow', 'total_rows', 'update_reference', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_delete_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_delete_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_delete_worksheet_rows`")
        # verify the required parameter 'startrow' is set
        if ('startrow' not in params) or (params['startrow'] is None):
            raise ValueError("Missing the required parameter `startrow` when calling `cells_delete_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'startrow' in params:
            query_params.append(('startrow', params['startrow']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'update_reference' in params:
            query_params.append(('updateReference', params['update_reference']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_cell_html_string(self, name, sheet_name, cell_name, **kwargs):
        """
        Read cell data by cell's name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_cell_html_string(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell's  name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_cell_html_string_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_get_cell_html_string_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_get_cell_html_string_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Read cell data by cell's name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_cell_html_string_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell's  name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_cell_html_string" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_cell_html_string`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_cell_html_string`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_get_cell_html_string`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_cell(self, name, sheet_name, cell_or_method_name, **kwargs):
        """
        Read cell data by cell's name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cell(name, sheet_name, cell_or_method_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_or_method_name: The cell's or method name. (Method name like firstcell, endcell etc.) (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_cell_with_http_info(name, sheet_name, cell_or_method_name, **kwargs)
        else:
            (data) = self.cells_get_worksheet_cell_with_http_info(name, sheet_name, cell_or_method_name, **kwargs)
            return data

    def cells_get_worksheet_cell_with_http_info(self, name, sheet_name, cell_or_method_name, **kwargs):
        """
        Read cell data by cell's name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cell_with_http_info(name, sheet_name, cell_or_method_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_or_method_name: The cell's or method name. (Method name like firstcell, endcell etc.) (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_or_method_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_cell" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_cell`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_cell`")
        # verify the required parameter 'cell_or_method_name' is set
        if ('cell_or_method_name' not in params) or (params['cell_or_method_name'] is None):
            raise ValueError("Missing the required parameter `cell_or_method_name` when calling `cells_get_worksheet_cell`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_or_method_name' in params:
            path_params['cellOrMethodName'] = params['cell_or_method_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellOrMethodName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_cell_style(self, name, sheet_name, cell_name, **kwargs):
        """
        Read cell's style info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cell_style(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: Cell's name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: StyleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_get_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_get_worksheet_cell_style_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Read cell's style info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: Cell's name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: StyleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_cell_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_cell_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_cell_style`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_get_worksheet_cell_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StyleResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_cells(self, name, sheet_name, **kwargs):
        """
        Get cells info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cells(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int offest: Begginig offset.
        :param int count: Maximum amount of cells in the response.
        :param str folder: Document's folder name.
        :param str storage: storage name.
        :return: CellsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_cells_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_get_worksheet_cells_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_get_worksheet_cells_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get cells info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_cells_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int offest: Begginig offset.
        :param int count: Maximum amount of cells in the response.
        :param str folder: Document's folder name.
        :param str storage: storage name.
        :return: CellsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'offest', 'count', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_cells" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_cells`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_cells`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'offest' in params:
            query_params.append(('offest', params['offest']))
        if 'count' in params:
            query_params.append(('count', params['count']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_column(self, name, sheet_name, column_index, **kwargs):
        """
        Read worksheet column data by column's index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_column(name, sheet_name, column_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_column_with_http_info(name, sheet_name, column_index, **kwargs)
        else:
            (data) = self.cells_get_worksheet_column_with_http_info(name, sheet_name, column_index, **kwargs)
            return data

    def cells_get_worksheet_column_with_http_info(self, name, sheet_name, column_index, **kwargs):
        """
        Read worksheet column data by column's index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_column_with_http_info(name, sheet_name, column_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_column" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_column`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_column`")
        # verify the required parameter 'column_index' is set
        if ('column_index' not in params) or (params['column_index'] is None):
            raise ValueError("Missing the required parameter `column_index` when calling `cells_get_worksheet_column`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'column_index' in params:
            path_params['columnIndex'] = params['column_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ColumnResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_columns(self, name, sheet_name, **kwargs):
        """
        Read worksheet columns info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_columns(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workdook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_columns_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_get_worksheet_columns_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_get_worksheet_columns_with_http_info(self, name, sheet_name, **kwargs):
        """
        Read worksheet columns info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_columns_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workdook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ColumnsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_row(self, name, sheet_name, row_index, **kwargs):
        """
        Read worksheet row data by row's index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_row(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
        else:
            (data) = self.cells_get_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
            return data

    def cells_get_worksheet_row_with_http_info(self, name, sheet_name, row_index, **kwargs):
        """
        Read worksheet row data by row's index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_row_with_http_info(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_row`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_row`")
        # verify the required parameter 'row_index' is set
        if ('row_index' not in params) or (params['row_index'] is None):
            raise ValueError("Missing the required parameter `row_index` when calling `cells_get_worksheet_row`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'row_index' in params:
            path_params['rowIndex'] = params['row_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RowResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_get_worksheet_rows(self, name, sheet_name, **kwargs):
        """
        Read worksheet rows info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_rows(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workdook folder.
        :param str storage: storage name.
        :return: RowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_get_worksheet_rows_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_get_worksheet_rows_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_get_worksheet_rows_with_http_info(self, name, sheet_name, **kwargs):
        """
        Read worksheet rows info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_get_worksheet_rows_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: The workdook folder.
        :param str storage: storage name.
        :return: RowsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_get_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_get_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_get_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RowsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_delete_worksheet_hyperlink(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Delete worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_delete_worksheet_hyperlink(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_delete_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
        else:
            (data) = self.cells_hypelinks_delete_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
            return data

    def cells_hypelinks_delete_worksheet_hyperlink_with_http_info(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Delete worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_delete_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'hyperlink_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_delete_worksheet_hyperlink" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_delete_worksheet_hyperlink`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_delete_worksheet_hyperlink`")
        # verify the required parameter 'hyperlink_index' is set
        if ('hyperlink_index' not in params) or (params['hyperlink_index'] is None):
            raise ValueError("Missing the required parameter `hyperlink_index` when calling `cells_hypelinks_delete_worksheet_hyperlink`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'hyperlink_index' in params:
            path_params['hyperlinkIndex'] = params['hyperlink_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_delete_worksheet_hyperlinks(self, name, sheet_name, **kwargs):
        """
        Delete all hyperlinks in worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_delete_worksheet_hyperlinks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_delete_worksheet_hyperlinks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_hypelinks_delete_worksheet_hyperlinks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_hypelinks_delete_worksheet_hyperlinks_with_http_info(self, name, sheet_name, **kwargs):
        """
        Delete all hyperlinks in worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_delete_worksheet_hyperlinks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_delete_worksheet_hyperlinks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_delete_worksheet_hyperlinks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_delete_worksheet_hyperlinks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_get_worksheet_hyperlink(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Get worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_get_worksheet_hyperlink(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_get_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
        else:
            (data) = self.cells_hypelinks_get_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
            return data

    def cells_hypelinks_get_worksheet_hyperlink_with_http_info(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Get worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_get_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'hyperlink_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_get_worksheet_hyperlink" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_get_worksheet_hyperlink`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_get_worksheet_hyperlink`")
        # verify the required parameter 'hyperlink_index' is set
        if ('hyperlink_index' not in params) or (params['hyperlink_index'] is None):
            raise ValueError("Missing the required parameter `hyperlink_index` when calling `cells_hypelinks_get_worksheet_hyperlink`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'hyperlink_index' in params:
            path_params['hyperlinkIndex'] = params['hyperlink_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HyperlinkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_get_worksheet_hyperlinks(self, name, sheet_name, **kwargs):
        """
        Get worksheet hyperlinks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_get_worksheet_hyperlinks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: HyperlinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_get_worksheet_hyperlinks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_hypelinks_get_worksheet_hyperlinks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_hypelinks_get_worksheet_hyperlinks_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet hyperlinks.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_get_worksheet_hyperlinks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: HyperlinksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_get_worksheet_hyperlinks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_get_worksheet_hyperlinks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_get_worksheet_hyperlinks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HyperlinksResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_post_worksheet_hyperlink(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Update worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_post_worksheet_hyperlink(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param Hyperlink hyperlink: Hyperlink object
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_post_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
        else:
            (data) = self.cells_hypelinks_post_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, **kwargs)
            return data

    def cells_hypelinks_post_worksheet_hyperlink_with_http_info(self, name, sheet_name, hyperlink_index, **kwargs):
        """
        Update worksheet hyperlink by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_post_worksheet_hyperlink_with_http_info(name, sheet_name, hyperlink_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int hyperlink_index: The hyperlink's index. (required)
        :param Hyperlink hyperlink: Hyperlink object
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'hyperlink_index', 'hyperlink', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_post_worksheet_hyperlink" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_post_worksheet_hyperlink`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_post_worksheet_hyperlink`")
        # verify the required parameter 'hyperlink_index' is set
        if ('hyperlink_index' not in params) or (params['hyperlink_index'] is None):
            raise ValueError("Missing the required parameter `hyperlink_index` when calling `cells_hypelinks_post_worksheet_hyperlink`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'hyperlink_index' in params:
            path_params['hyperlinkIndex'] = params['hyperlink_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'hyperlink' in params:
            body_params = params['hyperlink']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks/{hyperlinkIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HyperlinkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_hypelinks_put_worksheet_hyperlink(self, name, sheet_name, first_row, first_column, total_rows, total_columns, address, **kwargs):
        """
        Add worksheet hyperlink.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_put_worksheet_hyperlink(name, sheet_name, first_row, first_column, total_rows, total_columns, address, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int first_row: (required)
        :param int first_column: (required)
        :param int total_rows: (required)
        :param int total_columns: (required)
        :param str address: (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_hypelinks_put_worksheet_hyperlink_with_http_info(name, sheet_name, first_row, first_column, total_rows, total_columns, address, **kwargs)
        else:
            (data) = self.cells_hypelinks_put_worksheet_hyperlink_with_http_info(name, sheet_name, first_row, first_column, total_rows, total_columns, address, **kwargs)
            return data

    def cells_hypelinks_put_worksheet_hyperlink_with_http_info(self, name, sheet_name, first_row, first_column, total_rows, total_columns, address, **kwargs):
        """
        Add worksheet hyperlink.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_hypelinks_put_worksheet_hyperlink_with_http_info(name, sheet_name, first_row, first_column, total_rows, total_columns, address, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int first_row: (required)
        :param int first_column: (required)
        :param int total_rows: (required)
        :param int total_columns: (required)
        :param str address: (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: HyperlinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'first_row', 'first_column', 'total_rows', 'total_columns', 'address', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_hypelinks_put_worksheet_hyperlink" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'first_row' is set
        if ('first_row' not in params) or (params['first_row'] is None):
            raise ValueError("Missing the required parameter `first_row` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'first_column' is set
        if ('first_column' not in params) or (params['first_column'] is None):
            raise ValueError("Missing the required parameter `first_column` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_hypelinks_put_worksheet_hyperlink`")
        # verify the required parameter 'address' is set
        if ('address' not in params) or (params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `cells_hypelinks_put_worksheet_hyperlink`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'first_row' in params:
            query_params.append(('firstRow', params['first_row']))
        if 'first_column' in params:
            query_params.append(('firstColumn', params['first_column']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'address' in params:
            query_params.append(('address', params['address']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/hyperlinks', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HyperlinkResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_delete_worksheet_list_object(self, name, sheet_name, list_object_index, **kwargs):
        """
        Delete worksheet list object by index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_delete_worksheet_list_object(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int list_object_index: List object index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_delete_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, **kwargs)
        else:
            (data) = self.cells_list_objects_delete_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, **kwargs)
            return data

    def cells_list_objects_delete_worksheet_list_object_with_http_info(self, name, sheet_name, list_object_index, **kwargs):
        """
        Delete worksheet list object by index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_delete_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int list_object_index: List object index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'list_object_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_delete_worksheet_list_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_delete_worksheet_list_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_delete_worksheet_list_object`")
        # verify the required parameter 'list_object_index' is set
        if ('list_object_index' not in params) or (params['list_object_index'] is None):
            raise ValueError("Missing the required parameter `list_object_index` when calling `cells_list_objects_delete_worksheet_list_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'list_object_index' in params:
            path_params['listObjectIndex'] = params['list_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_delete_worksheet_list_objects(self, name, sheet_name, **kwargs):
        """
        Delete worksheet list objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_delete_worksheet_list_objects(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_delete_worksheet_list_objects_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_list_objects_delete_worksheet_list_objects_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_list_objects_delete_worksheet_list_objects_with_http_info(self, name, sheet_name, **kwargs):
        """
        Delete worksheet list objects
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_delete_worksheet_list_objects_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_delete_worksheet_list_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_delete_worksheet_list_objects`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_delete_worksheet_list_objects`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_get_worksheet_list_object(self, name, sheet_name, listobjectindex, **kwargs):
        """
        Get worksheet list object info by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_get_worksheet_list_object(name, sheet_name, listobjectindex, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int listobjectindex: list object index. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_get_worksheet_list_object_with_http_info(name, sheet_name, listobjectindex, **kwargs)
        else:
            (data) = self.cells_list_objects_get_worksheet_list_object_with_http_info(name, sheet_name, listobjectindex, **kwargs)
            return data

    def cells_list_objects_get_worksheet_list_object_with_http_info(self, name, sheet_name, listobjectindex, **kwargs):
        """
        Get worksheet list object info by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_get_worksheet_list_object_with_http_info(name, sheet_name, listobjectindex, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int listobjectindex: list object index. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'listobjectindex', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_get_worksheet_list_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_get_worksheet_list_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_get_worksheet_list_object`")
        # verify the required parameter 'listobjectindex' is set
        if ('listobjectindex' not in params) or (params['listobjectindex'] is None):
            raise ValueError("Missing the required parameter `listobjectindex` when calling `cells_list_objects_get_worksheet_list_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'listobjectindex' in params:
            path_params['listobjectindex'] = params['listobjectindex']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listobjectindex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListObjectResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_get_worksheet_list_objects(self, name, sheet_name, **kwargs):
        """
        Get worksheet listobjects info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_get_worksheet_list_objects(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_get_worksheet_list_objects_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_list_objects_get_worksheet_list_objects_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_list_objects_get_worksheet_list_objects_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet listobjects info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_get_worksheet_list_objects_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_get_worksheet_list_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_get_worksheet_list_objects`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_get_worksheet_list_objects`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListObjectsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_post_worksheet_list_object(self, name, sheet_name, list_object_index, **kwargs):
        """
        Update  list object 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int list_object_index: list Object index (required)
        :param ListObject list_object: listObject dto in request body.
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_post_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, **kwargs)
        else:
            (data) = self.cells_list_objects_post_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, **kwargs)
            return data

    def cells_list_objects_post_worksheet_list_object_with_http_info(self, name, sheet_name, list_object_index, **kwargs):
        """
        Update  list object 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_with_http_info(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int list_object_index: list Object index (required)
        :param ListObject list_object: listObject dto in request body.
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'list_object_index', 'list_object', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_post_worksheet_list_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_post_worksheet_list_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_post_worksheet_list_object`")
        # verify the required parameter 'list_object_index' is set
        if ('list_object_index' not in params) or (params['list_object_index'] is None):
            raise ValueError("Missing the required parameter `list_object_index` when calling `cells_list_objects_post_worksheet_list_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'list_object_index' in params:
            path_params['listObjectIndex'] = params['list_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'list_object' in params:
            body_params = params['list_object']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_post_worksheet_list_object_convert_to_range(self, name, sheet_name, list_object_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_convert_to_range(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_post_worksheet_list_object_convert_to_range_with_http_info(name, sheet_name, list_object_index, **kwargs)
        else:
            (data) = self.cells_list_objects_post_worksheet_list_object_convert_to_range_with_http_info(name, sheet_name, list_object_index, **kwargs)
            return data

    def cells_list_objects_post_worksheet_list_object_convert_to_range_with_http_info(self, name, sheet_name, list_object_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_convert_to_range_with_http_info(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'list_object_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_post_worksheet_list_object_convert_to_range" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_post_worksheet_list_object_convert_to_range`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_post_worksheet_list_object_convert_to_range`")
        # verify the required parameter 'list_object_index' is set
        if ('list_object_index' not in params) or (params['list_object_index'] is None):
            raise ValueError("Missing the required parameter `list_object_index` when calling `cells_list_objects_post_worksheet_list_object_convert_to_range`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'list_object_index' in params:
            path_params['listObjectIndex'] = params['list_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/ConvertToRange', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_post_worksheet_list_object_sort_table(self, name, sheet_name, list_object_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_sort_table(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param DataSorter data_sorter:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_post_worksheet_list_object_sort_table_with_http_info(name, sheet_name, list_object_index, **kwargs)
        else:
            (data) = self.cells_list_objects_post_worksheet_list_object_sort_table_with_http_info(name, sheet_name, list_object_index, **kwargs)
            return data

    def cells_list_objects_post_worksheet_list_object_sort_table_with_http_info(self, name, sheet_name, list_object_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_sort_table_with_http_info(name, sheet_name, list_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param DataSorter data_sorter:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'list_object_index', 'data_sorter', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_post_worksheet_list_object_sort_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_post_worksheet_list_object_sort_table`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_post_worksheet_list_object_sort_table`")
        # verify the required parameter 'list_object_index' is set
        if ('list_object_index' not in params) or (params['list_object_index'] is None):
            raise ValueError("Missing the required parameter `list_object_index` when calling `cells_list_objects_post_worksheet_list_object_sort_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'list_object_index' in params:
            path_params['listObjectIndex'] = params['list_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data_sorter' in params:
            body_params = params['data_sorter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/sort', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table(self, name, sheet_name, list_object_index, destsheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table(name, sheet_name, list_object_index, destsheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param str destsheet_name: (required)
        :param CreatePivotTableRequest request:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table_with_http_info(name, sheet_name, list_object_index, destsheet_name, **kwargs)
        else:
            (data) = self.cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table_with_http_info(name, sheet_name, list_object_index, destsheet_name, **kwargs)
            return data

    def cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table_with_http_info(self, name, sheet_name, list_object_index, destsheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table_with_http_info(name, sheet_name, list_object_index, destsheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int list_object_index: (required)
        :param str destsheet_name: (required)
        :param CreatePivotTableRequest request:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'list_object_index', 'destsheet_name', 'request', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table`")
        # verify the required parameter 'list_object_index' is set
        if ('list_object_index' not in params) or (params['list_object_index'] is None):
            raise ValueError("Missing the required parameter `list_object_index` when calling `cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table`")
        # verify the required parameter 'destsheet_name' is set
        if ('destsheet_name' not in params) or (params['destsheet_name'] is None):
            raise ValueError("Missing the required parameter `destsheet_name` when calling `cells_list_objects_post_worksheet_list_object_summarize_with_pivot_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'list_object_index' in params:
            path_params['listObjectIndex'] = params['list_object_index']

        query_params = []
        if 'destsheet_name' in params:
            query_params.append(('destsheetName', params['destsheet_name']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects/{listObjectIndex}/SummarizeWithPivotTable', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_list_objects_put_worksheet_list_object(self, name, sheet_name, start_row, start_column, end_row, end_column, **kwargs):
        """
        Add a list object into worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_put_worksheet_list_object(name, sheet_name, start_row, start_column, end_row, end_column, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row of the list range. (required)
        :param int start_column: The start row of the list range. (required)
        :param int end_row: The start row of the list range. (required)
        :param int end_column: The start row of the list range. (required)
        :param bool has_headers: Whether the range has headers.
        :param ListObject list_object: List Object
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_list_objects_put_worksheet_list_object_with_http_info(name, sheet_name, start_row, start_column, end_row, end_column, **kwargs)
        else:
            (data) = self.cells_list_objects_put_worksheet_list_object_with_http_info(name, sheet_name, start_row, start_column, end_row, end_column, **kwargs)
            return data

    def cells_list_objects_put_worksheet_list_object_with_http_info(self, name, sheet_name, start_row, start_column, end_row, end_column, **kwargs):
        """
        Add a list object into worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_list_objects_put_worksheet_list_object_with_http_info(name, sheet_name, start_row, start_column, end_row, end_column, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row of the list range. (required)
        :param int start_column: The start row of the list range. (required)
        :param int end_row: The start row of the list range. (required)
        :param int end_column: The start row of the list range. (required)
        :param bool has_headers: Whether the range has headers.
        :param ListObject list_object: List Object
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: ListObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'start_row', 'start_column', 'end_row', 'end_column', 'has_headers', 'list_object', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_list_objects_put_worksheet_list_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_list_objects_put_worksheet_list_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_list_objects_put_worksheet_list_object`")
        # verify the required parameter 'start_row' is set
        if ('start_row' not in params) or (params['start_row'] is None):
            raise ValueError("Missing the required parameter `start_row` when calling `cells_list_objects_put_worksheet_list_object`")
        # verify the required parameter 'start_column' is set
        if ('start_column' not in params) or (params['start_column'] is None):
            raise ValueError("Missing the required parameter `start_column` when calling `cells_list_objects_put_worksheet_list_object`")
        # verify the required parameter 'end_row' is set
        if ('end_row' not in params) or (params['end_row'] is None):
            raise ValueError("Missing the required parameter `end_row` when calling `cells_list_objects_put_worksheet_list_object`")
        # verify the required parameter 'end_column' is set
        if ('end_column' not in params) or (params['end_column'] is None):
            raise ValueError("Missing the required parameter `end_column` when calling `cells_list_objects_put_worksheet_list_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'end_row' in params:
            query_params.append(('endRow', params['end_row']))
        if 'end_column' in params:
            query_params.append(('endColumn', params['end_column']))
        if 'has_headers' in params:
            query_params.append(('hasHeaders', params['has_headers']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'list_object' in params:
            body_params = params['list_object']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/listobjects', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ListObjectResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_delete_worksheet_ole_object(self, name, sheet_name, ole_object_index, **kwargs):
        """
        Delete OLE object.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_delete_worksheet_ole_object(name, sheet_name, ole_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int ole_object_index: Ole object index (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_delete_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, **kwargs)
        else:
            (data) = self.cells_ole_objects_delete_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, **kwargs)
            return data

    def cells_ole_objects_delete_worksheet_ole_object_with_http_info(self, name, sheet_name, ole_object_index, **kwargs):
        """
        Delete OLE object.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_delete_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int ole_object_index: Ole object index (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'ole_object_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_delete_worksheet_ole_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_delete_worksheet_ole_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_delete_worksheet_ole_object`")
        # verify the required parameter 'ole_object_index' is set
        if ('ole_object_index' not in params) or (params['ole_object_index'] is None):
            raise ValueError("Missing the required parameter `ole_object_index` when calling `cells_ole_objects_delete_worksheet_ole_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'ole_object_index' in params:
            path_params['oleObjectIndex'] = params['ole_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_delete_worksheet_ole_objects(self, name, sheet_name, **kwargs):
        """
        Delete all OLE objects.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_delete_worksheet_ole_objects(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_delete_worksheet_ole_objects_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ole_objects_delete_worksheet_ole_objects_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ole_objects_delete_worksheet_ole_objects_with_http_info(self, name, sheet_name, **kwargs):
        """
        Delete all OLE objects.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_delete_worksheet_ole_objects_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_delete_worksheet_ole_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_delete_worksheet_ole_objects`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_delete_worksheet_ole_objects`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_get_worksheet_ole_object(self, name, sheet_name, object_number, **kwargs):
        """
        Get OLE object info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_get_worksheet_ole_object(name, sheet_name, object_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int object_number: The object number. (required)
        :param str format: The exported object format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_get_worksheet_ole_object_with_http_info(name, sheet_name, object_number, **kwargs)
        else:
            (data) = self.cells_ole_objects_get_worksheet_ole_object_with_http_info(name, sheet_name, object_number, **kwargs)
            return data

    def cells_ole_objects_get_worksheet_ole_object_with_http_info(self, name, sheet_name, object_number, **kwargs):
        """
        Get OLE object info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_get_worksheet_ole_object_with_http_info(name, sheet_name, object_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int object_number: The object number. (required)
        :param str format: The exported object format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'object_number', 'format', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_get_worksheet_ole_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_get_worksheet_ole_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_get_worksheet_ole_object`")
        # verify the required parameter 'object_number' is set
        if ('object_number' not in params) or (params['object_number'] is None):
            raise ValueError("Missing the required parameter `object_number` when calling `cells_ole_objects_get_worksheet_ole_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'object_number' in params:
            path_params['objectNumber'] = params['object_number']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects/{objectNumber}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_get_worksheet_ole_objects(self, name, sheet_name, **kwargs):
        """
        Get worksheet OLE objects info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_get_worksheet_ole_objects(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: OleObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_get_worksheet_ole_objects_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ole_objects_get_worksheet_ole_objects_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ole_objects_get_worksheet_ole_objects_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet OLE objects info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_get_worksheet_ole_objects_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: OleObjectsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_get_worksheet_ole_objects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_get_worksheet_ole_objects`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_get_worksheet_ole_objects`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='OleObjectsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_post_update_worksheet_ole_object(self, name, sheet_name, ole_object_index, **kwargs):
        """
        Update OLE object.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_post_update_worksheet_ole_object(name, sheet_name, ole_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int ole_object_index: Ole object index (required)
        :param OleObject ole: Ole Object
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_post_update_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, **kwargs)
        else:
            (data) = self.cells_ole_objects_post_update_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, **kwargs)
            return data

    def cells_ole_objects_post_update_worksheet_ole_object_with_http_info(self, name, sheet_name, ole_object_index, **kwargs):
        """
        Update OLE object.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_post_update_worksheet_ole_object_with_http_info(name, sheet_name, ole_object_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int ole_object_index: Ole object index (required)
        :param OleObject ole: Ole Object
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'ole_object_index', 'ole', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_post_update_worksheet_ole_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_post_update_worksheet_ole_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_post_update_worksheet_ole_object`")
        # verify the required parameter 'ole_object_index' is set
        if ('ole_object_index' not in params) or (params['ole_object_index'] is None):
            raise ValueError("Missing the required parameter `ole_object_index` when calling `cells_ole_objects_post_update_worksheet_ole_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'ole_object_index' in params:
            path_params['oleObjectIndex'] = params['ole_object_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ole' in params:
            body_params = params['ole']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects/{oleObjectIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ole_objects_put_worksheet_ole_object(self, name, sheet_name, **kwargs):
        """
        Add OLE object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_put_worksheet_ole_object(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param OleObject ole_object: Ole Object
        :param int upper_left_row: Upper left row index
        :param int upper_left_column: Upper left column index
        :param int height: Height of oleObject, in unit of pixel
        :param int width: Width of oleObject, in unit of pixel
        :param str ole_file: OLE filename
        :param str image_file: Image filename
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: OleObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ole_objects_put_worksheet_ole_object_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ole_objects_put_worksheet_ole_object_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ole_objects_put_worksheet_ole_object_with_http_info(self, name, sheet_name, **kwargs):
        """
        Add OLE object
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ole_objects_put_worksheet_ole_object_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param OleObject ole_object: Ole Object
        :param int upper_left_row: Upper left row index
        :param int upper_left_column: Upper left column index
        :param int height: Height of oleObject, in unit of pixel
        :param int width: Width of oleObject, in unit of pixel
        :param str ole_file: OLE filename
        :param str image_file: Image filename
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: OleObjectResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'ole_object', 'upper_left_row', 'upper_left_column', 'height', 'width', 'ole_file', 'image_file', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ole_objects_put_worksheet_ole_object" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ole_objects_put_worksheet_ole_object`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ole_objects_put_worksheet_ole_object`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'upper_left_row' in params:
            query_params.append(('upperLeftRow', params['upper_left_row']))
        if 'upper_left_column' in params:
            query_params.append(('upperLeftColumn', params['upper_left_column']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'ole_file' in params:
            query_params.append(('oleFile', params['ole_file']))
        if 'image_file' in params:
            query_params.append(('imageFile', params['image_file']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ole_object' in params:
            body_params = params['ole_object']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/oleobjects', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='OleObjectResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_delete_horizontal_page_break(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_horizontal_page_break(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_delete_horizontal_page_break_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_page_breaks_delete_horizontal_page_break_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_page_breaks_delete_horizontal_page_break_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_horizontal_page_break_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_delete_horizontal_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_delete_horizontal_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_delete_horizontal_page_break`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_page_breaks_delete_horizontal_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_delete_horizontal_page_breaks(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_horizontal_page_breaks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int row:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_delete_horizontal_page_breaks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_delete_horizontal_page_breaks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_delete_horizontal_page_breaks_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_horizontal_page_breaks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int row:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_delete_horizontal_page_breaks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_delete_horizontal_page_breaks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_delete_horizontal_page_breaks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_delete_vertical_page_break(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_vertical_page_break(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_delete_vertical_page_break_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_page_breaks_delete_vertical_page_break_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_page_breaks_delete_vertical_page_break_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_vertical_page_break_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_delete_vertical_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_delete_vertical_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_delete_vertical_page_break`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_page_breaks_delete_vertical_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_delete_vertical_page_breaks(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_vertical_page_breaks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int column:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_delete_vertical_page_breaks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_delete_vertical_page_breaks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_delete_vertical_page_breaks_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_delete_vertical_page_breaks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int column:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_delete_vertical_page_breaks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_delete_vertical_page_breaks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_delete_vertical_page_breaks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/verticalpagebreaks', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_get_horizontal_page_break(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_horizontal_page_break(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: HorizontalPageBreakResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_get_horizontal_page_break_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_page_breaks_get_horizontal_page_break_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_page_breaks_get_horizontal_page_break_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_horizontal_page_break_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: HorizontalPageBreakResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_get_horizontal_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_get_horizontal_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_get_horizontal_page_break`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_page_breaks_get_horizontal_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks/{index}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HorizontalPageBreakResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_get_horizontal_page_breaks(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_horizontal_page_breaks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: HorizontalPageBreaksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_get_horizontal_page_breaks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_get_horizontal_page_breaks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_get_horizontal_page_breaks_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_horizontal_page_breaks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: HorizontalPageBreaksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_get_horizontal_page_breaks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_get_horizontal_page_breaks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_get_horizontal_page_breaks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='HorizontalPageBreaksResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_get_vertical_page_break(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_vertical_page_break(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: VerticalPageBreakResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_get_vertical_page_break_with_http_info(name, sheet_name, index, **kwargs)
        else:
            (data) = self.cells_page_breaks_get_vertical_page_break_with_http_info(name, sheet_name, index, **kwargs)
            return data

    def cells_page_breaks_get_vertical_page_break_with_http_info(self, name, sheet_name, index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_vertical_page_break_with_http_info(name, sheet_name, index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: VerticalPageBreakResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_get_vertical_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_get_vertical_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_get_vertical_page_break`")
        # verify the required parameter 'index' is set
        if ('index' not in params) or (params['index'] is None):
            raise ValueError("Missing the required parameter `index` when calling `cells_page_breaks_get_vertical_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'index' in params:
            path_params['index'] = params['index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/verticalpagebreaks/{index}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VerticalPageBreakResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_get_vertical_page_breaks(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_vertical_page_breaks(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: VerticalPageBreaksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_get_vertical_page_breaks_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_get_vertical_page_breaks_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_get_vertical_page_breaks_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_get_vertical_page_breaks_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: VerticalPageBreaksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_get_vertical_page_breaks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_get_vertical_page_breaks`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_get_vertical_page_breaks`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/verticalpagebreaks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='VerticalPageBreaksResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_put_horizontal_page_break(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_put_horizontal_page_break(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cellname:
        :param int row:
        :param int column:
        :param int start_column:
        :param int end_column:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_put_horizontal_page_break_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_put_horizontal_page_break_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_put_horizontal_page_break_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_put_horizontal_page_break_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cellname:
        :param int row:
        :param int column:
        :param int start_column:
        :param int end_column:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cellname', 'row', 'column', 'start_column', 'end_column', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_put_horizontal_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_put_horizontal_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_put_horizontal_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'cellname' in params:
            query_params.append(('cellname', params['cellname']))
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'end_column' in params:
            query_params.append(('endColumn', params['end_column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/horizontalpagebreaks', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_breaks_put_vertical_page_break(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_put_vertical_page_break(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cellname:
        :param int column:
        :param int row:
        :param int start_row:
        :param int end_row:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_breaks_put_vertical_page_break_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_breaks_put_vertical_page_break_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_breaks_put_vertical_page_break_with_http_info(self, name, sheet_name, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_breaks_put_vertical_page_break_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cellname:
        :param int column:
        :param int row:
        :param int start_row:
        :param int end_row:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cellname', 'column', 'row', 'start_row', 'end_row', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_breaks_put_vertical_page_break" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_breaks_put_vertical_page_break`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_breaks_put_vertical_page_break`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'cellname' in params:
            query_params.append(('cellname', params['cellname']))
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'end_row' in params:
            query_params.append(('endRow', params['end_row']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/verticalpagebreaks', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_delete_header_footer(self, name, sheet_name, **kwargs):
        """
        clear header footer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_delete_header_footer(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_delete_header_footer_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_setup_delete_header_footer_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_setup_delete_header_footer_with_http_info(self, name, sheet_name, **kwargs):
        """
        clear header footer
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_delete_header_footer_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_delete_header_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_delete_header_footer`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_delete_header_footer`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup/clearheaderfooter', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_get_footer(self, name, sheet_name, **kwargs):
        """
        get page footer information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_footer(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_get_footer_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_setup_get_footer_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_setup_get_footer_with_http_info(self, name, sheet_name, **kwargs):
        """
        get page footer information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_footer_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_get_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_get_footer`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_get_footer`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup/footer', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageSectionsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_get_header(self, name, sheet_name, **kwargs):
        """
        get page header information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_header(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_get_header_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_setup_get_header_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_setup_get_header_with_http_info(self, name, sheet_name, **kwargs):
        """
        get page header information
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_header_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSectionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_get_header" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_get_header`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_get_header`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup/header', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageSectionsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_get_page_setup(self, name, sheet_name, **kwargs):
        """
        Get Page Setup information.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_page_setup(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSetupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_get_page_setup_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_setup_get_page_setup_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_setup_get_page_setup_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get Page Setup information.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_get_page_setup_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PageSetupResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_get_page_setup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_get_page_setup`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_get_page_setup`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PageSetupResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_post_footer(self, name, sheet_name, section, script, is_first_page, **kwargs):
        """
        update  page footer information 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_footer(name, sheet_name, section, script, is_first_page, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int section: (required)
        :param str script: (required)
        :param bool is_first_page: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_post_footer_with_http_info(name, sheet_name, section, script, is_first_page, **kwargs)
        else:
            (data) = self.cells_page_setup_post_footer_with_http_info(name, sheet_name, section, script, is_first_page, **kwargs)
            return data

    def cells_page_setup_post_footer_with_http_info(self, name, sheet_name, section, script, is_first_page, **kwargs):
        """
        update  page footer information 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_footer_with_http_info(name, sheet_name, section, script, is_first_page, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int section: (required)
        :param str script: (required)
        :param bool is_first_page: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'section', 'script', 'is_first_page', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_post_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_post_footer`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_post_footer`")
        # verify the required parameter 'section' is set
        if ('section' not in params) or (params['section'] is None):
            raise ValueError("Missing the required parameter `section` when calling `cells_page_setup_post_footer`")
        # verify the required parameter 'script' is set
        if ('script' not in params) or (params['script'] is None):
            raise ValueError("Missing the required parameter `script` when calling `cells_page_setup_post_footer`")
        # verify the required parameter 'is_first_page' is set
        if ('is_first_page' not in params) or (params['is_first_page'] is None):
            raise ValueError("Missing the required parameter `is_first_page` when calling `cells_page_setup_post_footer`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'section' in params:
            query_params.append(('section', params['section']))
        if 'script' in params:
            query_params.append(('script', params['script']))
        if 'is_first_page' in params:
            query_params.append(('isFirstPage', params['is_first_page']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup/footer', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_post_header(self, name, sheet_name, section, script, is_first_page, **kwargs):
        """
        update  page header information 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_header(name, sheet_name, section, script, is_first_page, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int section: (required)
        :param str script: (required)
        :param bool is_first_page: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_post_header_with_http_info(name, sheet_name, section, script, is_first_page, **kwargs)
        else:
            (data) = self.cells_page_setup_post_header_with_http_info(name, sheet_name, section, script, is_first_page, **kwargs)
            return data

    def cells_page_setup_post_header_with_http_info(self, name, sheet_name, section, script, is_first_page, **kwargs):
        """
        update  page header information 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_header_with_http_info(name, sheet_name, section, script, is_first_page, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int section: (required)
        :param str script: (required)
        :param bool is_first_page: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'section', 'script', 'is_first_page', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_post_header" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_post_header`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_post_header`")
        # verify the required parameter 'section' is set
        if ('section' not in params) or (params['section'] is None):
            raise ValueError("Missing the required parameter `section` when calling `cells_page_setup_post_header`")
        # verify the required parameter 'script' is set
        if ('script' not in params) or (params['script'] is None):
            raise ValueError("Missing the required parameter `script` when calling `cells_page_setup_post_header`")
        # verify the required parameter 'is_first_page' is set
        if ('is_first_page' not in params) or (params['is_first_page'] is None):
            raise ValueError("Missing the required parameter `is_first_page` when calling `cells_page_setup_post_header`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'section' in params:
            query_params.append(('section', params['section']))
        if 'script' in params:
            query_params.append(('script', params['script']))
        if 'is_first_page' in params:
            query_params.append(('isFirstPage', params['is_first_page']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup/header', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_page_setup_post_page_setup(self, name, sheet_name, **kwargs):
        """
        Update Page Setup information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_page_setup(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param PageSetup page_setup:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_page_setup_post_page_setup_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_page_setup_post_page_setup_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_page_setup_post_page_setup_with_http_info(self, name, sheet_name, **kwargs):
        """
        Update Page Setup information.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_page_setup_post_page_setup_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param PageSetup page_setup:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'page_setup', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_page_setup_post_page_setup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_page_setup_post_page_setup`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_page_setup_post_page_setup`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'page_setup' in params:
            body_params = params['page_setup']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pagesetup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_delete_worksheet_picture(self, name, sheet_name, picture_index, **kwargs):
        """
        Delete a picture object in worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_delete_worksheet_picture(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int picture_index: Picture index (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_delete_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
        else:
            (data) = self.cells_pictures_delete_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
            return data

    def cells_pictures_delete_worksheet_picture_with_http_info(self, name, sheet_name, picture_index, **kwargs):
        """
        Delete a picture object in worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_delete_worksheet_picture_with_http_info(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param int picture_index: Picture index (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'picture_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_delete_worksheet_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_delete_worksheet_picture`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_delete_worksheet_picture`")
        # verify the required parameter 'picture_index' is set
        if ('picture_index' not in params) or (params['picture_index'] is None):
            raise ValueError("Missing the required parameter `picture_index` when calling `cells_pictures_delete_worksheet_picture`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'picture_index' in params:
            path_params['pictureIndex'] = params['picture_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_delete_worksheet_pictures(self, name, sheet_name, **kwargs):
        """
        Delete all pictures in worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_delete_worksheet_pictures(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_delete_worksheet_pictures_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pictures_delete_worksheet_pictures_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pictures_delete_worksheet_pictures_with_http_info(self, name, sheet_name, **kwargs):
        """
        Delete all pictures in worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_delete_worksheet_pictures_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_delete_worksheet_pictures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_delete_worksheet_pictures`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_delete_worksheet_pictures`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_get_worksheet_picture(self, name, sheet_name, picture_index, **kwargs):
        """
        GRead worksheet picture by number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_get_worksheet_picture(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int picture_index: The picture index. (required)
        :param str format: The exported object format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_get_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
        else:
            (data) = self.cells_pictures_get_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
            return data

    def cells_pictures_get_worksheet_picture_with_http_info(self, name, sheet_name, picture_index, **kwargs):
        """
        GRead worksheet picture by number.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_get_worksheet_picture_with_http_info(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int picture_index: The picture index. (required)
        :param str format: The exported object format.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'picture_index', 'format', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_get_worksheet_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_get_worksheet_picture`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_get_worksheet_picture`")
        # verify the required parameter 'picture_index' is set
        if ('picture_index' not in params) or (params['picture_index'] is None):
            raise ValueError("Missing the required parameter `picture_index` when calling `cells_pictures_get_worksheet_picture`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'picture_index' in params:
            path_params['pictureIndex'] = params['picture_index']

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_get_worksheet_pictures(self, name, sheet_name, **kwargs):
        """
        Read worksheet pictures.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_get_worksheet_pictures(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_get_worksheet_pictures_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pictures_get_worksheet_pictures_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pictures_get_worksheet_pictures_with_http_info(self, name, sheet_name, **kwargs):
        """
        Read worksheet pictures.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_get_worksheet_pictures_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_get_worksheet_pictures" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_get_worksheet_pictures`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_get_worksheet_pictures`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PicturesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_post_worksheet_picture(self, name, sheet_name, picture_index, **kwargs):
        """
        Update worksheet picture by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_post_worksheet_picture(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int picture_index: The picture's index. (required)
        :param Picture picture: Picture object
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_post_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
        else:
            (data) = self.cells_pictures_post_worksheet_picture_with_http_info(name, sheet_name, picture_index, **kwargs)
            return data

    def cells_pictures_post_worksheet_picture_with_http_info(self, name, sheet_name, picture_index, **kwargs):
        """
        Update worksheet picture by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_post_worksheet_picture_with_http_info(name, sheet_name, picture_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param int picture_index: The picture's index. (required)
        :param Picture picture: Picture object
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: PictureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'picture_index', 'picture', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_post_worksheet_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_post_worksheet_picture`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_post_worksheet_picture`")
        # verify the required parameter 'picture_index' is set
        if ('picture_index' not in params) or (params['picture_index'] is None):
            raise ValueError("Missing the required parameter `picture_index` when calling `cells_pictures_post_worksheet_picture`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'picture_index' in params:
            path_params['pictureIndex'] = params['picture_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'picture' in params:
            body_params = params['picture']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures/{pictureIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PictureResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pictures_put_worksheet_add_picture(self, name, sheet_name, **kwargs):
        """
        Add a new worksheet picture.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_put_worksheet_add_picture(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param Picture picture: Pictute object
        :param int upper_left_row: The image upper left row.
        :param int upper_left_column: The image upper left column.
        :param int lower_right_row: The image low right row.
        :param int lower_right_column: The image low right column.
        :param str picture_path: The picture path, if not provided the picture data is inspected in the request body.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pictures_put_worksheet_add_picture_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pictures_put_worksheet_add_picture_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pictures_put_worksheet_add_picture_with_http_info(self, name, sheet_name, **kwargs):
        """
        Add a new worksheet picture.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pictures_put_worksheet_add_picture_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worsheet name. (required)
        :param Picture picture: Pictute object
        :param int upper_left_row: The image upper left row.
        :param int upper_left_column: The image upper left column.
        :param int lower_right_row: The image low right row.
        :param int lower_right_column: The image low right column.
        :param str picture_path: The picture path, if not provided the picture data is inspected in the request body.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: PicturesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'picture', 'upper_left_row', 'upper_left_column', 'lower_right_row', 'lower_right_column', 'picture_path', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pictures_put_worksheet_add_picture" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pictures_put_worksheet_add_picture`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pictures_put_worksheet_add_picture`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'upper_left_row' in params:
            query_params.append(('upperLeftRow', params['upper_left_row']))
        if 'upper_left_column' in params:
            query_params.append(('upperLeftColumn', params['upper_left_column']))
        if 'lower_right_row' in params:
            query_params.append(('lowerRightRow', params['lower_right_row']))
        if 'lower_right_column' in params:
            query_params.append(('lowerRightColumn', params['lower_right_column']))
        if 'picture_path' in params:
            query_params.append(('picturePath', params['picture_path']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'picture' in params:
            body_params = params['picture']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pictures', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PicturesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_delete_pivot_table_field(self, name, sheet_name, pivot_table_index, pivot_field_type, **kwargs):
        """
        Delete pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_pivot_table_field(name, sheet_name, pivot_table_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str pivot_field_type: The fields area type. (required)
        :param PivotTableFieldRequest request: Dto that conrains field indexes
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_delete_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, **kwargs)
        else:
            (data) = self.cells_pivot_tables_delete_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, **kwargs)
            return data

    def cells_pivot_tables_delete_pivot_table_field_with_http_info(self, name, sheet_name, pivot_table_index, pivot_field_type, **kwargs):
        """
        Delete pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str pivot_field_type: The fields area type. (required)
        :param PivotTableFieldRequest request: Dto that conrains field indexes
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'pivot_field_type', 'request', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_delete_pivot_table_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_delete_pivot_table_field`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_delete_pivot_table_field`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_delete_pivot_table_field`")
        # verify the required parameter 'pivot_field_type' is set
        if ('pivot_field_type' not in params) or (params['pivot_field_type'] is None):
            raise ValueError("Missing the required parameter `pivot_field_type` when calling `cells_pivot_tables_delete_pivot_table_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'pivot_field_type' in params:
            query_params.append(('pivotFieldType', params['pivot_field_type']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_delete_worksheet_pivot_table(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Delete worksheet pivot table by index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_delete_worksheet_pivot_table_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_delete_worksheet_pivot_table_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_delete_worksheet_pivot_table_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Delete worksheet pivot table by index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_delete_worksheet_pivot_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_delete_worksheet_pivot_table`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_delete_worksheet_pivot_table`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_delete_worksheet_pivot_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_delete_worksheet_pivot_table_filter(self, name, sheet_name, pivot_table_index, field_index, **kwargs):
        """
        delete  pivot filter for piovt table             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table_filter(name, sheet_name, pivot_table_index, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int field_index: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_delete_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, field_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_delete_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, field_index, **kwargs)
            return data

    def cells_pivot_tables_delete_worksheet_pivot_table_filter_with_http_info(self, name, sheet_name, pivot_table_index, field_index, **kwargs):
        """
        delete  pivot filter for piovt table             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, field_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int field_index: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'field_index', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_delete_worksheet_pivot_table_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filter`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filter`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']
        if 'field_index' in params:
            path_params['fieldIndex'] = params['field_index']

        query_params = []
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{fieldIndex}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_delete_worksheet_pivot_table_filters(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        delete all pivot filters for piovt table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table_filters(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_delete_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_delete_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_delete_worksheet_pivot_table_filters_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        delete all pivot filters for piovt table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_delete_worksheet_pivot_table_filters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filters`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filters`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_delete_worksheet_pivot_table_filters`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_delete_worksheet_pivot_tables(self, name, sheet_name, **kwargs):
        """
        Delete worksheet pivot tables
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_tables(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_delete_worksheet_pivot_tables_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pivot_tables_delete_worksheet_pivot_tables_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pivot_tables_delete_worksheet_pivot_tables_with_http_info(self, name, sheet_name, **kwargs):
        """
        Delete worksheet pivot tables
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_delete_worksheet_pivot_tables_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_delete_worksheet_pivot_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_delete_worksheet_pivot_tables`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_delete_worksheet_pivot_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_get_pivot_table_field(self, name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, **kwargs):
        """
        Get pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_pivot_table_field(name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param int pivot_field_index: The field index in the base fields. (required)
        :param str pivot_field_type: The fields area type. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_get_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, **kwargs)
        else:
            (data) = self.cells_pivot_tables_get_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, **kwargs)
            return data

    def cells_pivot_tables_get_pivot_table_field_with_http_info(self, name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, **kwargs):
        """
        Get pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param int pivot_field_index: The field index in the base fields. (required)
        :param str pivot_field_type: The fields area type. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotFieldResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'pivot_field_index', 'pivot_field_type', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_get_pivot_table_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_get_pivot_table_field`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_get_pivot_table_field`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_get_pivot_table_field`")
        # verify the required parameter 'pivot_field_index' is set
        if ('pivot_field_index' not in params) or (params['pivot_field_index'] is None):
            raise ValueError("Missing the required parameter `pivot_field_index` when calling `cells_pivot_tables_get_pivot_table_field`")
        # verify the required parameter 'pivot_field_type' is set
        if ('pivot_field_type' not in params) or (params['pivot_field_type'] is None):
            raise ValueError("Missing the required parameter `pivot_field_type` when calling `cells_pivot_tables_get_pivot_table_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'pivot_field_index' in params:
            query_params.append(('pivotFieldIndex', params['pivot_field_index']))
        if 'pivot_field_type' in params:
            query_params.append(('pivotFieldType', params['pivot_field_type']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotFieldResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_get_worksheet_pivot_table(self, name, sheet_name, pivottable_index, **kwargs):
        """
        Get worksheet pivottable info by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table(name, sheet_name, pivottable_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivottable_index: (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_get_worksheet_pivot_table_with_http_info(name, sheet_name, pivottable_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_get_worksheet_pivot_table_with_http_info(name, sheet_name, pivottable_index, **kwargs)
            return data

    def cells_pivot_tables_get_worksheet_pivot_table_with_http_info(self, name, sheet_name, pivottable_index, **kwargs):
        """
        Get worksheet pivottable info by index.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table_with_http_info(name, sheet_name, pivottable_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivottable_index: (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivottable_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_get_worksheet_pivot_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_get_worksheet_pivot_table`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_get_worksheet_pivot_table`")
        # verify the required parameter 'pivottable_index' is set
        if ('pivottable_index' not in params) or (params['pivottable_index'] is None):
            raise ValueError("Missing the required parameter `pivottable_index` when calling `cells_pivot_tables_get_worksheet_pivot_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivottable_index' in params:
            path_params['pivottableIndex'] = params['pivottable_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivottableIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotTableResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_get_worksheet_pivot_table_filter(self, name, sheet_name, pivot_table_index, filter_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table_filter(name, sheet_name, pivot_table_index, filter_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int filter_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PivotFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_get_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, filter_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_get_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, filter_index, **kwargs)
            return data

    def cells_pivot_tables_get_worksheet_pivot_table_filter_with_http_info(self, name, sheet_name, pivot_table_index, filter_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, filter_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int filter_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PivotFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'filter_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_get_worksheet_pivot_table_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_get_worksheet_pivot_table_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_get_worksheet_pivot_table_filter`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_get_worksheet_pivot_table_filter`")
        # verify the required parameter 'filter_index' is set
        if ('filter_index' not in params) or (params['filter_index'] is None):
            raise ValueError("Missing the required parameter `filter_index` when calling `cells_pivot_tables_get_worksheet_pivot_table_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']
        if 'filter_index' in params:
            path_params['filterIndex'] = params['filter_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters/{filterIndex}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotFilterResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_get_worksheet_pivot_table_filters(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table_filters(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PivotFiltersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_get_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_get_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_get_worksheet_pivot_table_filters_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_table_filters_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param str folder:
        :param str storage: storage name.
        :return: PivotFiltersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_get_worksheet_pivot_table_filters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_get_worksheet_pivot_table_filters`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_get_worksheet_pivot_table_filters`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_get_worksheet_pivot_table_filters`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotFiltersResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_get_worksheet_pivot_tables(self, name, sheet_name, **kwargs):
        """
        Get worksheet pivottables info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_tables(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_get_worksheet_pivot_tables_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pivot_tables_get_worksheet_pivot_tables_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pivot_tables_get_worksheet_pivot_tables_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get worksheet pivottables info.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_get_worksheet_pivot_tables_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: PivotTablesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_get_worksheet_pivot_tables" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_get_worksheet_pivot_tables`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_get_worksheet_pivot_tables`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotTablesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_pivot_table_cell_style(self, name, sheet_name, pivot_table_index, column, row, **kwargs):
        """
        Update cell style for pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_cell_style(name, sheet_name, pivot_table_index, column, row, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param int column: (required)
        :param int row: (required)
        :param Style style: Style dto in request body.
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_pivot_table_cell_style_with_http_info(name, sheet_name, pivot_table_index, column, row, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_pivot_table_cell_style_with_http_info(name, sheet_name, pivot_table_index, column, row, **kwargs)
            return data

    def cells_pivot_tables_post_pivot_table_cell_style_with_http_info(self, name, sheet_name, pivot_table_index, column, row, **kwargs):
        """
        Update cell style for pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_cell_style_with_http_info(name, sheet_name, pivot_table_index, column, row, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param int column: (required)
        :param int row: (required)
        :param Style style: Style dto in request body.
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'column', 'row', 'style', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_pivot_table_cell_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_pivot_table_cell_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_pivot_table_cell_style`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_pivot_table_cell_style`")
        # verify the required parameter 'column' is set
        if ('column' not in params) or (params['column'] is None):
            raise ValueError("Missing the required parameter `column` when calling `cells_pivot_tables_post_pivot_table_cell_style`")
        # verify the required parameter 'row' is set
        if ('row' not in params) or (params['row'] is None):
            raise ValueError("Missing the required parameter `row` when calling `cells_pivot_tables_post_pivot_table_cell_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Format', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_pivot_table_field_hide_item(self, name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_field_hide_item(name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param str pivot_field_type: (required)
        :param int field_index: (required)
        :param int item_index: (required)
        :param bool is_hide: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_pivot_table_field_hide_item_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_pivot_table_field_hide_item_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, **kwargs)
            return data

    def cells_pivot_tables_post_pivot_table_field_hide_item_with_http_info(self, name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_field_hide_item_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, field_index, item_index, is_hide, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param str pivot_field_type: (required)
        :param int field_index: (required)
        :param int item_index: (required)
        :param bool is_hide: (required)
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'pivot_field_type', 'field_index', 'item_index', 'is_hide', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_pivot_table_field_hide_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'pivot_field_type' is set
        if ('pivot_field_type' not in params) or (params['pivot_field_type'] is None):
            raise ValueError("Missing the required parameter `pivot_field_type` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'item_index' is set
        if ('item_index' not in params) or (params['item_index'] is None):
            raise ValueError("Missing the required parameter `item_index` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")
        # verify the required parameter 'is_hide' is set
        if ('is_hide' not in params) or (params['is_hide'] is None):
            raise ValueError("Missing the required parameter `is_hide` when calling `cells_pivot_tables_post_pivot_table_field_hide_item`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'pivot_field_type' in params:
            query_params.append(('pivotFieldType', params['pivot_field_type']))
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if 'item_index' in params:
            query_params.append(('itemIndex', params['item_index']))
        if 'is_hide' in params:
            query_params.append(('isHide', params['is_hide']))
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Hide', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_pivot_table_field_move_to(self, name, sheet_name, pivot_table_index, field_index, _from, to, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_field_move_to(name, sheet_name, pivot_table_index, field_index, _from, to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int field_index: (required)
        :param str _from: (required)
        :param str to: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_pivot_table_field_move_to_with_http_info(name, sheet_name, pivot_table_index, field_index, _from, to, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_pivot_table_field_move_to_with_http_info(name, sheet_name, pivot_table_index, field_index, _from, to, **kwargs)
            return data

    def cells_pivot_tables_post_pivot_table_field_move_to_with_http_info(self, name, sheet_name, pivot_table_index, field_index, _from, to, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_field_move_to_with_http_info(name, sheet_name, pivot_table_index, field_index, _from, to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int field_index: (required)
        :param str _from: (required)
        :param str to: (required)
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'field_index', '_from', 'to', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_pivot_table_field_move_to" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")
        # verify the required parameter 'field_index' is set
        if ('field_index' not in params) or (params['field_index'] is None):
            raise ValueError("Missing the required parameter `field_index` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")
        # verify the required parameter '_from' is set
        if ('_from' not in params) or (params['_from'] is None):
            raise ValueError("Missing the required parameter `_from` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")
        # verify the required parameter 'to' is set
        if ('to' not in params) or (params['to'] is None):
            raise ValueError("Missing the required parameter `to` when calling `cells_pivot_tables_post_pivot_table_field_move_to`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'field_index' in params:
            query_params.append(('fieldIndex', params['field_index']))
        if '_from' in params:
            query_params.append(('from', params['_from']))
        if 'to' in params:
            query_params.append(('to', params['to']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField/Move', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_pivot_table_style(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Update style for pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_style(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param Style style: Style dto in request body.
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_pivot_table_style_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_pivot_table_style_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_post_pivot_table_style_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Update style for pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_pivot_table_style_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param Style style: Style dto in request body.
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'style', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_pivot_table_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_pivot_table_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_pivot_table_style`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_pivot_table_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/FormatAll', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_worksheet_pivot_table_calculate(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Calculates pivottable's data to cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_worksheet_pivot_table_calculate(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_worksheet_pivot_table_calculate_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_worksheet_pivot_table_calculate_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_post_worksheet_pivot_table_calculate_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Calculates pivottable's data to cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_worksheet_pivot_table_calculate_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_worksheet_pivot_table_calculate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_worksheet_pivot_table_calculate`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_worksheet_pivot_table_calculate`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_worksheet_pivot_table_calculate`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Calculate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_post_worksheet_pivot_table_move(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_worksheet_pivot_table_move(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int row:
        :param int column:
        :param str dest_cell_name:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_post_worksheet_pivot_table_move_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_post_worksheet_pivot_table_move_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_post_worksheet_pivot_table_move_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_post_worksheet_pivot_table_move_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param int row:
        :param int column:
        :param str dest_cell_name:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'row', 'column', 'dest_cell_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_post_worksheet_pivot_table_move" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_post_worksheet_pivot_table_move`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_post_worksheet_pivot_table_move`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_post_worksheet_pivot_table_move`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'dest_cell_name' in params:
            query_params.append(('destCellName', params['dest_cell_name']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/Move', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_put_pivot_table_field(self, name, sheet_name, pivot_table_index, pivot_field_type, **kwargs):
        """
        Add pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_pivot_table_field(name, sheet_name, pivot_table_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str pivot_field_type: The fields area type. (required)
        :param PivotTableFieldRequest request: Dto that conrains field indexes
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_put_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, **kwargs)
        else:
            (data) = self.cells_pivot_tables_put_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, **kwargs)
            return data

    def cells_pivot_tables_put_pivot_table_field_with_http_info(self, name, sheet_name, pivot_table_index, pivot_field_type, **kwargs):
        """
        Add pivot field into into pivot table
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_pivot_table_field_with_http_info(name, sheet_name, pivot_table_index, pivot_field_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int pivot_table_index: Pivot table index (required)
        :param str pivot_field_type: The fields area type. (required)
        :param PivotTableFieldRequest request: Dto that conrains field indexes
        :param bool need_re_calculate:
        :param str folder: Document's folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'pivot_field_type', 'request', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_put_pivot_table_field" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_put_pivot_table_field`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_put_pivot_table_field`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_put_pivot_table_field`")
        # verify the required parameter 'pivot_field_type' is set
        if ('pivot_field_type' not in params) or (params['pivot_field_type'] is None):
            raise ValueError("Missing the required parameter `pivot_field_type` when calling `cells_pivot_tables_put_pivot_table_field`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'pivot_field_type' in params:
            query_params.append(('pivotFieldType', params['pivot_field_type']))
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotField', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_put_worksheet_pivot_table(self, name, sheet_name, **kwargs):
        """
        Add a pivot table into worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_worksheet_pivot_table(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param CreatePivotTableRequest request: CreatePivotTableRequest dto in request body.
        :param str folder: Document's folder.
        :param str storage: storage name.
        :param str source_data: The data for the new PivotTable cache.
        :param str dest_cell_name: The cell in the upper-left corner of the PivotTable report's destination range.
        :param str table_name: The name of the new PivotTable report.
        :param bool use_same_source: Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory.
        :return: PivotTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_put_worksheet_pivot_table_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_pivot_tables_put_worksheet_pivot_table_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_pivot_tables_put_worksheet_pivot_table_with_http_info(self, name, sheet_name, **kwargs):
        """
        Add a pivot table into worksheet.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_worksheet_pivot_table_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param CreatePivotTableRequest request: CreatePivotTableRequest dto in request body.
        :param str folder: Document's folder.
        :param str storage: storage name.
        :param str source_data: The data for the new PivotTable cache.
        :param str dest_cell_name: The cell in the upper-left corner of the PivotTable report's destination range.
        :param str table_name: The name of the new PivotTable report.
        :param bool use_same_source: Indicates whether using same data source when another existing pivot table has used this data source. If the property is true, it will save memory.
        :return: PivotTableResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'request', 'folder', 'storage', 'source_data', 'dest_cell_name', 'table_name', 'use_same_source']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_put_worksheet_pivot_table" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_put_worksheet_pivot_table`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_put_worksheet_pivot_table`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))
        if 'source_data' in params:
            query_params.append(('sourceData', params['source_data']))
        if 'dest_cell_name' in params:
            query_params.append(('destCellName', params['dest_cell_name']))
        if 'table_name' in params:
            query_params.append(('tableName', params['table_name']))
        if 'use_same_source' in params:
            query_params.append(('useSameSource', params['use_same_source']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PivotTableResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_pivot_tables_put_worksheet_pivot_table_filter(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Add pivot filter for piovt table index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_worksheet_pivot_table_filter(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param PivotFilter filter:
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_pivot_tables_put_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
        else:
            (data) = self.cells_pivot_tables_put_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, **kwargs)
            return data

    def cells_pivot_tables_put_worksheet_pivot_table_filter_with_http_info(self, name, sheet_name, pivot_table_index, **kwargs):
        """
        Add pivot filter for piovt table index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_pivot_tables_put_worksheet_pivot_table_filter_with_http_info(name, sheet_name, pivot_table_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param int pivot_table_index: (required)
        :param PivotFilter filter:
        :param bool need_re_calculate:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'pivot_table_index', 'filter', 'need_re_calculate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_pivot_tables_put_worksheet_pivot_table_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_pivot_tables_put_worksheet_pivot_table_filter`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_pivot_tables_put_worksheet_pivot_table_filter`")
        # verify the required parameter 'pivot_table_index' is set
        if ('pivot_table_index' not in params) or (params['pivot_table_index'] is None):
            raise ValueError("Missing the required parameter `pivot_table_index` when calling `cells_pivot_tables_put_worksheet_pivot_table_filter`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'pivot_table_index' in params:
            path_params['pivotTableIndex'] = params['pivot_table_index']

        query_params = []
        if 'need_re_calculate' in params:
            query_params.append(('needReCalculate', params['need_re_calculate']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'filter' in params:
            body_params = params['filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/pivottables/{pivotTableIndex}/PivotFilters', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_cell_calculate(self, name, sheet_name, cell_name, **kwargs):
        """
        Cell calculate formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_cell_calculate(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_name: (required)
        :param CalculationOptions options:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_cell_calculate_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_post_cell_calculate_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_post_cell_calculate_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Cell calculate formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_cell_calculate_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_name: (required)
        :param CalculationOptions options:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'options', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_cell_calculate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_cell_calculate`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_cell_calculate`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_post_cell_calculate`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/calculate', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_cell_characters(self, name, sheet_name, cell_name, **kwargs):
        """
        Set cell characters 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_cell_characters(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_name: (required)
        :param list[FontSetting] options:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_cell_characters_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_post_cell_characters_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_post_cell_characters_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Set cell characters 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_cell_characters_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param str cell_name: (required)
        :param list[FontSetting] options:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'options', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_cell_characters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_cell_characters`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_cell_characters`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_post_cell_characters`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/characters', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_clear_contents(self, name, sheet_name, **kwargs):
        """
        Clear cells contents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_clear_contents(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range.
        :param int start_row: The start row.
        :param int start_column: The start column.
        :param int end_row: The end row.
        :param int end_column: The end column.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_clear_contents_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_post_clear_contents_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_post_clear_contents_with_http_info(self, name, sheet_name, **kwargs):
        """
        Clear cells contents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_clear_contents_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range.
        :param int start_row: The start row.
        :param int start_column: The start column.
        :param int end_row: The end row.
        :param int end_column: The end column.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'start_row', 'start_column', 'end_row', 'end_column', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_clear_contents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_clear_contents`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_clear_contents`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'end_row' in params:
            query_params.append(('endRow', params['end_row']))
        if 'end_column' in params:
            query_params.append(('endColumn', params['end_column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/clearcontents', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_clear_formats(self, name, sheet_name, **kwargs):
        """
        Clear cells contents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_clear_formats(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range.
        :param int start_row: The start row.
        :param int start_column: The start column.
        :param int end_row: The end row.
        :param int end_column: The end column.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_clear_formats_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_post_clear_formats_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_post_clear_formats_with_http_info(self, name, sheet_name, **kwargs):
        """
        Clear cells contents.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_clear_formats_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range.
        :param int start_row: The start row.
        :param int start_column: The start column.
        :param int end_row: The end row.
        :param int end_column: The end column.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'start_row', 'start_column', 'end_row', 'end_column', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_clear_formats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_clear_formats`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_clear_formats`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'end_row' in params:
            query_params.append(('endRow', params['end_row']))
        if 'end_column' in params:
            query_params.append(('endColumn', params['end_column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/clearformats', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_column_style(self, name, sheet_name, column_index, **kwargs):
        """
        Set column style
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_column_style(name, sheet_name, column_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param Style style: Style dto
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_column_style_with_http_info(name, sheet_name, column_index, **kwargs)
        else:
            (data) = self.cells_post_column_style_with_http_info(name, sheet_name, column_index, **kwargs)
            return data

    def cells_post_column_style_with_http_info(self, name, sheet_name, column_index, **kwargs):
        """
        Set column style
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_column_style_with_http_info(name, sheet_name, column_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param Style style: Style dto
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column_index', 'style', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_column_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_column_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_column_style`")
        # verify the required parameter 'column_index' is set
        if ('column_index' not in params) or (params['column_index'] is None):
            raise ValueError("Missing the required parameter `column_index` when calling `cells_post_column_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'column_index' in params:
            path_params['columnIndex'] = params['column_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}/style', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_copy_cell_into_cell(self, name, dest_cell_name, sheet_name, worksheet, **kwargs):
        """
        Copy cell into cell
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_cell_into_cell(name, dest_cell_name, sheet_name, worksheet, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str dest_cell_name: Destination cell name (required)
        :param str sheet_name: Destination worksheet name. (required)
        :param str worksheet: Source worksheet name. (required)
        :param str cellname: Source cell name
        :param int row: Source row
        :param int column: Source column
        :param str folder: Folder name
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_copy_cell_into_cell_with_http_info(name, dest_cell_name, sheet_name, worksheet, **kwargs)
        else:
            (data) = self.cells_post_copy_cell_into_cell_with_http_info(name, dest_cell_name, sheet_name, worksheet, **kwargs)
            return data

    def cells_post_copy_cell_into_cell_with_http_info(self, name, dest_cell_name, sheet_name, worksheet, **kwargs):
        """
        Copy cell into cell
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_cell_into_cell_with_http_info(name, dest_cell_name, sheet_name, worksheet, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str dest_cell_name: Destination cell name (required)
        :param str sheet_name: Destination worksheet name. (required)
        :param str worksheet: Source worksheet name. (required)
        :param str cellname: Source cell name
        :param int row: Source row
        :param int column: Source column
        :param str folder: Folder name
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'dest_cell_name', 'sheet_name', 'worksheet', 'cellname', 'row', 'column', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_copy_cell_into_cell" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_copy_cell_into_cell`")
        # verify the required parameter 'dest_cell_name' is set
        if ('dest_cell_name' not in params) or (params['dest_cell_name'] is None):
            raise ValueError("Missing the required parameter `dest_cell_name` when calling `cells_post_copy_cell_into_cell`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_copy_cell_into_cell`")
        # verify the required parameter 'worksheet' is set
        if ('worksheet' not in params) or (params['worksheet'] is None):
            raise ValueError("Missing the required parameter `worksheet` when calling `cells_post_copy_cell_into_cell`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'dest_cell_name' in params:
            path_params['destCellName'] = params['dest_cell_name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'worksheet' in params:
            query_params.append(('worksheet', params['worksheet']))
        if 'cellname' in params:
            query_params.append(('cellname', params['cellname']))
        if 'row' in params:
            query_params.append(('row', params['row']))
        if 'column' in params:
            query_params.append(('column', params['column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{destCellName}/copy', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_copy_worksheet_columns(self, name, sheet_name, source_column_index, destination_column_index, column_number, **kwargs):
        """
        Copy worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_worksheet_columns(name, sheet_name, source_column_index, destination_column_index, column_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int source_column_index: Source column index (required)
        :param int destination_column_index: Destination column index (required)
        :param int column_number: The copied column number (required)
        :param str worksheet: The Worksheet
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_copy_worksheet_columns_with_http_info(name, sheet_name, source_column_index, destination_column_index, column_number, **kwargs)
        else:
            (data) = self.cells_post_copy_worksheet_columns_with_http_info(name, sheet_name, source_column_index, destination_column_index, column_number, **kwargs)
            return data

    def cells_post_copy_worksheet_columns_with_http_info(self, name, sheet_name, source_column_index, destination_column_index, column_number, **kwargs):
        """
        Copy worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_worksheet_columns_with_http_info(name, sheet_name, source_column_index, destination_column_index, column_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int source_column_index: Source column index (required)
        :param int destination_column_index: Destination column index (required)
        :param int column_number: The copied column number (required)
        :param str worksheet: The Worksheet
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'source_column_index', 'destination_column_index', 'column_number', 'worksheet', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_copy_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_copy_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_copy_worksheet_columns`")
        # verify the required parameter 'source_column_index' is set
        if ('source_column_index' not in params) or (params['source_column_index'] is None):
            raise ValueError("Missing the required parameter `source_column_index` when calling `cells_post_copy_worksheet_columns`")
        # verify the required parameter 'destination_column_index' is set
        if ('destination_column_index' not in params) or (params['destination_column_index'] is None):
            raise ValueError("Missing the required parameter `destination_column_index` when calling `cells_post_copy_worksheet_columns`")
        # verify the required parameter 'column_number' is set
        if ('column_number' not in params) or (params['column_number'] is None):
            raise ValueError("Missing the required parameter `column_number` when calling `cells_post_copy_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'source_column_index' in params:
            query_params.append(('sourceColumnIndex', params['source_column_index']))
        if 'destination_column_index' in params:
            query_params.append(('destinationColumnIndex', params['destination_column_index']))
        if 'column_number' in params:
            query_params.append(('columnNumber', params['column_number']))
        if 'worksheet' in params:
            query_params.append(('worksheet', params['worksheet']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/copy', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_copy_worksheet_rows(self, name, sheet_name, source_row_index, destination_row_index, row_number, **kwargs):
        """
        Copy worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_worksheet_rows(name, sheet_name, source_row_index, destination_row_index, row_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int source_row_index: Source row index (required)
        :param int destination_row_index: Destination row index (required)
        :param int row_number: The copied row number (required)
        :param str worksheet: worksheet
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_copy_worksheet_rows_with_http_info(name, sheet_name, source_row_index, destination_row_index, row_number, **kwargs)
        else:
            (data) = self.cells_post_copy_worksheet_rows_with_http_info(name, sheet_name, source_row_index, destination_row_index, row_number, **kwargs)
            return data

    def cells_post_copy_worksheet_rows_with_http_info(self, name, sheet_name, source_row_index, destination_row_index, row_number, **kwargs):
        """
        Copy worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_copy_worksheet_rows_with_http_info(name, sheet_name, source_row_index, destination_row_index, row_number, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int source_row_index: Source row index (required)
        :param int destination_row_index: Destination row index (required)
        :param int row_number: The copied row number (required)
        :param str worksheet: worksheet
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'source_row_index', 'destination_row_index', 'row_number', 'worksheet', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_copy_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_copy_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_copy_worksheet_rows`")
        # verify the required parameter 'source_row_index' is set
        if ('source_row_index' not in params) or (params['source_row_index'] is None):
            raise ValueError("Missing the required parameter `source_row_index` when calling `cells_post_copy_worksheet_rows`")
        # verify the required parameter 'destination_row_index' is set
        if ('destination_row_index' not in params) or (params['destination_row_index'] is None):
            raise ValueError("Missing the required parameter `destination_row_index` when calling `cells_post_copy_worksheet_rows`")
        # verify the required parameter 'row_number' is set
        if ('row_number' not in params) or (params['row_number'] is None):
            raise ValueError("Missing the required parameter `row_number` when calling `cells_post_copy_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'source_row_index' in params:
            query_params.append(('sourceRowIndex', params['source_row_index']))
        if 'destination_row_index' in params:
            query_params.append(('destinationRowIndex', params['destination_row_index']))
        if 'row_number' in params:
            query_params.append(('rowNumber', params['row_number']))
        if 'worksheet' in params:
            query_params.append(('worksheet', params['worksheet']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/copy', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_group_worksheet_columns(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Group worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_group_worksheet_columns(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first column index to be operated. (required)
        :param int last_index: The last column index to be operated. (required)
        :param bool hide: columns visible state
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_group_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
        else:
            (data) = self.cells_post_group_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
            return data

    def cells_post_group_worksheet_columns_with_http_info(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Group worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_group_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first column index to be operated. (required)
        :param int last_index: The last column index to be operated. (required)
        :param bool hide: columns visible state
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'first_index', 'last_index', 'hide', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_group_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_group_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_group_worksheet_columns`")
        # verify the required parameter 'first_index' is set
        if ('first_index' not in params) or (params['first_index'] is None):
            raise ValueError("Missing the required parameter `first_index` when calling `cells_post_group_worksheet_columns`")
        # verify the required parameter 'last_index' is set
        if ('last_index' not in params) or (params['last_index'] is None):
            raise ValueError("Missing the required parameter `last_index` when calling `cells_post_group_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'first_index' in params:
            query_params.append(('firstIndex', params['first_index']))
        if 'last_index' in params:
            query_params.append(('lastIndex', params['last_index']))
        if 'hide' in params:
            query_params.append(('hide', params['hide']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/group', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_group_worksheet_rows(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Group worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_group_worksheet_rows(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first row index to be operated. (required)
        :param int last_index: The last row index to be operated. (required)
        :param bool hide: rows visible state
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_group_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
        else:
            (data) = self.cells_post_group_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
            return data

    def cells_post_group_worksheet_rows_with_http_info(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Group worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_group_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first row index to be operated. (required)
        :param int last_index: The last row index to be operated. (required)
        :param bool hide: rows visible state
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'first_index', 'last_index', 'hide', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_group_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_group_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_group_worksheet_rows`")
        # verify the required parameter 'first_index' is set
        if ('first_index' not in params) or (params['first_index'] is None):
            raise ValueError("Missing the required parameter `first_index` when calling `cells_post_group_worksheet_rows`")
        # verify the required parameter 'last_index' is set
        if ('last_index' not in params) or (params['last_index'] is None):
            raise ValueError("Missing the required parameter `last_index` when calling `cells_post_group_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'first_index' in params:
            query_params.append(('firstIndex', params['first_index']))
        if 'last_index' in params:
            query_params.append(('lastIndex', params['last_index']))
        if 'hide' in params:
            query_params.append(('hide', params['hide']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/group', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_hide_worksheet_columns(self, name, sheet_name, start_column, total_columns, **kwargs):
        """
        Hide worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_hide_worksheet_columns(name, sheet_name, start_column, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_column: The begin column index to be operated. (required)
        :param int total_columns: Number of columns to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_hide_worksheet_columns_with_http_info(name, sheet_name, start_column, total_columns, **kwargs)
        else:
            (data) = self.cells_post_hide_worksheet_columns_with_http_info(name, sheet_name, start_column, total_columns, **kwargs)
            return data

    def cells_post_hide_worksheet_columns_with_http_info(self, name, sheet_name, start_column, total_columns, **kwargs):
        """
        Hide worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_hide_worksheet_columns_with_http_info(name, sheet_name, start_column, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_column: The begin column index to be operated. (required)
        :param int total_columns: Number of columns to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'start_column', 'total_columns', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_hide_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_hide_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_hide_worksheet_columns`")
        # verify the required parameter 'start_column' is set
        if ('start_column' not in params) or (params['start_column'] is None):
            raise ValueError("Missing the required parameter `start_column` when calling `cells_post_hide_worksheet_columns`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_post_hide_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/hide', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_hide_worksheet_rows(self, name, sheet_name, startrow, total_rows, **kwargs):
        """
        Hide worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_hide_worksheet_rows(name, sheet_name, startrow, total_rows, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_hide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, **kwargs)
        else:
            (data) = self.cells_post_hide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, **kwargs)
            return data

    def cells_post_hide_worksheet_rows_with_http_info(self, name, sheet_name, startrow, total_rows, **kwargs):
        """
        Hide worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_hide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'startrow', 'total_rows', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_hide_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_hide_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_hide_worksheet_rows`")
        # verify the required parameter 'startrow' is set
        if ('startrow' not in params) or (params['startrow'] is None):
            raise ValueError("Missing the required parameter `startrow` when calling `cells_post_hide_worksheet_rows`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_post_hide_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'startrow' in params:
            query_params.append(('startrow', params['startrow']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/hide', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_row_style(self, name, sheet_name, row_index, **kwargs):
        """
        Set row style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_row_style(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param Style style: Style dto
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_row_style_with_http_info(name, sheet_name, row_index, **kwargs)
        else:
            (data) = self.cells_post_row_style_with_http_info(name, sheet_name, row_index, **kwargs)
            return data

    def cells_post_row_style_with_http_info(self, name, sheet_name, row_index, **kwargs):
        """
        Set row style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_row_style_with_http_info(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param Style style: Style dto
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row_index', 'style', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_row_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_row_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_row_style`")
        # verify the required parameter 'row_index' is set
        if ('row_index' not in params) or (params['row_index'] is None):
            raise ValueError("Missing the required parameter `row_index` when calling `cells_post_row_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'row_index' in params:
            path_params['rowIndex'] = params['row_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}/style', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_set_cell_html_string(self, name, sheet_name, cell_name, html_string, **kwargs):
        """
        Set htmlstring value into cell
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_cell_html_string(name, sheet_name, cell_name, html_string, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param str html_string: (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_set_cell_html_string_with_http_info(name, sheet_name, cell_name, html_string, **kwargs)
        else:
            (data) = self.cells_post_set_cell_html_string_with_http_info(name, sheet_name, cell_name, html_string, **kwargs)
            return data

    def cells_post_set_cell_html_string_with_http_info(self, name, sheet_name, cell_name, html_string, **kwargs):
        """
        Set htmlstring value into cell
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_cell_html_string_with_http_info(name, sheet_name, cell_name, html_string, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param str html_string: (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'html_string', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_set_cell_html_string" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_set_cell_html_string`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_set_cell_html_string`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_post_set_cell_html_string`")
        # verify the required parameter 'html_string' is set
        if ('html_string' not in params) or (params['html_string'] is None):
            raise ValueError("Missing the required parameter `html_string` when calling `cells_post_set_cell_html_string`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'html_string' in params:
            body_params = params['html_string']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/htmlstring', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_set_cell_range_value(self, name, sheet_name, cellarea, value, type, **kwargs):
        """
        Set cell range value 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_cell_range_value(name, sheet_name, cellarea, value, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cellarea: Cell area (like \"A1:C2\") (required)
        :param str value: Range value (required)
        :param str type: Value data type (like \"int\") (required)
        :param str folder: Folder name
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_set_cell_range_value_with_http_info(name, sheet_name, cellarea, value, type, **kwargs)
        else:
            (data) = self.cells_post_set_cell_range_value_with_http_info(name, sheet_name, cellarea, value, type, **kwargs)
            return data

    def cells_post_set_cell_range_value_with_http_info(self, name, sheet_name, cellarea, value, type, **kwargs):
        """
        Set cell range value 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_cell_range_value_with_http_info(name, sheet_name, cellarea, value, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cellarea: Cell area (like \"A1:C2\") (required)
        :param str value: Range value (required)
        :param str type: Value data type (like \"int\") (required)
        :param str folder: Folder name
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cellarea', 'value', 'type', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_set_cell_range_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_set_cell_range_value`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_set_cell_range_value`")
        # verify the required parameter 'cellarea' is set
        if ('cellarea' not in params) or (params['cellarea'] is None):
            raise ValueError("Missing the required parameter `cellarea` when calling `cells_post_set_cell_range_value`")
        # verify the required parameter 'value' is set
        if ('value' not in params) or (params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `cells_post_set_cell_range_value`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `cells_post_set_cell_range_value`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'cellarea' in params:
            query_params.append(('cellarea', params['cellarea']))
        if 'value' in params:
            query_params.append(('value', params['value']))
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_set_worksheet_column_width(self, name, sheet_name, column_index, width, **kwargs):
        """
        Set worksheet column width.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_worksheet_column_width(name, sheet_name, column_index, width, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param float width: The width. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_set_worksheet_column_width_with_http_info(name, sheet_name, column_index, width, **kwargs)
        else:
            (data) = self.cells_post_set_worksheet_column_width_with_http_info(name, sheet_name, column_index, width, **kwargs)
            return data

    def cells_post_set_worksheet_column_width_with_http_info(self, name, sheet_name, column_index, width, **kwargs):
        """
        Set worksheet column width.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_set_worksheet_column_width_with_http_info(name, sheet_name, column_index, width, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param float width: The width. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column_index', 'width', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_set_worksheet_column_width" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_set_worksheet_column_width`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_set_worksheet_column_width`")
        # verify the required parameter 'column_index' is set
        if ('column_index' not in params) or (params['column_index'] is None):
            raise ValueError("Missing the required parameter `column_index` when calling `cells_post_set_worksheet_column_width`")
        # verify the required parameter 'width' is set
        if ('width' not in params) or (params['width'] is None):
            raise ValueError("Missing the required parameter `width` when calling `cells_post_set_worksheet_column_width`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'column_index' in params:
            path_params['columnIndex'] = params['column_index']

        query_params = []
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ColumnResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_ungroup_worksheet_columns(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Ungroup worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_ungroup_worksheet_columns(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first column index to be operated. (required)
        :param int last_index: The last column index to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_ungroup_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
        else:
            (data) = self.cells_post_ungroup_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
            return data

    def cells_post_ungroup_worksheet_columns_with_http_info(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Ungroup worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_ungroup_worksheet_columns_with_http_info(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first column index to be operated. (required)
        :param int last_index: The last column index to be operated. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'first_index', 'last_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_ungroup_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_ungroup_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_ungroup_worksheet_columns`")
        # verify the required parameter 'first_index' is set
        if ('first_index' not in params) or (params['first_index'] is None):
            raise ValueError("Missing the required parameter `first_index` when calling `cells_post_ungroup_worksheet_columns`")
        # verify the required parameter 'last_index' is set
        if ('last_index' not in params) or (params['last_index'] is None):
            raise ValueError("Missing the required parameter `last_index` when calling `cells_post_ungroup_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'first_index' in params:
            query_params.append(('firstIndex', params['first_index']))
        if 'last_index' in params:
            query_params.append(('lastIndex', params['last_index']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/ungroup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_ungroup_worksheet_rows(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Ungroup worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_ungroup_worksheet_rows(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first row index to be operated. (required)
        :param int last_index: The last row index to be operated. (required)
        :param bool is_all: Is all row to be operated
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_ungroup_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
        else:
            (data) = self.cells_post_ungroup_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, **kwargs)
            return data

    def cells_post_ungroup_worksheet_rows_with_http_info(self, name, sheet_name, first_index, last_index, **kwargs):
        """
        Ungroup worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_ungroup_worksheet_rows_with_http_info(name, sheet_name, first_index, last_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int first_index: The first row index to be operated. (required)
        :param int last_index: The last row index to be operated. (required)
        :param bool is_all: Is all row to be operated
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'first_index', 'last_index', 'is_all', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_ungroup_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_ungroup_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_ungroup_worksheet_rows`")
        # verify the required parameter 'first_index' is set
        if ('first_index' not in params) or (params['first_index'] is None):
            raise ValueError("Missing the required parameter `first_index` when calling `cells_post_ungroup_worksheet_rows`")
        # verify the required parameter 'last_index' is set
        if ('last_index' not in params) or (params['last_index'] is None):
            raise ValueError("Missing the required parameter `last_index` when calling `cells_post_ungroup_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'first_index' in params:
            query_params.append(('firstIndex', params['first_index']))
        if 'last_index' in params:
            query_params.append(('lastIndex', params['last_index']))
        if 'is_all' in params:
            query_params.append(('isAll', params['is_all']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/ungroup', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_unhide_worksheet_columns(self, name, sheet_name, startcolumn, total_columns, **kwargs):
        """
        Unhide worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_unhide_worksheet_columns(name, sheet_name, startcolumn, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startcolumn: The begin column index to be operated. (required)
        :param int total_columns: Number of columns to be operated. (required)
        :param float width: The new column width.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_unhide_worksheet_columns_with_http_info(name, sheet_name, startcolumn, total_columns, **kwargs)
        else:
            (data) = self.cells_post_unhide_worksheet_columns_with_http_info(name, sheet_name, startcolumn, total_columns, **kwargs)
            return data

    def cells_post_unhide_worksheet_columns_with_http_info(self, name, sheet_name, startcolumn, total_columns, **kwargs):
        """
        Unhide worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_unhide_worksheet_columns_with_http_info(name, sheet_name, startcolumn, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startcolumn: The begin column index to be operated. (required)
        :param int total_columns: Number of columns to be operated. (required)
        :param float width: The new column width.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'startcolumn', 'total_columns', 'width', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_unhide_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_unhide_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_unhide_worksheet_columns`")
        # verify the required parameter 'startcolumn' is set
        if ('startcolumn' not in params) or (params['startcolumn'] is None):
            raise ValueError("Missing the required parameter `startcolumn` when calling `cells_post_unhide_worksheet_columns`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_post_unhide_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'startcolumn' in params:
            query_params.append(('startcolumn', params['startcolumn']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'width' in params:
            query_params.append(('width', params['width']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/unhide', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_unhide_worksheet_rows(self, name, sheet_name, startrow, total_rows, **kwargs):
        """
        Unhide worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_unhide_worksheet_rows(name, sheet_name, startrow, total_rows, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated. (required)
        :param float height: The new row height.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_unhide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, **kwargs)
        else:
            (data) = self.cells_post_unhide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, **kwargs)
            return data

    def cells_post_unhide_worksheet_rows_with_http_info(self, name, sheet_name, startrow, total_rows, **kwargs):
        """
        Unhide worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_unhide_worksheet_rows_with_http_info(name, sheet_name, startrow, total_rows, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated. (required)
        :param float height: The new row height.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'startrow', 'total_rows', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_unhide_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_unhide_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_unhide_worksheet_rows`")
        # verify the required parameter 'startrow' is set
        if ('startrow' not in params) or (params['startrow'] is None):
            raise ValueError("Missing the required parameter `startrow` when calling `cells_post_unhide_worksheet_rows`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_post_unhide_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'startrow' in params:
            query_params.append(('startrow', params['startrow']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/unhide', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_update_worksheet_cell_style(self, name, sheet_name, cell_name, **kwargs):
        """
        Update cell's style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_cell_style(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param Style style: with update style settings.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: StyleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_update_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_post_update_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_post_update_worksheet_cell_style_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Update cell's style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_cell_style_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param Style style: with update style settings.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: StyleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'style', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_update_worksheet_cell_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_update_worksheet_cell_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_update_worksheet_cell_style`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_post_update_worksheet_cell_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}/style', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StyleResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_update_worksheet_range_style(self, name, sheet_name, range, **kwargs):
        """
        Update cell's range style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_range_style(name, sheet_name, range, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range. (required)
        :param Style style: with update style settings.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_update_worksheet_range_style_with_http_info(name, sheet_name, range, **kwargs)
        else:
            (data) = self.cells_post_update_worksheet_range_style_with_http_info(name, sheet_name, range, **kwargs)
            return data

    def cells_post_update_worksheet_range_style_with_http_info(self, name, sheet_name, range, **kwargs):
        """
        Update cell's range style.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_range_style_with_http_info(name, sheet_name, range, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Workbook name. (required)
        :param str sheet_name: Worksheet name. (required)
        :param str range: The range. (required)
        :param Style style: with update style settings.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'style', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_update_worksheet_range_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_update_worksheet_range_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_update_worksheet_range_style`")
        # verify the required parameter 'range' is set
        if ('range' not in params) or (params['range'] is None):
            raise ValueError("Missing the required parameter `range` when calling `cells_post_update_worksheet_range_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'range' in params:
            query_params.append(('range', params['range']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'style' in params:
            body_params = params['style']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/style', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_update_worksheet_row(self, name, sheet_name, row_index, **kwargs):
        """
        Update worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_row(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param float height: The new row height.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_update_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
        else:
            (data) = self.cells_post_update_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
            return data

    def cells_post_update_worksheet_row_with_http_info(self, name, sheet_name, row_index, **kwargs):
        """
        Update worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_update_worksheet_row_with_http_info(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The row index. (required)
        :param float height: The new row height.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row_index', 'height', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_update_worksheet_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_update_worksheet_row`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_update_worksheet_row`")
        # verify the required parameter 'row_index' is set
        if ('row_index' not in params) or (params['row_index'] is None):
            raise ValueError("Missing the required parameter `row_index` when calling `cells_post_update_worksheet_row`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'row_index' in params:
            path_params['rowIndex'] = params['row_index']

        query_params = []
        if 'height' in params:
            query_params.append(('height', params['height']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RowResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_worksheet_cell_set_value(self, name, sheet_name, cell_name, **kwargs):
        """
        Set cell value.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_cell_set_value(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param str value: The cell value.
        :param str type: The value type.
        :param str formula: Formula for cell
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_worksheet_cell_set_value_with_http_info(name, sheet_name, cell_name, **kwargs)
        else:
            (data) = self.cells_post_worksheet_cell_set_value_with_http_info(name, sheet_name, cell_name, **kwargs)
            return data

    def cells_post_worksheet_cell_set_value_with_http_info(self, name, sheet_name, cell_name, **kwargs):
        """
        Set cell value.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_cell_set_value_with_http_info(name, sheet_name, cell_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param str cell_name: The cell name. (required)
        :param str value: The cell value.
        :param str type: The value type.
        :param str formula: Formula for cell
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'cell_name', 'value', 'type', 'formula', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_worksheet_cell_set_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_worksheet_cell_set_value`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_worksheet_cell_set_value`")
        # verify the required parameter 'cell_name' is set
        if ('cell_name' not in params) or (params['cell_name'] is None):
            raise ValueError("Missing the required parameter `cell_name` when calling `cells_post_worksheet_cell_set_value`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'cell_name' in params:
            path_params['cellName'] = params['cell_name']

        query_params = []
        if 'value' in params:
            query_params.append(('value', params['value']))
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'formula' in params:
            query_params.append(('formula', params['formula']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/{cellName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_worksheet_merge(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Merge cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_merge(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row. (required)
        :param int start_column: The start column. (required)
        :param int total_rows: The total rows (required)
        :param int total_columns: The total columns. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_worksheet_merge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
        else:
            (data) = self.cells_post_worksheet_merge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
            return data

    def cells_post_worksheet_merge_with_http_info(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Merge cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_merge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row. (required)
        :param int start_column: The start column. (required)
        :param int total_rows: The total rows (required)
        :param int total_columns: The total columns. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'start_row', 'start_column', 'total_rows', 'total_columns', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_worksheet_merge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_worksheet_merge`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_worksheet_merge`")
        # verify the required parameter 'start_row' is set
        if ('start_row' not in params) or (params['start_row'] is None):
            raise ValueError("Missing the required parameter `start_row` when calling `cells_post_worksheet_merge`")
        # verify the required parameter 'start_column' is set
        if ('start_column' not in params) or (params['start_column'] is None):
            raise ValueError("Missing the required parameter `start_column` when calling `cells_post_worksheet_merge`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_post_worksheet_merge`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_post_worksheet_merge`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/merge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_post_worksheet_unmerge(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Unmerge cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_unmerge(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row. (required)
        :param int start_column: The start column. (required)
        :param int total_rows: The total rows (required)
        :param int total_columns: The total columns. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_post_worksheet_unmerge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
        else:
            (data) = self.cells_post_worksheet_unmerge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs)
            return data

    def cells_post_worksheet_unmerge_with_http_info(self, name, sheet_name, start_row, start_column, total_rows, total_columns, **kwargs):
        """
        Unmerge cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_post_worksheet_unmerge_with_http_info(name, sheet_name, start_row, start_column, total_rows, total_columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int start_row: The start row. (required)
        :param int start_column: The start column. (required)
        :param int total_rows: The total rows (required)
        :param int total_columns: The total columns. (required)
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'start_row', 'start_column', 'total_rows', 'total_columns', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_post_worksheet_unmerge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_post_worksheet_unmerge`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_post_worksheet_unmerge`")
        # verify the required parameter 'start_row' is set
        if ('start_row' not in params) or (params['start_row'] is None):
            raise ValueError("Missing the required parameter `start_row` when calling `cells_post_worksheet_unmerge`")
        # verify the required parameter 'start_column' is set
        if ('start_column' not in params) or (params['start_column'] is None):
            raise ValueError("Missing the required parameter `start_column` when calling `cells_post_worksheet_unmerge`")
        # verify the required parameter 'total_rows' is set
        if ('total_rows' not in params) or (params['total_rows'] is None):
            raise ValueError("Missing the required parameter `total_rows` when calling `cells_post_worksheet_unmerge`")
        # verify the required parameter 'total_columns' is set
        if ('total_columns' not in params) or (params['total_columns'] is None):
            raise ValueError("Missing the required parameter `total_columns` when calling `cells_post_worksheet_unmerge`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'start_row' in params:
            query_params.append(('startRow', params['start_row']))
        if 'start_column' in params:
            query_params.append(('startColumn', params['start_column']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'total_columns' in params:
            query_params.append(('totalColumns', params['total_columns']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/unmerge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_properties_delete_document_properties(self, name, **kwargs):
        """
        Delete all custom document properties and clean built-in ones.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_delete_document_properties(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_properties_delete_document_properties_with_http_info(name, **kwargs)
        else:
            (data) = self.cells_properties_delete_document_properties_with_http_info(name, **kwargs)
            return data

    def cells_properties_delete_document_properties_with_http_info(self, name, **kwargs):
        """
        Delete all custom document properties and clean built-in ones.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_delete_document_properties_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_properties_delete_document_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_properties_delete_document_properties`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/documentproperties', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsDocumentPropertiesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_properties_delete_document_property(self, name, property_name, **kwargs):
        """
        Delete document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_delete_document_property(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_properties_delete_document_property_with_http_info(name, property_name, **kwargs)
        else:
            (data) = self.cells_properties_delete_document_property_with_http_info(name, property_name, **kwargs)
            return data

    def cells_properties_delete_document_property_with_http_info(self, name, property_name, **kwargs):
        """
        Delete document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_delete_document_property_with_http_info(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'property_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_properties_delete_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_properties_delete_document_property`")
        # verify the required parameter 'property_name' is set
        if ('property_name' not in params) or (params['property_name'] is None):
            raise ValueError("Missing the required parameter `property_name` when calling `cells_properties_delete_document_property`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'property_name' in params:
            path_params['propertyName'] = params['property_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/documentproperties/{propertyName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsDocumentPropertiesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_properties_get_document_properties(self, name, **kwargs):
        """
        Read document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_get_document_properties(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_properties_get_document_properties_with_http_info(name, **kwargs)
        else:
            (data) = self.cells_properties_get_document_properties_with_http_info(name, **kwargs)
            return data

    def cells_properties_get_document_properties_with_http_info(self, name, **kwargs):
        """
        Read document properties.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_get_document_properties_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertiesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_properties_get_document_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_properties_get_document_properties`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/documentproperties', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsDocumentPropertiesResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_properties_get_document_property(self, name, property_name, **kwargs):
        """
        Read document property by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_get_document_property(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_properties_get_document_property_with_http_info(name, property_name, **kwargs)
        else:
            (data) = self.cells_properties_get_document_property_with_http_info(name, property_name, **kwargs)
            return data

    def cells_properties_get_document_property_with_http_info(self, name, property_name, **kwargs):
        """
        Read document property by name.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_get_document_property_with_http_info(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'property_name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_properties_get_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_properties_get_document_property`")
        # verify the required parameter 'property_name' is set
        if ('property_name' not in params) or (params['property_name'] is None):
            raise ValueError("Missing the required parameter `property_name` when calling `cells_properties_get_document_property`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'property_name' in params:
            path_params['propertyName'] = params['property_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/documentproperties/{propertyName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsDocumentPropertyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_properties_put_document_property(self, name, property_name, **kwargs):
        """
        Set/create document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_put_document_property(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param CellsDocumentProperty _property: with new property value.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_properties_put_document_property_with_http_info(name, property_name, **kwargs)
        else:
            (data) = self.cells_properties_put_document_property_with_http_info(name, property_name, **kwargs)
            return data

    def cells_properties_put_document_property_with_http_info(self, name, property_name, **kwargs):
        """
        Set/create document property.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_properties_put_document_property_with_http_info(name, property_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The document name. (required)
        :param str property_name: The property name. (required)
        :param CellsDocumentProperty _property: with new property value.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsDocumentPropertyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'property_name', '_property', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_properties_put_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_properties_put_document_property`")
        # verify the required parameter 'property_name' is set
        if ('property_name' not in params) or (params['property_name'] is None):
            raise ValueError("Missing the required parameter `property_name` when calling `cells_properties_put_document_property`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'property_name' in params:
            path_params['propertyName'] = params['property_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if '_property' in params:
            body_params = params['_property']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/documentproperties/{propertyName}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsDocumentPropertyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_put_insert_worksheet_columns(self, name, sheet_name, column_index, columns, **kwargs):
        """
        Insert worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_columns(name, sheet_name, column_index, columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param int columns: The columns. (required)
        :param bool update_reference: The update reference.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_put_insert_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, **kwargs)
        else:
            (data) = self.cells_put_insert_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, **kwargs)
            return data

    def cells_put_insert_worksheet_columns_with_http_info(self, name, sheet_name, column_index, columns, **kwargs):
        """
        Insert worksheet columns.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_columns_with_http_info(name, sheet_name, column_index, columns, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int column_index: The column index. (required)
        :param int columns: The columns. (required)
        :param bool update_reference: The update reference.
        :param str folder: The workbook folder.
        :param str storage: storage name.
        :return: ColumnsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'column_index', 'columns', 'update_reference', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_put_insert_worksheet_columns" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_put_insert_worksheet_columns`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_put_insert_worksheet_columns`")
        # verify the required parameter 'column_index' is set
        if ('column_index' not in params) or (params['column_index'] is None):
            raise ValueError("Missing the required parameter `column_index` when calling `cells_put_insert_worksheet_columns`")
        # verify the required parameter 'columns' is set
        if ('columns' not in params) or (params['columns'] is None):
            raise ValueError("Missing the required parameter `columns` when calling `cells_put_insert_worksheet_columns`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'column_index' in params:
            path_params['columnIndex'] = params['column_index']

        query_params = []
        if 'columns' in params:
            query_params.append(('columns', params['columns']))
        if 'update_reference' in params:
            query_params.append(('updateReference', params['update_reference']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/columns/{columnIndex}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ColumnsResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_put_insert_worksheet_row(self, name, sheet_name, row_index, **kwargs):
        """
        Insert new worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_row(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The new row index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_put_insert_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
        else:
            (data) = self.cells_put_insert_worksheet_row_with_http_info(name, sheet_name, row_index, **kwargs)
            return data

    def cells_put_insert_worksheet_row_with_http_info(self, name, sheet_name, row_index, **kwargs):
        """
        Insert new worksheet row.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_row_with_http_info(name, sheet_name, row_index, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int row_index: The new row index. (required)
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: RowResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'row_index', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_put_insert_worksheet_row" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_put_insert_worksheet_row`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_put_insert_worksheet_row`")
        # verify the required parameter 'row_index' is set
        if ('row_index' not in params) or (params['row_index'] is None):
            raise ValueError("Missing the required parameter `row_index` when calling `cells_put_insert_worksheet_row`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']
        if 'row_index' in params:
            path_params['rowIndex'] = params['row_index']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows/{rowIndex}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RowResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_put_insert_worksheet_rows(self, name, sheet_name, startrow, **kwargs):
        """
        Insert several new worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_rows(name, sheet_name, startrow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated.
        :param bool update_reference: Indicates if update references in other worksheets.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_put_insert_worksheet_rows_with_http_info(name, sheet_name, startrow, **kwargs)
        else:
            (data) = self.cells_put_insert_worksheet_rows_with_http_info(name, sheet_name, startrow, **kwargs)
            return data

    def cells_put_insert_worksheet_rows_with_http_info(self, name, sheet_name, startrow, **kwargs):
        """
        Insert several new worksheet rows.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_put_insert_worksheet_rows_with_http_info(name, sheet_name, startrow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The workbook name. (required)
        :param str sheet_name: The worksheet name. (required)
        :param int startrow: The begin row index to be operated. (required)
        :param int total_rows: Number of rows to be operated.
        :param bool update_reference: Indicates if update references in other worksheets.
        :param str folder: The document folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'startrow', 'total_rows', 'update_reference', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_put_insert_worksheet_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_put_insert_worksheet_rows`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_put_insert_worksheet_rows`")
        # verify the required parameter 'startrow' is set
        if ('startrow' not in params) or (params['startrow'] is None):
            raise ValueError("Missing the required parameter `startrow` when calling `cells_put_insert_worksheet_rows`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'startrow' in params:
            query_params.append(('startrow', params['startrow']))
        if 'total_rows' in params:
            query_params.append(('totalRows', params['total_rows']))
        if 'update_reference' in params:
            query_params.append(('updateReference', params['update_reference']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/cells/rows', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_get_worksheet_cells_range_value(self, name, sheet_name, **kwargs):
        """
        Get cells list in a range by range name or row column indexes  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_get_worksheet_cells_range_value(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param str namerange: range name, for example: 'A1:B2' or 'range_name1'
        :param int first_row: the first row of the range
        :param int first_column: the first column of the range
        :param int row_count: the count of rows in the range
        :param int column_count: the count of columns in the range
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: RangeValueResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_get_worksheet_cells_range_value_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ranges_get_worksheet_cells_range_value_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ranges_get_worksheet_cells_range_value_with_http_info(self, name, sheet_name, **kwargs):
        """
        Get cells list in a range by range name or row column indexes  
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_get_worksheet_cells_range_value_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param str namerange: range name, for example: 'A1:B2' or 'range_name1'
        :param int first_row: the first row of the range
        :param int first_column: the first column of the range
        :param int row_count: the count of rows in the range
        :param int column_count: the count of columns in the range
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: RangeValueResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'namerange', 'first_row', 'first_column', 'row_count', 'column_count', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_get_worksheet_cells_range_value" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_get_worksheet_cells_range_value`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_get_worksheet_cells_range_value`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'namerange' in params:
            query_params.append(('namerange', params['namerange']))
        if 'first_row' in params:
            query_params.append(('firstRow', params['first_row']))
        if 'first_column' in params:
            query_params.append(('firstColumn', params['first_column']))
        if 'row_count' in params:
            query_params.append(('rowCount', params['row_count']))
        if 'column_count' in params:
            query_params.append(('columnCount', params['column_count']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/value', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='RangeValueResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_column_width(self, name, sheet_name, value, **kwargs):
        """
        Set column width of range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_column_width(name, sheet_name, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param float value: (required)
        :param Range range:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_column_width_with_http_info(name, sheet_name, value, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_column_width_with_http_info(name, sheet_name, value, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_column_width_with_http_info(self, name, sheet_name, value, **kwargs):
        """
        Set column width of range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_column_width_with_http_info(name, sheet_name, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param float value: (required)
        :param Range range:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'value', 'range', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_column_width" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_column_width`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_column_width`")
        # verify the required parameter 'value' is set
        if ('value' not in params) or (params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `cells_ranges_post_worksheet_cells_range_column_width`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'value' in params:
            query_params.append(('value', params['value']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range' in params:
            body_params = params['range']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/columnWidth', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_merge(self, name, sheet_name, **kwargs):
        """
        Combines a range of cells into a single cell.              
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_merge(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_merge_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_merge_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_merge_with_http_info(self, name, sheet_name, **kwargs):
        """
        Combines a range of cells into a single cell.              
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_merge_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_merge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_merge`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_merge`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range' in params:
            body_params = params['range']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/merge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_move_to(self, name, sheet_name, dest_row, dest_column, **kwargs):
        """
        Move the current range to the dest range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_move_to(name, sheet_name, dest_row, dest_column, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param int dest_row: The start row of the dest range. (required)
        :param int dest_column: The start column of the dest range. (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_move_to_with_http_info(name, sheet_name, dest_row, dest_column, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_move_to_with_http_info(name, sheet_name, dest_row, dest_column, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_move_to_with_http_info(self, name, sheet_name, dest_row, dest_column, **kwargs):
        """
        Move the current range to the dest range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_move_to_with_http_info(name, sheet_name, dest_row, dest_column, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param int dest_row: The start row of the dest range. (required)
        :param int dest_column: The start column of the dest range. (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'dest_row', 'dest_column', 'range', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_move_to" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_move_to`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_move_to`")
        # verify the required parameter 'dest_row' is set
        if ('dest_row' not in params) or (params['dest_row'] is None):
            raise ValueError("Missing the required parameter `dest_row` when calling `cells_ranges_post_worksheet_cells_range_move_to`")
        # verify the required parameter 'dest_column' is set
        if ('dest_column' not in params) or (params['dest_column'] is None):
            raise ValueError("Missing the required parameter `dest_column` when calling `cells_ranges_post_worksheet_cells_range_move_to`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'dest_row' in params:
            query_params.append(('destRow', params['dest_row']))
        if 'dest_column' in params:
            query_params.append(('destColumn', params['dest_column']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range' in params:
            body_params = params['range']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/moveto', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_outline_border(self, name, sheet_name, **kwargs):
        """
        Sets outline border around a range of cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_outline_border(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param RangeSetOutlineBorderRequest range_operate: Range Set OutlineBorder Request 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_outline_border_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_outline_border_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_outline_border_with_http_info(self, name, sheet_name, **kwargs):
        """
        Sets outline border around a range of cells.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_outline_border_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param RangeSetOutlineBorderRequest range_operate: Range Set OutlineBorder Request 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range_operate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_outline_border" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_outline_border`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_outline_border`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range_operate' in params:
            body_params = params['range_operate']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/outlineBorder', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_row_height(self, name, sheet_name, value, **kwargs):
        """
        set row height of range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_row_height(name, sheet_name, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param float value: (required)
        :param Range range:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_row_height_with_http_info(name, sheet_name, value, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_row_height_with_http_info(name, sheet_name, value, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_row_height_with_http_info(self, name, sheet_name, value, **kwargs):
        """
        set row height of range
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_row_height_with_http_info(name, sheet_name, value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: (required)
        :param str sheet_name: (required)
        :param float value: (required)
        :param Range range:
        :param str folder:
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'value', 'range', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_row_height" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_row_height`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_row_height`")
        # verify the required parameter 'value' is set
        if ('value' not in params) or (params['value'] is None):
            raise ValueError("Missing the required parameter `value` when calling `cells_ranges_post_worksheet_cells_range_row_height`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'value' in params:
            query_params.append(('value', params['value']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range' in params:
            body_params = params['range']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/rowHeight', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_style(self, name, sheet_name, **kwargs):
        """
        Sets the style of the range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_style(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param RangeSetStyleRequest range_operate: Range Set Style Request 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_style_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_style_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_style_with_http_info(self, name, sheet_name, **kwargs):
        """
        Sets the style of the range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_style_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param RangeSetStyleRequest range_operate: Range Set Style Request 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range_operate', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_style" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_style`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_style`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range_operate' in params:
            body_params = params['range_operate']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/style', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def cells_ranges_post_worksheet_cells_range_unmerge(self, name, sheet_name, **kwargs):
        """
        Unmerges merged cells of this range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_unmerge(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        self.check_access_token()
        if kwargs.get('callback'):
            return self.cells_ranges_post_worksheet_cells_range_unmerge_with_http_info(name, sheet_name, **kwargs)
        else:
            (data) = self.cells_ranges_post_worksheet_cells_range_unmerge_with_http_info(name, sheet_name, **kwargs)
            return data

    def cells_ranges_post_worksheet_cells_range_unmerge_with_http_info(self, name, sheet_name, **kwargs):
        """
        Unmerges merged cells of this range.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.cells_ranges_post_worksheet_cells_range_unmerge_with_http_info(name, sheet_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: workbook name (required)
        :param str sheet_name: worksheet name (required)
        :param Range range: range in worksheet 
        :param str folder: Workbook folder.
        :param str storage: storage name.
        :return: CellsCloudResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'sheet_name', 'range', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cells_ranges_post_worksheet_cells_range_unmerge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `cells_ranges_post_worksheet_cells_range_unmerge`")
        # verify the required parameter 'sheet_name' is set
        if ('sheet_name' not in params) or (params['sheet_name'] is None):
            raise ValueError("Missing the required parameter `sheet_name` when calling `cells_ranges_post_worksheet_cells_range_unmerge`")


        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'sheet_name' in params:
            path_params['sheetName'] = params['sheet_name']

        query_params = []
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'range' in params:
            body_params = params['range']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/cells/{name}/worksheets/{sheetName}/ranges/unmerge', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='CellsCloudResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=par