import re
try:
    from urllib import parse
except ImportError:
    import urlparse as parse

from .base import _YahooFinance


class Screener(_YahooFinance):

    SCREENERS = {
        "accident_health_insurance": {
            "desc": "Accident & Health Insurance Stocks",
            "id": "ae93c45e-368f-4892-8684-f3503d7b7086",
            "title": "Accident & Health Insurance"
        },
        "advertising_agencies": {
            "desc": "Advertising Agencies Stocks",
            "id": "7deebcc3-2f08-489d-ac7b-0655da297013",
            "title": "Advertising Agencies"
        },
        "aerospace_defense_major_diversified": {
            "desc": "Aerospace/Defense - Major Diversified Stocks",
            "id": "5f82626f-0c7e-4197-8911-04674b56d415",
            "title": "Aerospace/Defense - Major Diversified"
        },
        "aerospace_defense_products_services": {
            "desc": "Aerospace/Defense Products & Services Stocks",
            "id": "19535808-f950-4791-978d-81a916513df2",
            "title": "Aerospace/Defense Products & Services"
        },
        "aggressive_small_caps": {
            "desc": "Small cap stocks with high earnings growth rates",
            "id": "af57f75b-eb22-4565-a604-5eb8744dd35c",
            "title": "Aggresive small cap stocks"
        },
        "agricultural_chemicals": {
            "desc": "Agricultural Chemicals Stocks",
            "id": "8ed42a44-1d08-4c7c-b197-884b5350d263",
            "title": "Agricultural Chemicals"
        },
        "air_delivery_freight_services": {
            "desc": "Air Delivery & Freight Services Stocks",
            "id": "9d07b316-fbea-4fa3-a293-4bc00fe55a71",
            "title": "Air Delivery & Freight Services"
        },
        "air_services_other": {
            "desc": "Air Services, Other Stocks",
            "id": "0941052b-864a-41e9-8aac-37adf7561659",
            "title": "Air Services, Other"
        },
        "all_cryptocurrencies_au": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "d4146c38-dd86-418c-b043-82858b3c472d",
            "title": "All Cryptocurrencies"
        },
        "all_cryptocurrencies_ca": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "7d701aca-d272-4d62-8921-fbdf3a5e90cd",
            "title": "All Cryptocurrencies"
        },
        "all_cryptocurrencies_eu": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "56d93251-dc99-492c-b7a9-4335a103c788",
            "title": "All Cryptocurrencies"
        },
        "all_cryptocurrencies_gb": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "b4ee2223-1076-4666-9348-76ec467e6f05",
            "title": "All Cryptocurrencies"
        },
        "all_cryptocurrencies_in": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "ab1f1b1f-e355-49e2-b316-341db363f627",
            "title": "All Cryptocurrencies"
        },
        "all_cryptocurrencies_us": {
            "desc": "Cryptocurrencies ordered in descending order by intraday marketcap",
            "id": "80046292-2898-474e-841c-7866e4f2fc80",
            "title": "All Cryptocurrencies"
        },
        "aluminum": {
            "desc": "Aluminum Stocks",
            "id": "6048eee9-dfe4-42e2-804e-7814644078fe",
            "title": "Aluminum"
        },
        "apparel_stores": {
            "desc": "Apparel Stores Stocks",
            "id": "f2f6b0d6-24aa-4418-8a1c-878089899367",
            "title": "Apparel Stores"
        },
        "appliances": {
            "desc": "Appliances Stocks",
            "id": "324a26f1-d9d1-4f1d-a111-75e709b9cb8d",
            "title": "Appliances"
        },
        "application_software": {
            "desc": "Application Software Stocks",
            "id": "2ba474b6-0510-48cc-936a-d12b32a7caad",
            "title": "Application Software"
        },
        "asset_management": {
            "desc": "Asset Management Stocks",
            "id": "c8b32fcc-27e5-48c0-b45a-901fa1f981c7",
            "title": "Asset Management"
        },
        "auto_dealerships": {
            "desc": "Auto Dealerships Stocks",
            "id": "a33dfb81-0ee0-476e-a4b5-16c3f5ef2fe9",
            "title": "Auto Dealerships"
        },
        "auto_manufacturers_major": {
            "desc": "Auto Manufacturers - Major Stocks",
            "id": "18c9d96e-5413-459a-afbc-87e7cac6765e",
            "title": "Auto Manufacturers - Major"
        },
        "auto_parts": {
            "desc": "Auto Parts Stocks",
            "id": "a56d1cdc-a25f-4568-b209-c6330340a4b3",
            "title": "Auto Parts"
        },
        "auto_parts_stores": {
            "desc": "Auto Parts Stores Stocks",
            "id": "d204ac1e-7e43-408a-883f-34ed3cf79444",
            "title": "Auto Parts Stores"
        },
        "auto_parts_wholesale": {
            "desc": "Auto Parts Wholesale Stocks",
            "id": "fb7cb783-c282-493e-9047-2f8530edb7f1",
            "title": "Auto Parts Wholesale"
        },
        "basic_materials": {
            "desc": "Basic Materials Stocks",
            "id": "3a697e76-9648-4570-813e-b4a459c2e33c",
            "title": "Basic Materials"
        },
        "basic_materials_wholesale": {
            "desc": "Basic Materials Wholesale Stocks",
            "id": "151e09fd-6d7f-41d0-b196-4d08f61c6ec4",
            "title": "Basic Materials Wholesale"
        },
        "beverages_brewers": {
            "desc": "Beverages - Brewers Stocks",
            "id": "043856ac-2e8e-4267-8315-7fbc4d1f166b",
            "title": "Beverages - Brewers"
        },
        "beverages_soft_drinks": {
            "desc": "Beverages - Soft Drinks Stocks",
            "id": "e426103b-1e77-40e9-912e-cd34c79d9b67",
            "title": "Beverages - Soft Drinks"
        },
        "beverages_wineries_distillers": {
            "desc": "Beverages - Wineries & Distillers Stocks",
            "id": "8c0afa98-c552-4169-9a0a-0472d32f68cc",
            "title": "Beverages - Wineries & Distillers"
        },
        "biotechnology": {
            "desc": "Biotechnology Stocks",
            "id": "71a482da-da21-4935-9c62-1bec97e548ae",
            "title": "Biotechnology"
        },
        "broadcasting_radio": {
            "desc": "Broadcasting - Radio Stocks",
            "id": "8f516b9c-261f-444c-b2f8-893fceea46b9",
            "title": "Broadcasting - Radio"
        },
        "broadcasting_tv": {
            "desc": "Broadcasting - TV Stocks",
            "id": "4de7dc2e-4afb-44c6-8f8a-a72040347bbe",
            "title": "Broadcasting - TV"
        },
        "building_materials_wholesale": {
            "desc": "Building Materials Wholesale Stocks",
            "id": "28f66d1e-7c42-488b-b042-a752587878eb",
            "title": "Building Materials Wholesale"
        },
        "business_equipment": {
            "desc": "Business Equipment Stocks",
            "id": "7cba798a-cc73-4df8-b9af-d8d6f1b8d95d",
            "title": "Business Equipment"
        },
        "business_services": {
            "desc": "Business Services Stocks",
            "id": "744edb19-119e-40e4-82e4-d08f09edf47c",
            "title": "Business Services"
        },
        "business_software_services": {
            "desc": "Business Software & Services Stocks",
            "id": "2c2d6477-dbc6-4253-aca9-e1683baf0a9e",
            "title": "Business Software & Services"
        },
        "catalog_mail_order_houses": {
            "desc": "Catalog & Mail Order Houses Stocks",
            "id": "119f488f-e4c6-4c3b-a893-e7d3d0b4a385",
            "title": "Catalog & Mail Order Houses"
        },
        "catv_systems": {
            "desc": "CATV Systems Stocks",
            "id": "a688d87a-fc1a-46c5-9fd6-8c0bd30342b2",
            "title": "CATV Systems"
        },
        "cement": {
            "desc": "Cement Stocks",
            "id": "b54fa128-31fe-4e28-b805-70e1b70b3717",
            "title": "Cement"
        },
        "chemicals_major_diversified": {
            "desc": "Chemicals - Major Diversified Stocks",
            "id": "9c8ad1aa-2133-4986-afe2-4231ebe7719c",
            "title": "Chemicals - Major Diversified"
        },
        "cigarettes": {
            "desc": "Cigarettes Stocks",
            "id": "45807e99-39d3-4e4a-931e-c640043af00b",
            "title": "Cigarettes"
        },
        "cleaning_products": {
            "desc": "Cleaning Products Stocks",
            "id": "5c26290a-39db-4c1f-886f-4813ae177bab",
            "title": "Cleaning Products"
        },
        "closedend_fund_debt": {
            "desc": "Closed-End Fund - Debt Stocks",
            "id": "27534373-2a39-415e-9a67-78d93d35c621",
            "title": "Closed-End Fund - Debt"
        },
        "closedend_fund_equity": {
            "desc": "Closed-End Fund - Equity Stocks",
            "id": "5110bb4b-dd13-473f-afd9-0e799c46cb48",
            "title": "Closed-End Fund - Equity"
        },
        "closedend_fund_foreign": {
            "desc": "Closed-End Fund - Foreign Stocks",
            "id": "f6a5600c-c870-4550-9a54-868f1cce4b90",
            "title": "Closed-End Fund - Foreign"
        },
        "communication_equipment": {
            "desc": "Communication Equipment Stocks",
            "id": "80f748ff-b01a-4bda-a1da-2a9dc9398964",
            "title": "Communication Equipment"
        },
        "computer_based_systems": {
            "desc": "Computer Based Systems Stocks",
            "id": "a3fd7ed8-981a-4c9c-b051-7f22acaec966",
            "title": "Computer Based Systems"
        },
        "computer_peripherals": {
            "desc": "Computer Peripherals Stocks",
            "id": "0489f1dd-ef7f-408e-87e5-cff9d2381219",
            "title": "Computer Peripherals"
        },
        "computers_wholesale": {
            "desc": "Computers Wholesale Stocks",
            "id": "d802163b-dd42-4617-a656-646996ba96fc",
            "title": "Computers Wholesale"
        },
        "confectioners": {
            "desc": "Confectioners Stocks",
            "id": "91abd719-354b-450f-aa0c-ef28cee8c6a7",
            "title": "Confectioners"
        },
        "conglomerates": {
            "desc": "Conglomerates Stocks",
            "id": "2ad87ade-6776-4ebf-b82d-99fdd00b4cb9",
            "title": "Conglomerates"
        },
        "conservative_foreign_funds": {
            "desc": "Foreign funds with Performance Rating of 4 & 5, low risk and top-half returns",
            "id": "86de34fe-ba77-4c36-be03-19c5d7cf4462",
            "title": "Conservative Foreign Funds"
        },
        "consumer_defensive": {
            "desc": "Consumer Defensive Stocks",
            "id": "e0297af8-fc38-4c13-9014-f2565f387214",
            "title": "Consumer Defensive"
        },
        "consumer_goods": {
            "desc": "Consumer Goods Stocks",
            "id": "8482bc34-cae2-411b-ac22-5e5ddd3eddbd",
            "title": "Consumer Goods"
        },
        "consumer_services": {
            "desc": "Consumer Services Stocks",
            "id": "38fcfdf1-05ac-4b94-8d85-7180c26654c8",
            "title": "Consumer Services"
        },
        "copper": {
            "desc": "Copper Stocks",
            "id": "c1e30f24-daa2-4ce7-af9a-67be4812d080",
            "title": "Copper"
        },
        "credit_services": {
            "desc": "Credit Services Stocks",
            "id": "0d597b4f-ad90-4748-95cc-85a4fe6a9573",
            "title": "Credit Services"
        },
        "dairy_products": {
            "desc": "Dairy Products Stocks",
            "id": "4cc8706a-70fc-4a49-8a44-46ccd0aa887e",
            "title": "Dairy Products"
        },
        "data_storage_devices": {
            "desc": "Data Storage Devices Stocks",
            "id": "3b4ad95e-ecf4-44ef-82f1-e0cf59e936f9",
            "title": "Data Storage Devices"
        },
        "day_gainers": {
            "desc": "Stocks ordered in descending order by price percent change greater than 3% with respect to the previous close",
            "id": "ec5bebb9-b7b2-4474-9e5c-3e258b61cbe6",
            "title": "Day Gainers - US"
        },
        "day_gainers_americas": {
            "desc": "stocks ordered in descending order by price percent change greater than 3% with respect to the previous close",
            "id": "0bfef98d-1a4b-449a-9049-737656446e7c",
            "title": "Day Gainers Americas"
        },
        "day_gainers_asia": {
            "desc": "stocks ordered in descending order by price percent change greater than 3% with respect to the previous close",
            "id": "fe852975-302e-413a-bd9c-7a2d602645e9",
            "title": "Day Gainers Asia"
        },
        "day_gainers_au": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Australia",
            "id": "d0907194-0b84-44d8-8005-054546c8f66b",
            "title": "Day Gainers - Australia"
        },
        "day_gainers_br": {
            "desc": "Stocks ordered in descending order by price percent change greater than 3% with respect to the previous close",
            "id": "8fd79848-c838-46bc-986c-7b97414e7d76",
            "title": "Day Gainers - Brazil"
        },
        "day_gainers_ca": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Canada",
            "id": "4a047ba4-ba4e-4372-8327-202083a89057",
            "title": "Day Gainers - Canada"
        },
        "day_gainers_de": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Germany",
            "id": "62764a5a-a47b-4a0d-b72a-f454e7b8acfb",
            "title": "Day Gainers - Germany"
        },
        "day_gainers_dji": {
            "desc": "Day Gainers - Dow Jones Industrials",
            "id": "9e621bd5-9a7e-4d00-869d-1b1e1b05afd0",
            "title": "Day Gainers - Dow Jones Industrials"
        },
        "day_gainers_es": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Spain",
            "id": "c50cfd23-75cc-4549-8c57-5029e10f962c",
            "title": "Day Gainers - Spain"
        },
        "day_gainers_europe": {
            "desc": "stocks ordered in descending order by price percent change greater than 3% with respect to the previous close",
            "id": "43463575-8b42-4762-9d7e-705588a25dcd",
            "title": "Day Gainers Europe"
        },
        "day_gainers_fr": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for France",
            "id": "9b598d0d-18d5-406e-a807-98d3e63c6afb",
            "title": "Day Gainers - France"
        },
        "day_gainers_gb": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for United Kingdom",
            "id": "97b9075b-c5ab-4c85-bfd3-9694a061e5d2",
            "title": "Day Gainers - United Kingdom"
        },
        "day_gainers_hk": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Hong Kong",
            "id": "93505957-f2ce-4666-8f7c-91275819b5f6",
            "title": "Day Gainers - Hong Kong"
        },
        "day_gainers_in": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for India",
            "id": "134b914f-e393-4b2e-a824-b4be15517cd8",
            "title": "Day Gainers - India"
        },
        "day_gainers_it": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Italy",
            "id": "9c86c7ac-c474-40d9-8912-1906cfc6cc1c",
            "title": "Day Gainers - Italy"
        },
        "day_gainers_ndx": {
            "desc": "Day Gainers - NASDAQ 100",
            "id": "d1d6e2ab-ca6f-4a7d-a2f2-d872efc816ef",
            "title": "Day Gainers - NASDAQ 100"
        },
        "day_gainers_nz": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for New Zealand",
            "id": "faa6cfcd-cb5d-4dfc-8532-3692ee3cc359",
            "title": "Day Gainers - New Zealand"
        },
        "day_gainers_sg": {
            "desc": "Stocks ordered in descending order by price percent change greater than 2.5% with respect to the previous close for Singapore",
            "id": "4d834f86-c0a9-4211-b7a4-3290011892eb",
            "title": "Day Gainers - Singapore"
        },
        "day_losers": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close",
            "id": "8ecefa87-a8b0-434a-9b39-e061a0baef9b",
            "title": "Day Losers - US"
        },
        "day_losers_americas": {
            "desc": "stocks ordered in ascending order by price percent change lesser than 2.5% with respect to the previous close",
            "id": "0e35eb9f-8cf1-4661-a336-e996c1c6f7f8",
            "title": "Day Losers Americas"
        },
        "day_losers_asia": {
            "desc": "stocks ordered in ascending order by price percent change lesser than 2.5% with respect to the previous close",
            "id": "37df3812-b9ee-41f0-87e4-b5f893f3198d",
            "title": "Day Losers Asia"
        },
        "day_losers_au": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Australia",
            "id": "e8e6731f-0eb9-4377-829c-1f61cb670df4",
            "title": "Day Losers - Australia"
        },
        "day_losers_br": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Brazil",
            "id": "2dd8e3c9-8755-4d02-9bf3-0dd0640d38f2",
            "title": "Day Losers - Brazil"
        },
        "day_losers_ca": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Canada",
            "id": "44c0eb22-33f1-4bf9-b4d0-e940838b47f5",
            "title": "Day Losers - Canada"
        },
        "day_losers_de": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Germany",
            "id": "953e5166-b2b3-471c-a765-4c1c3c15b2da",
            "title": "Day Losers - Germany"
        },
        "day_losers_dji": {
            "desc": "Day Losers - Dow Jones Industrials",
            "id": "c95c79eb-8b89-461b-b4cf-680cf77f057e",
            "title": "Day Losers - Dow Jones Industrials"
        },
        "day_losers_es": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Spain",
            "id": "80678708-0b02-409b-a378-15965a930d60",
            "title": "Day Losers - Spain"
        },
        "day_losers_europe": {
            "desc": "stocks ordered in ascending order by price percent change lesser than 2.5% with respect to the previous close",
            "id": "3dfde79b-6160-4da3-a042-d1a86fd5eff9",
            "title": "Day Losers Europe"
        },
        "day_losers_fr": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for France",
            "id": "bb9aaa7a-935e-49de-999e-e5b86c9aeefa",
            "title": "Day Losers - France"
        },
        "day_losers_gb": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for United Kingdom",
            "id": "01a3b7ec-c577-401f-8b19-57d6bbf5ce8e",
            "title": "Day Losers - United Kingdom"
        },
        "day_losers_hk": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Hong Kong",
            "id": "5d940688-4853-49bd-a3b3-849ca743ad8c",
            "title": "Day Losers - Hong Kong"
        },
        "day_losers_in": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for India",
            "id": "d17726f5-6c05-4c80-9cc9-3578febcdb3c",
            "title": "Day Losers - India"
        },
        "day_losers_it": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Italy",
            "id": "46677e46-895d-4c5c-a938-577d80df2180",
            "title": "Day Losers - Italy"
        },
        "day_losers_ndx": {
            "desc": "Day Losers - NASDAQ 100",
            "id": "b72e29e8-dfc2-428e-ab3f-e69df2008457",
            "title": "Day Losers - NASDAQ 100"
        },
        "day_losers_nz": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for New Zealand",
            "id": "ce6dcbd1-c853-402a-90b4-776865c76f5d",
            "title": "Day Losers - New Zealand"
        },
        "day_losers_sg": {
            "desc": "Stocks ordered in ascending order by price percent change with respect to the previous close for Singapore",
            "id": "87813bf9-1d84-4d03-9552-d5ee38666ca4",
            "title": "Day Losers - Singapore"
        },
        "department_stores": {
            "desc": "Department Stores Stocks",
            "id": "24ffe437-b88f-4eed-892e-28fde7411704",
            "title": "Department Stores"
        },
        "diagnostic_substances": {
            "desc": "Diagnostic Substances Stocks",
            "id": "0d21e4d3-1f56-47f3-aa5b-84355c008c35",
            "title": "Diagnostic Substances"
        },
        "discount_variety_stores": {
            "desc": "Discount, Variety Stores Stocks",
            "id": "eb64feb5-cad7-4fc3-a113-6ebff0afc18c",
            "title": "Discount, Variety Stores"
        },
        "diversified_communication_services": {
            "desc": "Diversified Communication Services Stocks",
            "id": "b440c77b-d1a5-44d9-a907-f46e26de393b",
            "title": "Diversified Communication Services"
        },
        "diversified_computer_systems": {
            "desc": "Diversified Computer Systems Stocks",
            "id": "dc87c541-0d89-47d2-bfc0-0e6ad698ac01",
            "title": "Diversified Computer Systems"
        },
        "diversified_electronics": {
            "desc": "Diversified Electronics Stocks",
            "id": "56ba316c-b776-4262-8b3c-2eb8bc94ba13",
            "title": "Diversified Electronics"
        },
        "diversified_investments": {
            "desc": "Diversified Investments Stocks",
            "id": "00dcd5c5-3958-4f35-8ee0-a9e006783b4c",
            "title": "Diversified Investments"
        },
        "diversified_machinery": {
            "desc": "Diversified Machinery Stocks",
            "id": "7045196f-41b5-4de6-b665-132e8438f025",
            "title": "Diversified Machinery"
        },
        "diversified_utilities": {
            "desc": "Diversified Utilities Stocks",
            "id": "07d94519-1c27-443d-8e75-7328d49e86f6",
            "title": "Diversified Utilities"
        },
        "drug_delivery": {
            "desc": "Drug Delivery Stocks",
            "id": "5e3f50e6-a2b5-47f6-b508-3574e0e0210d",
            "title": "Drug Delivery"
        },
        "drug_manufacturers_major": {
            "desc": "Drug Manufacturers - Major Stocks",
            "id": "e2c86234-82cd-4ad3-9271-19f8e9fb35aa",
            "title": "Drug Manufacturers - Major"
        },
        "drug_manufacturers_other": {
            "desc": "Drug Manufacturers - Other Stocks",
            "id": "a413147e-a405-4976-8004-f781e30fb241",
            "title": "Drug Manufacturers - Other"
        },
        "drug_related_products": {
            "desc": "Drug Related Products Stocks",
            "id": "0ff7e555-433a-489d-93a9-a93cbdc56089",
            "title": "Drug Related Products"
        },
        "drug_stores": {
            "desc": "Drug Stores Stocks",
            "id": "84871e44-d1de-4972-afa9-1f95abc59704",
            "title": "Drug Stores"
        },
        "drugs_generic": {
            "desc": "Drugs - Generic Stocks",
            "id": "1383c698-cfc4-4fce-8cae-6ba59a0f7daf",
            "title": "Drugs - Generic"
        },
        "drugs_wholesale": {
            "desc": "Drugs Wholesale Stocks",
            "id": "d9f21701-62f1-449f-bc05-7f9003d5623b",
            "title": "Drugs Wholesale"
        },
        "education_training_services": {
            "desc": "Education & Training Services Stocks",
            "id": "70d6d9f2-e322-47ab-8af7-8c2409d0d9c1",
            "title": "Education & Training Services"
        },
        "electric_utilities": {
            "desc": "Electric Utilities Stocks",
            "id": "7a550537-69a2-4a77-959a-dadc215a5ddf",
            "title": "Electric Utilities"
        },
        "electronic_equipment": {
            "desc": "Electronic Equipment Stocks",
            "id": "e9f52eae-f0aa-4cb0-810b-5ae77cfa9724",
            "title": "Electronic Equipment"
        },
        "electronics_stores": {
            "desc": "Electronics Stores Stocks",
            "id": "1249fb8d-cf84-4e1a-b861-534988ef060a",
            "title": "Electronics Stores"
        },
        "electronics_wholesale": {
            "desc": "Electronics Wholesale Stocks",
            "id": "bd8db9b6-3df9-4d6b-852e-1fa52904d7c0",
            "title": "Electronics Wholesale"
        },
        "entertainment_diversified": {
            "desc": "Entertainment - Diversified Stocks",
            "id": "226de064-c772-4d48-bdaf-6ec67708630c",
            "title": "Entertainment - Diversified"
        },
        "fair_value_screener": {
            "desc": "Undervalued stocks with a strong & consistent history of earnings and revenue growth",
            "id": "e2276d18-9203-4b75-8efd-0f3b5f5cde94",
            "title": "Fair Value Screener"
        },
        "farm_construction_machinery": {
            "desc": "Farm & Construction Machinery Stocks",
            "id": "5e4c5e8e-c19a-41ee-bec1-ee36376fd22a",
            "title": "Farm & Construction Machinery"
        },
        "farm_products": {
            "desc": "Farm Products Stocks",
            "id": "389cb282-102f-4933-a5fb-16a55f02b7ee",
            "title": "Farm Products"
        },
        "financial": {
            "desc": "Financial Stocks",
            "id": "69db7777-6328-4583-abfc-6c69beaac7e4",
            "title": "Financial"
        },
        "food_major_diversified": {
            "desc": "Food - Major Diversified Stocks",
            "id": "f70a22e4-bc9d-437b-a536-86c77d3b9dd3",
            "title": "Food - Major Diversified"
        },
        "food_wholesale": {
            "desc": "Food Wholesale Stocks",
            "id": "7c0ddc36-9c35-438c-aff6-d7f0db59886b",
            "title": "Food Wholesale"
        },
        "foreign_money_center_banks": {
            "desc": "Foreign Money Center Banks Stocks",
            "id": "e9da5c1c-630f-431a-ae46-5518a21c126b",
            "title": "Foreign Money Center Banks"
        },
        "foreign_regional_banks": {
            "desc": "Foreign Regional Banks Stocks",
            "id": "0bbb6104-c9aa-431e-a01e-6e5fa08b092b",
            "title": "Foreign Regional Banks"
        },
        "foreign_utilities": {
            "desc": "Foreign Utilities Stocks",
            "id": "d8e3034c-0ca3-4d18-860d-b386ae1649dc",
            "title": "Foreign Utilities"
        },
        "gaming_activities": {
            "desc": "Gaming Activities Stocks",
            "id": "77b7b262-53a1-4ad0-a2a9-af1ce9830628",
            "title": "Gaming Activities"
        },
        "gas_utilities": {
            "desc": "Gas Utilities Stocks",
            "id": "268fe346-d356-477c-98fa-a94998bf5f80",
            "title": "Gas Utilities"
        },
        "general_building_materials": {
            "desc": "General Building Materials Stocks",
            "id": "274cb728-f9c9-4a19-94b9-b372288e1cd1",
            "title": "General Building Materials"
        },
        "general_contractors": {
            "desc": "General Contractors Stocks",
            "id": "60936002-4c04-49c1-b1cd-102ce5278296",
            "title": "General Contractors"
        },
        "general_entertainment": {
            "desc": "General Entertainment Stocks",
            "id": "acbbf9d0-8b69-4e0b-a187-ea5c304b9cfb",
            "title": "General Entertainment"
        },
        "gold": {
            "desc": "Gold Stocks",
            "id": "2361c12d-b555-46a3-8a02-f4af101ce899",
            "title": "Gold"
        },
        "grocery_stores": {
            "desc": "Grocery Stores Stocks",
            "id": "1e5a01cd-20a5-4fee-91a2-49db0b2e7068",
            "title": "Grocery Stores"
        },
        "growth_technology_stocks": {
            "desc": "Technology stocks with revenue and earnings growth in excess of 25%.",
            "id": "e0c43708-7fa1-4f02-9425-697c0443d32f",
            "title": "Growth Technology Stocks"
        },
        "health_care_plans": {
            "desc": "Health Care Plans Stocks",
            "id": "7b7cae71-7acc-4845-89f1-50d4e968f9b2",
            "title": "Health Care Plans"
        },
        "healthcare": {
            "desc": "Healthcare Stocks",
            "id": "a61c851f-5d25-4237-878f-db9c46040b1a",
            "title": "Healthcare"
        },
        "healthcare_information_services": {
            "desc": "Healthcare Information Services Stocks",
            "id": "fd595c95-cf2e-4bdd-8916-f8725015e19a",
            "title": "Healthcare Information Services"
        },
        "heavy_construction": {
            "desc": "Heavy Construction Stocks",
            "id": "9e2a27dd-c3c4-4859-8605-cbe9fe1ebac4",
            "title": "Heavy Construction"
        },
        "high_yield_bond": {
            "desc": "High Yield Bond with Performance Rating of 4 & 5, low risk and top-half returns",
            "id": "d675527c-bc6a-486c-872d-bca43fbb4322",
            "title": "High Yield Bond"
        },
        "home_furnishing_stores": {
            "desc": "Home Furnishing Stores Stocks",
            "id": "1878c038-4c2c-4ded-afd2-9cea57212d7f",
            "title": "Home Furnishing Stores"
        },
        "home_furnishings_fixtures": {
            "desc": "Home Furnishings & Fixtures Stocks",
            "id": "bf4e278f-23d5-4b48-895f-94de35890d99",
            "title": "Home Furnishings & Fixtures"
        },
        "home_health_care": {
            "desc": "Home Health Care Stocks",
            "id": "4cc4a8d5-6cad-443b-8a58-5defb06a4e4d",
            "title": "Home Health Care"
        },
        "home_improvement_stores": {
            "desc": "Home Improvement Stores Stocks",
            "id": "088b187c-667a-4e12-97b3-17c9c7c8f98a",
            "title": "Home Improvement Stores"
        },
        "hospitals": {
            "desc": "Hospitals Stocks",
            "id": "651ab7b2-1214-41b8-9f7a-83dc7841fb10",
            "title": "Hospitals"
        },
        "housewares_accessories": {
            "desc": "Housewares & Accessories Stocks",
            "id": "142a2ee4-cfc1-45d7-83c0-30e737c8931a",
            "title": "Housewares & Accessories"
        },
        "independent_oil_gas": {
            "desc": "Independent Oil & Gas Stocks",
            "id": "cac7e5ae-03af-435e-8ca4-e33eeb82a61a",
            "title": "Independent Oil & Gas"
        },
        "industrial_electrical_equipment": {
            "desc": "Industrial Electrical Equipment Stocks",
            "id": "bd3aa4dc-6f42-44f7-82fa-b934b7be253f",
            "title": "Industrial Electrical Equipment"
        },
        "industrial_equipment_components": {
            "desc": "Industrial Equipment & Components Stocks",
            "id": "f2a8afa0-0aae-4fac-9463-7af4e30f85af",
            "title": "Industrial Equipment & Components"
        },
        "industrial_equipment_wholesale": {
            "desc": "Industrial Equipment Wholesale Stocks",
            "id": "c311f83c-1e52-43e2-a20d-b34196bcb9e7",
            "title": "Industrial Equipment Wholesale"
        },
        "industrial_goods": {
            "desc": "Industrial Goods Stocks",
            "id": "3451cc5c-1271-4bbb-be1b-3e3d0c10d066",
            "title": "Industrial Goods"
        },
        "industrial_metals_minerals": {
            "desc": "Industrial Metals & Minerals Stocks",
            "id": "0c13eed7-59eb-40aa-bf7d-e8b6da6c30b4",
            "title": "Industrial Metals & Minerals"
        },
        "information_delivery_services": {
            "desc": "Information & Delivery Services Stocks",
            "id": "8e9c42cd-636e-458d-89f9-16b61cf5b099",
            "title": "Information & Delivery Services"
        },
        "information_technology_services": {
            "desc": "Information Technology Services Stocks",
            "id": "1f8fc3f6-7cdc-4a87-ab63-b637a0cc9598",
            "title": "Information Technology Services"
        },
        "insurance_brokers": {
            "desc": "Insurance Brokers Stocks",
            "id": "3d08fef1-d735-476c-9f41-c32af4e5d15d",
            "title": "Insurance Brokers"
        },
        "internet_information_providers": {
            "desc": "Internet Information Providers Stocks",
            "id": "a671a9f8-b6b8-40ac-9a9b-46ae5a2dda6a",
            "title": "Internet Information Providers"
        },
        "internet_service_providers": {
            "desc": "Internet Service Providers Stocks",
            "id": "b2a97d8e-a938-40c5-af08-cdf747f50e43",
            "title": "Internet Service Providers"
        },
        "internet_software_services": {
            "desc": "Internet Software & Services Stocks",
            "id": "a74c2a53-c957-4138-858e-7e4a71539366",
            "title": "Internet Software & Services"
        },
        "investment_brokerage_national": {
            "desc": "Investment Brokerage - National Stocks",
            "id": "804969f0-ae71-429f-870c-dd3adef438b4",
            "title": "Investment Brokerage - National"
        },
        "investment_brokerage_regional": {
            "desc": "Investment Brokerage - Regional Stocks",
            "id": "263ea65b-20df-457b-b930-c238df5518f0",
            "title": "Investment Brokerage - Regional"
        },
        "jewelry_stores": {
            "desc": "Jewelry Stores Stocks",
            "id": "1df9286d-94b0-4d92-ac9d-a410a3c3df37",
            "title": "Jewelry Stores"
        },
        "life_insurance": {
            "desc": "Life Insurance Stocks",
            "id": "3505160e-06db-470a-ab0c-a990d7c1a7a3",
            "title": "Life Insurance"
        },
        "lodging": {
            "desc": "Lodging Stocks",
            "id": "e0ff1766-911e-41fe-a356-4772ef8703ad",
            "title": "Lodging"
        },
        "long_distance_carriers": {
            "desc": "Long Distance Carriers Stocks",
            "id": "4064e669-0900-4525-a0ed-95039ddb0981",
            "title": "Long Distance Carriers"
        },
        "longterm_care_facilities": {
            "desc": "Long-Term Care Facilities Stocks",
            "id": "82ed357c-b4ae-4912-b102-ad271dd50265",
            "title": "Long-Term Care Facilities"
        },
        "lumber_wood_production": {
            "desc": "Lumber, Wood Production Stocks",
            "id": "abb9694b-cb82-4d73-9458-fcb21be6a816",
            "title": "Lumber, Wood Production"
        },
        "machine_tools_accessories": {
            "desc": "Machine Tools & Accessories Stocks",
            "id": "af60e5a3-129a-4dd9-9caa-398bb38d6219",
            "title": "Machine Tools & Accessories"
        },
        "major_airlines": {
            "desc": "Major Airlines Stocks",
            "id": "f37f3659-ec67-417c-a748-e64635c8f5a9",
            "title": "Major Airlines"
        },
        "major_integrated_oil_gas": {
            "desc": "Major Integrated Oil & Gas Stocks",
            "id": "0a277914-9c11-438b-867e-587f670b3f27",
            "title": "Major Integrated Oil & Gas"
        },
        "management_services": {
            "desc": "Management Services Stocks",
            "id": "b8ac48d0-53cb-45b0-8ccd-b85340de0ae2",
            "title": "Management Services"
        },
        "marketing_services": {
            "desc": "Marketing Services Stocks",
            "id": "c96ef7b9-c96d-4846-bce4-41d33234e265",
            "title": "Marketing Services"
        },
        "meat_products": {
            "desc": "Meat Products Stocks",
            "id": "61c71d7f-5c7f-472a-afda-6dca4933bd74",
            "title": "Meat Products"
        },
        "medical_appliances_equipment": {
            "desc": "Medical Appliances & Equipment Stocks",
            "id": "49324014-202d-4719-a1b7-a28b622b474b",
            "title": "Medical Appliances & Equipment"
        },
        "medical_equipment_wholesale": {
            "desc": "Medical Equipment Wholesale Stocks",
            "id": "e73da5ae-176a-4b0f-a7e0-1c00ab46f95c",
            "title": "Medical Equipment Wholesale"
        },
        "medical_instruments_supplies": {
            "desc": "Medical Instruments & Supplies Stocks",
            "id": "a4d4cafc-9ecd-41d5-8ef6-a8a40671aa35",
            "title": "Medical Instruments & Supplies"
        },
        "medical_laboratories_research": {
            "desc": "Medical Laboratories & Research Stocks",
            "id": "79cf089e-8853-4d61-8216-8c69c3a2ecad",
            "title": "Medical Laboratories & Research"
        },
        "mega_cap_hc": {
            "desc": "Stocks with Mega Cap in healthcare industry",
            "id": "86889bb3-e9d9-464d-956a-4abe5a9728db",
            "title": "Mega Cap Healthcare"
        },
        "metal_fabrication": {
            "desc": "Metal Fabrication Stocks",
            "id": "78a2d4ca-f254-4cca-8d13-38f838bb504d",
            "title": "Metal Fabrication"
        },
        "money_center_banks": {
            "desc": "Money Center Banks Stocks",
            "id": "f9ad3ccf-37ab-4041-9c67-eabab432c28d",
            "title": "Money Center Banks"
        },
        "mortgage_investment": {
            "desc": "Mortgage Investment Stocks",
            "id": "5d96c8d0-7a02-4e20-a420-cefb9e859048",
            "title": "Mortgage Investment"
        },
        "most_actives": {
            "desc": "Stocks ordered in descending order by intraday trade volume",
            "id": "437465ef-980e-4d8c-a860-de7cbfbab373",
            "title": "Most Actives - US"
        },
        "most_actives_americas": {
            "desc": "Stocks ordered in descending order by intraday trade volume",
            "id": "a143f34f-7d90-473b-855b-67787326ce2c",
            "title": "Most Actives Americas"
        },
        "most_actives_asia": {
            "desc": "Stocks ordered in descending order by intraday trade volume",
            "id": "2e23187d-c4ff-48a5-b498-161a80b0145b",
            "title": "Most Actives Asia"
        },
        "most_actives_au": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Australia",
            "id": "d0dad29a-9a50-445b-8ca4-1367e51826eb",
            "title": "Most Actives - Australia"
        },
        "most_actives_br": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Brazil",
            "id": "ec23a32d-e108-465f-9d4b-e5db1d934f2e",
            "title": "Most Actives - Brazil"
        },
        "most_actives_ca": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Canada",
            "id": "5026cc58-c878-4f43-af38-efbffadce77f",
            "title": "Most Actives - Canada"
        },
        "most_actives_de": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Germany",
            "id": "5b4148d2-5a6d-4466-b663-b5895f5bc583",
            "title": "Most Actives - Germany"
        },
        "most_actives_dji": {
            "desc": "No description",
            "id": "a423c5d4-9eff-4fb5-9995-93d06480ea91",
            "title": "Most Actives - NASDAQ 100"
        },
        "most_actives_es": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Spain",
            "id": "8d1545dc-2fd9-4cac-854e-88f74c54b5dc",
            "title": "Most Actives - Spain"
        },
        "most_actives_europe": {
            "desc": "Stocks ordered in descending order by intraday trade volume",
            "id": "c46c7edd-c97f-4929-9ade-77ec21b86c18",
            "title": "Most Actives Europe"
        },
        "most_actives_fr": {
            "desc": "Stocks ordered in descending order by intraday trade volume for France",
            "id": "05f97149-f902-4cd3-8f72-f7768ac673e0",
            "title": "Most Actives - France"
        },
        "most_actives_gb": {
            "desc": "Stocks ordered in descending order by intraday trade volume for United Kingdom",
            "id": "433c5af8-f58f-4d92-8338-7d928f558a0d",
            "title": "Most Actives - United Kingdom"
        },
        "most_actives_hk": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Hong Kong",
            "id": "9dbdb8ef-d0c2-446f-baab-be6997a20be8",
            "title": "Most Actives - Hong Kong"
        },
        "most_actives_in": {
            "desc": "Stocks ordered in descending order by intraday trade volume for India",
            "id": "09a035cc-f535-4249-bfae-ed95e7a9e12e",
            "title": "Most Actives - India"
        },
        "most_actives_it": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Italy",
            "id": "2ec96414-6fb7-4da4-8600-cf6f82d0e6d8",
            "title": "Most Actives - Italy"
        },
        "most_actives_ndx": {
            "desc": "No description",
            "id": "393c6a0f-d975-45a7-91b5-478fd3847b31",
            "title": "Most Actives - NASDAQ 100"
        },
        "most_actives_nz": {
            "desc": "Stocks ordered in descending order by intraday trade volume for New Zealand",
            "id": "b6b57880-3ce5-4f10-943b-a5b6dbf77f4d",
            "title": "Most Actives - New Zealand"
        },
        "most_actives_sg": {
            "desc": "Stocks ordered in descending order by intraday trade volume for Singapore",
            "id": "96384b8f-b161-4eef-abf8-d1ce290da125",
            "title": "Most Actives - Singapore"
        },
        "most_watched_tickers": {
            "desc": "Top 30 tickers with highest portfolioheldcount",
            "id": "04c9d12e-f0a3-4ab8-bab8-904a2d1c3ab2",
            "title": "Most added to watchlist"
        },
        "movie_production_theaters": {
            "desc": "Movie Production, Theaters Stocks",
            "id": "6a3ac566-2922-470c-b06e-efd97588c0de",
            "title": "Movie Production, Theaters"
        },
        "ms_basic_materials": {
            "desc": "Basic Materials ordered by intra day market cap for US region",
            "id": "a4f8a58b-e458-44fe-b304-04af382a364e",
            "title": "Basic Materials Sector"
        },
        "ms_communication_services": {
            "desc": "Communication Services ordered by intra day market cap for US region",
            "id": "b8a44a72-2d49-4a2f-9261-f0fff3c2e4e2",
            "title": "Communication Services Sector"
        },
        "ms_consumer_cyclical": {
            "desc": "Consumer Cyclical ordered by intra day market cap for US region",
            "id": "4969e5a1-b0e0-416e-9ae3-191414339e3a",
            "title": "Consumer Cyclical Sector"
        },
        "ms_consumer_defensive": {
            "desc": "Consumer Defensive ordered by intra day market cap for US region",
            "id": "6a15b340-2e3c-44a6-b339-b7ae5c097be5",
            "title": "Consumer Defensive Sector"
        },
        "ms_energy": {
            "desc": "Energy Services ordered by intra day market cap for US region",
            "id": "2efb4ff8-64f4-4941-abb5-a399a6d0f66a",
            "title": "Energy Services Sector"
        },
        "ms_financial_services": {
            "desc": "Financial Services ordered by intra day market cap for US region",
            "id": "667f5248-3710-40d9-8d95-6582fdfa254c",
            "title": "Financial Services Sector"
        },
        "ms_healthcare": {
            "desc": "Healthcare ordered by intra day market cap for US region",
            "id": "e568d534-af60-4d20-a192-93bd4508f1bf",
            "title": "Healthcare Sector"
        },
        "ms_industrials": {
            "desc": "Industrials Services ordered by intra day market cap for US region",
            "id": "caf102b6-2c28-4abc-9d81-b13d710af432",
            "title": "Industrials Services Sector"
        },
        "ms_real_estate": {
            "desc": "Real Estate ordered by intra day market cap for US region",
            "id": "69d56754-89fd-4bc4-9f57-66ed42291311",
            "title": "Real Estate Sector"
        },
        "ms_technology": {
            "desc": "Technology Services ordered by intra day market cap for US region",
            "id": "c7b3f121-188a-4846-83e4-f049fab045cd",
            "title": "Technology Services Sector"
        },
        "ms_utilities": {
            "desc": "Utilities ordered by intra day market cap for US region",
            "id": "590cedc7-6ddc-40dc-9839-68b0c1572274",
            "title": "Utilities Sector"
        },
        "multimedia_graphics_software": {
            "desc": "Multimedia & Graphics Software Stocks",
            "id": "2b41b48d-efd5-442f-b099-0833b5d1859a",
            "title": "Multimedia & Graphics Software"
        },
        "networking_communication_devices": {
            "desc": "Networking & Communication Devices Stocks",
            "id": "c6b5fb38-2fc3-4376-a664-e5ec18498fcd",
            "title": "Networking & Communication Devices"
        },
        "nonmetallic_mineral_mining": {
            "desc": "Nonmetallic Mineral Mining Stocks",
            "id": "680d4cfb-49d5-4647-9969-091f0f607b3e",
            "title": "Nonmetallic Mineral Mining"
        },
        "office_supplies": {
            "desc": "Office Supplies Stocks",
            "id": "bd1d7317-6569-4b97-a261-1079c0d4742e",
            "title": "Office Supplies"
        },
        "oil_gas_drilling_exploration": {
            "desc": "Oil & Gas Drilling & Exploration Stocks",
            "id": "c0eda629-1a01-467c-a7a8-87c3bbadd8f2",
            "title": "Oil & Gas Drilling & Exploration"
        },
        "oil_gas_equipment_services": {
            "desc": "Oil & Gas Equipment & Services Stocks",
            "id": "497e4a9f-6092-4b97-9169-5030371cf138",
            "title": "Oil & Gas Equipment & Services"
        },
        "oil_gas_pipelines": {
            "desc": "Oil & Gas Pipelines Stocks",
            "id": "cc2e1037-0c46-4457-8ec6-fe6c253d09b1",
            "title": "Oil & Gas Pipelines"
        },
        "oil_gas_refining_marketing": {
            "desc": "Oil & Gas Refining & Marketing Stocks",
            "id": "8bbbe67c-3680-4833-811f-210b6bd254e3",
            "title": "Oil & Gas Refining & Marketing"
        },
        "packaging_containers": {
            "desc": "Packaging & Containers Stocks",
            "id": "af5cd4df-8857-4ff3-9db4-8473b65cdff6",
            "title": "Packaging & Containers"
        },
        "paper_paper_products": {
            "desc": "Paper & Paper Products Stocks",
            "id": "6bc68ccf-c574-4e69-a4fc-7a6b1c397de2",
            "title": "Paper & Paper Products"
        },
        "personal_products": {
            "desc": "Personal Products Stocks",
            "id": "12365539-b90c-4200-bcdd-c74a49a8d60b",
            "title": "Personal Products"
        },
        "personal_services": {
            "desc": "Personal Services Stocks",
            "id": "53860387-1bcc-46ee-af4d-11726648d596",
            "title": "Personal Services"
        },
        "photographic_equipment_supplies": {
            "desc": "Photographic Equipment & Supplies Stocks",
            "id": "c5bc5a27-2fd9-4582-ab84-7221f8219fa9",
            "title": "Photographic Equipment & Supplies"
        },
        "pollution_treatment_controls": {
            "desc": "Pollution & Treatment Controls Stocks",
            "id": "1278f73b-97e1-4482-bd04-f920c73d5f5f",
            "title": "Pollution & Treatment Controls"
        },
        "portfolio_anchors": {
            "desc": "Funds with Performance Rating of 4 & 5 and top-half returns that could serve as a rock-solid core of an investor&#39;s portfolio",
            "id": "7a0584d9-28a1-4a94-ac68-21f0aab91c4a",
            "title": "Portfolio Anchors"
        },
        "printed_circuit_boards": {
            "desc": "Printed Circuit Boards Stocks",
            "id": "8e27a780-a6f6-4684-84de-f4741b964c11",
            "title": "Printed Circuit Boards"
        },
        "processed_packaged_goods": {
            "desc": "Processed & Packaged Goods Stocks",
            "id": "d3c168fe-81cb-47a0-b51a-03f405006f22",
            "title": "Processed & Packaged Goods"
        },
        "processing_systems_products": {
            "desc": "Processing Systems & Products Stocks",
            "id": "a93b4045-47da-4543-8d52-62d698324a43",
            "title": "Processing Systems & Products"
        },
        "property_casualty_insurance": {
            "desc": "Property & Casualty Insurance Stocks",
            "id": "4a6b2ed1-fdd1-4d4a-b299-07ba560f8e25",
            "title": "Property & Casualty Insurance"
        },
        "property_management": {
            "desc": "Property Management Stocks",
            "id": "e8780dfd-c1e3-4c55-b9d9-2c7506a579da",
            "title": "Property Management"
        },
        "publishing_books": {
            "desc": "Publishing - Books Stocks",
            "id": "757c4dea-eb99-4bb2-ba08-f257a351b7bc",
            "title": "Publishing - Books"
        },
        "publishing_newspapers": {
            "desc": "Publishing - Newspapers Stocks",
            "id": "5c8fef92-9388-43b7-9638-d2a7b1ecebf5",
            "title": "Publishing - Newspapers"
        },
        "publishing_periodicals": {
            "desc": "Publishing - Periodicals Stocks",
            "id": "6b166e73-b531-443c-8401-626a1a224af2",
            "title": "Publishing - Periodicals"
        },
        "railroads": {
            "desc": "Railroads Stocks",
            "id": "f70bbf07-292b-4918-9cc0-4d553de4bd8c",
            "title": "Railroads"
        },
        "real_estate_development": {
            "desc": "Real Estate Development Stocks",
            "id": "aa93b691-8dd7-4533-9edd-19af1e943893",
            "title": "Real Estate Development"
        },
        "recreational_goods_other": {
            "desc": "Recreational Goods, Other Stocks",
            "id": "666c8f36-235f-4ce3-9a5d-0fc64eae056a",
            "title": "Recreational Goods, Other"
        },
        "recreational_vehicles": {
            "desc": "Recreational Vehicles Stocks",
            "id": "44e1a55d-5988-4f5b-84f6-0d6173b54f32",
            "title": "Recreational Vehicles"
        },
        "regional_airlines": {
            "desc": "Regional Airlines Stocks",
            "id": "3852fca0-8999-45da-921c-0dd693d719d0",
            "title": "Regional Airlines"
        },
        "regional_midatlantic_banks": {
            "desc": "Regional - Mid-Atlantic Banks Stocks",
            "id": "793ad3df-476d-454d-8870-7b63d12f8c68",
            "title": "Regional - Mid-Atlantic Banks"
        },
        "regional_midwest_banks": {
            "desc": "Regional - Midwest Banks Stocks",
            "id": "a2f4d18d-59e4-44bc-b1a9-810b5d990c2d",
            "title": "Regional - Midwest Banks"
        },
        "regional_northeast_banks": {
            "desc": "Regional - Northeast Banks Stocks",
            "id": "ead4e367-01b0-431c-a7a5-6e9ff620b1b5",
            "title": "Regional - Northeast Banks"
        },
        "regional_pacific_banks": {
            "desc": "Regional - Pacific Banks Stocks",
            "id": "3edd47c6-d35f-4777-9993-8115a07f1196",
            "title": "Regional - Pacific Banks"
        },
        "regional_southeast_banks": {
            "desc": "Regional - Southeast Banks Stocks",
            "id": "583f7386-f439-4634-b0e9-c7ddc91fca53",
            "title": "Regional - Southeast Banks"
        },
        "regional_southwest_banks": {
            "desc": "Regional - Southwest  Banks Stocks",
            "id": "d6ab7013-47c4-4093-bcc0-7295129c04b1",
            "title": "Regional - Southwest  Banks"
        },
        "reit_diversified": {
            "desc": "REIT - Diversified Stocks",
            "id": "1e6617a9-e188-4884-9b45-9ed46c50cbc0",
            "title": "REIT - Diversified"
        },
        "reit_healthcare_facilities": {
            "desc": "REIT - Healthcare Facilities Stocks",
            "id": "09d35e37-5c0a-4175-81f9-26141cc761f0",
            "title": "REIT - Healthcare Facilities"
        },
        "reit_hotel_motel": {
            "desc": "REIT - Hotel/Motel Stocks",
            "id": "93d32d5b-1933-4625-9337-b94606ea07c7",
            "title": "REIT - Hotel/Motel"
        },
        "reit_industrial": {
            "desc": "REIT - Industrial Stocks",
            "id": "f305fc52-f261-4634-b90d-03f5bdcff62c",
            "title": "REIT - Industrial"
        },
        "reit_office": {
            "desc": "REIT - Office Stocks",
            "id": "5abcc044-25d8-46e7-86b1-390b0b723de0",
            "title": "REIT - Office"
        },
        "reit_residential": {
            "desc": "REIT - Residential Stocks",
            "id": "4386d4b1-7fd8-46f7-bf50-a0a8fad0168f",
            "title": "REIT - Residential"
        },
        "reit_retail": {
            "desc": "REIT - Retail Stocks",
            "id": "51c8ff2b-8eb7-44dc-af5d-9362a9e32ae4",
            "title": "REIT - Retail"
        },
        "rental_leasing_services": {
            "desc": "Rental & Leasing Services Stocks",
            "id": "1032be0d-8b10-4b56-a5bd-b486f9f2fde3",
            "title": "Rental & Leasing Services"
        },
        "research_services": {
            "desc": "Research Services Stocks",
            "id": "855eff0c-5ccf-4932-bd81-faada5c421b0",
            "title": "Research Services"
        },
        "residential_construction": {
            "desc": "Residential Construction Stocks",
            "id": "abc687aa-5ab2-4ee1-a5ad-60b3a6cd101c",
            "title": "Residential Construction"
        },
        "resorts_casinos": {
            "desc": "Resorts & Casinos Stocks",
            "id": "687857ca-bcee-453c-a7db-ada450592171",
            "title": "Resorts & Casinos"
        },
        "restaurants": {
            "desc": "Restaurants Stocks",
            "id": "db208c80-4939-4ab2-b713-86f65fdc0062",
            "title": "Restaurants"
        },
        "rubber_plastics": {
            "desc": "Rubber & Plastics Stocks",
            "id": "8424f15b-6a0d-4305-bc8c-84b13aa7d061",
            "title": "Rubber & Plastics"
        },
        "savings_loans": {
            "desc": "Savings & Loans Stocks",
            "id": "39a155f1-9d21-46c9-b553-254639d18ffb",
            "title": "Savings & Loans"
        },
        "scientific_technical_instruments": {
            "desc": "Scientific & Technical Instruments Stocks",
            "id": "5baed8c8-7232-4616-987c-72b0cb87a0bc",
            "title": "Scientific & Technical Instruments"
        },
        "security_protection_services": {
            "desc": "Security & Protection Services Stocks",
            "id": "edc2ddf8-8c95-45e2-bd67-1f554e55421a",
            "title": "Security & Protection Services"
        },
        "security_software_services": {
            "desc": "Security Software & Services Stocks",
            "id": "64d8138d-278e-4875-8967-833323ece77b",
            "title": "Security Software & Services"
        },
        "semiconductor_broad_line": {
            "desc": "Semiconductor - Broad Line Stocks",
            "id": "6ffcfbf6-53dc-4bab-be70-db7c765b1d32",
            "title": "Semiconductor - Broad Line"
        },
        "semiconductor_equipment_materials": {
            "desc": "Semiconductor Equipment & Materials Stocks",
            "id": "bf5bc595-47c8-47ec-a43b-64e2d46bddfe",
            "title": "Semiconductor Equipment & Materials"
        },
        "semiconductor_integrated_circuits": {
            "desc": "Semiconductor - Integrated Circuits Stocks",
            "id": "6dce97ee-a6aa-4079-9640-e6aefa3be747",
            "title": "Semiconductor - Integrated Circuits"
        },
        "semiconductor_memory_chips": {
            "desc": "Semiconductor- Memory Chips Stocks",
            "id": "9a5fd21d-c5d6-4069-8926-80c301a3b233",
            "title": "Semiconductor- Memory Chips"
        },
        "semiconductor_specialized": {
            "desc": "Semiconductor - Specialized Stocks",
            "id": "33b79dbc-6c92-407e-9be7-d3483627042d",
            "title": "Semiconductor - Specialized"
        },
        "services": {
            "desc": "Services Stocks",
            "id": "81a63940-a84a-4946-8f24-79c677ec3d79",
            "title": "Services"
        },
        "shipping": {
            "desc": "Shipping Stocks",
            "id": "91f32f25-b520-45f7-a6cb-add65a146435",
            "title": "Shipping"
        },
        "silver": {
            "desc": "Silver Stocks",
            "id": "225d0c98-78d3-425e-a15e-a6308d461e2b",
            "title": "Silver"
        },
        "small_cap_gainers": {
            "desc": "Small cap stocks with percentchange greater than 5%",
            "id": "483129f4-b25a-44c1-afca-8934593f3f6d",
            "title": "Small caps with momentum"
        },
        "small_tools_accessories": {
            "desc": "Small Tools & Accessories Stocks",
            "id": "64b34413-0579-4af5-b8ab-4d3117cec9c8",
            "title": "Small Tools & Accessories"
        },
        "solid_large_growth_funds": {
            "desc": "Large Growth Funds with Performance Rating of 4 & 5 and top-half returns",
            "id": "5704ade5-098b-4c5e-997f-e50b32be7a55",
            "title": "Solid Large Growth Funds"
        },
        "solid_midcap_growth_funds": {
            "desc": "Mid-Cap Growth Funds with Performance Rating of 4 & 5 and top-half returns",
            "id": "d7235ede-59ce-40ad-99f9-5c7e4ec2c5e6",
            "title": "Solid Mid-Cap Growth Funds"
        },
        "specialized_health_services": {
            "desc": "Specialized Health Services Stocks",
            "id": "b6c3541d-ad4e-45ec-97bf-e2a9f9a73d1d",
            "title": "Specialized Health Services"
        },
        "specialty_chemicals": {
            "desc": "Specialty Chemicals Stocks",
            "id": "0b0c4ef4-b18a-40f1-a938-ef6d140c40da",
            "title": "Specialty Chemicals"
        },
        "specialty_eateries": {
            "desc": "Specialty Eateries Stocks",
            "id": "2c0d4e2a-f954-4b84-a1ca-79627b5ec2cf",
            "title": "Specialty Eateries"
        },
        "specialty_retail_other": {
            "desc": "Specialty Retail, Other Stocks",
            "id": "0fc02448-1a56-4363-ac79-3521bfe4b95a",
            "title": "Specialty Retail, Other"
        },
        "sporting_activities": {
            "desc": "Sporting Activities Stocks",
            "id": "2824bb1b-4e47-4a15-8e06-17ce07f93e4b",
            "title": "Sporting Activities"
        },
        "sporting_goods": {
            "desc": "Sporting Goods Stocks",
            "id": "b1576556-303e-47a1-a6a1-54b08c0ed8c3",
            "title": "Sporting Goods"
        },
        "sporting_goods_stores": {
            "desc": "Sporting Goods Stores Stocks",
            "id": "26168518-22b6-41dd-a39a-574bcc1b1917",
            "title": "Sporting Goods Stores"
        },
        "staffing_outsourcing_services": {
            "desc": "Staffing & Outsourcing Services Stocks",
            "id": "c86a14dd-8ab8-425f-a4fc-421d197067e3",
            "title": "Staffing & Outsourcing Services"
        },
        "steel_iron": {
            "desc": "Steel & Iron Stocks",
            "id": "47759edc-a6c8-479a-a9e1-54e90b63404e",
            "title": "Steel & Iron"
        },
        "surety_title_insurance": {
            "desc": "Surety & Title Insurance Stocks",
            "id": "8205086d-4d37-47e1-8c8b-80c530feb7fc",
            "title": "Surety & Title Insurance"
        },
        "synthetics": {
            "desc": "Synthetics Stocks",
            "id": "b4084f29-1a7f-4058-9aac-c88b6ffdcfd1",
            "title": "Synthetics"
        },
        "technical_services": {
            "desc": "Technical Services Stocks",
            "id": "169b9965-e311-4db4-b059-a078b7cb0353",
            "title": "Technical Services"
        },
        "technical_system_software": {
            "desc": "Technical & System Software Stocks",
            "id": "9d3c3e2a-1e1a-4918-8649-975570c768ec",
            "title": "Technical & System Software"
        },
        "technology": {
            "desc": "Technology Stocks",
            "id": "ca9caa2a-252f-47a8-a223-1f363f7819a3",
            "title": "Technology"
        },
        "telecom_services_domestic": {
            "desc": "Telecom Services - Domestic Stocks",
            "id": "acf3321f-3f60-46a6-8bb5-3c3b4467feff",
            "title": "Telecom Services - Domestic"
        },
        "telecom_services_foreign": {
            "desc": "Telecom Services - Foreign Stocks",
            "id": "c7cfc31b-b535-4b73-a11c-3c27ce920e2c",
            "title": "Telecom Services - Foreign"
        },
        "textile_apparel_clothing": {
            "desc": "Textile - Apparel Clothing Stocks",
            "id": "cdc2c395-163a-4cb5-a16b-55e871f281d0",
            "title": "Textile - Apparel Clothing"
        },
        "textile_apparel_footwear_accessories": {
            "desc": "Textile - Apparel Footwear & Accessories Stocks",
            "id": "e4c335b4-6caa-4e37-8061-61bddd4ffffc",
            "title": "Textile - Apparel Footwear & Accessories"
        },
        "textile_industrial": {
            "desc": "Textile Industrial Stocks",
            "id": "fe16af89-87b5-499d-9fa9-8ef604603c95",
            "title": "Textile Industrial"
        },
        "tobacco_products_other": {
            "desc": "Tobacco Products, Other Stocks",
            "id": "682ce320-dc78-49f9-9320-7f938587953a",
            "title": "Tobacco Products, Other"
        },
        "top_energy_us": {
            "desc": "Energy ordered by Percent Change for US region",
            "id": "9019aa39-cffd-4ffb-8c6c-dc6e9c48ef11",
            "title": "Top Energy US"
        },
        "top_etfs": {
            "desc": "ETFs with Performance Rating of 4 & 5 ordered by Percent Change",
            "id": "9976e04d-d1cb-49d4-abab-f8b45e0ae91c",
            "title": "Top ETFs"
        },
        "top_etfs_hk": {
            "desc": "ETFs ordered by Percent Change for HK region",
            "id": "131fc0f0-3c7b-476d-99e3-115a91680adf",
            "title": "Top ETFs HK"
        },
        "top_etfs_in": {
            "desc": "ETFs ordered by Percent Change for IN region",
            "id": "658effc7-8feb-4c65-9721-451e941be158",
            "title": "Top ETFs IN"
        },
        "top_etfs_us": {
            "desc": "ETFs with Performance Rating of 4 & 5 ordered by Percent Change for US region",
            "id": "1b4ff800-e5f6-40a8-92ad-30e68a728281",
            "title": "Top ETFs US"
        },
        "top_iv_options_us": {
            "desc": "Options with Highest Implied Volatility",
            "id": "f800f896-57a8-49f3-8763-a446d3154f13",
            "title": "Highest Implied Volatility"
        },
        "top_mutual_funds": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change",
            "id": "2ca6caed-e715-4fec-986a-fe68599160d9",
            "title": "Top Mutual Funds"
        },
        "top_mutual_funds_au": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for AU region",
            "id": "ae9de583-95cc-4269-821f-31a6a19febae",
            "title": "Top Mutual funds AU"
        },
        "top_mutual_funds_br": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for BR region",
            "id": "89d702fb-8a14-4f54-8ded-86da666a8d0b",
            "title": "Top Mutual funds BR"
        },
        "top_mutual_funds_ca": {
            "desc": "Mutual Funds ordered by Percent Change for CA region",
            "id": "71f592c6-6dce-4508-953a-311bfe76d0bc",
            "title": "Top Mutual Funds CA"
        },
        "top_mutual_funds_de": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for DE region",
            "id": "21c3ea5b-9d0d-47ef-b12c-efa620c28c7f",
            "title": "Top Mutual funds DE"
        },
        "top_mutual_funds_es": {
            "desc": "Mutual Funds ordered by Percent Change for ES region",
            "id": "3cb76596-ccf6-4bdf-9d37-93ac03515334",
            "title": "Top Mutual funds ES"
        },
        "top_mutual_funds_fr": {
            "desc": "MutualFunds ordered by Percent Change for FR region",
            "id": "a58a9112-738c-4c59-afc2-b5f94ea923a8",
            "title": "Top Mutual Funds FR"
        },
        "top_mutual_funds_gb": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for GB region",
            "id": "8214a99f-4992-4e6a-9eab-1b68ba8124cf",
            "title": "Top Mutual funds GB"
        },
        "top_mutual_funds_hk": {
            "desc": "MutualFunds ordered by Percent Change for HK region",
            "id": "b6e7a9e9-56d5-499b-b4af-018f45a65cd5",
            "title": "Top Mutual Funds HK"
        },
        "top_mutual_funds_in": {
            "desc": "Top Mutual funds for India",
            "id": "1d7eb3bf-ba14-4eae-b09c-b72c772bd995",
            "title": "Top Mutual funds for India"
        },
        "top_mutual_funds_it": {
            "desc": "MutualFunds ordered by Percent Change for IT region",
            "id": "dc43d757-d6c1-4129-bcf4-64e2fdd56472",
            "title": "Top Mutual Funds IT"
        },
        "top_mutual_funds_nz": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for NZ region",
            "id": "5a740873-637d-4895-bd5e-038a0d189025",
            "title": "Top Mutual funds NZ"
        },
        "top_mutual_funds_sg": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for SG region",
            "id": "c36f090e-98c0-40de-8cca-060e4d123304",
            "title": "Top Mutual funds SG"
        },
        "top_mutual_funds_us": {
            "desc": "Funds with Performance Rating of 4 & 5 ordered by Percent Change for US region",
            "id": "b749fa8b-a782-4e64-9224-1ad76e8f3d6c",
            "title": "Top Mutual funds US"
        },
        "top_options_implied_volatality": {
            "desc": "No description",
            "id": "671c40b0-5ea8-4063-89b9-9db45bf9edf0",
            "title": "Highest Implied Volatility"
        },
        "top_options_open_interest": {
            "desc": "Top options by Open Interest",
            "id": "65f51cea-8dc8-4e56-9f99-6ef7720eb69c",
            "title": "High Open Interest"
        },
        "toy_hobby_stores": {
            "desc": "Toy & Hobby Stores Stocks",
            "id": "945f763b-3ff7-4e6d-b173-25f1b72e9068",
            "title": "Toy & Hobby Stores"
        },
        "toys_games": {
            "desc": "Toys & Games Stocks",
            "id": "b0da25c8-bde9-4390-8a07-084eb66cc388",
            "title": "Toys & Games"
        },
        "trucking": {
            "desc": "Trucking Stocks",
            "id": "343d4ccc-e64b-4485-8802-17855e331df6",
            "title": "Trucking"
        },
        "trucks_other_vehicles": {
            "desc": "Trucks & Other Vehicles Stocks",
            "id": "eb5abc8c-07fc-4084-bdc4-43bd8d932660",
            "title": "Trucks & Other Vehicles"
        },
        "undervalued_growth_stocks": {
            "desc": "Stocks with earnings growth rates better than 25% and relatively low PE and PEG ratios.",
            "id": "b597175e-7243-4b42-82da-6811218a0945",
            "title": "Undervalued Growth Stocks"
        },
        "undervalued_large_caps": {
            "desc": "Large cap stocks that are potentially undervalued, ordered descending by volume",
            "id": "e31b19b8-efe0-4ed1-8856-7715c2ef858d",
            "title": "Potentially undervalued large cap stocks"
        },
        "utilities": {
            "desc": "Utilities Stocks",
            "id": "78dc9ee4-ca0c-488d-b3f8-83d7d72f1842",
            "title": "Utilities"
        },
        "waste_management": {
            "desc": "Waste Management Stocks",
            "id": "a4882652-ea1f-4902-9a8b-955adcc42421",
            "title": "Waste Management"
        },
        "water_utilities": {
            "desc": "Water Utilities Stocks",
            "id": "daaf12be-3ea2-49d2-8ac2-32aea07e0ab5",
            "title": "Water Utilities"
        },
        "wireless_communications": {
            "desc": "Wireless Communications Stocks",
            "id": "bd92033c-f5ce-40f2-a04f-dba9cec3ab5d",
            "title": "Wireless Communications"
        }
    }

    def __init__(self, **kwargs):
        super(Screener, self).__init__(**kwargs)

    def _construct_params(self, config, params):
        new_params = {}
        optional_params = [
            k for k in config['query'] if not config['query'][k]['required']
            and config['query'][k]['default'] is not None
        ]
        for optional in optional_params:
            new_params.update({optional: params.get(
                optional, config['query'][optional]['default'])
            })
        new_params.update(self.DEFAULT_QUERY_PARAMS)
        new_params = {
            k: str(v).lower() if v is True or v is False else v
            for k, v in new_params.items()
        }
        return [dict(new_params, scrIds=scrId) for scrId in params['scrIds']]

    def _construct_urls(self, config, params):
        return [self.session.get(url=config['path'], params=p) for p in params]

    def _get_symbol(self, response, params, **kwargs):
        query_params = dict(
            parse.parse_qsl(parse.urlsplit(response.url).query))
        screener_id = query_params['scrIds']
        key = next((k for k in self.SCREENERS
                    if self.SCREENERS[k]['id'] == screener_id))
        return key

    def _check_screen_ids(self, screen_ids):
        all_screeners = list(self.SCREENERS.keys())
        if not isinstance(screen_ids, list):
            screen_ids = re.findall(r"[a-zA-Z_]+", screen_ids)
        if any(elem not in all_screeners for elem in screen_ids):
            raise ValueError("One of {} is not a valid screener.  \
                              Please check available_screeners".format(
                ', '.join(screen_ids)))
        return screen_ids

    @property
    def available_screeners(self):
        """Return list of keys available to pass to
           :func:`Screener.get_screeners`
        """
        return list(self.SCREENERS.keys())

    def get_screeners(self, screen_ids, count=25):
        """Return list of predefined screeners from Yahoo Finance

        Parameters:
        screen_ids (str or list): Keys corresponding to list
            screen_ids = 'most_actives day_gainers'
            screen_ids = ['most_actives', 'day_gainers']
        count (int): Number of items to return, default=25
        """
        screen_ids = self._check_screen_ids(screen_ids)
        scrIds = [self.SCREENERS[screener]['id'] for screener in screen_ids]
        return self._get_data(
            'screener', params={'scrIds': scrIds, 'count': count})
