// Copyright (c) Mito
import React, { Fragment, useState } from 'react';
import DefaultModal from '../DefaultModal';
import { ModalEnum } from './modals';
import TextButton from '../elements/TextButton';
import { DISCORD_INVITE_LINK } from '../../data/documentationLinks';
/*
    A modal that displays error messages and gives
    users actions to recover.
*/
const ErrorModal = (props) => {
    const [viewTraceback, setViewTraceback] = useState(false);
    if (props.error === undefined) {
        return (React.createElement(React.Fragment, null));
    }
    return (React.createElement(DefaultModal, { header: props.error.header, modalType: ModalEnum.Error, wide: true, viewComponent: React.createElement(Fragment, null,
            props.error.to_fix &&
                React.createElement("div", { className: 'text-align-left text-body-1', onClick: () => setViewTraceback((viewTraceback) => !viewTraceback) },
                    props.error.to_fix,
                    " ",
                    ' ',
                    props.error.traceback &&
                        React.createElement("span", { className: 'text-body-1-link' }, "Click to view full traceback.")),
            props.error.traceback && viewTraceback &&
                React.createElement("div", { className: 'flex flex-column text-align-left text-overflow-hidden text-overflow-scroll mt-5px', style: { height: '200px', border: '1px solid var(--mito-purple)', borderRadius: '2px', padding: '5px' } },
                    React.createElement("pre", null, props.error.traceback))), buttons: React.createElement(Fragment, null,
            React.createElement(TextButton, { variant: 'light', width: 'small', onClick: () => {
                    props.setUIState((prevUIState) => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                } }, "Close"),
            React.createElement(TextButton, { variant: 'dark', width: 'medium', href: DISCORD_INVITE_LINK, target: '_blank', onClick: () => {
                    props.setUIState((prevUIState) => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                    void props.mitoAPI.sendLogMessage('clicked_discord_invite', {
                        'location': 'error modal'
                    });
                    return true;
                } }, "Get Immediate Support")) }));
};
export default ErrorModal;
//# sourceMappingURL=ErrorModal.js.map