// Copyright (c) Mito
import React from 'react';
import SheetTab from './SheetTab';
// import css
import "../../../css/footer.css";
import { TaskpaneType } from '../taskpanes/taskpanes';
import PlusIcon from '../icons/PlusIcon';
/*
    Wrapper component that displays the entire footer of the sheet, including
    the sheet tabs, as well as the shape of the currently selected dataframe.
*/
function Footer(props) {
    const sheetIndex = props.gridState.sheetIndex;
    const sheetData = props.sheetDataArray[sheetIndex];
    return (React.createElement("div", { className: 'footer' },
        React.createElement("div", { className: 'footer-add-button', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.IMPORT } });
                });
            } },
            React.createElement(PlusIcon, null)),
        React.createElement("div", { className: "footer-tab-bar" }, props.sheetDataArray.map(df => df.dfName).map((dfName, idx) => {
            return (React.createElement(SheetTab, { key: idx, dfName: dfName, sheetIndex: idx, selectedSheetIndex: sheetIndex, setUIState: props.setUIState, closeOpenEditingPopups: props.closeOpenEditingPopups, mitoAPI: props.mitoAPI, mitoContainerRef: props.mitoContainerRef }));
        })),
        sheetData !== undefined &&
            React.createElement("div", { className: 'footer-right-side' },
                React.createElement("div", { className: 'footer-sheet-shape' },
                    "(",
                    sheetData.numRows,
                    " rows, ",
                    sheetData.numColumns,
                    " cols)"))));
}
export default Footer;
//# sourceMappingURL=Footer.js.map