# sust.api.generated.climate-explorer
This API provides programmatic access to physical risk exposure data.For more guidance on using this API, please visit the Sust Global Dev Center: https://developers.sustglobal.com.

The `sust.api.generated.climate_explorer` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: beta
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3
* python-dateutil

## Getting Started

In your own code, to use this library to connect and interact with sust.api.generated.climate-explorer,
you can run the following:

```python

import time
import sust.api.generated.climate_explorer
from pprint import pprint
from sust.api.generated.climate_explorer.api import portfolios_api
from sust.api.generated.climate_explorer.model.asset_response import AssetResponse
from sust.api.generated.climate_explorer.model.message_response import MessageResponse
from sust.api.generated.climate_explorer.model.physical_risk_dataset_item_response import PhysicalRiskDatasetItemResponse
from sust.api.generated.climate_explorer.model.physical_risk_dataset_summary_response import PhysicalRiskDatasetSummaryResponse
from sust.api.generated.climate_explorer.model.physical_risk_metadata_response import PhysicalRiskMetadataResponse
from sust.api.generated.climate_explorer.model.portfolio_create_request import PortfolioCreateRequest
from sust.api.generated.climate_explorer.model.portfolio_response import PortfolioResponse
# Defining the host is optional and defaults to https://explorer.sustglobal.io/api
# See configuration.py for a list of all supported configuration parameters.
configuration = sust.api.generated.climate_explorer.Configuration(
    host = "https://explorer.sustglobal.io/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: api_key
configuration.api_key['api_key'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'


# Enter a context with an instance of the API client
with sust.api.generated.climate_explorer.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = portfolios_api.PortfoliosApi(api_client)
    portfolio_name = "portfolio_name_example" # str | Name for portfolio
project = "project_example" # str | Name of project. Param only required when user may access more than one. (optional)

    try:
        # Export Portfolio Assets
        api_response = api_instance.portfolios_assets_export_list(portfolio_name, project=project)
        pprint(api_response)
    except sust.api.generated.climate_explorer.ApiException as e:
        print("Exception when calling PortfoliosApi->portfolios_assets_export_list: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://explorer.sustglobal.io/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PortfoliosApi* | [**portfolios_assets_export_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_assets_export_list) | **GET** /portfolios/{portfolio_name}/assets/export | Export Portfolio Assets
*PortfoliosApi* | [**portfolios_assets_import_create**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_assets_import_create) | **POST** /portfolios/{portfolio_name}/assets/import | Import Portfolio Assets
*PortfoliosApi* | [**portfolios_assets_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_assets_list) | **GET** /portfolios/{portfolio_name}/assets | List Portfolio Assets
*PortfoliosApi* | [**portfolios_create**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_create) | **POST** /portfolios/ | Create Portfolio
*PortfoliosApi* | [**portfolios_datasets_physical_export_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_datasets_physical_export_list) | **GET** /portfolios/{portfolio_name}/datasets/physical/export | Export Physical Risk Exposure Dataset
*PortfoliosApi* | [**portfolios_datasets_physical_items_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_datasets_physical_items_list) | **GET** /portfolios/{portfolio_name}/datasets/physical/items | Get Physical Risk Exposure Data
*PortfoliosApi* | [**portfolios_datasets_physical_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_datasets_physical_list) | **GET** /portfolios/{portfolio_name}/datasets/physical | Get Physical Risk Exposure Metadata
*PortfoliosApi* | [**portfolios_datasets_physical_summary_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_datasets_physical_summary_list) | **GET** /portfolios/{portfolio_name}/datasets/physical/summary | Get Physical Risk Exposure Summary
*PortfoliosApi* | [**portfolios_delete**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_delete) | **DELETE** /portfolios/{portfolio_name}/ | Delete Portfolio
*PortfoliosApi* | [**portfolios_list**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_list) | **GET** /portfolios/ | List Portfolios
*PortfoliosApi* | [**portfolios_read**](sust/api/generated/climate_explorer/docs/PortfoliosApi.md#portfolios_read) | **GET** /portfolios/{portfolio_name}/ | Get Portfolio


## Documentation For Models

 - [AssetResponse](sust/api/generated/climate_explorer/docs/AssetResponse.md)
 - [MessageResponse](sust/api/generated/climate_explorer/docs/MessageResponse.md)
 - [PhysicalRiskDatasetItemResponse](sust/api/generated/climate_explorer/docs/PhysicalRiskDatasetItemResponse.md)
 - [PhysicalRiskDatasetSummaryResponse](sust/api/generated/climate_explorer/docs/PhysicalRiskDatasetSummaryResponse.md)
 - [PhysicalRiskMetadataResponse](sust/api/generated/climate_explorer/docs/PhysicalRiskMetadataResponse.md)
 - [PhysicalRiskSummaryIndicators](sust/api/generated/climate_explorer/docs/PhysicalRiskSummaryIndicators.md)
 - [PortfolioCreateRequest](sust/api/generated/climate_explorer/docs/PortfolioCreateRequest.md)
 - [PortfolioResponse](sust/api/generated/climate_explorer/docs/PortfolioResponse.md)
 - [ScenarioPhysicalRiskSummary](sust/api/generated/climate_explorer/docs/ScenarioPhysicalRiskSummary.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: URL query string


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in sust.api.generated.climate_explorer.apis and sust.api.generated.climate_explorer.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from sust.api.generated.climate_explorer.api.default_api import DefaultApi`
- `from sust.api.generated.climate_explorer.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import sust.api.generated.climate_explorer
from sust.api.generated.climate_explorer.apis import *
from sust.api.generated.climate_explorer.models import *
```

