"""
    Sust Global Climate Explorer API

    This API provides programmatic access to physical risk exposure data.For more guidance on using this API, please visit the Sust Global Dev Center: https://developers.sustglobal.com.  # noqa: E501

    The version of the OpenAPI document: beta
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sust.api.generated.climate_explorer.api_client import ApiClient, Endpoint as _Endpoint
from sust.api.generated.climate_explorer.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sust.api.generated.climate_explorer.model.asset_response import AssetResponse
from sust.api.generated.climate_explorer.model.message_response import MessageResponse
from sust.api.generated.climate_explorer.model.physical_risk_dataset_item_response import PhysicalRiskDatasetItemResponse
from sust.api.generated.climate_explorer.model.physical_risk_dataset_summary_response import PhysicalRiskDatasetSummaryResponse
from sust.api.generated.climate_explorer.model.physical_risk_metadata_response import PhysicalRiskMetadataResponse
from sust.api.generated.climate_explorer.model.portfolio_create_request import PortfolioCreateRequest
from sust.api.generated.climate_explorer.model.portfolio_response import PortfolioResponse


class PortfoliosApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.portfolios_assets_export_list_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/assets/export',
                'operation_id': 'portfolios_assets_export_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_assets_import_create_endpoint = _Endpoint(
            settings={
                'response_type': (MessageResponse,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/assets/import',
                'operation_id': 'portfolios_assets_import_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'asset',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                    'asset',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'asset':
                        (file_type,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'asset': 'asset',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'asset': 'form',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.portfolios_assets_list_endpoint = _Endpoint(
            settings={
                'response_type': ([AssetResponse],),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/assets',
                'operation_id': 'portfolios_assets_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                    'rows',
                    'page',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                    'rows':
                        (int,),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                    'rows': 'rows',
                    'page': 'page',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                    'rows': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_create_endpoint = _Endpoint(
            settings={
                'response_type': (PortfolioResponse,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/',
                'operation_id': 'portfolios_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'data',
                    'project',
                ],
                'required': [
                    'data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data':
                        (PortfolioCreateRequest,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'project': 'project',
                },
                'location_map': {
                    'data': 'body',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.portfolios_datasets_physical_export_list_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/datasets/physical/export',
                'operation_id': 'portfolios_datasets_physical_export_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_datasets_physical_items_list_endpoint = _Endpoint(
            settings={
                'response_type': ([PhysicalRiskDatasetItemResponse],),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/datasets/physical/items',
                'operation_id': 'portfolios_datasets_physical_items_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                    'risk_type',
                    'start_date',
                    'end_date',
                    'rows',
                    'page',
                    'scenario',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'risk_type',
                    'scenario',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('risk_type',): {

                        "CYCLONES": "cyclones",
                        "FIRE": "fire",
                        "FLOOD": "flood",
                        "SPEI": "SPEI",
                        "SLR": "SLR",
                        "HEATWAVES": "heatwaves",
                        "OBS_FIRE": "obs_fire",
                        "OBS_FLOOD": "obs_flood",
                        "OBS_CYCLONE": "obs_cyclone",
                        "ANNUAL_PRECIPITATION": "annual_precipitation",
                        "ANNUAL_TEMPERATURE": "annual_temperature",
                        "EXTREME_PRECIPITATION": "extreme_precipitation"
                    },
                    ('scenario',): {

                        "SSP126_LBD": "ssp126_lbd",
                        "SSP126": "ssp126",
                        "SSP126_UBD": "ssp126_ubd",
                        "SSP245_LBD": "ssp245_lbd",
                        "SSP245": "ssp245",
                        "SSP245_UBD": "ssp245_ubd",
                        "SSP585_LBD": "ssp585_lbd",
                        "SSP585": "ssp585",
                        "SSP585_UBD": "ssp585_ubd"
                    },
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                    'risk_type':
                        (str,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'rows':
                        (int,),
                    'page':
                        (int,),
                    'scenario':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                    'risk_type': 'risk_type',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'rows': 'rows',
                    'page': 'page',
                    'scenario': 'scenario',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                    'risk_type': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'rows': 'query',
                    'page': 'query',
                    'scenario': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_datasets_physical_list_endpoint = _Endpoint(
            settings={
                'response_type': (PhysicalRiskMetadataResponse,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/datasets/physical',
                'operation_id': 'portfolios_datasets_physical_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_datasets_physical_summary_list_endpoint = _Endpoint(
            settings={
                'response_type': ([PhysicalRiskDatasetSummaryResponse],),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/datasets/physical/summary',
                'operation_id': 'portfolios_datasets_physical_summary_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                    'rows',
                    'page',
                    'scenario',
                    'window',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                    'scenario',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('scenario',): {

                        "SSP126_LBD": "ssp126_lbd",
                        "SSP126": "ssp126",
                        "SSP126_UBD": "ssp126_ubd",
                        "SSP245_LBD": "ssp245_lbd",
                        "SSP245": "ssp245",
                        "SSP245_UBD": "ssp245_ubd",
                        "SSP585_LBD": "ssp585_lbd",
                        "SSP585": "ssp585",
                        "SSP585_UBD": "ssp585_ubd"
                    },
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                    'rows':
                        (int,),
                    'page':
                        (int,),
                    'scenario':
                        (str,),
                    'window':
                        (int,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                    'rows': 'rows',
                    'page': 'page',
                    'scenario': 'scenario',
                    'window': 'window',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                    'rows': 'query',
                    'page': 'query',
                    'scenario': 'query',
                    'window': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_delete_endpoint = _Endpoint(
            settings={
                'response_type': (MessageResponse,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/',
                'operation_id': 'portfolios_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_list_endpoint = _Endpoint(
            settings={
                'response_type': ([PortfolioResponse],),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/',
                'operation_id': 'portfolios_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'project': 'project',
                },
                'location_map': {
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.portfolios_read_endpoint = _Endpoint(
            settings={
                'response_type': (PortfolioResponse,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/portfolios/{portfolio_name}/',
                'operation_id': 'portfolios_read',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'portfolio_name',
                    'project',
                ],
                'required': [
                    'portfolio_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'portfolio_name':
                        (str,),
                    'project':
                        (str,),
                },
                'attribute_map': {
                    'portfolio_name': 'portfolio_name',
                    'project': 'project',
                },
                'location_map': {
                    'portfolio_name': 'path',
                    'project': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def portfolios_assets_export_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """Export Portfolio Assets  # noqa: E501

        Trigger an export operation of portfolio assets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_assets_export_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_assets_export_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_assets_import_create(
        self,
        portfolio_name,
        asset,
        **kwargs
    ):
        """Import Portfolio Assets  # noqa: E501

        Trigger an import operation of assets into existing portfolio. Format of the required CSV file is documented at https://developers.sustglobal.com/explorer.html.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_assets_import_create(portfolio_name, asset, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio
            asset (file_type): CSV file containing portfolio assets

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        kwargs['asset'] = \
            asset
        return self.portfolios_assets_import_create_endpoint.call_with_http_info(**kwargs)

    def portfolios_assets_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """List Portfolio Assets  # noqa: E501

        Retrieve a set of assets belonging to a specific portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_assets_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            rows (int): Maximum number of items to return per page (min=1, max=250). [optional]
            page (int): Numerical index of current page, beginning at 1. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [AssetResponse]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_assets_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_create(
        self,
        data,
        **kwargs
    ):
        """Create Portfolio  # noqa: E501

        Create an empty portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_create(data, async_req=True)
        >>> result = thread.get()

        Args:
            data (PortfolioCreateRequest):

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PortfolioResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['data'] = \
            data
        return self.portfolios_create_endpoint.call_with_http_info(**kwargs)

    def portfolios_datasets_physical_export_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """Export Physical Risk Exposure Dataset  # noqa: E501

        Trigger an export operation of physical risk exposure data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_datasets_physical_export_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_datasets_physical_export_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_datasets_physical_items_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """Get Physical Risk Exposure Data  # noqa: E501

        Retrieve items from the physical risk exposure dataset generated for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_datasets_physical_items_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            risk_type (str): Climate hazard filter. [optional]
            start_date (str): Left boundary of time range filter in format YYYY-MM-DD. [optional]
            end_date (str): Right boundary of time range filter in format YYYY-MM-DD. [optional]
            rows (int): Maximum number of items to return per page (min=1, max=250). [optional]
            page (int): Numerical index of current page, beginning at 1. [optional]
            scenario (str): Shared socioeconomic pathway filter. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [PhysicalRiskDatasetItemResponse]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_datasets_physical_items_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_datasets_physical_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """Get Physical Risk Exposure Metadata  # noqa: E501

        Retrieve metadata from the physical risk exposure dataset generated for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_datasets_physical_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PhysicalRiskMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_datasets_physical_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_datasets_physical_summary_list(
        self,
        portfolio_name,
        **kwargs
    ):
        """Get Physical Risk Exposure Summary  # noqa: E501

        Retrieve a summary of the physical risk exposure dataset generated for a portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_datasets_physical_summary_list(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str): Name for portfolio

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            rows (int): Maximum number of items to return per page (min=1, max=250). [optional]
            page (int): Numerical index of current page, beginning at 1. [optional]
            scenario (str): Shared socioeconomic pathway filter. [optional]
            window (int): Number of years forward used to determine the Physical Risk Summary. Valid windows are currently 5, 15, and 30. Defaults to 30 if nothing is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [PhysicalRiskDatasetSummaryResponse]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_datasets_physical_summary_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_delete(
        self,
        portfolio_name,
        **kwargs
    ):
        """Delete Portfolio  # noqa: E501

        Deletes a portfolio and all associated Risk Exposure Data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_delete(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str):

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_delete_endpoint.call_with_http_info(**kwargs)

    def portfolios_list(
        self,
        **kwargs
    ):
        """List Portfolios  # noqa: E501

        Retrieve a list of portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [PortfolioResponse]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.portfolios_list_endpoint.call_with_http_info(**kwargs)

    def portfolios_read(
        self,
        portfolio_name,
        **kwargs
    ):
        """Get Portfolio  # noqa: E501

        Retrieve a single portfolio.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.portfolios_read(portfolio_name, async_req=True)
        >>> result = thread.get()

        Args:
            portfolio_name (str):

        Keyword Args:
            project (str): Name of project. Param only required when user may access more than one.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PortfolioResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['portfolio_name'] = \
            portfolio_name
        return self.portfolios_read_endpoint.call_with_http_info(**kwargs)

