"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestSynthesizer = void 0;
const cloud_assembly_schema_1 = require("@aws-cdk/cloud-assembly-schema");
const manifest_writer_1 = require("./manifest-writer");
const emptyManifest = {
    version: '',
    testCases: {},
};
class IntegManifestSynthesizer {
    constructor(testCases) {
        this.testCases = testCases;
    }
    synthesize(session) {
        const manifest = this.testCases
            .map(tc => tc.manifest)
            .reduce(mergeManifests, emptyManifest);
        const snapshotDir = session.assembly.outdir;
        manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
    }
}
exports.IntegManifestSynthesizer = IntegManifestSynthesizer;
function mergeManifests(m1, m2) {
    return {
        version: cloud_assembly_schema_1.Manifest.version(),
        testCases: { ...m1.testCases, ...m2.testCases },
    };
}
//# sourceMappingURL=data:application/json;base64,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