# PY4OPENAG

This open-source package aims to establish the ML4Ops pipeline from public databases to integrated analytics for agriculture. It provides  a variety of functions  to study climate trends and simplify the calculation of commonly used metrics in agriculture, such as growing degree days, extreme heat degree days, the base temperature for different crop types, as well as basic climate metrics like average temperature and total precipitation for user specified time periods. The package also includes unsupervised and supervised learning based on these metrics. . 

The development of this package is supported by the SMARTFARM project. The SMARTFARM program of DOE’s Advanced Research Projects Agency-Energy (ARPA-E) aims to innovate technologies that can help to cost-effectively and efficiently quantify feedstock emissions at the field level. The project aspires to facilitate advanced biofuels that can potentially be a carbon-negative source of energy and aims to promote environmental sustainability while simultaneously increasing farmer profitability and productivity. 


## Functions In The Package:
The following functions are currently included in the package. More information and a demonstration on each function can be found in the links provided.

[Annual Average Temperature: average_temperature](https://colab.research.google.com/drive/1yAIbQYOK6uNcoUJkx4TYnYExj5YYoFQj?usp=sharing) <br>
[Annual Total Precipitation: total_precipitation](https://colab.research.google.com/drive/12jJ3PITv0XxCKnlSbLCbk-j9Pp15b98h?usp=sharing)<br>
[Extreme Degree Days: extreme_degree_days](https://colab.research.google.com/drive/1lVU1J_9P2Nl7EweV_ZkJPhvQerJlBcGt?usp=sharing) <br>
[Growing degree days: growing_degree_days](https://colab.research.google.com/drive/17gCluadiRPwwEdybSuuFyYoHyuaJV7WT?usp=sharing) <br>
[Base Temperature For Growing Degree Days: growingdays_basetemp](https://colab.research.google.com/drive/1mkQNKEM_QsAMLzFSyuHQi5p9p8r6Rboj?usp=sharing) <br>
[Temperature Trend: temptrend](https://colab.research.google.com/drive/1MQ2i8PwOeE3mBQL_YRkFqS5d2njyCYxU?usp=sharing) <br>

## Output Diagrams:

Ipyleaflet Map Demonstrating Temperature Variablility Across U.S. Farm Sites:

![Ipyleaflet Map Function Output](https://user-images.githubusercontent.com/66324301/119862482-8bac1c00-bee6-11eb-925c-ba619283c191.png)

PCA Biplot:

![PCA Image](https://user-images.githubusercontent.com/66324301/119883153-3596a300-befd-11eb-92ed-a78a8f23eb0e.png)

Clustering Results Based On Pairs Of Climate Metrics:

![Pairgrid Image](https://user-images.githubusercontent.com/66324301/119883214-49420980-befd-11eb-86d0-c20afb5cd842.png)
 
## Demonstration Notebooks:

1. [Download data from GEE](https://colab.research.google.com/drive/14V2hgVFVVddbVo_xKWHYuHyvGeJ11NUC?usp=sharing)
2. [Running functions](https://colab.research.google.com/drive/1gO1QjxAL1Q5uvzpKCz1SeioKfs5XazGh?usp=sharing)
3. [Demonstration Of Clustering](https://colab.research.google.com/drive/1CiQXOAop0sYedc2P77V6geQ1_bLFB7Rk?usp=sharing)
4. [Demonstration Of PCA](https://colab.research.google.com/drive/1xxXLrJfbjk9ED8L07fv2rUN68XC76k-E?usp=sharing)

