class DicAddress:

    ##ROW:PosBuffer
    FDM_Row = {0: 0,
               1: 6,
               2: 12,
               3: 18,
               4: 1,
               5: 7,
               6: 13,
               7: 19,
               8: 2,
               9: 8,
               10: 14,
               11: 20,
               19: 21,
               20: 3,
               21: 9,
               22: 15,
               23: 22,
               24: 4,
               25: 10,
               26: 16,
               27: 23,
               28: 5,
               29: 11,
               30: 17,
               31: 24
               }

    RowsAddress = {}
    for i in range(8):
        for j in range(4):
            ri = 4 * i + j
            if ri in FDM_Row:
                RowsAddress['R' + str(ri)] = {'B': i,
                                              'F': j,
                                              'Index': FDM_Row[ri]}

    ColsAddress = {}
    FCLK = 51.2e6/2
    FCDiv = [158, 150, 142, 135, 128, 122, 117, 111, 108, 103, 100, 96, 93, 90, 87, 84]
    for i in range(16):
        ColsAddress['C' + str(i)] = {'Add': i,
                                     'Freq': FCLK/FCDiv[i]}

    RowsAddressRaw = {}
    for i in range(8):
        for j in range(4):
            ri = 4 * i + j
            if ri in FDM_Row:
                RowsAddressRaw['R' + str(ri)] = {'B': i,
                                              'F': j,
                                              'Index': FDM_Row[ri]+1}


    MapMice = {
                'R0C0': ['R4C0', 4, 0],
                'R0C1': ['R5C0', 5, 0],
                'R0C2': ['R3C0', 3, 0],
                'R0C3': ['R6C0', 6, 0],
                'R0C4': ['R1C1', 1, 1],

                'R1C0': ['R4C1', 4, 1],
                'R1C1': ['R5C1', 5, 1],
                'R1C2': ['R3C1', 3, 1],
                'R1C3': ['R7C1', 7, 1],
                'R1C4': ['R2C1', 2, 1],

                'R2C0': ['R4C2', 4, 2],
                'R2C1': ['R5C2', 5, 2],
                'R2C2': ['R3C2', 3, 2],
                'R2C3': ['R6C1', 6, 1],
                'R2C4': ['R1C2', 1, 2],

                'R3C0': ['R4C3', 4, 3],
                'R3C1': ['R6C2', 6, 2],
                'R3C2': ['R3C3', 3, 3],
                'R3C3': ['R7C2', 7, 2],
                'R3C4': ['R2C2', 2, 2],

                'R4C0': ['R5C3', 5, 3],
                'R4C1': ['R6C3', 6, 3],
                'R4C2': ['R2C3', 2, 3],
                'R4C3': ['R8C2', 8, 2],
                'R4C4': ['R1C3', 1, 3],

                'R5C0': ['R5C4', 5, 4],
                'R5C1': ['R7C3', 7, 3],
                'R5C2': ['R3C4', 3, 4],
                'R5C3': ['R8C3', 8, 3],
                'R5C4': ['R0C4', 0, 4],

                'R6C0': ['R4C4', 4, 4],
                'R6C1': ['R7C4', 7, 4],
                'R6C2': ['R2C4', 2, 4],
                'R6C3': ['R9C4', 9, 4],
                'R6C4': ['R1C4', 1, 4],

                'R7C0': ['R6C4', 6, 4],
                'R7C1': ['R7C5', 7, 5],
                'R7C2': ['R2C5', 2, 5],
                'R7C3': ['R8C4', 8, 4],
                'R7C4': ['R0C5', 0, 5],

                'R8C0': ['R4C5', 4, 5],
                'R8C1': ['R6C5', 6, 5],
                'R8C2': ['R3C5', 3, 5],
                'R8C3': ['R9C5', 9, 5],
                'R8C4': ['R1C5', 1, 5],

                'R9C0': ['R5C5', 5, 5],
                'R9C1': ['R7C6', 7, 6],
                'R9C2': ['R2C6', 2, 6],
                'R9C3': ['R8C5', 8, 5],
                'R9C4': ['R0C6', 0, 6],

                'R10C0': ['R4C6', 4, 6],
                'R10C1': ['R6C6', 6, 6],
                'R10C2': ['R3C6', 3, 6],
                'R10C3': ['R9C6', 9, 6],
                'R10C4': ['R1C6', 1, 6],

                'R11C0': ['R5C6', 5, 6],
                'R11C1': ['R8C7', 8, 7],
                'R11C2': ['R2C7', 2, 7],
                'R11C3': ['R8C6', 8, 6],
                'R11C4': ['R0C7', 0, 7],

                'R19C0': ['R5C7', 5, 7],
                'R19C1': ['R7C7', 7, 7],
                'R19C2': ['R3C7', 3, 7],
                'R19C3': ['R9C7', 9, 7],
                'R19C4': ['R1C7', 1, 7],

                'R20C0': ['R5C8', 5, 8],
                'R20C1': ['R6C7', 6, 7],
                'R20C2': ['R4C7', 4, 7],
                'R20C3': ['R8C8', 8, 8],
                'R20C4': ['NAAN', 0, 0], ##NO EXISTE

                'R21C0': ['R4C8', 4, 8],
                'R21C1': ['R6C8', 6, 8],
                'R21C2': ['R3C8', 3, 8],
                'R21C3': ['R9C8', 9, 8],
                'R21C4': ['R1C8', 1, 8],

                'R22C0': ['R5C9', 5, 9],
                'R22C1': ['R7C8', 7, 8],
                'R22C2': ['R2C8', 2, 8],
                'R22C3': ['R8C9', 8, 9],
                'R22C4': ['R0C8', 0, 8],

                'R23C0': ['R4C9', 4, 9],
                'R23C1': ['R6C9', 6, 9],
                'R23C2': ['R3C9', 3, 9],
                'R23C3': ['R9C9', 9, 9],
                'R23C4': ['R1C9', 1, 9],

                'R24C0': ['R6C10', 6, 10],
                'R24C1': ['R7C9', 7, 9],
                'R24C2': ['R2C9', 2, 9],
                'R24C3': ['R8C10', 8, 10],
                'R24C4': ['R0C9', 0, 9],

                'R25C0': ['R4C10', 4, 10],
                'R25C1': ['R7C10', 7, 10],
                'R25C2': ['R2C10', 2, 10],
                'R25C3': ['R9C10', 9, 10],
                'R25C4': ['R1C10', 1, 10],

                'R26C0': ['R5C10', 5, 10],
                'R26C1': ['R7C11', 7, 11],
                'R26C2': ['R3C10', 3, 10],
                'R26C3': ['R8C11', 8, 11],
                'R26C4': ['R0C10', 0, 10],

                'R27C0': ['R5C11', 5, 11],
                'R27C1': ['R6C11', 6, 11],
                'R27C2': ['R2C11', 2, 11],
                'R27C3': ['R8C12', 8, 12],
                'R27C4': ['R1C11', 1, 11],

                'R28C0': ['R4C11', 4, 11],
                'R28C1': ['R6C12', 6, 12],
                'R28C2': ['R3C11', 3, 11],
                'R28C3': ['R7C12', 7, 12],
                'R28C4': ['R2C12', 2, 12],

                'R29C0': ['R4C12', 4, 12],
                'R29C1': ['R5C12', 5, 12],
                'R29C2': ['R3C12', 3, 12],
                'R29C3': ['R6C13', 6, 13],
                'R29C4': ['R1C12', 1, 12],

                'R30C0': ['R4C13', 4, 13],
                'R30C1': ['R5C13', 5, 13],
                'R30C2': ['R3C13', 3, 13],
                'R30C3': ['R7C13', 7, 13],
                'R30C4': ['R2C13', 2, 13],

                'R31C0': ['R4C14', 4, 14],
                'R31C1': ['R5C14', 5, 14],
                'R31C2': ['R3C14', 3, 14],
                'R31C3': ['R6C14', 6, 14],
                'R31C4': ['R1C13', 1, 13],

    }

    MapProbe = {'25x5_M' : MapMice}





