
;********************************
; LAYER DEFINITION
;********************************
layerDefinitions(

 techLayerPurposePriorities(
 ;layers are ordered from lowest to highest priority
 ;( LayerName                 Purpose    )
 ;( ---------                 -------    )
  ( background                drawing    )
  ( grid                      drawing    )
  ( grid                      drawing1   )
  ( pwell                     drawing    )
  ( pwell                     net        )
  ( pwell                     pin        )
  ( nwell                     drawing    )
  ( nwell                     net        )
  ( nwell                     pin        )
  ( vtg			      drawing    )
  ( vtg			      net        )
  ( vth			      drawing    )
  ( vth			      net        )
  ( active                    drawing    )
  ( active                    net        )
  ( active                    pin        )
  ( nimplant                  drawing    )
  ( pimplant                  drawing    )
  ( poly                      drawing    )
  ( poly                      net        )
  ( poly                      pin        )
  ( poly                      label      )
  ( poly                      boundary   )
  ( poly                      blockage   )
  ( thkox                     drawing    )
  ( thkox                     label      )
  ( contact                   drawing    )
  ( contact                   net        )
  ( contact                   pin        )
  ( contact                   label      )
  ( contact                   boundary   )
  ( contact                   blockage   )
  ( metal1                    drawing    )
  ( metal1                    net        )
  ( metal1                    pin        )
  ( metal1                    label      )
  ( metal1                    boundary   )
  ( metal1                    blockage   )
  ( via1                      drawing    )
  ( via1                      net        )
  ( via1                      pin        )
  ( via1                      label      )
  ( via1                      boundary   )
  ( via1                      blockage   )
  ( metal2                    drawing    )
  ( metal2                    net        )
  ( metal2                    pin        )
  ( metal2                    label      )
  ( metal2                    boundary   )
  ( metal2                    blockage   )
  ( via2                      drawing    )
  ( via2                      net        )
  ( via2                      pin        )
  ( via2                      label      )
  ( via2                      boundary   )
  ( via2                      blockage   )
  ( metal3                    drawing    )
  ( metal3                    net        )
  ( metal3                    pin        )
  ( metal3                    label      )
  ( metal3                    boundary   )
  ( metal3                    blockage   )
  ( via3                      drawing    )
  ( via3                      net        )
  ( via3                      pin        )
  ( via3                      label      )
  ( via3                      boundary   )
  ( via3                      blockage   )
  ( metal4                    drawing    )
  ( metal4                    net        )
  ( metal4                    pin        )
  ( metal4                    label      )
  ( metal4                    boundary   )
  ( metal4                    blockage   )
  ( via4                      drawing    )
  ( via4                      net        )
  ( via4                      pin        )
  ( via4                      label      )
  ( via4                      boundary   )
  ( via4                      blockage   )
  ( metal5                    drawing    )
  ( metal5                    net        )
  ( metal5                    pin        )
  ( metal5                    label      )
  ( metal5                    boundary   )
  ( metal5                    blockage   )
  ( via5                      drawing    )
  ( via5                      net        )
  ( via5                      pin        )
  ( via5                      label      )
  ( via5                      boundary   )
  ( via5                      blockage   )
  ( metal6                    drawing    )
  ( metal6                    net        )
  ( metal6                    pin        )
  ( metal6                    label      )
  ( metal6                    boundary   )
  ( metal6                    blockage   )
  ( via6                      drawing    )
  ( via6                      net        )
  ( via6                      pin        )
  ( via6                      label      )
  ( via6                      boundary   )
  ( via6                      blockage   )
  ( metal7                    drawing    )
  ( metal7                    net        )
  ( metal7                    pin        )
  ( metal7                    label      )
  ( metal7                    boundary   )
  ( metal7                    blockage   )
  ( via7                      drawing    )
  ( via7                      net        )
  ( via7                      pin        )
  ( via7                      label      )
  ( via7                      boundary   )
  ( via7                      blockage   )
  ( metal8                    drawing    )
  ( metal8                    net        )
  ( metal8                    pin        )
  ( metal8                    label      )
  ( metal8                    boundary   )
  ( metal8                    blockage   )
  ( via8                      drawing    )
  ( via8                      net        )
  ( via8                      pin        )
  ( via8                      label      )
  ( via8                      boundary   )
  ( via8                      blockage   )
  ( metal9                    drawing    )
  ( metal9                    net        )
  ( metal9                    pin        )
  ( metal9                    label      )
  ( metal9                    boundary   )
  ( metal9                    blockage   )
  ( via9                      drawing    )
  ( via9                      net        )
  ( via9                      pin        )
  ( via9                      label      )
  ( via9                      boundary   )
  ( via9                      blockage   )
  ( metal10                   drawing    )
  ( metal10                   net        )
  ( metal10                   pin        )
  ( metal10                   label      )
  ( metal10                   boundary   )
  ( metal10                   blockage   )
  ( annotate                  drawing    )
  ( annotate                  drawing1   )
  ( annotate                  drawing2   )
  ( annotate                  drawing3   )
  ( annotate                  drawing4   )
  ( annotate                  drawing5   )
  ( annotate                  drawing6   )
  ( annotate                  drawing7   )
  ( annotate                  drawing8   )
  ( annotate                  drawing9   )
  ( instance                  drawing    )
  ( instance                  label      )
  ( prBoundary                drawing    )
  ( prBoundary                boundary   )
  ( prBoundary                label      )
  ( align                     drawing    )
  ( hardFence                 drawing    )
  ( softFence                 drawing    )
  ( comment                   drawing    )
  ( comment                   drawing1   )
  ( comment                   drawing2   )
  ( border                    drawing    )
  ( device                    drawing    )
  ( device                    label      )
  ( device                    drawing1   )
  ( device                    drawing2   )
  ( device                    annotate   )
  ( wire                      drawing    )
  ( wire                      label      )
  ( wire                      flight     )
  ( pin                       label      )
  ( pin                       drawing    )
  ( pin                       annotate   )
  ( axis                      drawing    )
  ( edgeLayer                 drawing    )
  ( edgeLayer                 pin        )
  ( snap                      drawing    )
  ( stretch                   drawing    )
  ( y0                        drawing    )
  ( y0                        flight     )
  ( y1                        drawing    )
  ( y1                        flight     )
  ( y2                        drawing    )
  ( y2                        flight     )
  ( y3                        drawing    )
  ( y3                        flight     )
  ( y4                        drawing    )
  ( y4                        flight     )
  ( y5                        drawing    )
  ( y5                        flight     )
  ( y6                        drawing    )
  ( y6                        flight     )
  ( y7                        drawing    )
  ( y7                        flight     )
  ( y8                        drawing    )
  ( y8                        flight     )
  ( y9                        drawing    )
  ( y9                        flight     )
  ( hilite                    drawing    )
  ( hilite                    drawing1   )
  ( hilite                    drawing2   )
  ( hilite                    drawing3   )
  ( hilite                    drawing4   )
  ( hilite                    drawing5   )
  ( hilite                    drawing6   )
  ( hilite                    drawing7   )
  ( hilite                    drawing8   )
  ( hilite                    drawing9   )
  ( select                    drawing    )
  ( drive                     drawing    )
  ( hiz                       drawing    )
  ( resist                    drawing    )
  ( spike                     drawing    )
  ( supply                    drawing    )
  ( unknown                   drawing    )
  ( unset                     drawing    )
  ( designFlow                drawing    )
  ( designFlow                drawing1   )
  ( designFlow                drawing2   )
  ( designFlow                drawing3   )
  ( designFlow                drawing4   )
  ( designFlow                drawing5   )
  ( designFlow                drawing6   )
  ( designFlow                drawing7   )
  ( designFlow                drawing8   )
  ( designFlow                drawing9   )
  ( changedLayer              tool0      )
  ( changedLayer              tool1      )
  ( marker                    warning    )
  ( marker                    error      )
  ( marker                    annotate   )
  ( marker                    info       )
  ( marker                    ackWarn    )
  ( marker                    soError    )
  ( marker                    soCritical )
  ( marker                    critical   )
  ( marker                    fatal      )
  ( Row                       drawing    )
  ( Row                       label      )
  ( Row                       boundary   )
  ( Group                     drawing    )
  ( Group                     label      )
  ( Group                     boundary   )
  ( Cannotoccupy              drawing    )
  ( Cannotoccupy              boundary   )
  ( Canplace                  drawing    )
  ( Unrouted                  drawing    )
  ( Unrouted                  drawing1   )
  ( Unrouted                  drawing2   )
  ( Unrouted                  drawing3   )
  ( Unrouted                  drawing4   )
  ( Unrouted                  drawing5   )
  ( Unrouted                  drawing6   )
  ( Unrouted                  drawing7   )
  ( Unrouted                  drawing8   )
  ( Unrouted                  drawing9   )
  ( Unrouted                  track      )
  ( snap                      boundary   )
  ( border                    boundary   )
  ( metal1                    track      )
  ( metal2                    track      )
  ( metal3                    track      )
  ( metal4                    track      )
  ( metal5                    track      )
  ( metal6                    track      )
  ( metal7                    track      )
  ( metal8                    track      )
  ( metal9                    track      )
  ( metal10                   track      )
  ( contact                   grid       )
  ( metal1                    grid       )
  ( via1                      grid       )
  ( metal2                    grid       )
  ( via2                      grid       )
  ( metal3                    grid       )
  ( via3                      grid       )
  ( metal4                    grid       )
  ( via4                      grid       )
  ( metal5                    grid       )
  ( via5                      grid       )
  ( metal6                    grid       )
  ( via6                      grid       )
  ( metal7                    grid       )
  ( via7                      grid       )
  ( metal8                    grid       )
  ( via8                      grid       )
  ( metal9                    grid       )
  ( via9                      grid       )
  ( metal10                   grid       )
  ( snap                      grid       )
 ) ;techLayerPurposePriorities

 techDisplays(
 ;( LayerName    Purpose      Packet          Vis Sel Con2ChgLy DrgEnbl Valid )
 ;( ---------    -------      ------          --- --- --------- ------- ----- )
  ( pwell        drawing      pwell            t t t t t )
  ( nwell        drawing      nwell            t t t t t )
  ( vtg          drawing      vtg              t t t t t )
  ( vth          drawing      vth              t t t t t )
  ( active       drawing      active           t t t t t )
  ( nimplant     drawing      nimplant         t t t t t )
  ( pimplant     drawing      pimplant         t t t t t )
  ( poly         drawing      poly             t t t t t )
  ( thkox        drawing      thkox            t t t t t )
  ( metal1       drawing      metal1           t t t t t )
  ( metal1       blockage     metal1           t nil t t nil )
  ( metal2       drawing      metal2           t t t t t )
  ( metal2       blockage     metal2           t nil t t nil )
  ( metal3       drawing      metal3           t t t t t )
  ( metal3       blockage     metal3           t nil t t nil )
  ( metal4       drawing      metal4           t t t t t )
  ( metal4       blockage     metal4           t nil t t nil )
  ( metal5       drawing      metal5           t t t t t )
  ( metal5       blockage     metal5           t nil t t nil )
  ( metal6       drawing      metal6           t t t t t )
  ( metal6       blockage     metal6           t nil t t nil )
  ( metal7       drawing      metal7           t t t t t )
  ( metal7       blockage     metal7           t nil t t nil )
  ( metal8       drawing      metal8           t t t t t )
  ( metal8       blockage     metal8           t nil t t nil )
  ( metal9       drawing      metal9           t t t t t )
  ( metal9       blockage     metal9           t nil t t nil )
  ( metal10      drawing      metal10          t t t t t )
  ( metal10      blockage     metal10          t nil t t nil )
  ( contact      drawing      contact          t t t t t )
  ( contact      blockage     contact          t nil t t nil )
  ( via1         drawing      via1             t t t t t )
  ( via1         blockage     via1             t nil t t nil )
  ( via2         drawing      via2             t t t t t )
  ( via2         blockage     via2             t nil t t nil )
  ( via3         drawing      via3             t t t t t )
  ( via3         blockage     via3             t nil t t nil )
  ( via4         drawing      via4             t t t t t )
  ( via4         blockage     via4             t nil t t nil )
  ( via5         drawing      via5             t t t t t )
  ( via5         blockage     via5             t nil t t nil )
  ( via6         drawing      via6             t t t t t )
  ( via6         blockage     via6             t nil t t nil )
  ( via7         drawing      via7             t t t t t )
  ( via7         blockage     via7             t nil t t nil )
  ( via8         drawing      via8             t t t t t )
  ( via8         blockage     via8             t nil t t nil )
  ( via9         drawing      via9             t t t t t )
  ( via9         blockage     via9             t nil t t nil )
  ( background   drawing      background       t nil t nil nil )
  ( grid         drawing      grid             t nil t nil nil )
  ( grid         drawing1     grid1            t nil t nil nil )
  ( annotate     drawing      annotate         t t t t nil )
  ( annotate     drawing1     annotate1        t t t t nil )
  ( annotate     drawing2     annotate2        t t t t nil )
  ( annotate     drawing3     annotate3        t t t t nil )
  ( annotate     drawing4     annotate4        t t t t nil )
  ( annotate     drawing5     annotate5        t t t t nil )
  ( annotate     drawing6     annotate6        t t t t nil )
  ( annotate     drawing7     annotate7        t t t t nil )
  ( annotate     drawing8     annotate8        t t t t nil )
  ( annotate     drawing9     annotate9        nil t t t nil )
  ( instance     drawing      instance         t t t t nil )
  ( instance     label        instanceLbl      t t t t nil )
  ( prBoundary   drawing      prBoundary       t t t t nil )
  ( prBoundary   boundary     prBoundaryBnd    t t t t nil )
  ( prBoundary   label        prBoundaryLbl    t t t t nil )
  ( align        drawing      align            t t t t nil )
  ( hardFence    drawing      hardFence        t t t t nil )
  ( softFence    drawing      softFence        t t t t nil )
  ( comment      drawing      comment          t t t t t )
  ( comment      drawing1     comment1            t t t t nil )
  ( comment      drawing2     comment2            t t t t nil )
  ( border       drawing      border           t t t t nil )
  ( device       drawing      device           t t t t nil )
  ( device       label        deviceLbl        t t t t nil )
  ( device       drawing1     device1          t t t t nil )
  ( device       drawing2     device2          t t t t nil )
  ( device       annotate     deviceAnt        t t t t nil )
  ( wire         drawing      wire             t t t t nil )
  ( wire         label        wireLbl          t t t t nil )
  ( wire         flight       wireFlt          t t t t nil )
  ( pin          label        pinLbl           t t t t nil )
  ( pin          drawing      pin              t t t t nil )
  ( pin          annotate     pinAnt           t t t t nil )
  ( axis         drawing      axis             t nil t t nil )
  ( edgeLayer    drawing      edgeLayer        t t t t nil )
  ( edgeLayer    pin          edgeLayerPin     t t t t nil )
  ( snap         drawing      snap             t t t t nil )
  ( stretch      drawing      stretch          t t t t nil )
  ( y0           drawing      y0               t t t t nil )
  ( y1           drawing      y1               t t t t nil )
  ( y2           drawing      y2               t t t t nil )
  ( y3           drawing      y3               t t t t nil )
  ( y4           drawing      y4               t t t t nil )
  ( y5           drawing      y5               t t t t nil )
  ( y6           drawing      y6               t t t t nil )
  ( y7           drawing      y7               t t t t nil )
  ( y8           drawing      y8               t t t t nil )
  ( y9           drawing      y9               t t t t nil )
  ( hilite       drawing      hilite           t t t t nil )
  ( hilite       drawing1     hilite1          t t t t nil )
  ( hilite       drawing2     hilite2          t t t t nil )
  ( hilite       drawing3     hilite3          t t t t nil )
  ( hilite       drawing4     hilite4          t t t t nil )
  ( hilite       drawing5     hilite5          t t t t nil )
  ( hilite       drawing6     hilite6          t t t t nil )
  ( hilite       drawing7     hilite7          t t t t nil )
  ( hilite       drawing8     hilite8          t t t t nil )
  ( hilite       drawing9     hilite9          t t t t nil )
  ( select       drawing      select           t t t t nil )
  ( drive        drawing      drive            t t t t nil )
  ( hiz          drawing      hiz              t t t t nil )
  ( resist       drawing      resist           t t t t nil )
  ( spike        drawing      spike            t t t t nil )
  ( supply       drawing      supply           t t t t nil )
  ( unknown      drawing      unknown          t t t t nil )
  ( unset        drawing      unset            t t t t nil )
  ( designFlow   drawing      designFlow       t t t nil nil )
  ( designFlow   drawing1     designFlow1      t t t nil nil )
  ( designFlow   drawing2     designFlow2      t t t nil nil )
  ( designFlow   drawing3     designFlow3      t t t nil nil )
  ( designFlow   drawing4     designFlow4      t t t nil nil )
  ( designFlow   drawing5     designFlow5      t t t nil nil )
  ( designFlow   drawing6     designFlow6      t t t nil nil )
  ( designFlow   drawing7     designFlow7      t t t nil nil )
  ( designFlow   drawing8     designFlow8      t t t nil nil )
  ( designFlow   drawing9     designFlow9      t t t nil nil )
  ( changedLayer tool0        changedLayerTl0  nil nil t nil nil )
  ( changedLayer tool1        changedLayerTl1  nil nil t nil nil )
  ( marker       warning      markerWarn       t t t t nil )
  ( marker       error        markerErr        t t t t nil )
  ( Row          drawing      Row              t t t t nil )
  ( Row          label        RowLbl           t nil t t nil )
  ( Group        drawing      Group            t t t t nil )
  ( Group        label        GroupLbl         t nil t t nil )
  ( contact      label        contactLbl       t t t nil nil )
  ( metal1       label        metal1Lbl        t t t nil nil )
  ( metal2       label        metal2Lbl        t t t nil nil )
  ( metal3       label        metal3Lbl        t t t nil nil )
  ( metal4       label        metal4Lbl        t t t nil nil )
  ( metal5       label        metal5Lbl        t t t nil nil )
  ( metal6       label        metal6Lbl        t t t nil nil )
  ( metal7       label        metal7Lbl        t t t nil nil )
  ( metal8       label        metal8Lbl        t t t nil nil )
  ( metal9       label        metal9Lbl        t t t nil nil )
  ( metal10      label        metal10Lbl       t t t nil nil )
  ( poly         label        polyLbl          t t t nil nil )
  ( thkox        label        thkoxLbl         t t t nil nil )
  ( via1         label        via1Lbl          t t t nil nil )
  ( via2         label        via2Lbl          t t t nil nil )
  ( via3         label        via3Lbl          t t t nil nil )
  ( via4         label        via4Lbl          t t t nil nil )
  ( via5         label        via5Lbl          t t t nil nil )
  ( via6         label        via6Lbl          t t t nil nil )
  ( via7         label        via7Lbl          t t t nil nil )
  ( via8         label        via8Lbl          t t t nil nil )
  ( via9         label        via9Lbl          t t t nil nil )
  ( pwell        net          pwellNet         t t t nil t )
  ( nwell        net          nwellNet         t t t nil t )
  ( vtg          net          vtgNet           t t t nil t )
  ( vth          net          vthNet           t t t nil t )
  ( active       net          activeNet        t t t nil t )
  ( poly         net          polyNet          t t t nil t )
  ( metal1       net          metal1Net        t t t nil t )
  ( metal2       net          metal2Net        t t t nil t )
  ( metal3       net          metal3Net        t t t nil t )
  ( metal4       net          metal4Net        t t t nil t )
  ( metal5       net          metal5Net        t t t nil t )
  ( metal6       net          metal6Net        t t t nil t )
  ( metal7       net          metal7Net        t t t nil t )
  ( metal8       net          metal8Net        t t t nil t )
  ( metal9       net          metal9Net        t t t nil t )
  ( metal10      net          metal10Net       t t t nil t )
  ( contact      net          contactNet       t t t nil t )
  ( via1         net          via1Net          t t t nil t )
  ( via2         net          via2Net          t t t nil t )
  ( via3         net          via3Net          t t t nil t )
  ( via4         net          via4Net          t t t nil t )
  ( via5         net          via5Net          t t t nil t )
  ( via6         net          via6Net          t t t nil t )
  ( via7         net          via7Net          t t t nil t )
  ( via8         net          via8Net          t t t nil t )
  ( via9         net          via9Net          t t t nil t )
  ( active       pin          activePin        t t t nil nil )
  ( contact      pin          contactPin       t t t nil nil )
  ( metal1       pin          metal1Pin        t t t nil nil )
  ( metal2       pin          metal2Pin        t t t nil nil )
  ( metal3       pin          metal3Pin        t t t nil nil )
  ( metal4       pin          metal4Pin        t t t nil nil )
  ( metal5       pin          metal5Pin        t t t nil nil )
  ( metal6       pin          metal6Pin        t t t nil nil )
  ( metal7       pin          metal7Pin        t t t nil nil )
  ( metal8       pin          metal8Pin        t t t nil nil )
  ( metal9       pin          metal9Pin        t t t nil nil )
  ( metal10      pin          metal10Pin       t t t nil nil )
  ( nwell        pin          nwellPin         t t t nil nil )
  ( poly         pin          polyPin          t t t nil nil )
  ( pwell        pin          pwellPin         t t t nil nil )
  ( via1         pin          via1Pin          t t t nil nil )
  ( via2         pin          via2Pin          t t t nil nil )
  ( via3         pin          via3Pin          t t t nil nil )
  ( via4         pin          via4Pin          t t t nil nil )
  ( via5         pin          via5Pin          t t t nil nil )
  ( via6         pin          via6Pin          t t t nil nil )
  ( via7         pin          via7Pin          t t t nil nil )
  ( via8         pin          via8Pin          t t t nil nil )
  ( via9         pin          via9Pin          t t t nil nil )
  ( Cannotoccupy drawing      Cannotoccupy     t t t t nil )
  ( Cannotoccupy boundary     CannotoccupyBnd  t t t t nil )
  ( Canplace     drawing      Canplace         t t t t nil )
  ( contact      boundary     contactBnd       t t t nil nil )
  ( metal1       boundary     metal1Bnd        t t t nil nil )
  ( metal2       boundary     metal2Bnd        t t t nil nil )
  ( metal3       boundary     metal3Bnd        t t t nil nil )
  ( metal4       boundary     metal4Bnd        t t t nil nil )
  ( metal5       boundary     metal5Bnd        t t t nil nil )
  ( metal6       boundary     metal6Bnd        t t t nil nil )
  ( metal7       boundary     metal7Bnd        t t t nil nil )
  ( metal8       boundary     metal8Bnd        t t t nil nil )
  ( metal9       boundary     metal9Bnd        t t t nil nil )
  ( metal10      boundary     metal10Bnd       t t t nil nil )
  ( poly         boundary     polyBnd          t t t nil nil )
  ( via1         boundary     via1Bnd          t t t nil nil )
  ( via2         boundary     via2Bnd          t t t nil nil )
  ( via3         boundary     via3Bnd          t t t nil nil )
  ( via4         boundary     via4Bnd          t t t nil nil )
  ( via5         boundary     via5Bnd          t t t nil nil )
  ( via6         boundary     via6Bnd          t t t nil nil )
  ( via7         boundary     via7Bnd          t t t nil nil )
  ( via8         boundary     via8Bnd          t t t nil nil )
  ( via9         boundary     via9Bnd          t t t nil nil )
  ( Unrouted     drawing      Unrouted         t t t t nil )
  ( Unrouted     drawing1     Unrouted1        t t t t nil )
  ( Unrouted     drawing2     Unrouted2        t t t t nil )
  ( Unrouted     drawing3     Unrouted3        t t t t nil )
  ( Unrouted     drawing4     Unrouted4        t t t t nil )
  ( Unrouted     drawing5     Unrouted5        t t t t nil )
  ( Unrouted     drawing6     Unrouted6        t t t t nil )
  ( Unrouted     drawing7     Unrouted7        t t t t nil )
  ( Unrouted     drawing8     Unrouted8        t t t t nil )
  ( Unrouted     drawing9     Unrouted9        t t t t nil )
  ( snap         boundary     snap             t nil t t nil )
  ( Row          boundary     RowBnd           t t t t nil )
  ( Unrouted     track        UnroutedTrk      t t t t nil )
  ( marker       annotate     markerAno        t t t t nil )
  ( marker       info         markerInf        t t t t nil )
  ( marker       ackWarn      markerAck        t t t t nil )
  ( marker       soError      markerSer        t t t t nil )
  ( marker       soCritical   markerScr        t t t t nil )
  ( marker       critical     markerCrt        t t t t nil )
  ( marker       fatal        markerFat        t t t t nil )
  ( Group        boundary     GroupBnd         t nil t t nil )
  ( y0           flight       y0Flt            t t t t nil )
  ( y1           flight       y1Flt            t t t t nil )
  ( y2           flight       y2Flt            t t t t nil )
  ( y3           flight       y3Flt            t t t t nil )
  ( y4           flight       y4Flt            t t t t nil )
  ( y5           flight       y5Flt            t t t t nil )
  ( y6           flight       y6Flt            t t t t nil )
  ( y7           flight       y7Flt            t t t t nil )
  ( y8           flight       y8Flt            t t t t nil )
  ( y9           flight       y9Flt            t t t t nil )
  ( border       boundary     area             t nil t t nil )
 ) ;techDisplays

 techLayerProperties(
 ;( PropName               Layer1 [ Layer2 ]            PropValue )
 ;( --------               ------ ----------            --------- )
  ( contactResistance      via2                           11.390000 )
  ( contactResistance      via1                           5.690000 )
  ( contactResistance      via3                           16.730000 )
  ( contactResistance      via4                           21.440000 )
  ( contactResistance      via5                           24.080000 )
  ( contactResistance      via6                           11.390000 )
  ( contactResistance      via7                           5.690000 )
  ( contactResistance      via8                           16.730000 )
  ( contactResistance      via9                           21.440000 )
  ( sheetResistance        nwell                          933.000000 )
  ( sheetResistance        poly                           7.800000 )
  ( sheetResistance        metal1                         0.380000 )
  ( sheetResistance        metal3                         0.250000 )
  ( sheetResistance        metal4                         0.250000 )
  ( sheetResistance        metal5                         0.250000 )
  ( sheetResistance        metal6                         0.250000 )
  ( sheetResistance        metal2                         0.250000 )
  ( sheetResistance        metal7                         0.250000 )
  ( sheetResistance        metal8                         0.250000 )
  ( sheetResistance        metal9                         0.210000 )
  ( sheetResistance        metal10                        0.210000 )
  ( contactResistance      contact                        10.500000 )
  ( areaCap                active       metal1            51 )
  ( areaCap                active       metal3            13 )
  ( areaCap                active       metal4            10 )
  ( areaCap                active       metal5            9 )
  ( areaCap                active       metal6            8 )
  ( areaCap                active       metal2            19 )
  ( areaCap                active       metal7            51 )
  ( areaCap                active       metal8            13 )
  ( areaCap                active       metal9            10 )
  ( areaCap                active       metal10           9 )
  ( areaCap                poly         metal1            61 )
  ( areaCap                poly         metal3            9 )
  ( areaCap                poly         metal4            7 )
  ( areaCap                poly         metal5            5 )
  ( areaCap                poly         metal6            4 )
  ( areaCap                poly         metal2            16 )
  ( areaCap                poly         metal7            61 )
  ( areaCap                poly         metal8            9 )
  ( areaCap                poly         metal9            7 )
  ( areaCap                poly         metal10           5 )
  ( perimeterCap           poly         metal1            66 )
  ( perimeterCap           poly         metal3            28 )
  ( perimeterCap           poly         metal4            23 )
  ( perimeterCap           poly         metal5            19 )
  ( perimeterCap           poly         metal6            17 )
  ( perimeterCap           poly         metal2            38 )
  ( perimeterCap           poly         metal7            66 )
  ( perimeterCap           poly         metal8            28 )
  ( perimeterCap           poly         metal9            23 )
  ( perimeterCap           poly         metal10           19 )
  ( areaCap                metal1       metal3            13 )
  ( areaCap                metal1       metal4            9 )
  ( areaCap                metal1       metal5            6 )
  ( areaCap                metal1       metal6            5 )
  ( areaCap                metal1       metal2            34 )
  ( areaCap                metal1       metal7            13 )
  ( areaCap                metal1       metal8            9 )
  ( areaCap                metal1       metal9            6 )
  ( areaCap                metal1       metal10           5 )
  ( perimeterCap           metal1       metal3            34 )
  ( perimeterCap           metal1       metal4            34 )
  ( perimeterCap           metal1       metal5            21 )
  ( perimeterCap           metal1       metal6            18 )
  ( perimeterCap           metal1       metal2            49 )
  ( perimeterCap           metal1       metal7            49 )
  ( perimeterCap           metal1       metal8            34 )
  ( perimeterCap           metal1       metal9            34 )
  ( perimeterCap           metal1       metal10           21 )
  ( areaCap                metal3       metal2            36 )
  ( areaCap                metal3       metal4            34 )
  ( areaCap                metal3       metal5            14 )
  ( areaCap                metal3       metal6            8 )
  ( areaCap                metal3       metal7            36 )
  ( areaCap                metal3       metal8            34 )
  ( areaCap                metal3       metal9            14 )
  ( areaCap                metal3       metal10           8 )
  ( perimeterCap           metal3       metal2            46 )
  ( perimeterCap           metal3       metal4            52 )
  ( perimeterCap           metal3       metal5            34 )
  ( perimeterCap           metal3       metal6            27 )
  ( perimeterCap           metal3       metal7            46 )
  ( perimeterCap           metal3       metal8            52 )
  ( perimeterCap           metal3       metal9            34 )
  ( perimeterCap           metal3       metal10           27 )
  ( areaCap                metal4       metal2            13 )
  ( areaCap                metal4       metal5            36 )
  ( areaCap                metal4       metal6            13 )
  ( areaCap                metal4       metal7            13 )
  ( areaCap                metal4       metal8            36 )
  ( areaCap                metal4       metal9            13 )
  ( areaCap                metal4       metal10           13 )
  ( perimeterCap           metal4       metal2            45 )
  ( perimeterCap           metal4       metal5            57 )
  ( perimeterCap           metal4       metal6            34 )
  ( perimeterCap           metal4       metal7            45 )
  ( perimeterCap           metal4       metal8            57 )
  ( perimeterCap           metal4       metal9            34 )
  ( perimeterCap           metal4       metal10           45 )
  ( areaCap                metal5       metal2            8 )
  ( areaCap                metal5       metal6            33 )
  ( areaCap                metal5       metal7            33 )
  ( areaCap                metal5       metal8            33 )
  ( areaCap                metal5       metal9            33 )
  ( areaCap                metal5       metal10           33 )
  ( perimeterCap           metal5       metal2            26 )
  ( perimeterCap           metal5       metal6            47 )
  ( perimeterCap           metal5       metal7            47 )
  ( perimeterCap           metal5       metal8            47 )
  ( perimeterCap           metal5       metal9            47 )
  ( perimeterCap           metal5       metal10           47 )
  ( areaCap                metal6       metal2            6 )
  ( areaCap                metal6       metal7            6 )
  ( areaCap                metal6       metal8            6 )
  ( areaCap                metal6       metal9            6 )
  ( areaCap                metal6       metal10           6 )
  ( perimeterCap           metal6       metal2            22 )
  ( perimeterCap           metal6       metal7            22 )
  ( perimeterCap           metal6       metal8            22 )
  ( perimeterCap           metal6       metal9            22 )
  ( perimeterCap           metal6       metal10           22 )
  ( areaCap                metal7       metal2            6 )
  ( areaCap                metal7       metal8            6 )
  ( areaCap                metal7       metal9            6 )
  ( areaCap                metal7       metal10           6 )
  ( perimeterCap           metal7       metal2            22 )
  ( perimeterCap           metal7       metal8            22 )
  ( perimeterCap           metal7       metal9            22 )
  ( perimeterCap           metal7       metal10           22 )
  ( areaCap                metal8       metal2            6 )
  ( areaCap                metal8       metal9            6 )
  ( areaCap                metal8       metal10           6 )
  ( perimeterCap           metal8       metal2            22 )
  ( perimeterCap           metal8       metal9            22 )
  ( perimeterCap           metal8       metal10           22 )
  ( areaCap                metal9       metal2            6 )
  ( areaCap                metal9       metal10           6 )
  ( perimeterCap           metal9       metal2            22 )
  ( perimeterCap           metal9       metal10           22 )
  ( areaCap                metal10      metal2            6 )
  ( perimeterCap           metal10      metal2            22 )
 ) ;techLayerProperties

 techDerivedLayers(
 ;( DerivedLayerName          #          composition  )
 ;( ----------------          ------     ------------ )
  ( noOverlapLayer1           10001           ( poly       'and    active    ))
  ( noOverlapLayer2           10002           ( via1       'and    contact   ))
 ) ;techDerivedLayers

) ;layerDefinitions


;********************************
; LAYER RULES
;********************************
layerRules(

 equivalentLayers(
 ;( list of layers )
 ;( -------------- )
 ) ;equivalentLayers

 functions(
 ;( layer                       function        [maskNumber])
 ;( -----                       --------        ------------)
  ( active                   	"unknown"   	1            )
  ( poly                     	"poly"      	9            )
  ( contact                  	"cut"       	10           )
  ( metal1                   	"metal"     	11           )
  ( via1                     	"cut"       	12           )
  ( metal2                   	"metal"     	13           )
  ( via2                     	"cut"       	14           )
  ( metal3                   	"metal"     	15           )
  ( via3                     	"cut"       	16           )
  ( metal4                   	"metal"     	17           )
  ( via4                     	"cut"       	18           )
  ( metal5                   	"metal"     	19           )
  ( via5                     	"cut"       	20           )
  ( metal6                   	"metal"     	21           )
  ( via6                     	"cut"       	22           )
  ( metal7                   	"metal"     	23           )
  ( via7                     	"cut"       	24           )
  ( metal8                   	"metal"     	25           )
  ( via8                     	"cut"       	26           )
  ( metal9                   	"metal"     	27           )
  ( via9                     	"cut"       	28           )
  ( metal10                  	"metal"     	29           )
 ) ;functions

 routingDirections(
 ;( layer                       direction     )
 ;( -----                       ---------     )
  ( metal1                   	"horizontal" )
  ( metal10                  	"vertical"   )
  ( metal2                   	"vertical"   )
  ( metal3                   	"horizontal" )
  ( metal4                   	"vertical"   )
  ( metal5                   	"horizontal" )
  ( metal6                   	"vertical"   )
  ( metal7                   	"horizontal" )
  ( metal8                   	"vertical"   )
  ( metal9                   	"horizontal" )
 ) ;routingDirections

 currentDensity(
 ;( rule                	layer1    	layer2    	value    )
 ;( ----                	------    	------    	-----    )
 ) ;currentDensity

 currentDensityTables(
 ;( rule                	layer1    
 ;  (( index1Definitions	[index2Definitions]) [defaultValue] )
 ;  (table))
 ;( ----------------------------------------------------------------------)
 ) ;currentDensityTables

) ;layerRules


;********************************
; VIADEFS
;********************************
viaDefs(

 standardViaDefs(
 ;( viaDefName	layer1	layer2	(cutLayer cutWidth cutHeight [resistancePerCut]) 
 ;   (cutRows	cutCol	(cutSpace)) 
 ;   (layer1Enc) (layer2Enc)	(layer1Offset)	(layer2Offset)	(origOffset) 
 ;   [implant1	 (implant1Enc)	[implant2	(implant2Enc)]]) 
 ;( -------------------------------------------------------------------------- ) 
  ( M2_M1       	metal1      metal2      	("via1" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.0 0.035)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M3_M2       	metal2      metal3      	("via2" 0.07 0.07)
     (1 1 (0.085 0.085))
     (0.0 0.035)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M4_M3       	metal3      metal4      	("via3" 0.07 0.07)
     (1 1 (0.085 0.085))
     (0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M5_M4       	metal4      metal5      	("via4" 0.14 0.14)
     (1 1 (0.16 0.16))
     (0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M6_M5       	metal5      metal6      	("via5" 0.14 0.14)
     (1 1 (0.16 0.16))
     (0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M7_M6       	metal6      metal7      	("via6" 0.14 0.14)
     (1 1 (0.16 0.16))
     (0.0 0.0)	(0.13 0.13)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M8_M7       	metal7      metal8      	("via7" 0.4 0.4)
     (1 1 (0.4 0.4))
     (0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M9_M8       	metal8      metal9      	("via8" 0.4 0.4)
     (1 1 (0.4 0.4))
     (0.0 0.0)	(0.2 0.2)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M10_M9       	metal9      metal10      	("via9" 0.8 0.8)
     (1 1 (0.8 0.8))
     (0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( M1_POLY     	poly        metal1      	("contact" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.0 0.0)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
  )
  ( NTAP        	nwell       metal1      	("contact" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.0675 0.0675)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
     nimplant     	(-0.055 -0.055)	active     	(0.0125 -0.0225)
  )
  ( PTAP        	pwell       metal1      	("contact" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.0675 0.0675)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
     pimplant     	(-0.055 -0.055)	active     	(0.0125 -0.0225)
  )
  ( M1_N        	active     metal1      	("contact" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.005 0.005)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
     nimplant     	(0.0 0.0)
  )
  ( M1_P        	active     metal1      	("contact" 0.065 0.065)
     (1 1 (0.075 0.075))
     (0.005 0.005)	(0.0 0.035)	(0.0 0.0)	(0.0 0.0)	(0.0 0.0)
     pimplant     	(0.0 0.0)
  )
 ) ;standardViaDefs

 customViaDefs(
 ;( viaDefName libName cellName viewName layer1 layer2 resistancePerCut)
 ;( ---------- ------- -------- -------- ------ ------ ----------------)
   ( M2_M1_via  NCSU_TechLib_FreePDK45 M2_M1_via via metal1 metal2 0.0)
   ( M3_M2_via  NCSU_TechLib_FreePDK45 M3_M2_via via metal2 metal3 0.0)
   ( M4_M3_via  NCSU_TechLib_FreePDK45 M4_M3_via via metal3 metal4 0.0)
   ( M5_M4_via  NCSU_TechLib_FreePDK45 M5_M4_via via metal4 metal5 0.0)
   ( M6_M5_via  NCSU_TechLib_FreePDK45 M6_M5_via via metal5 metal6 0.0)
   ( M7_M6_via  NCSU_TechLib_FreePDK45 M7_M6_via via metal6 metal7 0.0)
   ( M8_M7_via  NCSU_TechLib_FreePDK45 M8_M7_via via metal7 metal8 0.0)
   ( M9_M8_via  NCSU_TechLib_FreePDK45 M9_M8_via via metal8 metal9 0.0)
   ( M10_M9_via  NCSU_TechLib_FreePDK45 M10_M9_via via metal9 metal10 0.0)
   ( M2_M1_viaB  NCSU_TechLib_FreePDK45 M2_M1_viaB via metal1 metal2 0.0)
   ( M2_M1_viaC  NCSU_TechLib_FreePDK45 M2_M1_viaC via metal1 metal2 0.0)
   ( M3_M2_viaB  NCSU_TechLib_FreePDK45 M3_M2_viaB via metal2 metal3 0.0)
   ( M3_M2_viaC  NCSU_TechLib_FreePDK45 M3_M2_viaC via metal2 metal3 0.0)
   ( M4_M3_viaB  NCSU_TechLib_FreePDK45 M4_M3_viaB via metal3 metal4 0.0)
 ) ;customViaDefs

) ;viaDefs



;********************************
; CONSTRAINT GROUPS
;********************************
constraintGroups(

 ;( group	[override] )
 ;( -----	---------- )
  ( "virtuosoDefaultExtractorSetup"	nil

    interconnect(
     ( validLayers   (metal10  metal9  metal8  metal7  metal6  metal5  metal4  metal3  metal2  metal1  via9  via8  via7  via6  via5  via4  via3  via2  via1  contact  poly  active  nwell  pwell  ) )
     ( errorLayer    noOverlapLayer1 )
     ( errorLayer    noOverlapLayer2 )
    ) ;interconnect
  ) ;virtuosoDefaultExtractorSetup

 ;( group	[override] )
 ;( -----	---------- )
  ( "LEFDefaultRouteSpec"	nil

    interconnect(
     ( validLayers   (metal1  metal2  metal3  metal4  metal5  metal6  metal7  metal8  metal9  metal10  ) )
    ) ;interconnect

    routingGrids(
     ( horizontalPitch            "metal1"   0.19 )
     ( verticalPitch              "metal1"   0.19 )
     ( horizontalPitch            "metal2"   0.19 )
     ( verticalPitch              "metal2"   0.19 )
     ( horizontalPitch            "metal3"   0.19 )
     ( verticalPitch              "metal3"   0.19 )
     ( horizontalPitch            "metal4"   0.285 )
     ( verticalPitch              "metal4"   0.285 )
     ( horizontalPitch            "metal5"   0.285 )
     ( verticalPitch              "metal5"   0.285 )
     ( horizontalPitch            "metal6"   0.285 )
     ( verticalPitch              "metal6"   0.285 )
     ( horizontalPitch            "metal7"   0.855 )
     ( verticalPitch              "metal7"   0.855 )
     ( horizontalPitch            "metal8"   0.855 )
     ( verticalPitch              "metal8"   0.855 )
     ( horizontalPitch            "metal9"   1.71 )
     ( verticalPitch              "metal9"   1.71 )
     ( horizontalPitch            "metal10"   1.71 )
     ( verticalPitch              "metal10"   1.71 )
    ) ;routingGrids

    interconnect(
     ( validVias     (M2_M1_via  M3_M2_via  M4_M3_via  M5_M4_via  M6_M5_via  M7_M6_via  M8_M7_via  M9_M8_via  M10_M9_via  M2_M1_viaB  M2_M1_viaC  M3_M2_viaB  M3_M2_viaC  M4_M3_viaB  ) )
    ) ;interconnect
  ) ;LEFDefaultRouteSpec

 ;( group	[override] )
 ;( -----	---------- )
  ( "foundry"	nil

    orderedSpacings(
     ( minEnclosure               "nimplant"	"active"		0.0 )
     ( minEnclosure               "pimplant"	"active"		0.0 )
     ( minEnclosure               "nwell"	"active"		0.055 )
     ( minEnclosure               "pwell"	"active"		0.055 )
     ( minEnclosure               "nimplant"	"contact"		0.005 )
     ( minEnclosure               "pimplant"	"contact"		0.005 )
     ( minEnclosure               "active"	"contact"		0.005 )
     ( minEnclosure               "poly"	"contact"	0.005 )
     ( minEnclosure               "metal1"	"contact"	0.0 )
     ( minEnclosure               "metal1"	"via1"		0.0 )
     ( minEnclosure               "metal2"	"via1"		0.0 )
     ( minEnclosure               "nwell"	"active"		0.0 )
     ( minEnclosure               "pwell"	"active"		0.0 )
     ( minEnclosure               "metal2"	"via2"		0.0 )
     ( minEnclosure               "metal3"	"via2"		0.0 )
     ( minEnclosure               "metal3"	"via3"		0.0 )
     ( minEnclosure               "metal4"	"via3"		0.0 )
     ( minEnclosure               "metal4"	"via4"		0.0 )
     ( minEnclosure               "metal5"	"via4"		0.0 )
     ( minEnclosure               "metal5"	"via5"		0.0 )
     ( minEnclosure               "metal6"	"via5"		0.0 )
     ( minEnclosure               "metal6"	"via6"		0.0 )
     ( minEnclosure               "metal7"	"via6"		0.0 )
     ( minEnclosure               "metal7"	"via7"		0.0 )
     ( minEnclosure               "metal8"	"via7"		0.0 )
     ( minEnclosure               "metal8"	"via8"		0.0 )
     ( minEnclosure               "metal9"	"via8"		0.0 )
     ( minEnclosure               "metal9"	"via9"		0.0 )
     ( minEnclosure               "metal10"	"via9"		0.0 )
    ) ;orderedSpacings

    spacings(
     ( minSameNetSpacing          "nwell"	0.135 )
     ( minSpacing                 "nwell"	"active"		0.055 )
     ( minSpacing                 "pwell"	"active"		0.055 )
     ( minSameNetSpacing          "pwell"	0.135 )
     ( minSpacing                 "active"	0.08 )
     ( minSameNetSpacing          "active"	0.08 )
     ( minWidth                   "active"	0.09 )
     ( minSpacing                 "nimplant"	0.045 )
     ( minSpacing                 "pimplant"	0.045 )
     ( minSameNetSpacing          "nimplant"	0.045 )
     ( minSameNetSpacing          "pimplant"	0.045 )
     ( minWidth                   "nimplant"	0.045 )
     ( minWidth                   "pimplant"	0.045 )
     ( minWidth                   "poly"	0.05 )
     ( minSpacing                 "poly"	"contact"		0.09 )
     ( minSpacing                 "metal1"	0.065 )
     ( minSameNetSpacing          "metal1"	0.065 )
     ( minWidth                   "metal1"	0.065 )
     ( minWidth                   "metal2"	0.070 )
     ( minSpacing                 "via1"  	0.075 )
     ( minWidth    	          "via1"        0.065  )
     ( minSpacing                 "metal2"	0.075 )
     ( minSameNetSpacing          "metal2"	0.070 )
     ( minSpacing                 "contact"  	0.075 )
     ( minSpacing                 "poly"	0.075 )
     ( minWidth                   "nwell"	0.2 )
     ( minWidth                   "pwell"	0.2 )
     ( minSpacing                 "nwell"	0.225 )
     ( minSpacing                 "pwell"	0.225 )
     ( minSpacing                 "metal6"	0.14 )
     ( minSameNetSpacing          "metal6"	0.14 )
     ( minWidth                   "metal6"	0.14 )
     ( minSpacing                 "via5"	0.16 )
     ( minWidth    	          "via5"        0.14  )
     ( minSpacing                 "metal5"	0.14 )
     ( minSameNetSpacing          "metal5"	0.14 )
     ( minWidth                   "metal5"	0.14 )
     ( minSpacing                 "via4"	0.16 )
     ( minWidth    	          "via4"        0.14 )
     ( minWidth                   "metal4"	0.14 )
     ( minSpacing                 "via3"	0.085 )
     ( minWidth    	          "via3"        0.07  )
     ( minWidth                   "metal3"	0.07 )
     ( minSpacing                 "via2"	0.085 )
     ( minWidth    	          "via2"        0.07  )
     ( minSpacing                 "metal4"	0.14 )
     ( minSameNetSpacing          "metal4"	0.14 )
     ( minSpacing                 "metal3"	0.07 )
     ( minSameNetSpacing          "metal3"	0.07 )

     ( minSpacing                 "metal7"	0.44 )
     ( minSameNetSpacing          "metal7"	0.44 )
     ( minWidth                   "metal7"	0.4 )
     ( minSpacing                 "via6"	0.16 )
     ( minWidth    	          "via6"        0.14  )
     ( minSpacing                 "metal8"	0.44 )
     ( minSameNetSpacing          "metal8"	0.44 )
     ( minWidth                   "metal8"	0.4 )
     ( minSpacing                 "via7"	0.44 )
     ( minWidth    	          "via7"        0.4  )
     ( minWidth                   "metal9"	0.8 )
     ( minSpacing                 "via8"	0.44 )
     ( minWidth    	          "via8"        0.4  )
     ( minWidth                   "metal10"	0.4 )
     ( minSpacing                 "via9"	0.88 )
     ( minWidth    	          "via9"        0.8 )
     ( minSpacing                 "metal9"	0.8 )
     ( minSameNetSpacing          "metal9"	0.8 )
     ( minSpacing                 "metal10"	0.8 )
     ( minSameNetSpacing          "metal10"	0.8 )

    ) ;spacings
  ) ;foundry
) ;constraintGroups


;********************************
; DEVICES
;********************************
devices(
tcCreateCDSDeviceClass()

;
; no cdsVia devices
;

;
; no cdsMos devices
;

;
; no ruleContact devices
;

;
; no multipartPathTemplates
;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Opus Symbolic Device Class Definition
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; no other device classes
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Opus Symbolic Device Declaration
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; no other devices
;
) ;devices


;********************************
; LE RULES
;********************************
leRules(

 leLswLayers(
 ;( layer               purpose         )
 ;( -----               -------         )
 ) ;leLswLayers

) ;leRules
