/*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */

"use strict";

function peg$subclass(child, parent) {
  function ctor() { this.constructor = child; }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
}

function peg$SyntaxError(message, expected, found, location) {
  this.message  = message;
  this.expected = expected;
  this.found    = found;
  this.location = location;
  this.name     = "SyntaxError";

  if (typeof Error.captureStackTrace === "function") {
    Error.captureStackTrace(this, peg$SyntaxError);
  }
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function(expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
        literal: function(expectation) {
          return "\"" + literalEscape(expectation.text) + "\"";
        },

        "class": function(expectation) {
          var escapedParts = "",
              i;

          for (i = 0; i < expectation.parts.length; i++) {
            escapedParts += expectation.parts[i] instanceof Array
              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
              : classEscape(expectation.parts[i]);
          }

          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
        },

        any: function(expectation) {
          return "any character";
        },

        end: function(expectation) {
          return "end of input";
        },

        other: function(expectation) {
          return expectation.description;
        }
      };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/"/g,  '\\"')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function classEscape(s) {
    return s
      .replace(/\\/g, '\\\\')
      .replace(/\]/g, '\\]')
      .replace(/\^/g, '\\^')
      .replace(/-/g,  '\\-')
      .replace(/\0/g, '\\0')
      .replace(/\t/g, '\\t')
      .replace(/\n/g, '\\n')
      .replace(/\r/g, '\\r')
      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = new Array(expected.length),
        i, j;

    for (i = 0; i < expected.length; i++) {
      descriptions[i] = describeExpectation(expected[i]);
    }

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ")
          + ", or "
          + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== void 0 ? options : {};

  var peg$FAILED = {},

      peg$startRuleFunctions = { start: peg$parsestart },
      peg$startRuleFunction  = peg$parsestart,

      peg$c0 = function(token) { return {name:'name', op:'ilike', val: '%'+ token + '%'}},
      peg$c1 = ":",
      peg$c2 = peg$literalExpectation(":", false),
      peg$c3 = ".",
      peg$c4 = peg$literalExpectation(".", false),
      peg$c5 = "'",
      peg$c6 = peg$literalExpectation("'", false),
      peg$c7 = "-",
      peg$c8 = peg$literalExpectation("-", false),
      peg$c9 = "/",
      peg$c10 = peg$literalExpectation("/", false),
      peg$c11 = function(exp, optional) {
               return {
                   name: 'name',
                   op: 'ilike' ,
                   val: processValue(name, null, exp += optional.join(""))
               }
          },
      peg$c12 = "or",
      peg$c13 = peg$literalExpectation("or", false),
      peg$c14 = function(left, right) { return {"or": [left, right]} },
      peg$c15 = "and",
      peg$c16 = peg$literalExpectation("and", false),
      peg$c17 = function(left, right) { return {"and": [left, right]} },
      peg$c18 = "not",
      peg$c19 = peg$literalExpectation("not", false),
      peg$c20 = function(operand) { return processLogicalNot(operand) },
      peg$c21 = "(",
      peg$c22 = peg$literalExpectation("(", false),
      peg$c23 = ")",
      peg$c24 = peg$literalExpectation(")", false),
      peg$c25 = function(logical_or) { return logical_or; },
      peg$c26 = function(name, value) {
            return {
                name: processName(name),
                op: processOperator(name, null) ,
                val: processValue(name, null, value)
            }
       },
      peg$c27 = "\"",
      peg$c28 = peg$literalExpectation("\"", false),
      peg$c29 = function(name, mandatory, optional) {
             return {
                 name: processName(name),
                 op: processOperator(name, null) ,
                 val: processValue(name, null, mandatory += optional.join(""))
             }
        },
      peg$c30 = /^[a-zA-Z0-9_.-\/]/,
      peg$c31 = peg$classExpectation([["a", "z"], ["A", "Z"], ["0", "9"], "_", [".", "/"]], false, false),
      peg$c32 = function(token) { return token.join(""); },
      peg$c33 = /^[ \t]/,
      peg$c34 = peg$classExpectation([" ", "\t"], false, false),

      peg$currPos          = 0,
      peg$savedPos         = 0,
      peg$posDetailsCache  = [{ line: 1, column: 1 }],
      peg$maxFailPos       = 0,
      peg$maxFailExpected  = [],
      peg$silentFails      = 0,

      peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function location() {
    return peg$computeLocation(peg$savedPos, peg$currPos);
  }

  function expected(description, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildStructuredError(
      [peg$otherExpectation(description)],
      input.substring(peg$savedPos, peg$currPos),
      location
    );
  }

  function error(message, location) {
    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

    throw peg$buildSimpleError(message, location);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$anyExpectation() {
    return { type: "any" };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos], p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line:   details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;
      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos),
        endPosDetails   = peg$computePosDetails(endPos);

    return {
      start: {
        offset: startPos,
        line:   startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line:   endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) { return; }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildSimpleError(message, location) {
    return new peg$SyntaxError(message, null, null, location);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(
      peg$SyntaxError.buildMessage(expected, found),
      expected,
      found,
      location
    );
  }

  function peg$parsestart() {
    var s0, s1;

    s0 = peg$parselogical_or();
    if (s0 === peg$FAILED) {
      s0 = peg$parsefree_exp();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsetoken();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c0(s1);
        }
        s0 = s1;
      }
    }

    return s0;
  }

  function peg$parsefree_exp() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    s1 = peg$parsetoken();
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (input.charCodeAt(peg$currPos) === 58) {
        s3 = peg$c1;
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c2); }
      }
      if (s3 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s3 = peg$c3;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c4); }
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parsews();
          if (s3 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 39) {
              s3 = peg$c5;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c6); }
            }
            if (s3 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s3 = peg$c7;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c8); }
              }
              if (s3 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 47) {
                  s3 = peg$c9;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c10); }
                }
                if (s3 === peg$FAILED) {
                  s3 = peg$parsetoken();
                }
              }
            }
          }
        }
      }
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        if (input.charCodeAt(peg$currPos) === 58) {
          s3 = peg$c1;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c2); }
        }
        if (s3 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c3;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c4); }
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parsews();
            if (s3 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 39) {
                s3 = peg$c5;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c6); }
              }
              if (s3 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 45) {
                  s3 = peg$c7;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c8); }
                }
                if (s3 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 47) {
                    s3 = peg$c9;
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c10); }
                  }
                  if (s3 === peg$FAILED) {
                    s3 = peg$parsetoken();
                  }
                }
              }
            }
          }
        }
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c11(s1, s2);
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parselogical_or() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parselogical_and();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsews();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsews();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 2) === peg$c12) {
          s3 = peg$c12;
          peg$currPos += 2;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c13); }
        }
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$parsews();
          if (s5 !== peg$FAILED) {
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parsews();
            }
          } else {
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parselogical_or();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c14(s1, s5);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parselogical_and();
    }

    return s0;
  }

  function peg$parselogical_and() {
    var s0, s1, s2, s3, s4, s5;

    s0 = peg$currPos;
    s1 = peg$parselogical_not();
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsews();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsews();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c15) {
          s3 = peg$c15;
          peg$currPos += 3;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c16); }
        }
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$parsews();
          if (s5 !== peg$FAILED) {
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parsews();
            }
          } else {
            s4 = peg$FAILED;
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parselogical_and();
            if (s5 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c17(s1, s5);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parselogical_not();
    }

    return s0;
  }

  function peg$parselogical_not() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.substr(peg$currPos, 3) === peg$c18) {
      s1 = peg$c18;
      peg$currPos += 3;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c19); }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parsews();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parsews();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parselogical_not();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c20(s3);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    if (s0 === peg$FAILED) {
      s0 = peg$parseprimary();
    }

    return s0;
  }

  function peg$parseprimary() {
    var s0, s1, s2, s3;

    s0 = peg$parseterm();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c21;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c22); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parselogical_or();
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s3 = peg$c23;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c24); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c25(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseterm() {
    var s0, s1, s2, s3;

    s0 = peg$parseexpression();
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parsetoken();
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c1;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c2); }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsetoken();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c26(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseexpression() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parsetoken();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 58) {
        s2 = peg$c1;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c2); }
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 34) {
          s3 = peg$c27;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c28); }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parsetoken();
          if (s4 !== peg$FAILED) {
            s5 = [];
            if (input.charCodeAt(peg$currPos) === 58) {
              s6 = peg$c1;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c2); }
            }
            if (s6 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 46) {
                s6 = peg$c3;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c4); }
              }
              if (s6 === peg$FAILED) {
                s6 = peg$parsews();
                if (s6 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 39) {
                    s6 = peg$c5;
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c6); }
                  }
                  if (s6 === peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 45) {
                      s6 = peg$c7;
                      peg$currPos++;
                    } else {
                      s6 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c8); }
                    }
                    if (s6 === peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 47) {
                        s6 = peg$c9;
                        peg$currPos++;
                      } else {
                        s6 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c10); }
                      }
                      if (s6 === peg$FAILED) {
                        s6 = peg$parsetoken();
                      }
                    }
                  }
                }
              }
            }
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              if (input.charCodeAt(peg$currPos) === 58) {
                s6 = peg$c1;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c2); }
              }
              if (s6 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s6 = peg$c3;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c4); }
                }
                if (s6 === peg$FAILED) {
                  s6 = peg$parsews();
                  if (s6 === peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 39) {
                      s6 = peg$c5;
                      peg$currPos++;
                    } else {
                      s6 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c6); }
                    }
                    if (s6 === peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 45) {
                        s6 = peg$c7;
                        peg$currPos++;
                      } else {
                        s6 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c8); }
                      }
                      if (s6 === peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 47) {
                          s6 = peg$c9;
                          peg$currPos++;
                        } else {
                          s6 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c10); }
                        }
                        if (s6 === peg$FAILED) {
                          s6 = peg$parsetoken();
                        }
                      }
                    }
                  }
                }
              }
            }
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 34) {
                s6 = peg$c27;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c28); }
              }
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c29(s1, s4, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parsetoken() {
    var s0, s1, s2;

    s0 = peg$currPos;
    s1 = [];
    if (peg$c30.test(input.charAt(peg$currPos))) {
      s2 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s2 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c31); }
    }
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        if (peg$c30.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c31); }
        }
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$c32(s1);
    }
    s0 = s1;

    return s0;
  }

  function peg$parsews() {
    var s0;

    if (peg$c33.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) { peg$fail(peg$c34); }
    }

    return s0;
  }


     function processName(name) {
        var processedName = "";
        switch (name) {
            case 'accountability':
            case 'availability':
            case 'confidentiality':
            case 'integrity':
                processedName = 'impact_' + name;
                break;
            case 'service':
                processedName = 'service__name';
                break;
            case 'easeofresolution':
            case 'ease_of_resolution':
                processedName = 'ease_of_resolution';
                break;
            case 'web':
            case 'type':
                processedName = 'type';
                break;
            case 'creator':
                processedName = 'creator_command_tool';
                break;
            case 'policy_violations':
            case 'policyviolations':
                processedName = 'policy_violations__name';
                break;
            case 'host_os':
                processedName = 'host__os';
                break;
            case 'refs':
            case 'ref':
                processedName = 'references__name';
                break;
            case 'evidence':
                processedName = 'evidence__filename';
                break;
            case 'params':
            case 'parameters':
                processedName = 'parameters';
                break;
            case 'pname':
            case 'parameter_name':
                processedName = 'parameter_name';
                break;
            case 'query':
            case 'query_string':
                processedName = 'query_string';
                break;
            case 'tags':
            case 'tag':
                processedName = 'tags__name';
                break;
            case 'port':
            case 'service_port':
                processedName = 'service__port';
                break;
            case 'protocol':
            case 'service_protocol':
                processedName = 'service__protocol';
                break;
            case 'hostname':
                processedName = 'hostnames';
                break;
            default:
                processedName = name;
                break;
        }
        return processedName;
     }


     function processOperator(name, operator) {
         var processedOperator = "";
         name = processName(name);
         switch (name) {
             case 'confirmed':
             case 'impact_accountability':
             case 'impact_availability':
             case 'impact_confidentiality':
             case 'impact_integrity':
             case 'ease_of_resolution':
             case 'type':
             case 'id':
                 processedOperator = operator !== 'not' ? '==' : '!=';
                 break;
             case 'severity':
             case 'target':
             case 'hostnames':
             case 'policy_violations__name':
             case 'references__name':
             case 'status':
             case 'status_code':
                 processedOperator = operator !== 'not' ? 'eq' : '!=';
                 break;
             case 'service__name':
             case 'service__port':
             case 'service__protocol':
             case 'host__os':
                 processedOperator = operator !== 'not' ? 'has' : '!=';
                 break;
             case 'evidence__filename':
             case 'tags__name':
                 processedOperator = operator !== 'not' ? 'any' : '!=';
                 break;
             default:
                 processedOperator = operator !== 'not' ? 'ilike' : '!=';
                 break;
         }

         return processedOperator;
     }


     function processValue(name, operator, value) {
          name = processName(name);
          operator = processOperator(name, operator);
          var val = value;

          if (val === 'info') val = 'informational';
          if (val === 'med') val = 'medium';

          if (operator === 'ilike' && name !== 'creator_command_tool') {
              val = '%' + value + '%';
          }
          return val;
     }

     function processLogicalNot(operand){
          try{
              operand.val = operand.val.replace(/%/g,'');
              return {
                    name: operand.name,
                    op: processOperator(operand.name, 'not') ,
                    val: processValue(operand.name, 'not', operand.val)
              }
          }catch(e){
              throw '"NOT" expression only can contain one operand'
              return null;
          }


     }



  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(
      peg$maxFailExpected,
      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
      peg$maxFailPos < input.length
        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
    );
  }
}
