"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnumType = exports.UnionType = exports.InputType = exports.ObjectType = exports.InterfaceType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const private_1 = require("./private");
const schema_field_1 = require("./schema-field");
/**
 * Interface Types are abstract types that includes a certain set of fields
 * that other types must include if they implement the interface.
 *
 */
class InterfaceType {
    constructor(name, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IntermediateTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InterfaceType);
            }
            throw error;
        }
        this.name = name;
        this.definition = props.definition;
        this.directives = props.directives;
    }
    /**
     * Create a GraphQL Type representing this Intermediate Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options?.isList,
            isRequired: options?.isRequired,
            isRequiredList: options?.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this object type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'interface',
            name: this.name,
            directives: this.directives,
            fields: Object.keys(this.definition).map((key) => {
                const field = this.definition[key];
                return `${key}${field.argsToString()}: ${field.toString()}${field.directivesToString(this.modes)}`;
            }),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Interface Type.
     *
     * Interface Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Interface Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.InterfaceType = InterfaceType;
_a = JSII_RTTI_SYMBOL_1;
InterfaceType[_a] = { fqn: "@aws-cdk/aws-appsync.InterfaceType", version: "1.188.0" };
/**
 * Object Types are types declared by you.
 *
 */
class ObjectType extends InterfaceType {
    constructor(name, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ObjectTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ObjectType);
            }
            throw error;
        }
        const options = {
            definition: props.interfaceTypes?.reduce((def, interfaceType) => {
                return Object.assign({}, def, interfaceType.definition);
            }, props.definition) ?? props.definition,
            directives: props.directives,
        };
        super(name, options);
        this.interfaceTypes = props.interfaceTypes;
        this.resolvers = [];
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        // If the resolvers have been generated, skip the bind
        if (this.resolvers && this.resolvers.length > 0) {
            return this;
        }
        Object.keys(this.definition).forEach((fieldName) => {
            const field = this.definition[fieldName];
            if (field instanceof schema_field_1.ResolvableField) {
                if (!this.resolvers)
                    this.resolvers = [];
                this.resolvers.push(this.generateResolver(api, fieldName, field.fieldOptions));
            }
        });
        return this;
    }
    /**
     * Add a field to this Object Type.
     *
     * Object Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Object Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Generate the string of this object type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'type',
            name: this.name,
            interfaceTypes: this.interfaceTypes,
            directives: this.directives,
            fields: Object.keys(this.definition).map((key) => {
                const field = this.definition[key];
                return `${key}${field.argsToString()}: ${field.toString()}${field.directivesToString(this.modes)}`;
            }),
            modes: this.modes,
        });
    }
    /**
     * Generate the resolvers linked to this Object Type
     */
    generateResolver(api, fieldName, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IGraphqlApi(api);
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_ResolvableFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.generateResolver);
            }
            throw error;
        }
        return api.createResolver({
            typeName: this.name,
            fieldName: fieldName,
            dataSource: options?.dataSource,
            pipelineConfig: options?.pipelineConfig,
            requestMappingTemplate: options?.requestMappingTemplate,
            responseMappingTemplate: options?.responseMappingTemplate,
        });
    }
}
exports.ObjectType = ObjectType;
_b = JSII_RTTI_SYMBOL_1;
ObjectType[_b] = { fqn: "@aws-cdk/aws-appsync.ObjectType", version: "1.188.0" };
/**
 * Input Types are abstract types that define complex objects.
 * They are used in arguments to represent
 *
 */
class InputType {
    constructor(name, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_IntermediateTypeOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InputType);
            }
            throw error;
        }
        this.name = name;
        this.definition = props.definition;
    }
    /**
     * Create a GraphQL Type representing this Input Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options?.isList,
            isRequired: options?.isRequired,
            isRequiredList: options?.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this input type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'input',
            name: this.name,
            fields: Object.keys(this.definition).map((key) => `${key}${this.definition[key].argsToString()}: ${this.definition[key].toString()}`),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Input Type.
     *
     * Input Types must have both fieldName and field options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (!options.fieldName || !options.field) {
            throw new Error('Input Types must have both fieldName and field options.');
        }
        this.definition[options.fieldName] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.InputType = InputType;
_c = JSII_RTTI_SYMBOL_1;
InputType[_c] = { fqn: "@aws-cdk/aws-appsync.InputType", version: "1.188.0" };
/**
 * Union Types are abstract types that are similar to Interface Types,
 * but they cannot to specify any common fields between types.
 *
 * Note that fields of a union type need to be object types. In other words,
 * you can't create a union type out of interfaces, other unions, or inputs.
 *
 */
class UnionType {
    constructor(name, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_UnionTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UnionType);
            }
            throw error;
        }
        this.name = name;
        this.definition = {};
        options.definition.map((def) => this.addField({ field: def.attribute() }));
    }
    /**
     * Create a GraphQL Type representing this Union Type
     *
     * @param options the options to configure this attribute
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options?.isList,
            isRequired: options?.isRequired,
            isRequiredList: options?.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this Union type
     */
    toString() {
        // Return a string that appends all Object Types for this Union Type
        // i.e. 'union Example = example1 | example2'
        return Object.values(this.definition).reduce((acc, field) => `${acc} ${field.toString()} |`, `union ${this.name} =`).slice(0, -2);
    }
    /**
     * Add a field to this Union Type
     *
     * Input Types must have field options and the IField must be an Object Type.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (options.fieldName) {
            throw new Error('Union Types cannot be configured with the fieldName option. Use the field option instead.');
        }
        if (!options.field) {
            throw new Error('Union Types must be configured with the field option.');
        }
        if (options.field && !(options.field.intermediateType instanceof ObjectType)) {
            throw new Error('Fields for Union Types must be Object Types.');
        }
        this.definition[options.field.toString()] = options.field;
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.UnionType = UnionType;
_d = JSII_RTTI_SYMBOL_1;
UnionType[_d] = { fqn: "@aws-cdk/aws-appsync.UnionType", version: "1.188.0" };
/**
 * Enum Types are abstract types that includes a set of fields
 * that represent the strings this type can create.
 *
 */
class EnumType {
    constructor(name, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_EnumTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EnumType);
            }
            throw error;
        }
        this.name = name;
        this.definition = {};
        options.definition.map((fieldName) => this.addField({ fieldName }));
    }
    /**
     * Create an GraphQL Type representing this Enum Type
     */
    attribute(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_BaseTypeOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attribute);
            }
            throw error;
        }
        return schema_field_1.GraphqlType.intermediate({
            isList: options?.isList,
            isRequired: options?.isRequired,
            isRequiredList: options?.isRequiredList,
            intermediateType: this,
        });
    }
    /**
     * Generate the string of this enum type
     */
    toString() {
        return private_1.shapeAddition({
            prefix: 'enum',
            name: this.name,
            fields: Object.keys(this.definition),
            modes: this.modes,
        });
    }
    /**
     * Add a field to this Enum Type
     *
     * To add a field to this Enum Type, you must only configure
     * addField with the fieldName options.
     *
     * @param options the options to add a field
     */
    addField(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_appsync_AddFieldOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addField);
            }
            throw error;
        }
        if (options.field) {
            throw new Error('Enum Type fields consist of strings. Use the fieldName option instead of the field option.');
        }
        if (!options.fieldName) {
            throw new Error('When adding a field to an Enum Type, you must configure the fieldName option.');
        }
        if (options.fieldName.indexOf(' ') > -1) {
            throw new Error(`Enum Type values cannot have whitespace. Received: ${options.fieldName}`);
        }
        this.definition[options.fieldName] = schema_field_1.GraphqlType.string();
    }
    /**
     * Method called when the stringifying Intermediate Types for schema generation
     *
     * @internal
     */
    _bindToGraphqlApi(api) {
        this.modes = api.modes;
        return this;
    }
}
exports.EnumType = EnumType;
_e = JSII_RTTI_SYMBOL_1;
EnumType[_e] = { fqn: "@aws-cdk/aws-appsync.EnumType", version: "1.188.0" };
//# sourceMappingURL=data:application/json;base64,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