/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.type.Type;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;

public class SsaRenamer
implements Runnable {
    private static final boolean DEBUG = false;
    private final SsaMethod ssaMeth;
    private int nextSsaReg;
    private final int ropRegCount;
    private int threshold;
    private final RegisterSpec[][] startsForBlocks;
    private final ArrayList<LocalItem> ssaRegToLocalItems;
    private IntList ssaRegToRopReg;

    public SsaRenamer(SsaMethod ssaMethod) {
        this.ropRegCount = ssaMethod.getRegCount();
        this.ssaMeth = ssaMethod;
        this.nextSsaReg = this.ropRegCount;
        this.threshold = 0;
        this.startsForBlocks = new RegisterSpec[ssaMethod.getBlocks().size()][];
        this.ssaRegToLocalItems = new ArrayList();
        RegisterSpec[] registerSpecArray = new RegisterSpec[this.ropRegCount];
        for (int i = 0; i < this.ropRegCount; ++i) {
            registerSpecArray[i] = RegisterSpec.make(i, Type.VOID);
        }
        this.startsForBlocks[ssaMethod.getEntryBlockIndex()] = registerSpecArray;
    }

    public SsaRenamer(SsaMethod ssaMethod, int n) {
        this(ssaMethod);
        this.threshold = n;
    }

    @Override
    public void run() {
        this.ssaMeth.forEachBlockDepthFirstDom(new SsaBasicBlock.Visitor(){

            @Override
            public void visitBlock(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
                new BlockRenamer(ssaBasicBlock).process();
            }
        });
        this.ssaMeth.setNewRegCount(this.nextSsaReg);
        this.ssaMeth.onInsnsChanged();
    }

    private static RegisterSpec[] dupArray(RegisterSpec[] registerSpecArray) {
        RegisterSpec[] registerSpecArray2 = new RegisterSpec[registerSpecArray.length];
        System.arraycopy(registerSpecArray, 0, registerSpecArray2, 0, registerSpecArray.length);
        return registerSpecArray2;
    }

    private LocalItem getLocalForNewReg(int n) {
        if (n < this.ssaRegToLocalItems.size()) {
            return this.ssaRegToLocalItems.get(n);
        }
        return null;
    }

    private void setNameForSsaReg(RegisterSpec registerSpec) {
        int n = registerSpec.getReg();
        LocalItem localItem = registerSpec.getLocalItem();
        this.ssaRegToLocalItems.ensureCapacity(n + 1);
        while (this.ssaRegToLocalItems.size() <= n) {
            this.ssaRegToLocalItems.add(null);
        }
        this.ssaRegToLocalItems.set(n, localItem);
    }

    private boolean isBelowThresholdRegister(int n) {
        return n < this.threshold;
    }

    private boolean isVersionZeroRegister(int n) {
        return n < this.ropRegCount;
    }

    private static boolean equalsHandlesNulls(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private class BlockRenamer
    implements SsaInsn.Visitor {
        private final SsaBasicBlock block;
        private final RegisterSpec[] currentMapping;
        private final HashSet<SsaInsn> movesToKeep;
        private final HashMap<SsaInsn, SsaInsn> insnsToReplace;
        private final RenamingMapper mapper;

        BlockRenamer(SsaBasicBlock ssaBasicBlock) {
            this.block = ssaBasicBlock;
            this.currentMapping = SsaRenamer.this.startsForBlocks[ssaBasicBlock.getIndex()];
            this.movesToKeep = new HashSet();
            this.insnsToReplace = new HashMap();
            this.mapper = new RenamingMapper();
            ((SsaRenamer)SsaRenamer.this).startsForBlocks[ssaBasicBlock.getIndex()] = null;
        }

        public void process() {
            int n;
            this.block.forEachInsn(this);
            this.updateSuccessorPhis();
            ArrayList<SsaInsn> arrayList = this.block.getInsns();
            int n2 = arrayList.size();
            for (n = n2 - 1; n >= 0; --n) {
                SsaInsn ssaInsn = arrayList.get(n);
                SsaInsn object = this.insnsToReplace.get(ssaInsn);
                if (object != null) {
                    arrayList.set(n, object);
                    continue;
                }
                if (!ssaInsn.isNormalMoveInsn() || this.movesToKeep.contains(ssaInsn)) continue;
                arrayList.remove(n);
            }
            n = 1;
            for (SsaBasicBlock ssaBasicBlock : this.block.getDomChildren()) {
                if (ssaBasicBlock == this.block) continue;
                RegisterSpec[] registerSpecArray = n != 0 ? this.currentMapping : SsaRenamer.dupArray(this.currentMapping);
                ((SsaRenamer)SsaRenamer.this).startsForBlocks[ssaBasicBlock.getIndex()] = registerSpecArray;
                n = 0;
            }
        }

        private void addMapping(int n, RegisterSpec registerSpec) {
            RegisterSpec registerSpec2;
            int n2;
            int n3 = registerSpec.getReg();
            LocalItem localItem = registerSpec.getLocalItem();
            this.currentMapping[n] = registerSpec;
            for (n2 = this.currentMapping.length - 1; n2 >= 0; --n2) {
                registerSpec2 = this.currentMapping[n2];
                if (n3 != registerSpec2.getReg()) continue;
                this.currentMapping[n2] = registerSpec;
            }
            if (localItem == null) {
                return;
            }
            SsaRenamer.this.setNameForSsaReg(registerSpec);
            for (n2 = this.currentMapping.length - 1; n2 >= 0; --n2) {
                registerSpec2 = this.currentMapping[n2];
                if (n3 == registerSpec2.getReg() || !localItem.equals(registerSpec2.getLocalItem())) continue;
                this.currentMapping[n2] = registerSpec2.withLocalItem(null);
            }
        }

        @Override
        public void visitPhiInsn(PhiInsn phiInsn) {
            this.processResultReg(phiInsn);
        }

        @Override
        public void visitMoveInsn(NormalSsaInsn normalSsaInsn) {
            RegisterSpec registerSpec = normalSsaInsn.getResult();
            int n = registerSpec.getReg();
            int n2 = normalSsaInsn.getSources().get(0).getReg();
            normalSsaInsn.mapSourceRegisters(this.mapper);
            int n3 = normalSsaInsn.getSources().get(0).getReg();
            LocalItem localItem = this.currentMapping[n2].getLocalItem();
            LocalItem localItem2 = registerSpec.getLocalItem();
            LocalItem localItem3 = localItem2 == null ? localItem : localItem2;
            LocalItem localItem4 = SsaRenamer.this.getLocalForNewReg(n3);
            boolean bl = localItem4 == null || localItem3 == null || localItem3.equals(localItem4);
            RegisterSpec registerSpec2 = RegisterSpec.makeLocalOptional(n3, registerSpec.getType(), localItem3);
            if (!Optimizer.getPreserveLocals() || bl && SsaRenamer.equalsHandlesNulls(localItem3, localItem) && SsaRenamer.this.threshold == 0) {
                this.addMapping(n, registerSpec2);
            } else if (bl && localItem == null && SsaRenamer.this.threshold == 0) {
                RegisterSpecList registerSpecList = RegisterSpecList.make(RegisterSpec.make(registerSpec2.getReg(), registerSpec2.getType(), localItem3));
                SsaInsn ssaInsn = SsaInsn.makeFromRop(new PlainInsn(Rops.opMarkLocal(registerSpec2), SourcePosition.NO_INFO, null, registerSpecList), this.block);
                this.insnsToReplace.put(normalSsaInsn, ssaInsn);
                this.addMapping(n, registerSpec2);
            } else {
                this.processResultReg(normalSsaInsn);
                this.movesToKeep.add(normalSsaInsn);
            }
        }

        @Override
        public void visitNonMoveInsn(NormalSsaInsn normalSsaInsn) {
            normalSsaInsn.mapSourceRegisters(this.mapper);
            this.processResultReg(normalSsaInsn);
        }

        void processResultReg(SsaInsn ssaInsn) {
            RegisterSpec registerSpec = ssaInsn.getResult();
            if (registerSpec == null) {
                return;
            }
            int n = registerSpec.getReg();
            if (SsaRenamer.this.isBelowThresholdRegister(n)) {
                return;
            }
            ssaInsn.changeResultReg(SsaRenamer.this.nextSsaReg);
            this.addMapping(n, ssaInsn.getResult());
            SsaRenamer.this.nextSsaReg++;
        }

        private void updateSuccessorPhis() {
            PhiInsn.Visitor visitor = new PhiInsn.Visitor(){

                @Override
                public void visitPhiInsn(PhiInsn phiInsn) {
                    int n = phiInsn.getRopResultReg();
                    if (SsaRenamer.this.isBelowThresholdRegister(n)) {
                        return;
                    }
                    RegisterSpec registerSpec = BlockRenamer.this.currentMapping[n];
                    if (!SsaRenamer.this.isVersionZeroRegister(registerSpec.getReg())) {
                        phiInsn.addPhiOperand(registerSpec, BlockRenamer.this.block);
                    }
                }
            };
            BitSet bitSet = this.block.getSuccessors();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                SsaBasicBlock ssaBasicBlock = SsaRenamer.this.ssaMeth.getBlocks().get(n);
                ssaBasicBlock.forEachPhiInsn(visitor);
                n = bitSet.nextSetBit(n + 1);
            }
        }

        private class RenamingMapper
        extends RegisterMapper {
            @Override
            public int getNewRegisterCount() {
                return SsaRenamer.this.nextSsaReg;
            }

            @Override
            public RegisterSpec map(RegisterSpec registerSpec) {
                if (registerSpec == null) {
                    return null;
                }
                int n = registerSpec.getReg();
                return registerSpec.withReg(BlockRenamer.this.currentMapping[n].getReg());
            }
        }
    }
}

