/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.code.TranslationAdvice;
import com.android.dx.ssa.ConstCollector;
import com.android.dx.ssa.DeadCodeRemover;
import com.android.dx.ssa.EscapeAnalysis;
import com.android.dx.ssa.LiteralOpUpgrader;
import com.android.dx.ssa.MoveParamCombiner;
import com.android.dx.ssa.PhiTypeResolver;
import com.android.dx.ssa.SCCP;
import com.android.dx.ssa.SsaConverter;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.LivenessAnalyzer;
import com.android.dx.ssa.back.SsaToRop;
import java.util.AbstractCollection;
import java.util.EnumSet;

public class Optimizer {
    private static boolean preserveLocals = true;
    private static TranslationAdvice advice;

    public static boolean getPreserveLocals() {
        return preserveLocals;
    }

    public static TranslationAdvice getAdvice() {
        return advice;
    }

    public static RopMethod optimize(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice) {
        return Optimizer.optimize(ropMethod, n, bl, bl2, translationAdvice, EnumSet.allOf(OptionalStep.class));
    }

    public static RopMethod optimize(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice, EnumSet<OptionalStep> enumSet) {
        SsaMethod ssaMethod = null;
        preserveLocals = bl2;
        advice = translationAdvice;
        ssaMethod = SsaConverter.convertToSsaMethod(ropMethod, n, bl);
        Optimizer.runSsaFormSteps(ssaMethod, enumSet);
        RopMethod ropMethod2 = SsaToRop.convertToRopMethod(ssaMethod, false);
        if (ropMethod2.getBlocks().getRegCount() > advice.getMaxOptimalRegisterCount()) {
            ropMethod2 = Optimizer.optimizeMinimizeRegisters(ropMethod, n, bl, enumSet);
        }
        return ropMethod2;
    }

    private static RopMethod optimizeMinimizeRegisters(RopMethod ropMethod, int n, boolean bl, EnumSet<OptionalStep> enumSet) {
        SsaMethod ssaMethod = SsaConverter.convertToSsaMethod(ropMethod, n, bl);
        Object object = enumSet.clone();
        ((AbstractCollection)object).remove((Object)OptionalStep.CONST_COLLECTOR);
        Optimizer.runSsaFormSteps(ssaMethod, (EnumSet<OptionalStep>)object);
        RopMethod ropMethod2 = SsaToRop.convertToRopMethod(ssaMethod, true);
        return ropMethod2;
    }

    private static void runSsaFormSteps(SsaMethod ssaMethod, EnumSet<OptionalStep> enumSet) {
        boolean bl = true;
        if (enumSet.contains((Object)OptionalStep.MOVE_PARAM_COMBINER)) {
            MoveParamCombiner.process(ssaMethod);
        }
        if (enumSet.contains((Object)OptionalStep.SCCP)) {
            SCCP.process(ssaMethod);
            DeadCodeRemover.process(ssaMethod);
            bl = false;
        }
        if (enumSet.contains((Object)OptionalStep.LITERAL_UPGRADE)) {
            LiteralOpUpgrader.process(ssaMethod);
            DeadCodeRemover.process(ssaMethod);
            bl = false;
        }
        enumSet.remove((Object)OptionalStep.ESCAPE_ANALYSIS);
        if (enumSet.contains((Object)OptionalStep.ESCAPE_ANALYSIS)) {
            EscapeAnalysis.process(ssaMethod);
            DeadCodeRemover.process(ssaMethod);
            bl = false;
        }
        if (enumSet.contains((Object)OptionalStep.CONST_COLLECTOR)) {
            ConstCollector.process(ssaMethod);
            DeadCodeRemover.process(ssaMethod);
            bl = false;
        }
        if (bl) {
            DeadCodeRemover.process(ssaMethod);
        }
        PhiTypeResolver.process(ssaMethod);
    }

    public static SsaMethod debugEdgeSplit(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice) {
        preserveLocals = bl2;
        advice = translationAdvice;
        return SsaConverter.testEdgeSplit(ropMethod, n, bl);
    }

    public static SsaMethod debugPhiPlacement(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice) {
        preserveLocals = bl2;
        advice = translationAdvice;
        return SsaConverter.testPhiPlacement(ropMethod, n, bl);
    }

    public static SsaMethod debugRenaming(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice) {
        preserveLocals = bl2;
        advice = translationAdvice;
        return SsaConverter.convertToSsaMethod(ropMethod, n, bl);
    }

    public static SsaMethod debugDeadCodeRemover(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice) {
        preserveLocals = bl2;
        advice = translationAdvice;
        SsaMethod ssaMethod = SsaConverter.convertToSsaMethod(ropMethod, n, bl);
        DeadCodeRemover.process(ssaMethod);
        return ssaMethod;
    }

    public static SsaMethod debugNoRegisterAllocation(RopMethod ropMethod, int n, boolean bl, boolean bl2, TranslationAdvice translationAdvice, EnumSet<OptionalStep> enumSet) {
        preserveLocals = bl2;
        advice = translationAdvice;
        SsaMethod ssaMethod = SsaConverter.convertToSsaMethod(ropMethod, n, bl);
        Optimizer.runSsaFormSteps(ssaMethod, enumSet);
        LivenessAnalyzer.constructInterferenceGraph(ssaMethod);
        return ssaMethod;
    }

    public static enum OptionalStep {
        MOVE_PARAM_COMBINER,
        SCCP,
        LITERAL_UPGRADE,
        CONST_COLLECTOR,
        ESCAPE_ANALYSIS;

    }
}

