/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.DomFront;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public final class Dominators {
    private final boolean postdom;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> blocks;
    private final DFSInfo[] info;
    private final ArrayList<SsaBasicBlock> vertex;
    private final DomFront.DomInfo[] domInfos;

    private Dominators(SsaMethod ssaMethod, DomFront.DomInfo[] domInfoArray, boolean bl) {
        this.meth = ssaMethod;
        this.domInfos = domInfoArray;
        this.postdom = bl;
        this.blocks = ssaMethod.getBlocks();
        this.info = new DFSInfo[this.blocks.size() + 2];
        this.vertex = new ArrayList();
    }

    public static Dominators make(SsaMethod ssaMethod, DomFront.DomInfo[] domInfoArray, boolean bl) {
        Dominators dominators = new Dominators(ssaMethod, domInfoArray, bl);
        dominators.run();
        return dominators;
    }

    private BitSet getSuccs(SsaBasicBlock ssaBasicBlock) {
        if (this.postdom) {
            return ssaBasicBlock.getPredecessors();
        }
        return ssaBasicBlock.getSuccessors();
    }

    private BitSet getPreds(SsaBasicBlock ssaBasicBlock) {
        if (this.postdom) {
            return ssaBasicBlock.getSuccessors();
        }
        return ssaBasicBlock.getPredecessors();
    }

    private void compress(SsaBasicBlock ssaBasicBlock) {
        DFSInfo dFSInfo = this.info[ssaBasicBlock.getIndex()];
        DFSInfo dFSInfo2 = this.info[dFSInfo.ancestor.getIndex()];
        if (dFSInfo2.ancestor != null) {
            ArrayList<SsaBasicBlock> arrayList = new ArrayList<SsaBasicBlock>();
            HashSet<SsaBasicBlock> hashSet = new HashSet<SsaBasicBlock>();
            arrayList.add(ssaBasicBlock);
            while (!arrayList.isEmpty()) {
                int n = arrayList.size();
                SsaBasicBlock ssaBasicBlock2 = (SsaBasicBlock)arrayList.get(n - 1);
                DFSInfo dFSInfo3 = this.info[ssaBasicBlock2.getIndex()];
                SsaBasicBlock ssaBasicBlock3 = dFSInfo3.ancestor;
                DFSInfo dFSInfo4 = this.info[ssaBasicBlock3.getIndex()];
                if (hashSet.add(ssaBasicBlock3) && dFSInfo4.ancestor != null) {
                    arrayList.add(ssaBasicBlock3);
                    continue;
                }
                arrayList.remove(n - 1);
                if (dFSInfo4.ancestor == null) continue;
                SsaBasicBlock ssaBasicBlock4 = dFSInfo4.rep;
                SsaBasicBlock ssaBasicBlock5 = dFSInfo3.rep;
                if (this.info[ssaBasicBlock4.getIndex()].semidom < this.info[ssaBasicBlock5.getIndex()].semidom) {
                    dFSInfo3.rep = ssaBasicBlock4;
                }
                dFSInfo3.ancestor = dFSInfo4.ancestor;
            }
        }
    }

    private SsaBasicBlock eval(SsaBasicBlock ssaBasicBlock) {
        DFSInfo dFSInfo = this.info[ssaBasicBlock.getIndex()];
        if (dFSInfo.ancestor == null) {
            return ssaBasicBlock;
        }
        this.compress(ssaBasicBlock);
        return dFSInfo.rep;
    }

    private void run() {
        SsaBasicBlock ssaBasicBlock;
        int n;
        int n2;
        SsaBasicBlock ssaBasicBlock2;
        SsaBasicBlock ssaBasicBlock3 = ssaBasicBlock2 = this.postdom ? this.meth.getExitBlock() : this.meth.getEntryBlock();
        if (ssaBasicBlock2 != null) {
            this.vertex.add(ssaBasicBlock2);
            this.domInfos[ssaBasicBlock2.getIndex()].idom = ssaBasicBlock2.getIndex();
        }
        DfsWalker dfsWalker = new DfsWalker();
        this.meth.forEachBlockDepthFirst(this.postdom, dfsWalker);
        for (n2 = n = this.vertex.size() - 1; n2 >= 2; --n2) {
            Object object;
            ssaBasicBlock = this.vertex.get(n2);
            DFSInfo dFSInfo = this.info[ssaBasicBlock.getIndex()];
            BitSet bitSet = this.getPreds(ssaBasicBlock);
            int n3 = bitSet.nextSetBit(0);
            while (n3 >= 0) {
                int n4;
                SsaBasicBlock ssaBasicBlock4 = this.blocks.get(n3);
                object = this.info[ssaBasicBlock4.getIndex()];
                if (object != null && (n4 = this.info[this.eval((SsaBasicBlock)ssaBasicBlock4).getIndex()].semidom) < dFSInfo.semidom) {
                    dFSInfo.semidom = n4;
                }
                n3 = bitSet.nextSetBit(n3 + 1);
            }
            this.info[this.vertex.get((int)dFSInfo.semidom).getIndex()].bucket.add(ssaBasicBlock);
            dFSInfo.ancestor = dFSInfo.parent;
            ArrayList<SsaBasicBlock> arrayList = this.info[dFSInfo.parent.getIndex()].bucket;
            while (!arrayList.isEmpty()) {
                int n5 = arrayList.size() - 1;
                object = arrayList.remove(n5);
                SsaBasicBlock ssaBasicBlock5 = this.eval((SsaBasicBlock)object);
                if (this.info[ssaBasicBlock5.getIndex()].semidom < this.info[((SsaBasicBlock)object).getIndex()].semidom) {
                    this.domInfos[((SsaBasicBlock)object).getIndex()].idom = ssaBasicBlock5.getIndex();
                    continue;
                }
                this.domInfos[((SsaBasicBlock)object).getIndex()].idom = dFSInfo.parent.getIndex();
            }
        }
        for (n2 = 2; n2 <= n; ++n2) {
            ssaBasicBlock = this.vertex.get(n2);
            if (this.domInfos[ssaBasicBlock.getIndex()].idom == this.vertex.get(this.info[ssaBasicBlock.getIndex()].semidom).getIndex()) continue;
            this.domInfos[ssaBasicBlock.getIndex()].idom = this.domInfos[this.domInfos[ssaBasicBlock.getIndex()].idom].idom;
        }
    }

    private static final class DFSInfo {
        public int semidom;
        public SsaBasicBlock parent;
        public SsaBasicBlock rep;
        public SsaBasicBlock ancestor;
        public ArrayList<SsaBasicBlock> bucket = new ArrayList();
    }

    private class DfsWalker
    implements SsaBasicBlock.Visitor {
        private int dfsNum = 0;

        private DfsWalker() {
        }

        @Override
        public void visitBlock(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
            DFSInfo dFSInfo = new DFSInfo();
            dFSInfo.semidom = ++this.dfsNum;
            dFSInfo.rep = ssaBasicBlock;
            dFSInfo.parent = ssaBasicBlock2;
            Dominators.this.vertex.add(ssaBasicBlock);
            ((Dominators)Dominators.this).info[ssaBasicBlock.getIndex()] = dFSInfo;
        }
    }
}

