/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.List;

public final class UniformListItem<T extends OffsettedItem>
extends OffsettedItem {
    private static final int HEADER_SIZE = 4;
    private final ItemType itemType;
    private final List<T> items;

    public UniformListItem(ItemType itemType, List<T> list) {
        super(UniformListItem.getAlignment(list), UniformListItem.writeSize(list));
        if (itemType == null) {
            throw new NullPointerException("itemType == null");
        }
        this.items = list;
        this.itemType = itemType;
    }

    private static int getAlignment(List<? extends OffsettedItem> list) {
        try {
            return Math.max(4, list.get(0).getAlignment());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("items.size() == 0");
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("items == null");
        }
    }

    private static int writeSize(List<? extends OffsettedItem> list) {
        OffsettedItem offsettedItem = list.get(0);
        return list.size() * offsettedItem.writeSize() + UniformListItem.getAlignment(list);
    }

    @Override
    public ItemType itemType() {
        return this.itemType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(this.items);
        return stringBuffer.toString();
    }

    @Override
    public void addContents(DexFile dexFile) {
        for (OffsettedItem offsettedItem : this.items) {
            offsettedItem.addContents(dexFile);
        }
    }

    @Override
    public final String toHuman() {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        stringBuffer.append("{");
        for (OffsettedItem offsettedItem : this.items) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(offsettedItem.toHuman());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public final List<T> getItems() {
        return this.items;
    }

    @Override
    protected void place0(Section section, int n) {
        n += this.headerSize();
        boolean bl = true;
        int n2 = -1;
        int n3 = -1;
        for (OffsettedItem offsettedItem : this.items) {
            int n4 = offsettedItem.writeSize();
            if (bl) {
                n2 = n4;
                n3 = offsettedItem.getAlignment();
                bl = false;
            } else {
                if (n4 != n2) {
                    throw new UnsupportedOperationException("item size mismatch");
                }
                if (offsettedItem.getAlignment() != n3) {
                    throw new UnsupportedOperationException("item alignment mismatch");
                }
            }
            n = offsettedItem.place(section, n) + n4;
        }
    }

    @Override
    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = this.items.size();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, this.offsetString() + " " + this.typeName());
            annotatedOutput.annotate(4, "  size: " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n);
        for (OffsettedItem offsettedItem : this.items) {
            offsettedItem.writeTo(dexFile, annotatedOutput);
        }
    }

    private int headerSize() {
        return this.getAlignment();
    }
}

