/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.code.LocalList;
import com.android.dx.dex.code.PositionList;
import com.android.dx.dex.file.DexFile;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;

public final class DebugInfoEncoder {
    private static final boolean DEBUG = false;
    private final PositionList positions;
    private final LocalList locals;
    private final ByteArrayAnnotatedOutput output;
    private final DexFile file;
    private final int codeSize;
    private final int regSize;
    private final Prototype desc;
    private final boolean isStatic;
    private int address = 0;
    private int line = 1;
    private AnnotatedOutput annotateTo;
    private PrintWriter debugPrint;
    private String prefix;
    private boolean shouldConsume;
    private final LocalList.Entry[] lastEntryForReg;

    public DebugInfoEncoder(PositionList positionList, LocalList localList, DexFile dexFile, int n, int n2, boolean bl, CstMethodRef cstMethodRef) {
        this.positions = positionList;
        this.locals = localList;
        this.file = dexFile;
        this.desc = cstMethodRef.getPrototype();
        this.isStatic = bl;
        this.codeSize = n;
        this.regSize = n2;
        this.output = new ByteArrayAnnotatedOutput();
        this.lastEntryForReg = new LocalList.Entry[n2];
    }

    private void annotate(int n, String string) {
        if (this.prefix != null) {
            string = this.prefix + string;
        }
        if (this.annotateTo != null) {
            this.annotateTo.annotate(this.shouldConsume ? n : 0, string);
        }
        if (this.debugPrint != null) {
            this.debugPrint.println(string);
        }
    }

    public byte[] convert() {
        try {
            byte[] byArray = this.convert0();
            return byArray;
        }
        catch (IOException iOException) {
            throw ExceptionWithContext.withContext(iOException, "...while encoding debug info");
        }
    }

    public byte[] convertAndAnnotate(String string, PrintWriter printWriter, AnnotatedOutput annotatedOutput, boolean bl) {
        this.prefix = string;
        this.debugPrint = printWriter;
        this.annotateTo = annotatedOutput;
        this.shouldConsume = bl;
        byte[] byArray = this.convert();
        return byArray;
    }

    private byte[] convert0() throws IOException {
        ArrayList<PositionList.Entry> arrayList = this.buildSortedPositions();
        ArrayList<LocalList.Entry> arrayList2 = this.extractMethodArguments();
        this.emitHeader(arrayList, arrayList2);
        this.output.writeByte(7);
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(1, String.format("%04x: prologue end", this.address));
        }
        int n = arrayList.size();
        int n2 = this.locals.size();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5;
            n4 = this.emitLocalsAtAddress(n4);
            n3 = this.emitPositionsAtAddress(n3, arrayList);
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            if (n4 < n2) {
                n6 = this.locals.get(n4).getAddress();
            }
            if (n3 < n) {
                n7 = arrayList.get(n3).getAddress();
            }
            if ((n5 = Math.min(n7, n6)) == Integer.MAX_VALUE || n5 == this.codeSize && n6 == Integer.MAX_VALUE && n7 == Integer.MAX_VALUE) break;
            if (n5 == n7) {
                this.emitPosition(arrayList.get(n3++));
                continue;
            }
            this.emitAdvancePc(n5 - this.address);
        }
        this.emitEndSequence();
        return this.output.toByteArray();
    }

    private int emitLocalsAtAddress(int n) throws IOException {
        int n2 = this.locals.size();
        while (n < n2 && this.locals.get(n).getAddress() == this.address) {
            int n3;
            LocalList.Entry entry;
            LocalList.Entry entry2;
            if ((entry2 = this.locals.get(n++)) == (entry = this.lastEntryForReg[n3 = entry2.getRegister()])) continue;
            this.lastEntryForReg[n3] = entry2;
            if (entry2.isStart()) {
                if (entry != null && entry2.matches(entry)) {
                    if (entry.isStart()) {
                        throw new RuntimeException("shouldn't happen");
                    }
                    this.emitLocalRestart(entry2);
                    continue;
                }
                this.emitLocalStart(entry2);
                continue;
            }
            if (entry2.getDisposition() == LocalList.Disposition.END_REPLACED) continue;
            this.emitLocalEnd(entry2);
        }
        return n;
    }

    private int emitPositionsAtAddress(int n, ArrayList<PositionList.Entry> arrayList) throws IOException {
        int n2 = arrayList.size();
        while (n < n2 && arrayList.get(n).getAddress() == this.address) {
            this.emitPosition(arrayList.get(n++));
        }
        return n;
    }

    private void emitHeader(ArrayList<PositionList.Entry> arrayList, ArrayList<LocalList.Entry> arrayList2) throws IOException {
        boolean bl = this.annotateTo != null || this.debugPrint != null;
        int n = this.output.getCursor();
        if (arrayList.size() > 0) {
            PositionList.Entry entry = arrayList.get(0);
            this.line = entry.getPosition().getLine();
        }
        this.output.writeUleb128(this.line);
        if (bl) {
            this.annotate(this.output.getCursor() - n, "line_start: " + this.line);
        }
        int n2 = this.getParamBase();
        StdTypeList stdTypeList = this.desc.getParameterTypes();
        int n3 = stdTypeList.size();
        if (!this.isStatic) {
            for (LocalList.Entry comparable2 : arrayList2) {
                if (n2 != comparable2.getRegister()) continue;
                this.lastEntryForReg[n2] = comparable2;
                break;
            }
            ++n2;
        }
        n = this.output.getCursor();
        this.output.writeUleb128(n3);
        if (bl) {
            this.annotate(this.output.getCursor() - n, String.format("parameters_size: %04x", n3));
        }
        for (int i = 0; i < n3; ++i) {
            Type type = stdTypeList.get(i);
            Comparable<LocalList.Entry> comparable = null;
            n = this.output.getCursor();
            for (Comparable<LocalList.Entry> comparable2 : arrayList2) {
                if (n2 != ((LocalList.Entry)comparable2).getRegister()) continue;
                comparable = comparable2;
                if (((LocalList.Entry)comparable2).getSignature() != null) {
                    this.emitStringIndex(null);
                } else {
                    this.emitStringIndex(((LocalList.Entry)comparable2).getName());
                }
                this.lastEntryForReg[n2] = comparable2;
                break;
            }
            if (comparable == null) {
                this.emitStringIndex(null);
            }
            if (bl) {
                String string = comparable == null || ((LocalList.Entry)comparable).getSignature() != null ? "<unnamed>" : ((LocalList.Entry)comparable).getName().toHuman();
                this.annotate(this.output.getCursor() - n, "parameter " + string + " " + "v" + n2);
            }
            n2 += type.getCategory();
        }
        for (LocalList.Entry entry : this.lastEntryForReg) {
            Comparable<LocalList.Entry> comparable2;
            if (entry == null || (comparable2 = entry.getSignature()) == null) continue;
            this.emitLocalStartExtended(entry);
        }
    }

    private ArrayList<PositionList.Entry> buildSortedPositions() {
        int n = this.positions == null ? 0 : this.positions.size();
        ArrayList<PositionList.Entry> arrayList = new ArrayList<PositionList.Entry>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.positions.get(i));
        }
        Collections.sort(arrayList, new Comparator<PositionList.Entry>(){

            @Override
            public int compare(PositionList.Entry entry, PositionList.Entry entry2) {
                return entry.getAddress() - entry2.getAddress();
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        return arrayList;
    }

    private int getParamBase() {
        return this.regSize - this.desc.getParameterTypes().getWordCount() - (this.isStatic ? 0 : 1);
    }

    private ArrayList<LocalList.Entry> extractMethodArguments() {
        ArrayList<LocalList.Entry> arrayList = new ArrayList<LocalList.Entry>(this.desc.getParameterTypes().size());
        int n = this.getParamBase();
        BitSet bitSet = new BitSet(this.regSize - n);
        int n2 = this.locals.size();
        for (int i = 0; i < n2; ++i) {
            LocalList.Entry entry = this.locals.get(i);
            int n3 = entry.getRegister();
            if (n3 < n || bitSet.get(n3 - n)) continue;
            bitSet.set(n3 - n);
            arrayList.add(entry);
        }
        Collections.sort(arrayList, new Comparator<LocalList.Entry>(){

            @Override
            public int compare(LocalList.Entry entry, LocalList.Entry entry2) {
                return entry.getRegister() - entry2.getRegister();
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        return arrayList;
    }

    private String entryAnnotationString(LocalList.Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("v");
        stringBuilder.append(entry.getRegister());
        stringBuilder.append(' ');
        CstString cstString = entry.getName();
        if (cstString == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(cstString.toHuman());
        }
        stringBuilder.append(' ');
        CstType cstType = entry.getType();
        if (cstType == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(cstType.toHuman());
        }
        CstString cstString2 = entry.getSignature();
        if (cstString2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(cstString2.toHuman());
        }
        return stringBuilder.toString();
    }

    private void emitLocalRestart(LocalList.Entry entry) throws IOException {
        int n = this.output.getCursor();
        this.output.writeByte(6);
        this.emitUnsignedLeb128(entry.getRegister());
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n, String.format("%04x: +local restart %s", this.address, this.entryAnnotationString(entry)));
        }
    }

    private void emitStringIndex(CstString cstString) throws IOException {
        if (cstString == null || this.file == null) {
            this.output.writeUleb128(0);
        } else {
            this.output.writeUleb128(1 + this.file.getStringIds().indexOf(cstString));
        }
    }

    private void emitTypeIndex(CstType cstType) throws IOException {
        if (cstType == null || this.file == null) {
            this.output.writeUleb128(0);
        } else {
            this.output.writeUleb128(1 + this.file.getTypeIds().indexOf(cstType));
        }
    }

    private void emitLocalStart(LocalList.Entry entry) throws IOException {
        if (entry.getSignature() != null) {
            this.emitLocalStartExtended(entry);
            return;
        }
        int n = this.output.getCursor();
        this.output.writeByte(3);
        this.emitUnsignedLeb128(entry.getRegister());
        this.emitStringIndex(entry.getName());
        this.emitTypeIndex(entry.getType());
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n, String.format("%04x: +local %s", this.address, this.entryAnnotationString(entry)));
        }
    }

    private void emitLocalStartExtended(LocalList.Entry entry) throws IOException {
        int n = this.output.getCursor();
        this.output.writeByte(4);
        this.emitUnsignedLeb128(entry.getRegister());
        this.emitStringIndex(entry.getName());
        this.emitTypeIndex(entry.getType());
        this.emitStringIndex(entry.getSignature());
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n, String.format("%04x: +localx %s", this.address, this.entryAnnotationString(entry)));
        }
    }

    private void emitLocalEnd(LocalList.Entry entry) throws IOException {
        int n = this.output.getCursor();
        this.output.writeByte(5);
        this.output.writeUleb128(entry.getRegister());
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n, String.format("%04x: -local %s", this.address, this.entryAnnotationString(entry)));
        }
    }

    private void emitPosition(PositionList.Entry entry) throws IOException {
        int n;
        SourcePosition sourcePosition = entry.getPosition();
        int n2 = sourcePosition.getLine();
        int n3 = entry.getAddress();
        int n4 = n2 - this.line;
        int n5 = n3 - this.address;
        if (n5 < 0) {
            throw new RuntimeException("Position entries must be in ascending address order");
        }
        if (n4 < -4 || n4 > 10) {
            this.emitAdvanceLine(n4);
            n4 = 0;
        }
        if (((n = DebugInfoEncoder.computeOpcode(n4, n5)) & 0xFFFFFF00) > 0) {
            this.emitAdvancePc(n5);
            n5 = 0;
            n = DebugInfoEncoder.computeOpcode(n4, n5);
            if ((n & 0xFFFFFF00) > 0) {
                this.emitAdvanceLine(n4);
                n4 = 0;
                n = DebugInfoEncoder.computeOpcode(n4, n5);
            }
        }
        this.output.writeByte(n);
        this.line += n4;
        this.address += n5;
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(1, String.format("%04x: line %d", this.address, this.line));
        }
    }

    private static int computeOpcode(int n, int n2) {
        if (n < -4 || n > 10) {
            throw new RuntimeException("Parameter out of range");
        }
        return n - -4 + 15 * n2 + 10;
    }

    private void emitAdvanceLine(int n) throws IOException {
        int n2 = this.output.getCursor();
        this.output.writeByte(2);
        this.output.writeSleb128(n);
        this.line += n;
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n2, String.format("line = %d", this.line));
        }
    }

    private void emitAdvancePc(int n) throws IOException {
        int n2 = this.output.getCursor();
        this.output.writeByte(1);
        this.output.writeUleb128(n);
        this.address += n;
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(this.output.getCursor() - n2, String.format("%04x: advance pc", this.address));
        }
    }

    private void emitUnsignedLeb128(int n) throws IOException {
        if (n < 0) {
            throw new RuntimeException("Signed value where unsigned required: " + n);
        }
        this.output.writeUleb128(n);
    }

    private void emitEndSequence() {
        this.output.writeByte(0);
        if (this.annotateTo != null || this.debugPrint != null) {
            this.annotate(1, "end sequence");
        }
    }
}

