/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.annotool;

import com.android.dx.cf.attrib.BaseAnnotations;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.command.annotool.Main;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.util.ByteArray;
import java.io.File;
import java.lang.annotation.ElementType;
import java.util.HashSet;

class AnnotationLister {
    private static final String PACKAGE_INFO = "package-info";
    private final Main.Arguments args;
    HashSet<String> matchInnerClassesOf = new HashSet();
    HashSet<String> matchPackages = new HashSet();

    AnnotationLister(Main.Arguments arguments) {
        this.args = arguments;
    }

    void process() {
        for (String string : this.args.files) {
            ClassPathOpener classPathOpener = new ClassPathOpener(string, true, new ClassPathOpener.Consumer(){

                @Override
                public boolean processFileBytes(String string, long l, byte[] byArray) {
                    if (!string.endsWith(".class")) {
                        return true;
                    }
                    ByteArray byteArray = new ByteArray(byArray);
                    DirectClassFile directClassFile = new DirectClassFile(byteArray, string, true);
                    directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
                    AttributeList attributeList = directClassFile.getAttributes();
                    String string2 = directClassFile.getThisClass().getClassType().getClassName();
                    if (string2.endsWith(AnnotationLister.PACKAGE_INFO)) {
                        BaseAnnotations baseAnnotations;
                        Attribute attribute = attributeList.findFirst("RuntimeInvisibleAnnotations");
                        while (attribute != null) {
                            baseAnnotations = (BaseAnnotations)attribute;
                            AnnotationLister.this.visitPackageAnnotation(directClassFile, baseAnnotations);
                            attribute = attributeList.findNext(attribute);
                        }
                        attribute = attributeList.findFirst("RuntimeVisibleAnnotations");
                        while (attribute != null) {
                            baseAnnotations = (BaseAnnotations)attribute;
                            AnnotationLister.this.visitPackageAnnotation(directClassFile, baseAnnotations);
                            attribute = attributeList.findNext(attribute);
                        }
                    } else if (AnnotationLister.this.isMatchingInnerClass(string2) || AnnotationLister.this.isMatchingPackage(string2)) {
                        AnnotationLister.this.printMatch(directClassFile);
                    } else {
                        BaseAnnotations baseAnnotations;
                        Attribute attribute = attributeList.findFirst("RuntimeInvisibleAnnotations");
                        while (attribute != null) {
                            baseAnnotations = (BaseAnnotations)attribute;
                            AnnotationLister.this.visitClassAnnotation(directClassFile, baseAnnotations);
                            attribute = attributeList.findNext(attribute);
                        }
                        attribute = attributeList.findFirst("RuntimeVisibleAnnotations");
                        while (attribute != null) {
                            baseAnnotations = (BaseAnnotations)attribute;
                            AnnotationLister.this.visitClassAnnotation(directClassFile, baseAnnotations);
                            attribute = attributeList.findNext(attribute);
                        }
                    }
                    return true;
                }

                @Override
                public void onException(Exception exception) {
                    throw new RuntimeException(exception);
                }

                @Override
                public void onProcessArchiveStart(File file) {
                }
            });
            classPathOpener.process();
        }
    }

    private void visitClassAnnotation(DirectClassFile directClassFile, BaseAnnotations baseAnnotations) {
        if (!this.args.eTypes.contains((Object)ElementType.TYPE)) {
            return;
        }
        for (Annotation annotation : baseAnnotations.getAnnotations().getAnnotations()) {
            String string = annotation.getType().getClassType().getClassName();
            if (!this.args.aclass.equals(string)) continue;
            this.printMatch(directClassFile);
        }
    }

    private void visitPackageAnnotation(DirectClassFile directClassFile, BaseAnnotations baseAnnotations) {
        if (!this.args.eTypes.contains((Object)ElementType.PACKAGE)) {
            return;
        }
        String string = directClassFile.getThisClass().getClassType().getClassName();
        int n = string.lastIndexOf(47);
        string = n == -1 ? "" : string.substring(0, n);
        for (Annotation annotation : baseAnnotations.getAnnotations().getAnnotations()) {
            String string2 = annotation.getType().getClassType().getClassName();
            if (!this.args.aclass.equals(string2)) continue;
            this.printMatchPackage(string);
        }
    }

    private void printMatchPackage(String string) {
        for (Main.PrintType printType : this.args.printTypes) {
            switch (printType) {
                case CLASS: 
                case INNERCLASS: 
                case METHOD: {
                    this.matchPackages.add(string);
                    break;
                }
                case PACKAGE: {
                    System.out.println(string.replace('/', '.'));
                }
            }
        }
    }

    private void printMatch(DirectClassFile directClassFile) {
        for (Main.PrintType printType : this.args.printTypes) {
            switch (printType) {
                case CLASS: {
                    String string = directClassFile.getThisClass().getClassType().getClassName();
                    string = string.replace('/', '.');
                    System.out.println(string);
                    break;
                }
                case INNERCLASS: {
                    this.matchInnerClassesOf.add(directClassFile.getThisClass().getClassType().getClassName());
                    break;
                }
                case METHOD: {
                    break;
                }
            }
        }
    }

    private boolean isMatchingInnerClass(String string) {
        int n;
        while (0 < (n = string.lastIndexOf(36))) {
            if (!this.matchInnerClassesOf.contains(string = string.substring(0, n))) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingPackage(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n == -1 ? "" : string.substring(0, n);
        return this.matchPackages.contains(string2);
    }
}

