/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.AnnotationVisibility;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.annotation.NameValuePair;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstAnnotation;
import com.android.dx.rop.cst.CstArray;
import com.android.dx.rop.cst.CstBoolean;
import com.android.dx.rop.cst.CstByte;
import com.android.dx.rop.cst.CstChar;
import com.android.dx.rop.cst.CstDouble;
import com.android.dx.rop.cst.CstEnumRef;
import com.android.dx.rop.cst.CstFloat;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstLong;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstShort;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.ToHuman;
import java.io.IOException;

public final class AnnotationParser {
    private final DirectClassFile cf;
    private final ConstantPool pool;
    private final ByteArray bytes;
    private final ParseObserver observer;
    private final ByteArray.MyDataInputStream input;
    private int parseCursor;

    public AnnotationParser(DirectClassFile directClassFile, int n, int n2, ParseObserver parseObserver) {
        if (directClassFile == null) {
            throw new NullPointerException("cf == null");
        }
        this.cf = directClassFile;
        this.pool = directClassFile.getConstantPool();
        this.observer = parseObserver;
        this.bytes = directClassFile.getBytes().slice(n, n + n2);
        this.input = this.bytes.makeDataInputStream();
        this.parseCursor = 0;
    }

    public Constant parseValueAttribute() {
        Constant constant;
        try {
            constant = this.parseValue();
            if (this.input.available() != 0) {
                throw new ParseException("extra data in attribute");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("shouldn't happen", iOException);
        }
        return constant;
    }

    public AnnotationsList parseParameterAttribute(AnnotationVisibility annotationVisibility) {
        AnnotationsList annotationsList;
        try {
            annotationsList = this.parseAnnotationsList(annotationVisibility);
            if (this.input.available() != 0) {
                throw new ParseException("extra data in attribute");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("shouldn't happen", iOException);
        }
        return annotationsList;
    }

    public Annotations parseAnnotationAttribute(AnnotationVisibility annotationVisibility) {
        Annotations annotations;
        try {
            annotations = this.parseAnnotations(annotationVisibility);
            if (this.input.available() != 0) {
                throw new ParseException("extra data in attribute");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("shouldn't happen", iOException);
        }
        return annotations;
    }

    private AnnotationsList parseAnnotationsList(AnnotationVisibility annotationVisibility) throws IOException {
        int n = this.input.readUnsignedByte();
        if (this.observer != null) {
            this.parsed(1, "num_parameters: " + Hex.u1(n));
        }
        AnnotationsList annotationsList = new AnnotationsList(n);
        for (int i = 0; i < n; ++i) {
            if (this.observer != null) {
                this.parsed(0, "parameter_annotations[" + i + "]:");
                this.changeIndent(1);
            }
            Annotations annotations = this.parseAnnotations(annotationVisibility);
            annotationsList.set(i, annotations);
            if (this.observer == null) continue;
            this.observer.changeIndent(-1);
        }
        annotationsList.setImmutable();
        return annotationsList;
    }

    private Annotations parseAnnotations(AnnotationVisibility annotationVisibility) throws IOException {
        int n = this.input.readUnsignedShort();
        if (this.observer != null) {
            this.parsed(2, "num_annotations: " + Hex.u2(n));
        }
        Annotations annotations = new Annotations();
        for (int i = 0; i < n; ++i) {
            if (this.observer != null) {
                this.parsed(0, "annotations[" + i + "]:");
                this.changeIndent(1);
            }
            Annotation annotation = this.parseAnnotation(annotationVisibility);
            annotations.add(annotation);
            if (this.observer == null) continue;
            this.observer.changeIndent(-1);
        }
        annotations.setImmutable();
        return annotations;
    }

    private Annotation parseAnnotation(AnnotationVisibility annotationVisibility) throws IOException {
        this.requireLength(4);
        int n = this.input.readUnsignedShort();
        int n2 = this.input.readUnsignedShort();
        CstString cstString = (CstString)this.pool.get(n);
        CstType cstType = new CstType(Type.intern(cstString.getString()));
        if (this.observer != null) {
            this.parsed(2, "type: " + cstType.toHuman());
            this.parsed(2, "num_elements: " + n2);
        }
        Annotation annotation = new Annotation(cstType, annotationVisibility);
        for (int i = 0; i < n2; ++i) {
            if (this.observer != null) {
                this.parsed(0, "elements[" + i + "]:");
                this.changeIndent(1);
            }
            NameValuePair nameValuePair = this.parseElement();
            annotation.add(nameValuePair);
            if (this.observer == null) continue;
            this.changeIndent(-1);
        }
        annotation.setImmutable();
        return annotation;
    }

    private NameValuePair parseElement() throws IOException {
        this.requireLength(5);
        int n = this.input.readUnsignedShort();
        CstString cstString = (CstString)this.pool.get(n);
        if (this.observer != null) {
            this.parsed(2, "element_name: " + cstString.toHuman());
            this.parsed(0, "value: ");
            this.changeIndent(1);
        }
        Constant constant = this.parseValue();
        if (this.observer != null) {
            this.changeIndent(-1);
        }
        return new NameValuePair(cstString, constant);
    }

    private Constant parseValue() throws IOException {
        ToHuman toHuman;
        int n = this.input.readUnsignedByte();
        if (this.observer != null) {
            toHuman = new CstString(Character.toString((char)n));
            this.parsed(1, "tag: " + ((CstString)toHuman).toQuoted());
        }
        switch (n) {
            case 66: {
                toHuman = (CstInteger)this.parseConstant();
                return CstByte.make(((CstInteger)toHuman).getValue());
            }
            case 67: {
                toHuman = (CstInteger)this.parseConstant();
                int n2 = ((CstInteger)toHuman).getValue();
                return CstChar.make(((CstInteger)toHuman).getValue());
            }
            case 68: {
                toHuman = (CstDouble)this.parseConstant();
                return toHuman;
            }
            case 70: {
                toHuman = (CstFloat)this.parseConstant();
                return toHuman;
            }
            case 73: {
                toHuman = (CstInteger)this.parseConstant();
                return toHuman;
            }
            case 74: {
                toHuman = (CstLong)this.parseConstant();
                return toHuman;
            }
            case 83: {
                toHuman = (CstInteger)this.parseConstant();
                return CstShort.make(((CstInteger)toHuman).getValue());
            }
            case 90: {
                toHuman = (CstInteger)this.parseConstant();
                return CstBoolean.make(((CstInteger)toHuman).getValue());
            }
            case 99: {
                int n3 = this.input.readUnsignedShort();
                CstString cstString = (CstString)this.pool.get(n3);
                Type type = Type.internReturnType(cstString.getString());
                if (this.observer != null) {
                    this.parsed(2, "class_info: " + type.toHuman());
                }
                return new CstType(type);
            }
            case 115: {
                return this.parseConstant();
            }
            case 101: {
                this.requireLength(4);
                int n4 = this.input.readUnsignedShort();
                int n5 = this.input.readUnsignedShort();
                CstString cstString = (CstString)this.pool.get(n4);
                CstString cstString2 = (CstString)this.pool.get(n5);
                if (this.observer != null) {
                    this.parsed(2, "type_name: " + cstString.toHuman());
                    this.parsed(2, "const_name: " + cstString2.toHuman());
                }
                return new CstEnumRef(new CstNat(cstString2, cstString));
            }
            case 64: {
                toHuman = this.parseAnnotation(AnnotationVisibility.EMBEDDED);
                return new CstAnnotation((Annotation)toHuman);
            }
            case 91: {
                this.requireLength(2);
                int n6 = this.input.readUnsignedShort();
                CstArray.List list = new CstArray.List(n6);
                if (this.observer != null) {
                    this.parsed(2, "num_values: " + n6);
                    this.changeIndent(1);
                }
                for (int i = 0; i < n6; ++i) {
                    if (this.observer != null) {
                        this.changeIndent(-1);
                        this.parsed(0, "element_value[" + i + "]:");
                        this.changeIndent(1);
                    }
                    list.set(i, this.parseValue());
                }
                if (this.observer != null) {
                    this.changeIndent(-1);
                }
                list.setImmutable();
                return new CstArray(list);
            }
        }
        throw new ParseException("unknown annotation tag: " + Hex.u1(n));
    }

    private Constant parseConstant() throws IOException {
        int n = this.input.readUnsignedShort();
        Constant constant = this.pool.get(n);
        if (this.observer != null) {
            String string = constant instanceof CstString ? ((CstString)constant).toQuoted() : constant.toHuman();
            this.parsed(2, "constant_value: " + string);
        }
        return constant;
    }

    private void requireLength(int n) throws IOException {
        if (this.input.available() < n) {
            throw new ParseException("truncated annotation attribute");
        }
    }

    private void parsed(int n, String string) {
        this.observer.parsed(this.bytes, this.parseCursor, n, string);
        this.parseCursor += n;
    }

    private void changeIndent(int n) {
        this.observer.changeIndent(n);
    }
}

