import { ReactWidget, UseSignal } from '@jupyterlab/apputils';
import * as React from 'react';
import { Feedback } from '../components/Feedback';
import { GitPanel } from '../components/GitPanel';
import { LoggerContext } from '../logger';
import { gitWidgetStyle } from '../style/GitWidgetStyle';
import { Level } from '../tokens';
/**
 * A class that exposes the git plugin Widget.
 */
export class GitWidget extends ReactWidget {
    constructor(model, settings, commands, filebrowser, options) {
        super(options);
        this.node.id = 'GitSession-root';
        this.addClass(gitWidgetStyle);
        this._commands = commands;
        this._filebrowser = filebrowser;
        this._model = model;
        this._settings = settings;
    }
    render() {
        return (React.createElement(LoggerContext.Consumer, null, logger => (React.createElement(React.Fragment, null,
            React.createElement(GitPanel, { commands: this._commands, filebrowser: this._filebrowser, logger: logger, model: this._model, settings: this._settings }),
            React.createElement(UseSignal, { signal: logger.signal, initialArgs: { message: '', level: Level.INFO } }, (sender, log) => {
                var _a;
                return ((_a = log) === null || _a === void 0 ? void 0 : _a.message) ? (React.createElement(Feedback, { log: log, settings: this._settings })) : null;
            })))));
    }
}
//# sourceMappingURL=GitWidget.js.map