# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/cross_entropy_weighter.ipynb (unless otherwise specified).

__all__ = ['MultiTaskCELoss']

# Cell
import torch
from torch import nn
import pandas as pd
import numpy as np
from typing import Callable

# Cell
class MultiTaskCELoss(nn.Module):
    """
    A cross entropy loss function which will cancel out
        the effect of different class numbers
    """
    def __init__(self,):
        super().__init__()
        self.celoss = nn.CrossEntropyLoss()

    def forward(
        self,
        y_pred: torch.FloatTensor,
        y_true: torch.LongTensor,
    )-> torch.FloatTensor:
        """
        Input:
            - y_pred: torch.FloatTensor, Prediction tensor
            - y_true: torch.LongTensor, Label indices
        Return:
            - loss: torch.FloatTensor, scala adjusted
        """
        nb_classes = y_pred.size(-1)
        lambda_ = 1/np.log10(nb_classes)
        loss = self.celoss(y_pred,y_true)
        return loss*lambda_