/*
 Highstock JS v10.3.2 (2022-11-28)

 Advanced Highcharts Stock tools

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/stock-tools",["highcharts","highcharts/modules/stock"],function(r){b(r);b.Highcharts=r;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function r(b,n,m,q){b.hasOwnProperty(n)||(b[n]=q.apply(null,m),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:n,module:b[n]}})))}
b=b?b._modules:{};r(b,"Core/Chart/ChartNavigationComposition.js",[],function(){var b;(function(b){b.compose=function(b){b.navigation||(b.navigation=new m(b));return b};var m=function(){function b(b){this.updates=[];this.chart=b}b.prototype.addUpdate=function(b){this.chart.navigation.updates.push(b)};b.prototype.update=function(b,h){var d=this;this.updates.forEach(function(H){H.call(d.chart,b,h)})};return b}();b.Additions=m})(b||(b={}));return b});r(b,"Extensions/Annotations/NavigationBindingsUtilities.js",
[b["Core/Utilities.js"]],function(b){var n=b.defined,m=b.isNumber,q=b.pick,f={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:f,getAssignedAxis:function(b){return b.filter(function(d){var b=d.axis.getExtremes(),h=b.min;b=b.max;var f=q(d.axis.minPointOffset,0);return m(h)&&m(b)&&d.value>=h-f&&d.value<=b+f&&!d.axis.options.isInternal})[0]},getFieldType:function(b,
d){b=f[b];d=typeof d;n(b)&&(d=b);return{string:"text",number:"number","boolean":"checkbox"}[d]}}});r(b,"Extensions/Annotations/NavigationBindingsDefaults.js",[b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Core/Utilities.js"]],function(b,n){var m=b.getAssignedAxis,q=n.isNumber,f=n.merge;return{lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",
format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",
start:function(b){var d=this.chart.pointer.getCoordinates(b);b=m(d.xAxis);d=m(d.yAxis);var h=this.chart.options.navigation;if(b&&d)return this.chart.addAnnotation(f({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",point:{x:b.value,y:d.value,xAxis:b.axis.options.index,yAxis:d.axis.options.index},r:5}]},h.annotationsOptions,h.bindings.circleAnnotation.annotationsOptions))},steps:[function(b,d){var h=d.options.shapes;h=h&&h[0]&&h[0].point||{};if(q(h.xAxis)&&q(h.yAxis)){var f=this.chart.inverted;
var m=this.chart.xAxis[h.xAxis].toPixels(h.x);h=this.chart.yAxis[h.yAxis].toPixels(h.y);f=Math.max(Math.sqrt(Math.pow(f?h-b.chartX:m-b.chartX,2)+Math.pow(f?m-b.chartY:h-b.chartY,2)),5)}d.update({shapes:[{r:f}]})}]},ellipseAnnotation:{className:"highcharts-ellipse-annotation",start:function(b){var d=this.chart.pointer.getCoordinates(b);b=m(d.xAxis);d=m(d.yAxis);var h=this.chart.options.navigation;if(b&&d)return this.chart.addAnnotation(f({langKey:"ellipse",type:"basicAnnotation",shapes:[{type:"ellipse",
xAxis:b.axis.options.index,yAxis:d.axis.options.index,points:[{x:b.value,y:d.value},{x:b.value,y:d.value}],ry:1}]},h.annotationsOptions,h.bindings.ellipseAnnotation.annotationOptions))},steps:[function(b,d){d=d.shapes[0];var h=d.getAbsolutePosition(d.points[1]);d.translatePoint(b.chartX-h.x,b.chartY-h.y,1);d.redraw(!1)},function(b,d){d=d.shapes[0];var f=d.getAbsolutePosition(d.points[0]),h=d.getAbsolutePosition(d.points[1]);b=d.getDistanceFromLine(f,h,b.chartX,b.chartY);f=d.getYAxis();b=Math.abs(f.toValue(0)-
f.toValue(b));d.setYRadius(b);d.redraw(!1)}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(b){b=this.chart.pointer.getCoordinates(b);var d=m(b.xAxis),h=m(b.yAxis);if(d&&h){b=d.value;var n=h.value;d=d.axis.options.index;h=h.axis.options.index;var x=this.chart.options.navigation;return this.chart.addAnnotation(f({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:d,yAxis:h,x:b,y:n},{xAxis:d,yAxis:h,x:b,y:n},{xAxis:d,yAxis:h,x:b,y:n},{xAxis:d,
yAxis:h,x:b,y:n},{command:"Z"}]}]},x.annotationsOptions,x.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(b,d){var f=d.options.shapes;f=f&&f[0]&&f[0].points||[];var h=this.chart.pointer.getCoordinates(b);b=m(h.xAxis);h=m(h.yAxis);b&&h&&(b=b.value,h=h.value,f[1].x=b,f[2].x=b,f[2].y=h,f[3].y=h,d.update({shapes:[{points:f}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(b){var d=this.chart.pointer.getCoordinates(b);b=m(d.xAxis);d=m(d.yAxis);var h=this.chart.options.navigation;
if(b&&d)return this.chart.addAnnotation(f({langKey:"label",type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:b.axis.options.index,yAxis:d.axis.options.index,x:b.value,y:d.value},overflow:"none",crop:!0}]},h.annotationsOptions,h.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}}});r(b,"Extensions/Annotations/NavigationBindings.js",[b["Core/Chart/ChartNavigationComposition.js"],b["Core/Defaults.js"],b["Core/FormatUtilities.js"],
b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindingsDefaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Core/Utilities.js"]],function(b,n,m,q,f,h,d){function w(a,c){var b=y.Element.prototype,e=b.matches||b.msMatchesSelector||b.webkitMatchesSelector,k=null;if(b.closest)k=b.closest.call(a,c);else{do{if(e.call(a,c))return a;a=a.parentElement||a.parentNode}while(null!==a&&1===a.nodeType)}return k}function r(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()}
function x(){this.navigationBindings&&this.navigationBindings.destroy()}function g(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new D(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())}function p(){var a=this.navigationBindings;if(this&&a){var c=!1;this.series.forEach(function(a){!a.options.isInternal&&a.visible&&(c=!0)});if(this.navigationBindings&&this.navigationBindings.container&&this.navigationBindings.container[0]){var b=
this.navigationBindings.container[0];z(a.boundClassNames,function(a,e){if(e=b.querySelectorAll("."+e))for(var k=0;k<e.length;k++){var v=e[k],g=v.className;"normal"===a.noDataState?-1!==g.indexOf("highcharts-disabled-btn")&&v.classList.remove("highcharts-disabled-btn"):c?-1!==g.indexOf("highcharts-disabled-btn")&&v.classList.remove("highcharts-disabled-btn"):-1===g.indexOf("highcharts-disabled-btn")&&(v.className+=" highcharts-disabled-btn")}})}}}function l(){this.deselectAnnotation()}function a(){this.selectedButtonElement=
null}function c(a){var c=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;E(!0,a.prototype.defaultOptions.events,{click:function(a){var b=this,e=b.chart.navigationBindings,k=e.activeAnnotation;c&&c.call(b,a);k!==b?(e.deselectAnnotation(),e.activeAnnotation=b,b.setControlPointsVisibility(!0),B(e,"showPopup",{annotation:b,formType:"annotation-toolbar",options:e.annotationToFields(b),onSubmit:function(a){if("remove"===a.actionType)e.activeAnnotation=!1,e.chart.removeAnnotation(b);
else{var c={};e.fieldsToOptions(a.fields,c);e.deselectAnnotation();a=c.typeOptions;"measure"===b.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth);b.update(c)}}})):B(e,"closePopup");a.activeAnnotation=!0}})}var e=n.setOptions,v=m.format,t=q.doc,y=q.win,k=h.getFieldType,u=d.addEvent,I=d.attr,B=d.fireEvent,C=d.isArray,J=d.isFunction,K=d.isNumber,F=d.isObject,E=d.merge,z=d.objectEach,G=d.pick,A=[],D=function(){function d(a,c){this.selectedButton=
this.boundClassNames=void 0;this.chart=a;this.options=c;this.eventsToUnbind=[];this.container=this.chart.container.getElementsByClassName(this.options.bindingsClassName||"");this.container.length||(this.container=t.getElementsByClassName(this.options.bindingsClassName||""))}d.compose=function(b,k){-1===A.indexOf(b)&&(A.push(b),u(b,"remove",r),c(b),z(b.types,function(a){c(a)}));-1===A.indexOf(k)&&(A.push(k),u(k,"destroy",x),u(k,"load",g),u(k,"render",p));-1===A.indexOf(d)&&(A.push(d),u(d,"closePopup",
l),u(d,"deselectButton",a));-1===A.indexOf(e)&&(A.push(e),e(f))};d.prototype.initEvents=function(){var a=this,c=a.chart,b=a.container,e=a.options;a.boundClassNames={};z(e.bindings||{},function(c){a.boundClassNames[c.className]=c});[].forEach.call(b,function(c){a.eventsToUnbind.push(u(c,"click",function(b){var e=a.getButtonEvents(c,b);e&&-1===e.button.className.indexOf("highcharts-disabled-btn")&&a.bindingsButtonClick(e.button,e.events,b)}))});z(e.events||{},function(c,b){J(c)&&a.eventsToUnbind.push(u(a,
b,c,{passive:!1}))});a.eventsToUnbind.push(u(c.container,"click",function(b){!c.cancelClick&&c.isInsidePlot(b.chartX-c.plotLeft,b.chartY-c.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,b)}));a.eventsToUnbind.push(u(c.container,q.isTouchDevice?"touchmove":"mousemove",function(c){a.bindingsContainerMouseMove(this,c)},q.isTouchDevice?{passive:!1}:void 0))};d.prototype.initUpdate=function(){var a=this;b.compose(this.chart).navigation.addUpdate(function(c){a.update(c)})};d.prototype.bindingsButtonClick=
function(a,c,b){var e=this.chart,k=e.renderer.boxWrapper,d=!0;this.selectedButtonElement&&(this.selectedButtonElement.classList===a.classList&&(d=!1),B(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&e.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));d?(this.selectedButton=c,this.selectedButtonElement=a,B(this,"selectButton",{button:a}),c.init&&c.init.call(this,a,b),
(c.start||c.steps)&&e.renderer.boxWrapper.addClass("highcharts-draw-mode")):(e.stockTools&&e.stockTools.toggleButtonActiveClass(a),k.removeClass("highcharts-draw-mode"),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null)};d.prototype.bindingsChartClick=function(a,c){a=this.chart;var b=this.activeAnnotation,e=this.selectedButton;a=a.renderer.boxWrapper;b&&(b.cancelClick||c.activeAnnotation||!c.target.parentNode||w(c.target,".highcharts-popup")?b.cancelClick&&setTimeout(function(){b.cancelClick=
!1},0):B(this,"closePopup"));e&&e.start&&(this.nextEvent?(this.nextEvent(c,this.currentUserDetails),this.steps&&(this.stepIndex++,e.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=e.steps[this.stepIndex]:(B(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),e.end&&e.end.call(this,c,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=e.start.call(this,c))&&e.steps?(this.stepIndex=
0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=e.steps[this.stepIndex]):(B(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,e.end&&e.end.call(this,c,this.currentUserDetails)))};d.prototype.bindingsContainerMouseMove=function(a,c){this.mouseMoveEvent&&this.mouseMoveEvent(c,this.currentUserDetails)};d.prototype.fieldsToOptions=function(a,c){z(a,function(a,b){var e=parseFloat(a),k=b.split("."),d=k.length-1;!K(e)||
a.match(/px/g)||b.match(/format/g)||(a=e);if("undefined"!==a){var v=c;k.forEach(function(c,b){var e=G(k[b+1],"");d===b?v[c]=a:(v[c]||(v[c]=e.match(/\d/g)?[]:{}),v=v[c])})}});return c};d.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};d.prototype.annotationToFields=function(a){function c(b,e,d,t,l){if(d&&b&&-1===f.indexOf(e)&&(0<=(d.indexOf&&d.indexOf(e))||d[e]||!0===d))if(C(b))t[e]=[],b.forEach(function(a,
b){F(a)?(t[e][b]={},z(a,function(a,k){c(a,k,g[e],t[e][b],e)})):c(a,0,g[e],t[e],e)});else if(F(b)){var u={};C(t)?(t.push(u),u[e]={},u=u[e]):t[e]=u;z(b,function(a,b){c(a,b,0===e?d:g[e],u,e)})}else"format"===e?t[e]=[v(b,a.labels[0].points[0]).toString(),"text"]:C(t)?t.push([b,k(l,b)]):t[e]=[b,k(e,b)]}var b=a.options,e=d.annotationsEditable,g=e.nestedOptions,t=G(b.type,b.shapes&&b.shapes[0]&&b.shapes[0].type,b.labels&&b.labels[0]&&b.labels[0].type,"label"),f=d.annotationsNonEditable[b.langKey]||[],l=
{langKey:b.langKey,type:t};z(b,function(a,k){"typeOptions"===k?(l[k]={},z(b[k],function(a,b){c(a,b,g,l[k],b)})):c(a,k,e[t],l,k)});return l};d.prototype.getClickedClassNames=function(a,c){var b=c.target;c=[];for(var e;b&&((e=I(b,"class"))&&(c=c.concat(e.split(" ").map(function(a){return[a,b]}))),b=b.parentNode,b!==a););return c};d.prototype.getButtonEvents=function(a,c){var b=this,e;this.getClickedClassNames(a,c).forEach(function(a){b.boundClassNames[a[0]]&&!e&&(e={events:b.boundClassNames[a[0]],button:a[1]})});
return e};d.prototype.update=function(a){this.options=E(!0,this.options,a);this.removeEvents();this.initEvents()};d.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){return a()})};d.prototype.destroy=function(){this.removeEvents()};d.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill",
"strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],ellipse:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],
crookedLine:[],basicAnnotation:["shapes","labelOptions"]};d.annotationsNonEditable={rectangle:["crosshairX","crosshairY","labelOptions"],ellipse:["labelOptions"],circle:["labelOptions"]};return d}();"";return D});r(b,"Stock/StockTools/StockToolsUtilities.js",[b["Core/Defaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,n,m,q){function f(a,b){a=b.pointer.getCoordinates(a);var c=Number.MAX_VALUE,e;if(b.navigationBindings){var g=
d(a.xAxis);var k=d(a.yAxis)}if(g&&k){var f=g.value;b=k.value;k.axis.series.forEach(function(a){a.points&&a.points.forEach(function(a){a&&c>Math.abs(a.x-f)&&(c=Math.abs(a.x-f),e=a)})});if(e&&e.x&&e.y)return{x:e.x,y:e.y,below:b<e.y,series:e.series,xAxis:e.series.xAxis.options.index||0,yAxis:e.series.yAxis.options.index||0}}}var h=b.getOptions,d=n.getAssignedAxis,w=n.getFieldType,r=q.defined,x=q.fireEvent,g=q.isNumber,p=q.uniqueKey,l="apo ad aroon aroonoscillator atr ao cci chaikin cmf cmo disparityindex dmi dpo linearRegressionAngle linearRegressionIntercept linearRegressionSlope klinger macd mfi momentum natr obv ppo roc rsi slowstochastic stochastic trix williamsr".split(" "),
a="ad cmf klinger mfi obv vbp vwap".split(" ");return{indicatorsWithAxes:l,indicatorsWithVolume:a,addFlagFromForm:function(a){return function(c){var b=this,e=b.chart,d=e.stockTools;if(c=f(c,e)){var k={type:"flags",onSeries:c.series.id,shape:a,data:[{x:c.x,y:c.y}],xAxis:c.xAxis,yAxis:c.yAxis,point:{events:{click:function(){var a=this,c=a.options;x(b,"showPopup",{point:a,formType:"annotation-toolbar",options:{langKey:"flags",type:"flags",title:[c.title,w("title",c.title)],name:[c.name,w("name",c.name)]},
onSubmit:function(c){"remove"===c.actionType?a.remove():a.update(b.fieldsToOptions(c.fields,{}))}})}}}};d&&d.guiEnabled||e.addSeries(k);x(b,"showPopup",{formType:"flag",options:{langKey:"flags",type:"flags",title:["A",w("label","A")],name:["Flag A",w("label","Flag A")]},onSubmit:function(a){b.fieldsToOptions(a.fields,k.data[0]);e.addSeries(k)}})}}},attractToPoint:f,getAssignedAxis:d,isNotNavigatorYAxis:function(a){return"highcharts-navigator-yaxis"!==a.userOptions.className},isPriceIndicatorEnabled:function(a){return a.some(function(a){return a.lastVisiblePrice||
a.lastPrice})},manageIndicators:function(c){var b=this.chart,d={linkedTo:c.linkedTo,type:c.type};if("edit"===c.actionType)this.fieldsToOptions(c.fields,d),(c=b.get(c.seriesId))&&c.update(d,!1);else if("remove"===c.actionType){if(c=b.get(c.seriesId)){var g=c.yAxis;c.linkedSeries&&c.linkedSeries.forEach(function(a){a.remove(!1)});c.remove(!1);0<=l.indexOf(c.type)&&(d={height:g.options.height,top:g.options.top},g.remove(!1),this.resizeYAxes(d))}}else{d.id=p();this.fieldsToOptions(c.fields,d);g=b.get(d.linkedTo);
var f=h().plotOptions;"undefined"!==typeof g&&g instanceof m&&"sum"===g.getDGApproximation()&&!r(f&&f[d.type]&&f.dataGrouping&&f.dataGrouping.approximation)&&(d.dataGrouping={approximation:"sum"});0<=l.indexOf(c.type)?(g=b.addAxis({id:p(),offset:0,opposite:!0,title:{text:""},tickPixelInterval:40,showLastLabel:!1,labels:{align:"left",y:-2}},!1,!1),d.yAxis=g.options.id,this.resizeYAxes()):d.yAxis=b.get(c.linkedTo).options.yAxis;0<=a.indexOf(c.type)&&(d.params.volumeSeriesID=b.series.filter(function(a){return"column"===
a.options.type})[0].options.id);b.addSeries(d,!1)}x(this,"deselectButton",{button:this.selectedButtonElement});b.redraw()},updateHeight:function(a,b){var c=b.options.typeOptions,e=g(c.yAxis)&&this.chart.yAxis[c.yAxis];e&&c.points&&b.update({typeOptions:{height:e.toValue(a[e.horiz?"chartX":"chartY"])-(c.points[1].y||0)}})},updateNthPoint:function(a){return function(c,b){var e=b.options.typeOptions,d=g(e.xAxis)&&this.chart.xAxis[e.xAxis],k=g(e.yAxis)&&this.chart.yAxis[e.yAxis];d&&k&&(e.points.forEach(function(b,
e){e>=a&&(b.x=d.toValue(c[d.horiz?"chartX":"chartY"]),b.y=k.toValue(c[k.horiz?"chartX":"chartY"]))}),b.update({typeOptions:{points:e.points}}))}},updateRectSize:function(a,b){var c=b.chart,e=b.options.typeOptions,d=g(e.xAxis)&&c.xAxis[e.xAxis],k=g(e.yAxis)&&c.yAxis[e.yAxis];d&&k&&(d=d.toValue(a[d.horiz?"chartX":"chartY"]),a=k.toValue(a[k.horiz?"chartX":"chartY"]),k=d-e.point.x,e=e.point.y-a,b.update({typeOptions:{background:{width:c.inverted?e:k,height:c.inverted?k:e}}}))}}});r(b,"Stock/StockTools/StockToolsBindings.js",
[b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Stock/StockTools/StockToolsUtilities.js"],b["Core/Utilities.js"]],function(b,n,m,q){var f=n.getAssignedAxis;n=m.addFlagFromForm;var h=m.attractToPoint,d=m.isNotNavigatorYAxis,w=m.isPriceIndicatorEnabled,r=m.manageIndicators,x=m.updateHeight,g=m.updateNthPoint;m=m.updateRectSize;var p=q.fireEvent,l=q.merge;return{segment:{className:"highcharts-segment",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=
f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"segment",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.segment.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},arrowSegment:{className:"highcharts-arrow-segment",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;
a=l({langKey:"arrowSegment",type:"crookedLine",typeOptions:{line:{markerEnd:"arrow"},xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.arrowSegment.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},ray:{className:"highcharts-ray",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"ray",type:"infinityLine",
typeOptions:{type:"ray",xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.ray.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},arrowRay:{className:"highcharts-arrow-ray",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"arrowRay",type:"infinityLine",typeOptions:{type:"ray",line:{markerEnd:"arrow"},
xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.arrowRay.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},infinityLine:{className:"highcharts-infinity-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"infinityLine",type:"infinityLine",typeOptions:{type:"line",xAxis:a.axis.options.index,
yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.infinityLine.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},arrowInfinityLine:{className:"highcharts-arrow-infinity-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"arrowInfinityLine",type:"infinityLine",typeOptions:{type:"line",line:{markerEnd:"arrow"},xAxis:a.axis.options.index,
yAxis:c.axis.options.index,points:[{x:a.value,y:c.value},{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.arrowInfinityLine.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1)]},horizontalLine:{className:"highcharts-horizontal-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"horizontalLine",type:"infinityLine",draggable:"y",typeOptions:{type:"horizontalLine",xAxis:a.axis.options.index,
yAxis:c.axis.options.index,points:[{x:a.value,y:c.value}]}},b.annotationsOptions,b.bindings.horizontalLine.annotationsOptions);this.chart.addAnnotation(a)}}},verticalLine:{className:"highcharts-vertical-line",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"verticalLine",type:"infinityLine",draggable:"x",typeOptions:{type:"verticalLine",xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,
y:c.value}]}},b.annotationsOptions,b.bindings.verticalLine.annotationsOptions);this.chart.addAnnotation(a)}}},crooked3:{className:"highcharts-crooked3",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"crooked3",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d}]}},g.annotationsOptions,g.bindings.crooked3.annotationsOptions);
return this.chart.addAnnotation(a)}},steps:[g(1),g(2)]},crooked5:{className:"highcharts-crooked5",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"crooked5",type:"crookedLine",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]}},g.annotationsOptions,g.bindings.crooked5.annotationsOptions);return this.chart.addAnnotation(a)}},
steps:[g(1),g(2),g(3),g(4)]},elliott3:{className:"highcharts-elliott3",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"elliott3",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},g.annotationsOptions,g.bindings.elliott3.annotationsOptions);return this.chart.addAnnotation(a)}},
steps:[g(1),g(2),g(3)]},elliott5:{className:"highcharts-elliott5",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"elliott5",type:"elliottWave",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},g.annotationsOptions,g.bindings.elliott5.annotationsOptions);return this.chart.addAnnotation(a)}},
steps:[g(1),g(2),g(3),g(4),g(5)]},measureX:{className:"highcharts-measure-x",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"measure",type:"measure",typeOptions:{selectType:"x",xAxis:a.axis.options.index,yAxis:c.axis.options.index,point:{x:a.value,y:c.value},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{enabled:!1,strokeWidth:0,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},
labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,b.bindings.measureX.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[m]},measureY:{className:"highcharts-measure-y",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"measure",type:"measure",typeOptions:{selectType:"y",xAxis:a.axis.options.index,yAxis:c.axis.options.index,point:{x:a.value,y:c.value},crosshairX:{enabled:!1,strokeWidth:0,
stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"},background:{width:0,height:0,strokeWidth:0,stroke:"#ffffff"}},labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,b.bindings.measureY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[m]},measureXY:{className:"highcharts-measure-xy",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({langKey:"measure",type:"measure",typeOptions:{selectType:"xy",
xAxis:a.axis.options.index,yAxis:c.axis.options.index,point:{x:a.value,y:c.value},background:{width:0,height:0,strokeWidth:10},crosshairX:{strokeWidth:1,stroke:"#000000"},crosshairY:{strokeWidth:1,stroke:"#000000"}},labelOptions:{style:{color:"#666666"}}},b.annotationsOptions,b.bindings.measureXY.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[m]},fibonacci:{className:"highcharts-fibonacci",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&
c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"fibonacci",type:"fibonacci",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d}]},labelOptions:{style:{color:"#666666"}}},g.annotationsOptions,g.bindings.fibonacci.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1),x]},parallelChannel:{className:"highcharts-parallel-channel",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&
c){var b=a.value,d=c.value,g=this.chart.options.navigation;a=l({langKey:"parallelChannel",type:"tunnel",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:b,y:d},{x:b,y:d}]}},g.annotationsOptions,g.bindings.parallelChannel.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1),x]},pitchfork:{className:"highcharts-pitchfork",start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=a.value,d=c.value,g=this.chart.options.navigation;
a=l({langKey:"pitchfork",type:"pitchfork",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value,y:c.value,controlPoint:{style:{fill:"#f21313"}}},{x:b,y:d},{x:b,y:d}],innerBackground:{fill:"rgba(100, 170, 255, 0.8)"}},shapeOptions:{strokeWidth:2}},g.annotationsOptions,g.bindings.pitchfork.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[g(1),g(2)]},verticalCounter:{className:"highcharts-vertical-counter",start:function(a){if(a=h(a,this.chart)){this.verticalCounter=
this.verticalCounter||0;var c=this.chart.options.navigation;a=l({langKey:"verticalCounter",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,text:this.verticalCounter.toString()}},labelOptions:{style:{color:"#666666",fontSize:"11px"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalCounter.annotationsOptions);a=this.chart.addAnnotation(a);this.verticalCounter++;a.options.events.click.call(a,
{})}}},timeCycles:{className:"highcharts-time-cycles",start:function(a){if(a=h(a,this.chart)){var c=this.chart.options.navigation;a=l({langKey:"timeCycles",type:"timeCycles",typeOptions:{xAxis:a.xAxis,yAxis:a.yAxis,points:[{x:a.x},{x:a.x}],line:{stroke:"rgba(0, 0, 0, 0.75)",fill:"transparent",strokeWidth:2}}},c.annotationsOptions,c.bindings.timeCycles.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{});return a}},steps:[g(1)]},verticalLabel:{className:"highcharts-vertical-label",
start:function(a){if(a=h(a,this.chart)){var c=this.chart.options.navigation;a=l({langKey:"verticalLabel",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40}},labelOptions:{style:{color:"#666666",fontSize:"11px"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalLabel.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{})}}},verticalArrow:{className:"highcharts-vertical-arrow",
start:function(a){if(a=h(a,this.chart)){var c=this.chart.options.navigation;a=l({langKey:"verticalArrow",type:"verticalLine",typeOptions:{point:{x:a.x,y:a.y,xAxis:a.xAxis,yAxis:a.yAxis},label:{offset:a.below?40:-40,format:" "},connector:{fill:"none",stroke:a.below?"#f21313":"#06b535"}},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1}},c.annotationsOptions,c.bindings.verticalArrow.annotationsOptions);a=this.chart.addAnnotation(a);a.options.events.click.call(a,{})}}},fibonacciTimeZones:{className:"highcharts-fibonacci-time-zones",
start:function(a){var c=this.chart.pointer.getCoordinates(a);a=f(c.xAxis);c=f(c.yAxis);if(a&&c){var b=this.chart.options.navigation;a=l({type:"fibonacciTimeZones",langKey:"fibonacciTimeZones",typeOptions:{xAxis:a.axis.options.index,yAxis:c.axis.options.index,points:[{x:a.value}]}},b.annotationsOptions,b.bindings.fibonacciTimeZones.annotationsOptions);return this.chart.addAnnotation(a)}},steps:[function(a,c){var b=c.options.typeOptions.points;b=b&&b[0].x;var d=this.chart.pointer.getCoordinates(a);
a=f(d.xAxis);d=f(d.yAxis);c.update({typeOptions:{xAxis:a.axis.options.index,yAxis:d.axis.options.index,points:[{x:b},{x:a.value}]}})}]},flagCirclepin:{className:"highcharts-flag-circlepin",start:n("circlepin")},flagDiamondpin:{className:"highcharts-flag-diamondpin",start:n("flag")},flagSquarepin:{className:"highcharts-flag-squarepin",start:n("squarepin")},flagSimplepin:{className:"highcharts-flag-simplepin",start:n("nopin")},zoomX:{className:"highcharts-zoom-x",init:function(a){this.chart.update({chart:{zooming:{type:"x"}}});
p(this,"deselectButton",{button:a})}},zoomY:{className:"highcharts-zoom-y",init:function(a){this.chart.update({chart:{zooming:{type:"y"}}});p(this,"deselectButton",{button:a})}},zoomXY:{className:"highcharts-zoom-xy",init:function(a){this.chart.update({chart:{zooming:{type:"xy"}}});p(this,"deselectButton",{button:a})}},seriesTypeLine:{className:"highcharts-series-type-line",init:function(a){this.chart.series[0].update({type:"line",useOhlcData:!0});p(this,"deselectButton",{button:a})}},seriesTypeOhlc:{className:"highcharts-series-type-ohlc",
init:function(a){this.chart.series[0].update({type:"ohlc"});p(this,"deselectButton",{button:a})}},seriesTypeCandlestick:{className:"highcharts-series-type-candlestick",init:function(a){this.chart.series[0].update({type:"candlestick"});p(this,"deselectButton",{button:a})}},seriesTypeHeikinAshi:{className:"highcharts-series-type-heikinashi",init:function(a){this.chart.series[0].update({type:"heikinashi"});p(this,"deselectButton",{button:a})}},seriesTypeHLC:{className:"highcharts-series-type-hlc",init:function(a){this.chart.series[0].update({type:"hlc",
useOhlcData:!0});p(this,"deselectButton",{button:a})}},seriesTypeHollowCandlestick:{className:"highcharts-series-type-hollowcandlestick",init:function(a){this.chart.series[0].update({type:"hollowcandlestick"});p(this,"deselectButton",{button:a})}},fullScreen:{className:"highcharts-full-screen",noDataState:"normal",init:function(a){this.chart.fullscreen&&this.chart.fullscreen.toggle();p(this,"deselectButton",{button:a})}},currentPriceIndicator:{className:"highcharts-current-price-indicator",init:function(a){var b=
this.chart,d=b.series,g=b.stockTools,f=w(b.series);g&&g.guiEnabled&&(d.forEach(function(a){a.update({lastPrice:{enabled:!f},lastVisiblePrice:{enabled:!f,label:{enabled:!0}}},!1)}),b.redraw());p(this,"deselectButton",{button:a})}},indicators:{className:"highcharts-indicators",init:function(){var a=this;p(a,"showPopup",{formType:"indicators",options:{},onSubmit:function(b){r.call(a,b)}})}},toggleAnnotations:{className:"highcharts-toggle-annotations",init:function(a){var b=this.chart,d=b.stockTools,
g=d.getIconsURL();this.toggledAnnotations=!this.toggledAnnotations;(b.annotations||[]).forEach(function(a){a.setVisibility(!this.toggledAnnotations)},this);d&&d.guiEnabled&&(a.firstChild.style["background-image"]=this.toggledAnnotations?'url("'+g+'annotations-hidden.svg")':'url("'+g+'annotations-visible.svg")');p(this,"deselectButton",{button:a})}},saveChart:{className:"highcharts-save-chart",noDataState:"normal",init:function(a){var c=this.chart,e=[],g=[],f=[],l=[];c.annotations.forEach(function(a,
b){e[b]=a.userOptions});c.series.forEach(function(a){a.is("sma")?g.push(a.userOptions):"flags"===a.type&&f.push(a.userOptions)});c.yAxis.forEach(function(a){d(a)&&l.push(a.options)});b.win.localStorage.setItem("highcharts-chart",JSON.stringify({annotations:e,indicators:g,flags:f,yAxes:l}));p(this,"deselectButton",{button:a})}}}});r(b,"Stock/StockTools/StockToolsDefaults.js",[],function(){return{lang:{stockTools:{gui:{simpleShapes:"Simple shapes",lines:"Lines",crookedLines:"Crooked lines",measure:"Measure",
advanced:"Advanced",toggleAnnotations:"Toggle annotations",verticalLabels:"Vertical labels",flags:"Flags",zoomChange:"Zoom change",typeChange:"Type change",saveChart:"Save chart",indicators:"Indicators",currentPriceIndicator:"Current Price Indicators",zoomX:"Zoom X",zoomY:"Zoom Y",zoomXY:"Zooom XY",fullScreen:"Fullscreen",typeOHLC:"OHLC",typeLine:"Line",typeCandlestick:"Candlestick",typeHLC:"HLC",typeHollowCandlestick:"Hollow Candlestick",typeHeikinAshi:"Heikin Ashi",circle:"Circle",ellipse:"Ellipse",
label:"Label",rectangle:"Rectangle",flagCirclepin:"Flag circle",flagDiamondpin:"Flag diamond",flagSquarepin:"Flag square",flagSimplepin:"Flag simple",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",verticalLine:"Vertical line",infinityLine:"Infinity line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",
elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",timeCycles:"Time Cycles"}},navigation:{popup:{circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",segment:"Segment",arrowSegment:"Arrow segment",ray:"Ray",arrowRay:"Arrow ray",line:"Line",arrowInfinityLine:"Arrow line",horizontalLine:"Horizontal line",
verticalLine:"Vertical line",crooked3:"Crooked 3 line",crooked5:"Crooked 5 line",elliott3:"Elliott 3 line",elliott5:"Elliott 5 line",verticalCounter:"Vertical counter",verticalLabel:"Vertical label",verticalArrow:"Vertical arrow",fibonacci:"Fibonacci",fibonacciTimeZones:"Fibonacci Time Zones",pitchfork:"Pitchfork",parallelChannel:"Parallel channel",infinityLine:"Infinity line",measure:"Measure",measureXY:"Measure XY",measureX:"Measure X",measureY:"Measure Y",timeCycles:"Time Cycles",flags:"Flags",
addButton:"Add",saveButton:"Save",editButton:"Edit",removeButton:"Remove",series:"Series",volume:"Volume",connector:"Connector",innerBackground:"Inner background",outerBackground:"Outer background",crosshairX:"Crosshair X",crosshairY:"Crosshair Y",tunnel:"Tunnel",background:"Background",noFilterMatch:"No match",searchIndicators:"Search Indicators",clearFilter:"\u2715 clear filter",index:"Index",period:"Period",periods:"Periods",standardDeviation:"Standard deviation",periodTenkan:"Tenkan period",periodSenkouSpanB:"Senkou Span B period",
periodATR:"ATR period",multiplierATR:"ATR multiplier",shortPeriod:"Short period",longPeriod:"Long period",signalPeriod:"Signal period",decimals:"Decimals",algorithm:"Algorithm",topBand:"Top band",bottomBand:"Bottom band",initialAccelerationFactor:"Initial acceleration factor",maxAccelerationFactor:"Max acceleration factor",increment:"Increment",multiplier:"Multiplier",ranges:"Ranges",highIndex:"High index",lowIndex:"Low index",deviation:"Deviation",xAxisUnit:"x-axis unit",factor:"Factor",fastAvgPeriod:"Fast average period",
slowAvgPeriod:"Slow average period",average:"Average",indicatorAliases:{abands:["Acceleration Bands"],bb:["Bollinger Bands"],dema:["Double Exponential Moving Average"],ema:["Exponential Moving Average"],ikh:["Ichimoku Kinko Hyo"],keltnerchannels:["Keltner Channels"],linearRegression:["Linear Regression"],pivotpoints:["Pivot Points"],pc:["Price Channel"],priceenvelopes:["Price Envelopes"],psar:["Parabolic SAR"],sma:["Simple Moving Average"],supertrend:["Super Trend"],tema:["Triple Exponential Moving Average"],
vbp:["Volume by Price"],vwap:["Volume Weighted Moving Average"],wma:["Weighted Moving Average"],zigzag:["Zig Zag"],apo:["Absolute price indicator"],ad:["Accumulation/Distribution"],aroon:["Aroon"],aroonoscillator:["Aroon oscillator"],atr:["Average True Range"],ao:["Awesome oscillator"],cci:["Commodity Channel Index"],chaikin:["Chaikin"],cmf:["Chaikin Money Flow"],cmo:["Chande Momentum Oscillator"],disparityindex:["Disparity Index"],dmi:["Directional Movement Index"],dpo:["Detrended price oscillator"],
klinger:["Klinger Oscillator"],linearRegressionAngle:["Linear Regression Angle"],linearRegressionIntercept:["Linear Regression Intercept"],linearRegressionSlope:["Linear Regression Slope"],macd:["Moving Average Convergence Divergence"],mfi:["Money Flow Index"],momentum:["Momentum"],natr:["Normalized Average True Range"],obv:["On-Balance Volume"],ppo:["Percentage Price oscillator"],roc:["Rate of Change"],rsi:["Relative Strength Index"],slowstochastic:["Slow Stochastic"],stochastic:["Stochastic"],trix:["TRIX"],
williamsr:["Williams %R"]}}}},stockTools:{gui:{enabled:!0,className:"highcharts-bindings-wrapper",toolbarClassName:"stocktools-toolbar",buttons:"indicators separator simpleShapes lines crookedLines measure advanced toggleAnnotations separator verticalLabels flags separator zoomChange fullScreen typeChange separator currentPriceIndicator saveChart".split(" "),definitions:{separator:{symbol:"separator.svg"},simpleShapes:{items:["label","circle","ellipse","rectangle"],circle:{symbol:"circle.svg"},ellipse:{symbol:"ellipse.svg"},
rectangle:{symbol:"rectangle.svg"},label:{symbol:"label.svg"}},flags:{items:["flagCirclepin","flagDiamondpin","flagSquarepin","flagSimplepin"],flagSimplepin:{symbol:"flag-basic.svg"},flagDiamondpin:{symbol:"flag-diamond.svg"},flagSquarepin:{symbol:"flag-trapeze.svg"},flagCirclepin:{symbol:"flag-elipse.svg"}},lines:{items:"segment arrowSegment ray arrowRay line arrowInfinityLine horizontalLine verticalLine".split(" "),segment:{symbol:"segment.svg"},arrowSegment:{symbol:"arrow-segment.svg"},ray:{symbol:"ray.svg"},
arrowRay:{symbol:"arrow-ray.svg"},line:{symbol:"line.svg"},arrowInfinityLine:{symbol:"arrow-line.svg"},verticalLine:{symbol:"vertical-line.svg"},horizontalLine:{symbol:"horizontal-line.svg"}},crookedLines:{items:["elliott3","elliott5","crooked3","crooked5"],crooked3:{symbol:"crooked-3.svg"},crooked5:{symbol:"crooked-5.svg"},elliott3:{symbol:"elliott-3.svg"},elliott5:{symbol:"elliott-5.svg"}},verticalLabels:{items:["verticalCounter","verticalLabel","verticalArrow"],verticalCounter:{symbol:"vertical-counter.svg"},
verticalLabel:{symbol:"vertical-label.svg"},verticalArrow:{symbol:"vertical-arrow.svg"}},advanced:{items:["fibonacci","fibonacciTimeZones","pitchfork","parallelChannel","timeCycles"],pitchfork:{symbol:"pitchfork.svg"},fibonacci:{symbol:"fibonacci.svg"},fibonacciTimeZones:{symbol:"fibonacci-timezone.svg"},parallelChannel:{symbol:"parallel-channel.svg"},timeCycles:{symbol:"time-cycles.svg"}},measure:{items:["measureXY","measureX","measureY"],measureX:{symbol:"measure-x.svg"},measureY:{symbol:"measure-y.svg"},
measureXY:{symbol:"measure-xy.svg"}},toggleAnnotations:{symbol:"annotations-visible.svg"},currentPriceIndicator:{symbol:"current-price-show.svg"},indicators:{symbol:"indicators.svg"},zoomChange:{items:["zoomX","zoomY","zoomXY"],zoomX:{symbol:"zoom-x.svg"},zoomY:{symbol:"zoom-y.svg"},zoomXY:{symbol:"zoom-xy.svg"}},typeChange:{items:"typeOHLC typeLine typeCandlestick typeHollowCandlestick typeHLC typeHeikinAshi".split(" "),typeOHLC:{symbol:"series-ohlc.svg"},typeLine:{symbol:"series-line.svg"},typeCandlestick:{symbol:"series-candlestick.svg"},
typeHLC:{symbol:"series-hlc.svg"},typeHeikinAshi:{symbol:"series-heikin-ashi.svg"},typeHollowCandlestick:{symbol:"series-hollow-candlestick.svg"}},fullScreen:{symbol:"fullscreen.svg"},saveChart:{symbol:"save-chart.svg"}}}}}});r(b,"Stock/StockTools/StockTools.js",[b["Core/Defaults.js"],b["Extensions/Annotations/NavigationBindingsUtilities.js"],b["Stock/StockTools/StockToolsBindings.js"],b["Stock/StockTools/StockToolsDefaults.js"],b["Stock/StockTools/StockToolsUtilities.js"],b["Core/Utilities.js"]],
function(b,n,m,q,f,h){function d(a,b,d,g){function k(a){return e(a)&&!v(a)&&a.match("%")}var f=0,l;if(g){var h=c(parseFloat(g.top)/100);var u=c(parseFloat(g.height)/100)}return{positions:a.map(function(g,e){var p=c(k(g.options.height)?parseFloat(g.options.height)/100:g.height/b);g=c(k(g.options.top)?parseFloat(g.options.top)/100:(g.top-g.chart.plotTop)/b);u?(g>h&&(g-=u),f=Math.max(f,(g||0)+(p||0))):(v(p)||(p=a[e-1].series.every(function(a){return a.is("sma")})?l:d/100),v(g)||(g=f),l=p,f=c(Math.max(f,
(g||0)+(p||0))));return{height:100*p,top:100*g}}),allAxesHeight:f}}function w(a){var b=[];a.forEach(function(c,d){c=a[d+1];b[d]=c?{enabled:!0,controlledAxis:{next:[t(c.options.id,c.options.index)]}}:{enabled:!1}});return b}function r(a,b,d,g){a.forEach(function(e,k){k=a[k-1];e.top=k?c(k.height+k.top):0;d&&(e.height=c(e.height+g*b))});return a}function x(a){var b=this.chart,d=b.yAxis.filter(l);b=this.getYAxisPositions(d,b.plotHeight,20,a);var g=b.positions,e=b.allAxesHeight,k=this.getYAxisResizers(d);
!a&&e<=c(1)?g[g.length-1]={height:20,top:c(100*e-20)}:g.forEach(function(a){a.height=a.height/(100*e)*100;a.top=a.top/(100*e)*100});g.forEach(function(a,b){d[b].update({height:a.height+"%",top:a.top+"%",resize:k[b],offset:0},!1)})}var g=b.setOptions,p=n.getAssignedAxis,l=f.isNotNavigatorYAxis,a=f.isPriceIndicatorEnabled,c=h.correctFloat,e=h.defined,v=h.isNumber,t=h.pick,y=[];return{compose:function(b){-1===y.indexOf(b)&&(y.push(b),b=b.prototype,b.getYAxisPositions=d,b.getYAxisResizers=w,b.recalculateYAxisPositions=
r,b.resizeYAxes=x,b.utils={indicatorsWithAxes:f.indicatorsWithAxes,indicatorsWithVolume:f.indicatorsWithVolume,getAssignedAxis:p,isPriceIndicatorEnabled:a,manageIndicators:f.manageIndicators});-1===y.indexOf(g)&&(y.push(g),g(q),g({navigation:{bindings:m}}))}}});r(b,"Stock/StockTools/StockToolbar.js",[b["Core/Utilities.js"]],function(b){var n=b.addEvent,m=b.createElement,q=b.css,f=b.fireEvent,h=b.getStyle,d=b.isArray,r=b.merge,w=b.pick;b=function(){function b(b,d,l){this.wrapper=this.toolbar=this.submenu=
this.showhideBtn=this.listWrapper=this.arrowWrapper=this.arrowUp=this.arrowDown=void 0;this.chart=l;this.options=b;this.lang=d;this.iconsURL=this.getIconsURL();this.guiEnabled=b.enabled;this.visible=w(b.visible,!0);this.placed=w(b.placed,!1);this.eventsToUnbind=[];this.guiEnabled&&(this.createHTML(),this.init(),this.showHideNavigatorion());f(this,"afterInit")}b.prototype.init=function(){var b=this,f=this.lang,l=this.options,a=this.toolbar,c=l.definitions,e=a.childNodes;l.buttons.forEach(function(g){var l=
b.addButton(a,c,g,f);b.eventsToUnbind.push(n(l.buttonWrapper,"click",function(){return b.eraseActiveButtons(e,l.buttonWrapper)}));d(c[g].items)&&b.addSubmenu(l,c[g])})};b.prototype.addSubmenu=function(b,d){var g=this,a=b.submenuArrow,c=b.buttonWrapper,e=h(c,"width"),f=this.wrapper,p=this.listWrapper,r=this.toolbar.childNodes,k=this.submenu=m("ul",{className:"highcharts-submenu-wrapper"},void 0,c);this.addSubmenuItems(c,d);this.eventsToUnbind.push(n(a,"click",function(a){a.stopPropagation();g.eraseActiveButtons(r,
c);0<=c.className.indexOf("highcharts-current")?(p.style.width=p.startWidth+"px",c.classList.remove("highcharts-current"),k.style.display="none"):(k.style.display="block",a=k.offsetHeight-c.offsetHeight-3,k.offsetHeight+c.offsetTop>f.offsetHeight&&c.offsetTop>a||(a=0),q(k,{top:-a+"px",left:e+3+"px"}),c.className+=" highcharts-current",p.startWidth=f.offsetWidth,p.style.width=p.startWidth+h(p,"padding-left")+k.offsetWidth+3+"px")}))};b.prototype.addSubmenuItems=function(b,d){var g=this,a=this,c=this.submenu,
e=this.lang,f=this.listWrapper,h;d.items.forEach(function(k){h=g.addButton(c,d,k,e);g.eventsToUnbind.push(n(h.mainButton,"click",function(){a.switchSymbol(this,b,!0);f.style.width=f.startWidth+"px";c.style.display="none"}))});var p=c.querySelectorAll("li > .highcharts-menu-item-btn")[0];this.switchSymbol(p,!1)};b.prototype.eraseActiveButtons=function(b,d,f){[].forEach.call(b,function(a){a!==d&&(a.classList.remove("highcharts-current"),a.classList.remove("highcharts-active"),f=a.querySelectorAll(".highcharts-submenu-wrapper"),
0<f.length&&(f[0].style.display="none"))})};b.prototype.addButton=function(d,f,l,a){void 0===a&&(a={});f=f[l];var c=f.items,e=f.className||"";d=m("li",{className:w(b.prototype.classMapping[l],"")+" "+e,title:a[l]||l},void 0,d);l=m("span",{className:"highcharts-menu-item-btn"},void 0,d);if(c&&c.length)return f=m("span",{className:"highcharts-submenu-item-arrow highcharts-arrow-right"},void 0,d),f.style.backgroundImage="url("+this.iconsURL+"arrow-bottom.svg)",{buttonWrapper:d,mainButton:l,submenuArrow:f};
l.style.backgroundImage="url("+this.iconsURL+f.symbol+")";return{buttonWrapper:d,mainButton:l}};b.prototype.addNavigation=function(){var b=this.wrapper;this.arrowWrapper=m("div",{className:"highcharts-arrow-wrapper"});this.arrowUp=m("div",{className:"highcharts-arrow-up"},void 0,this.arrowWrapper);this.arrowUp.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)";this.arrowDown=m("div",{className:"highcharts-arrow-down"},void 0,this.arrowWrapper);this.arrowDown.style.backgroundImage="url("+
this.iconsURL+"arrow-right.svg)";b.insertBefore(this.arrowWrapper,b.childNodes[0]);this.scrollButtons()};b.prototype.scrollButtons=function(){var b=this.wrapper,d=this.toolbar,f=.1*b.offsetHeight,a=0;this.eventsToUnbind.push(n(this.arrowUp,"click",function(){0<a&&(a-=f,d.style.marginTop=-a+"px")}));this.eventsToUnbind.push(n(this.arrowDown,"click",function(){b.offsetHeight+a<=d.offsetHeight+f&&(a+=f,d.style.marginTop=-a+"px")}))};b.prototype.createHTML=function(){var b=this.chart,d=this.options,f=
b.container,a=b.options.navigation,c=this.wrapper=m("div",{className:"highcharts-stocktools-wrapper "+d.className+" "+(a&&a.bindingsClassName)});f.appendChild(c);["mousedown","mousemove","click","touchstart"].forEach(function(a){n(c,a,function(a){return a.stopPropagation()})});n(c,"mouseover",function(a){return b.pointer.onContainerMouseLeave(a)});this.toolbar=f=m("ul",{className:"highcharts-stocktools-toolbar "+d.toolbarClassName});this.listWrapper=d=m("div",{className:"highcharts-menu-wrapper"});
c.insertBefore(d,c.childNodes[0]);d.insertBefore(f,d.childNodes[0]);this.showHideToolbar();this.addNavigation()};b.prototype.showHideNavigatorion=function(){this.visible&&this.toolbar.offsetHeight>this.wrapper.offsetHeight-50?this.arrowWrapper.style.display="block":(this.toolbar.style.marginTop="0px",this.arrowWrapper.style.display="none")};b.prototype.showHideToolbar=function(){var b=this.chart,d=this.wrapper,f=this.listWrapper,a=this.submenu,c=this.showhideBtn=m("div",{className:"highcharts-toggle-toolbar highcharts-arrow-left"},
void 0,d),e=this.visible;c.style.backgroundImage="url("+this.iconsURL+"arrow-right.svg)";e?(d.style.height="100%",c.style.top=h(f,"padding-top")+"px",c.style.left=d.offsetWidth+h(f,"padding-left")+"px"):(a&&(a.style.display="none"),c.style.left="0px",e=this.visible=!1,f.classList.add("highcharts-hide"),c.classList.toggle("highcharts-arrow-right"),d.style.height=c.offsetHeight+"px");this.eventsToUnbind.push(n(c,"click",function(){b.update({stockTools:{gui:{visible:!e,placed:!0}}})}))};b.prototype.switchSymbol=
function(b,d){var f=b.parentNode,a=f.className;f=f.parentNode.parentNode;-1<a.indexOf("highcharts-disabled-btn")||(f.className="",a&&f.classList.add(a.trim()),f.querySelectorAll(".highcharts-menu-item-btn")[0].style.backgroundImage=b.style.backgroundImage,d&&this.toggleButtonActiveClass(f))};b.prototype.toggleButtonActiveClass=function(b){b=b.classList;b.contains("highcharts-active")?b.remove("highcharts-active"):b.add("highcharts-active")};b.prototype.unselectAllButtons=function(b){var d=b.parentNode.querySelectorAll(".highcharts-active");
[].forEach.call(d,function(d){d!==b&&d.classList.remove("highcharts-active")})};b.prototype.update=function(b,d){r(!0,this.chart.options.stockTools,b);this.destroy();this.chart.setStockTools(b);this.chart.navigationBindings&&this.chart.navigationBindings.update();this.chart.isDirtyBox=!0;w(d,!0)&&this.chart.redraw()};b.prototype.destroy=function(){var b=this.wrapper,d=b&&b.parentNode;this.eventsToUnbind.forEach(function(b){return b()});d&&d.removeChild(b)};b.prototype.redraw=function(){this.showHideNavigatorion()};
b.prototype.getIconsURL=function(){return this.chart.options.navigation.iconsURL||this.options.iconsURL||"https://code.highcharts.com/10.3.2/gfx/stock-icons/"};return b}();b.prototype.classMapping={circle:"highcharts-circle-annotation",ellipse:"highcharts-ellipse-annotation",rectangle:"highcharts-rectangle-annotation",label:"highcharts-label-annotation",segment:"highcharts-segment",arrowSegment:"highcharts-arrow-segment",ray:"highcharts-ray",arrowRay:"highcharts-arrow-ray",line:"highcharts-infinity-line",
arrowInfinityLine:"highcharts-arrow-infinity-line",verticalLine:"highcharts-vertical-line",horizontalLine:"highcharts-horizontal-line",crooked3:"highcharts-crooked3",crooked5:"highcharts-crooked5",elliott3:"highcharts-elliott3",elliott5:"highcharts-elliott5",pitchfork:"highcharts-pitchfork",fibonacci:"highcharts-fibonacci",fibonacciTimeZones:"highcharts-fibonacci-time-zones",parallelChannel:"highcharts-parallel-channel",measureX:"highcharts-measure-x",measureY:"highcharts-measure-y",measureXY:"highcharts-measure-xy",
timeCycles:"highcharts-time-cycles",verticalCounter:"highcharts-vertical-counter",verticalLabel:"highcharts-vertical-label",verticalArrow:"highcharts-vertical-arrow",currentPriceIndicator:"highcharts-current-price-indicator",indicators:"highcharts-indicators",flagCirclepin:"highcharts-flag-circlepin",flagDiamondpin:"highcharts-flag-diamondpin",flagSquarepin:"highcharts-flag-squarepin",flagSimplepin:"highcharts-flag-simplepin",zoomX:"highcharts-zoom-x",zoomY:"highcharts-zoom-y",zoomXY:"highcharts-zoom-xy",
typeLine:"highcharts-series-type-line",typeOHLC:"highcharts-series-type-ohlc",typeHLC:"highcharts-series-type-hlc",typeCandlestick:"highcharts-series-type-candlestick",typeHollowCandlestick:"highcharts-series-type-hollowcandlestick",typeHeikinAshi:"highcharts-series-type-heikinashi",fullScreen:"highcharts-full-screen",toggleAnnotations:"highcharts-toggle-annotations",saveChart:"highcharts-save-chart",separator:"highcharts-separator"};return b});r(b,"Stock/StockTools/StockToolsGui.js",[b["Core/Defaults.js"],
b["Stock/StockTools/StockToolsDefaults.js"],b["Stock/StockTools/StockToolbar.js"],b["Core/Utilities.js"]],function(b,n,m,q){function f(a){var b=this.options,c=b.lang;a=v(b.stockTools&&b.stockTools.gui,a&&a.gui);this.stockTools=new m(a,c&&c.stockTools&&c.stockTools.gui,this);this.stockTools.guiEnabled&&(this.isDirtyBox=!0)}function h(){this.setStockTools()}function d(){if(this.stockTools){var a=this.options.chart,b=this.stockTools.listWrapper;b=b&&(b.startWidth+e(b,"padding-left")+e(b,"padding-right")||
b.offsetWidth);var c=!1;b&&b<this.plotWidth?(a=t(a.spacingLeft,a.spacing&&a.spacing[3],0)+b,c=a-this.spacingBox.x,this.spacingBox.x=a,this.spacingBox.width-=c,c=!0):0===b&&(c=!0);b!==this.stockTools.prevOffsetWidth&&(this.stockTools.prevOffsetWidth=b,c&&(this.isDirtyLegend=!0))}}function r(){this.stockTools&&this.stockTools.destroy()}function w(){var a=this.stockTools&&this.stockTools.listWrapper;(a=a&&(a.startWidth+e(a,"padding-left")+e(a,"padding-right")||a.offsetWidth))&&a<this.plotWidth&&(this.plotLeft+=
a,this.spacing[3]+=a)}function x(){this.stockTools&&this.stockTools.guiEnabled&&this.stockTools.redraw()}function g(){var a=this.stockTools,b=a&&a.toolbar&&a.toolbar.querySelector(".highcharts-current-price-indicator");a&&this.navigationBindings&&this.options.series&&b&&(this.navigationBindings.constructor.prototype.utils.isPriceIndicatorEnabled(this.series)?b.firstChild.style["background-image"]='url("'+a.getIconsURL()+'current-price-hide.svg")':b.firstChild.style["background-image"]='url("'+a.getIconsURL()+
'current-price-show.svg")')}function p(a){var b=this.chart.stockTools;b&&b.guiEnabled&&(a=a.button,0<=a.parentNode.className.indexOf("highcharts-submenu-wrapper")&&(a=a.parentNode.parentNode),b.toggleButtonActiveClass(a))}function l(a){var b=this.chart.stockTools;if(b&&b.guiEnabled){var c=a.button;b.unselectAllButtons(a.button);0<=c.parentNode.className.indexOf("highcharts-submenu-wrapper")&&(c=c.parentNode.parentNode);b.toggleButtonActiveClass(c)}}var a=b.setOptions,c=q.addEvent,e=q.getStyle,v=q.merge,
t=q.pick,y=[];return{compose:function(b,e){-1===y.indexOf(b)&&(y.push(b),c(b,"afterGetContainer",h),c(b,"beforeRedraw",d),c(b,"beforeRender",d),c(b,"destroy",r),c(b,"getMargins",w,{order:0}),c(b,"redraw",x),c(b,"render",g),b.prototype.setStockTools=f);-1===y.indexOf(e)&&(y.push(e),c(e,"deselectButton",p),c(e,"selectButton",l));-1===y.indexOf(a)&&(y.push(a),a(n))}}});r(b,"masters/modules/stock-tools.src.js",[b["Core/Globals.js"],b["Extensions/Annotations/NavigationBindings.js"],b["Stock/StockTools/StockTools.js"],
b["Stock/StockTools/StockToolsGui.js"],b["Stock/StockTools/StockToolbar.js"]],function(b,n,m,q,f){b.Toolbar=f;m.compose(n);q.compose(b.Chart,n)})});
//# sourceMappingURL=stock-tools.js.map