"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onDelete = exports.onUpdate = exports.onCreate = exports.onEvent = exports.HttpAction = exports.HttpGet = void 0;
const axios_1 = require("axios");
async function HttpGet(url) {
    return HttpAction('get', url);
}
exports.HttpGet = HttpGet;
async function HttpAction(action, url) {
    const apiClient = axios_1.default.create({
        responseType: 'json',
        headers: {
            'Content-Type': 'application/json',
        },
    });
    let response;
    switch (action) {
        case 'get':
            response = await apiClient.get(url);
            break;
        case 'post':
            response = await apiClient.post(url);
            break;
        case 'put':
            response = await apiClient.put(url);
            break;
        case 'head':
            response = await apiClient.head(url);
            break;
        default:
            response = await apiClient.get(url);
            break;
    }
    const title = parseTitle(response.data);
    const resp = {
        title: title,
        headers: response.headers,
        status: response.status,
        body: response.data,
    };
    return resp;
}
exports.HttpAction = HttpAction;
function parseTitle(body) {
    let match = body.match(/<title>([^<]*)<\/title>/); // regular expression to parse contents of the <title> tag
    if (!match || typeof match[1] !== 'string') {
        // unable to parse the title
        return '';
    }
    else {
        return match[1];
    }
}
async function onEvent(event) {
    console.log('Event: %j', event);
    console.log('Got parameter:', process.env.PARAMETER);
    const requestType = event.RequestType;
    switch (requestType) {
        case 'Create':
            return onCreate(event);
            break;
        case 'Update':
            return onUpdate(event);
            break;
        case 'Delete':
            return onDelete(event);
            break;
        default: console.log(`invalid request type ${requestType}`);
    }
}
exports.onEvent = onEvent;
async function onCreate(event) {
    const props = event.ResourceProperties;
    const url = props.url;
    const resp = await HttpGet(url);
    const data = {
        status: resp.status,
        title: resp.title,
        // we only return first 256 characters of the body
        body: resp.body.substr(0, 256),
        url,
    };
    return { Data: data };
}
exports.onCreate = onCreate;
async function onUpdate(event) {
    return onCreate(event);
}
exports.onUpdate = onUpdate;
async function onDelete(event) {
    return event;
}
exports.onDelete = onDelete;
//# sourceMappingURL=data:application/json;base64,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