# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['roboai_cli',
 'roboai_cli.commands',
 'roboai_cli.config',
 'roboai_cli.config.store',
 'roboai_cli.initial_structure',
 'roboai_cli.initial_structure.initial_project',
 'roboai_cli.initial_structure.initial_project.actions',
 'roboai_cli.initial_structure.initial_project.custom.components.exact_match_classifier',
 'roboai_cli.initial_structure.initial_project.custom.components.spacy_nlp',
 'roboai_cli.initial_structure.initial_project.custom.policies.language_detection',
 'roboai_cli.util']

package_data = \
{'': ['*'],
 'roboai_cli.initial_structure': ['language/*', 'language/data/*'],
 'roboai_cli.initial_structure.initial_project': ['languages/*']}

install_requires = \
['Pygments==2.6.1',
 'XlsxWriter==1.3.7',
 'attrs==19.3.0',
 'cattrs==1.0.0',
 'certifi==2020.4.5.1',
 'chardet==3.0.4',
 'click==7.1.2',
 'colorama==0.4.3',
 'cursor==1.3.4',
 'halo==0.0.29',
 'idna==2.9',
 'log-symbols==0.0.14',
 'openpyxl==3.0.4',
 'pandas==1.0.5',
 'polling==0.3.1',
 'pyfiglet==0.8.post1',
 'pytablewriter==0.57.0',
 'questionary==1.5.2',
 'rasa==1.10.0',
 'regex==2020.5.14',
 'requests==2.23.0',
 'robo_ai>=0.1.1,<0.2.0',
 'six==1.14.0',
 'spinners==0.0.24',
 'termcolor==1.1.0',
 'urllib3==1.25.9',
 'wcwidth==0.1.9']

entry_points = \
{'console_scripts': ['roboai = roboai_cli:run']}

setup_kwargs = {
    'name': 'roboai-cli',
    'version': '1.1.2',
    'description': 'A command line tool to create, manage and deploy Rasa chatbots on the Robo.AI platform.',
    'long_description': '[![License: MIT](https://img.shields.io/badge/License-MIT-pink.svg)](https://opensource.org/licenses/MIT)\n\n# ROBO.AI Bot Runtime manager CLI tool #\n\n<img align="right" width="200" height="200" alt="robo-bot" src="robo-bot.png"></img>\nThis tool allows anyone to create, train, deploy, monitor and manage a Rasa based bot on the ROBO.AI platform.  \nCheck our [CHANGELOG](CHANGELOG.md) for the latest changes.\n\nTutorials: \n* [The ROBO.AI platform - creating bots and API keys for deployment](docs/manage_roboai_account.md)\n* [Creating and deploying a Rasa chatbot on the ROBO.AI platform](docs/create_deploy_bot.md)\n\n### How to install ###\n\n#### Requirements ####\n\n* Python 3.7\n* Pip and/or anaconda\n\nYou can create a virtual environment using conda:\n```sh\nconda create -n roboai-cli python=3.7\nconda activate roboai-cli\n```\n\n#### Installing the ROBO.AI tool ####\n\nAssuming you are already in your virtual environment with Python 3.7, you can install the tool with the following command:\n```\npip install roboai-cli\n```\n\n\nAfter installing the library you should be able to execute the robo-bot command in your terminal.\n\n#### Usage ####\n\nThe command line tool is available through the following terminal command:\n\n```\nroboai\n```\n\nWhen you execute it in a terminal you should see an output with a list of commands supported\nby the tool.\n\nI.e:\n```\nuser@host:~$ roboai\n ____   ___  ____   ___           _    ___ \n|  _ \\ / _ \\| __ ) / _ \\         / \\  |_ _|\n| |_) | | | |  _ \\| | | |       / _ \\  | | \n|  _ <| |_| | |_) | |_| |  _   / ___ \\ | | \n|_| \\_\\\\___/|____/ \\___/  (_) /_/   \\_\\___|\nBot Management Tool             robo-ai.com\n\nUsage: roboai [OPTIONS] COMMAND [ARGS]...\n\n  roboai 1.1.1\n\nOptions:\n  --version  Show the version and exit.\n  --help     Show this message and exit.\n\nCommands:\n  clean        Clean the last package\n  connect      Connect a local bot to a ROBO.AI server bot instance.\n  data         Utility command to split, export and import data.\n  deploy       Deploy the current bot into the ROBO.AI platform.\n  diff         Check for structural differences between languages for the...\n  environment  Define the ROBO.AI platform API endpoint to use.\n  interactive  Run in interactive learning mode where you can provide...\n  login        Initialize a new session using a ROBO.AI API key.\n  logout       Close the current session in the ROBO.AI platform.\n  logs         Display selected bot runtime logs.\n  package      Package the required bot and make it ready for deployment.\n  remove       Remove a deployed bot from the ROBO.AI platform.\n  run          Start the action server.\n  seed         Create a new ROBO.AI project seedling, including folder...\n  shell        Start a shell to interact with the required bot.\n  start        Start a bot deployed on the ROBO.AI platform.\n  status       Display the bot status.\n  stories      Generate stories for a Rasa bot.\n  stop         Stop a bot running in the ROBO.AI platform.\n  test         Test Rasa models for the required bots.\n  train        Train Rasa models for the required bots.\n``` \n\nEach of the listed commands provides you a functionality to deal with your bots,\neach one has a description, and a help option, so you can see what options and\narguments are available.\n\nYou can invoke each of the tool commands by following the pattern:\n```\nroboai <command> [command arguments or options]\n```\n\ni.e.:\n```\nroboai login --api-key=my-apy-key\n```\n\nYou can check the supported options and arguments for every command by following\nthe pattern:\n\n```\nroboai <command> --help\n```\n\ni.e.:\n\n```\nuser@host:~$ roboai login --help\n ____   ___  ____   ___           _    ___ \n|  _ \\ / _ \\| __ ) / _ \\         / \\  |_ _|\n| |_) | | | |  _ \\| | | |       / _ \\  | | \n|  _ <| |_| | |_) | |_| |  _   / ___ \\ | | \n|_| \\_\\\\___/|____/ \\___/  (_) /_/   \\_\\___|\nBot Management Tool             robo-ai.com\n\nUsage: roboai login [OPTIONS]\n\n  Initialize a new session using a ROBO.AI API key.\n\nOptions:\n  --api-key TEXT  The ROBO.AI platform API key.\n  --help          Show this message and exit.\n```\n\n### Using roboai-cli to create and maintain a bot ###\n\n##### Generating an initial structure #####\n\nThe ROBO.AI tool provides you with a set of commands useful to create, train, interact and test a bot \nbefore its deployment. \n\nTo create a bot you can use the **seed** command:\n\n```\nroboai seed [language-codes] [--path <path> --language-detection --chit-chat --coref-resolution]\n```\ni.e.:\n```\nroboai seed en de --path bot/ --language-detection --chit-chat --coref-resolution\n```\n\nThe first argument of the seed command is the language-codes which indicate the languages the bot will be built upon. \nIf no language-codes are passed, only an english sub-directory (en) will be created. \nThe optional parameters are referring to features you may want to add to the bot.  \nThis command behaves like rasa init but it\'ll generate a dedicated structure where you can have\nmulti-language bots related with the same domain. Below there\'s an example of a bot generated with this command. \n\n```\n.\n├── actions\n│   └── action_parlai_fallback.py\n├── custom\n│   ├── components\n│   │   └── spacy_nlp\n│   │       ├── spacy_nlp_neuralcoref.py\n│   │       └── spacy_tokenizer_neuralcoref.py\n│   └── policies\n│       └── language_detection\n│           ├── lang_change_policy.py\n│           └── lid.176.ftz\n├── languages\n|   ├── de\n|   │   ├── config.yml\n|   │   ├── data\n|   │   │   ├── lookup_tables\n|   │   │   └── nlu.md\n|   │   └── domain.yml\n|   ├── en\n|   │   ├── config.yml\n|   │   ├── data\n|   │   │   ├── lookup_tables\n|   │   │   └── nlu.md\n|   │   └── domain.yml\n|   └── stories.md\n├── credentials.yml\n├── endpoints.yml\n└── __init__.py\n```\n\n##### Generating stories for a bot #####\n\nAfter defining intents and actions for a bot you need to combine these in stories. This command allows you to generate the most basic interactions in your Rasa bot. \nNote: Manual checks will be needed to implement more complex stories but basic ping-pong dialogues should be covered with this feature. \nUsage: \n```\nroboai stories [language-codes] [--check-covered-intents]\n```\n\nIf no language-code is passed, roboai-cli will assume you\'re working in a single-language bot (and thus the default Rasa structure). \nThe option --check-covered-intents will go through your stories file and check if the intents you have defined in the domain file are being covered in the dialogues. This command is more useful when you\'re deep in the development of your bot.\n\n\n##### Checking for differences in a bot #####\n\nAfter making all the necessary changes to your bots, you want to make sure that all bots (languages) are coherent between each other (i.e. the same stories.md file will work for the nlu.md and domain.yml files configured for the different languages.) To know whether your bot is achieving this, you can use the **diff** command. \n\n```\nroboai diff [language-codes] [--path <path>]\n```\n\nIt will check for structural differences between the domain.yml and stories.md files for the same multi-language bot. \nIf no language codes are passed, then it\'ll pair all the languages found and check for differences between them.  \n\n\n##### Splitting the nlu #####\nIn case you want to split your nlu data, you can use the data command for that.  \nSimply run ```roboai data split nlu [language-code]``` and a new folder called train_test_split will be generated within the bot directory.  \nWhen training and testing the bot you can then pass these files as arguments.  \n\n##### Training a bot #####\n\nYou\'re now in a position to train the bot. To do so you only need to run the **train** command just as you would do in Rasa. \n\n```\nroboai train [language-codes] [--nlu --core --augmentation <value> --dev-config <path to config file> --force --debug --training-data-path <path-to-training-data-file>]\n```\n\nIn case you want to pass a specific training data file you can use the train command in the following way:  \n```\nroboai train en --training-data-path train_test_split/training_data.md\n```\n\n\nIt will train the bot and store the model in the language sub-directory. If no language codes are passed, all bots will be trained.  \n\nNote: The **augmentation** and **force** options do not work in the case of NLU training.\n\n##### Interacting with a bot #####\n\nTo interact with the bot, you can use the **shell** command. Before running it, you need to execute the **run actions** command. \n\n```\nroboai run actions [--debug]\n```\n\nAfter doing so, you can execute the shell command. \n\n```\nroboai shell [language-code] [--nlu] [--debug] \n```\n\nYou need to specify what language (bot) you want to interact with - you can only interact with one bot at the time.\n\n##### Testing a bot #####\n\nTesting a bot is also probably in your pipeline. And this is possible with the **test** command.\n\n```\nroboai test [language-code] [--cross-validation --folds <nr-of-folds> --tet-data-path <path-to-testing-data-file>]\n```\n\nIn case you want to pass a specific testing data file you can use the test command in the following way:  \n```\nroboai test --training-data-path train_test_split/test_data.md\n```\n\nIt\'ll test the bot with the conversation_tests.md file you have stored in your tests folder.  \nThe results will be stored in the language sub-directory. Besides Rasa\'s default results, roboai-cli also produces an excel file with a confusion list of mistmatched intents.\n\n##### Interactive learning #####\n\nIf you want to use Rasa\'s interactive learning mode you can do this by using the interactive command. \n\n```\nroboai interactive [language-code]\n```\n\nIt\'ll launch an interactive session where you can provide feedback to the bot. At the end don\'t forget to\nadjust the paths to where the new files should be saved. \n\nBy now you\'re probably ready to deploy your bot...\n\n### Using roboai-cli to deploy a bot ###\n\n##### Setting the target endpoint #####\n\nBefore doing any operation you must indicate to the tool in what environment you\'re working in,\nfor that you have the **environment** command:\n\nThe tool provides you with a default production environment in the ROBO.AI platform.\nYou can activate it by running:\n\n```\nroboai environment activate production\n```\n\nYou can also create new environments by executing:\n\n\n```\nroboai environment create <environment name> --base-url <base-url> [--username <username> --password <password>]\n```\n\nThe base-url refers to the environment URL and you can optionally pass a username\nand password if your environment requires them.\n\ni.e.:\n\n```\nroboai environment create development --base-url https://robo-core.my-robo-server.com --username m2m --password GgvJrZSCXger\n```\n\nAfter creating an environment, do not forget to activate it if you want to use it. \nTo know which environment is activated you can simply run:\n\n```\nroboai environment which\n```\n\nIt\'s possible to check what environments are available in your configuration file by running: \n\n```\nroboai environment list\n```\n\nYou can also remove environments by executing:\n\n```\nroboai environment remove <environment name>\n```\n\n\n##### Logging in #####\n\nOnce you have the desired environment activated, you need to login into the account you\'d like to use by using\nan API key.\n\n1. Log-in into your ROBO.AI administration and generate an API key (do not forget to enable it).\n2. Execute the login command and enter the API key.\n\ni.e.:\n```\nroboai login --api-key=my-api-key\n```\n\nOr if you don\'t want to enter the api key in your command, you can enter it interactively by only executing:\n\n```\nroboai login\n```\n\n##### Initializing a bot #####\n\nIn order to manage a bot runtime, it needs to be initialized so the tool will know what bot this runtime\nrefers to. If you already have the Rasa bot initialized, just execute the following command:\n\n```\nroboai connect [language-code] --target-dir <path to rasa bot files>\n```\n\ni.e.:\n\n```\nroboai connect [language-code] --target-dir /path/to/rasa/bot\n```\n\nFirst it\'ll ask you to pick an existing bot (if it does not exist, you must create it before executing this step).\nAfter doing it, it\'ll generate a new file called robo-manifest.json which contains meta-information about the deployment\nand the target bot.  \n**Note:** if no language-code is provided, it\'s assumed that you\'re working with the default Rasa structure.\n\n##### Deploying a bot #####\n\nWhen your bot is ready for deployment, you must train it first and ensure you\'re in the bot root directory. You can then execute:\n\n```\nroboai deploy [language-code] --model <path to model file>\n```\n\nIt\'ll package your bot files and upload them to the ROBO.AI platform, starting a new deployment. This step may take some time.  \nIf you want you can pass the path to the model you want to deploy. If no model path is passed then the most recent one will be picked up.\n**Note:** if no language-code is provided, it\'s assumed that you\'re working with the default Rasa structure.\n\n##### Checking a bot status #####\n\nIf you want to check your bot status, just run the following command from the same directory as of your robo-manifest.json\n\n```\nroboai status [language-code]\n```\n\n**Note:** if no language-code is provided, it\'s assumed that you\'re working with the default Rasa structure.\n\n##### Removing a bot #####\n\nIf you need to remove a bot, execute the following command from the bot root directory:\n\n```\nroboai remove [language-code]\n```\n\n**Note:** if no language-code is provided, it\'s assumed that you\'re working with the default Rasa structure.\n\n##### Checking a deployed bot logs #####\n\nSometimes it\'s useful to have a look into the logs, for that you need to execute:\n\n```\nroboai logs [language-code]\n```\n\nIt\'ll show you the latest 1000 lines from that rasa bot logs.  \n**Note:** if no language-code is provided, it\'s assumed that you\'re working with the default Rasa structure.\n\n### Using roboai-cli to export and import data ###\n\n##### Export data #####\nIf you require to export your bot\'s data you may use the data command for that end.  \nYou can run  \n```\nroboai data export [nlu/responses/all] --input-path <bot-root-dir> --output-path <path-to-where-you-want-to-save-the-file>\n```\nIf you opt to export only the nlu or the responses, an excel file will be generated with this content. If you wish to export both, use the \'all\' option and an excel file with both the nlu and responses will be generated.\n\n##### Import data #####\nTo import the data back from excel to markdown/yaml, the data command is what you\'re looking for.  \nYou can run  \n```\nroboai data import [nlu/responses/all] --input-path <path-where-your-file-is-saved> --output-path <path-to-where-you-want-to-save-the-file>\n```\nThis will generate markdown and yaml files containing the nlu and responses content, respectively.   \n\n## Code Style\n\nWe use [Google Style Python Docstrings](https://google.github.io/styleguide/pyguide.html#38-comments-and-docstrings).   \n\n## Releases\n\nWe follow [Semantic Versioning 2.0.0](https://semver.org/) standards.  \n\nGiven a version number MAJOR.MINOR.PATCH, increment the:  \n\n- MAJOR version when you make incompatible API changes,  \n- MINOR version when you add functionality in a backwards compatible manner, and  \n- PATCH version when you make backwards compatible bug fixes.  \nAdditional labels for pre-release and build metadata are available as extensions to the MAJOR.MINOR.PATCH format.  ',
    'author': 'ROBO.AI',
    'author_email': 'info@robo-ai.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://robo-ai.com/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.8',
}


setup(**setup_kwargs)
