from marshmallow import fields
from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.loads.equipment_schema import EquipmentSchema
from cc_py_commons.loads.location_schema import LocationSchema
from cc_py_commons.loads.freighthub_contact_schema import FreightHubContactSchema

class LoadSchema(CamelCaseSchema):
    reference_number = fields.String()
    # C4 Account ID
    customer_id = fields.Integer(allow_none=True)
    origin = fields.Nested(LocationSchema)
    destination = fields.Nested(LocationSchema)
    pickup_date = fields.Date()
    delivery_date = fields.Date()
    status_id = fields.UUID()
    source_id = fields.UUID()
    equipment = fields.List(fields.Nested(EquipmentSchema))
    equipment_description = fields.String()     
    contact = fields.Nested(FreightHubContactSchema, allow_none=True)
    pickup_open_time= fields.Time(allow_none=True)
    pickup_close_time= fields.Time(allow_none=True)
    pickup_appointment_required= fields.Boolean(missing=False, default=False)
    delivery_open_time= fields.Time(allow_none=True)
    delivery_close_time= fields.Time(allow_none=True)
    delivery_appointment_required= fields.Boolean(missing=False, default=False)
    tracking_number = fields.String(allow_none=True)
    full_load = fields.Boolean(missing=True)
    length = fields.Integer(allow_none=True)
    width = fields.Integer(allow_none=True)
    height = fields.Integer(allow_none=True)
    weight = fields.Integer(allow_none=True)
    load_count = fields.Integer(allow_none=True)
    distance = fields.Integer(allow_none=True)
    stops = fields.Integer(allow_none=True)
    rate = fields.String(allow_none=True)
    declared_value = fields.Integer(allow_none=True)
    comment = fields.String(allow_none=True)
    commodity = fields.String(allow_none=True)
    min_temperature= fields.Float(allow_none=True)
    max_temperature= fields.Float(allow_none=True)
    tarp_size = fields.Integer(allow_none=True)
    carrier_id = fields.UUID(allow_none=True)
    contact_id = fields.UUID(allow_none=True)
    url = fields.String(allow_none=True)
    demo_load= fields.Boolean(missing=False, default=False)
    team_service_required= fields.Boolean(missing=False, default=False)
    quote_id = fields.UUID(allow_none=True)
    truck_lane_search_id = fields.UUID(allow_none=True)
    truck_search_id = fields.UUID(allow_none=True)
    # generated by server and returned
    id = fields.UUID(allow_none=True)
    # generated by server and returned
    load_number = fields.String(allow_none=True)   