# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI.ipynb (unless otherwise specified).

__all__ = ["app"]

# Internal Cell

from contextlib import contextmanager
import os
import types

import typer

import captn
from .token import token
from .version import version

from . import db, ds, api_key, user
from ..client import _replace_env_var

# Cell

app = typer.Typer(help="CLI for interfacing with Capt’n.")

# Internal Cell

# token root command

app.command()(token)

# Internal Cell

# version root command

app.command()(version)

# Internal Cell

# db root command

app.add_typer(db.app, name="db")

# Internal Cell

# ds root command

app.add_typer(ds.app, name="ds")

# Internal Cell

# api_key root command

app.add_typer(api_key.app, name="api-key")

# Internal Cell

# user root command

app.add_typer(user.app, name="user")
