from __future__ import annotations
from dataclasses import dataclass
from typing import List, Tuple

from pydantic import BaseModel


@dataclass
class WeatherApiBundle:
    """
    :param str domain: Domain where Weather API is found
    :param tuple credentials: Weather API username and password
    """
    domain: str
    credentials: Tuple[str, str]


@dataclass
class Location:
    latitude: float
    longitude: float


# Let's use the autogenerated pydantic model
# The variable names in the classes defined below have to match the keys in the incoming JSON


class WeatherRequestLocation(BaseModel):
    latitude: float
    longitude: float


class WeatherRequest(BaseModel):
    coordinates: List[WeatherRequestLocation]
    variables: List[str]


class DataPoint(BaseModel):
    time: str
    value: float


class Variable(BaseModel):
    name: str
    description: str
    data: List[DataPoint]


class WeatherLocation(BaseModel):
    latitude: float
    longitude: float
    variables: List[Variable]


class WeatherModel(BaseModel):
    requestTime: str
    request: WeatherRequest
    coordinates: List[WeatherLocation]
