# -*- coding: utf-8 -*-
#
# Copyright (c) 2019-2020 VMware, Inc. All Rights Reserved.
# SPDX-License-Identifier: BSD-2-Clause

"""
SPDX document formatting
"""

# basic strings
tag_value = '{tag}: {value}'
block_text = '<text>\n{message}\n</text>'

# document level strings
spdx_version = 'SPDXVersion: SPDX-2.2'
data_license = 'DataLicense: CC0-1.0'
spdx_id = 'SPDXID: SPDXRef-DOCUMENT'
document_name = 'DocumentName: Tern report for {image_name}'
document_comment = 'DocumentComment: <text>This document was generated by ' \
    'the Tern Project: https://github.com/tern-tools/tern</text>'
document_namespace = 'DocumentNamespace: https://spdx.org/spdxdocs/tern-' \
    'report-{version}-{image}-{uuid}'
license_list_version = 'LicenseListVersion: 3.8'
creator = 'Creator: Tool: tern-{version}'
created = 'Created: {timestamp}'

# Package level strings
package_comment = 'PackageComment: <text>\n{comment}\n</text>'
package_id = '{name}-{ver}'

# Relationship strings
contains = 'Relationship: {outer} CONTAINS {inner}'
prereq = 'Relationship: {after} HAS_PREREQUISITE {before}'

# License Reference Information
license_id = 'LicenseID: {license_ref}'
extracted_text = 'ExtractedText: <text>Original license: {orig_license}</text>'
