# -*- coding: utf-8 -*-
#
# Copyright (c) 2021 VMware, Inc. All Rights Reserved.
# SPDX-License-Identifier: BSD-2-Clause

"""
SPDX document formatting
"""


# document level strings
spdx_version = 'SPDX-2.2'
data_license = 'CC0-1.0'
spdx_id = 'SPDXRef-DOCUMENT'
document_name = 'Tern report for {image_name}'
document_comment = 'This document was generated by ' \
    'the Tern Project: https://github.com/tern-tools/tern'
document_namespace = 'https://spdx.org/spdxdocs/tern-' \
    'report-{version}-{image}-{uuid}'
license_list_version = '3.8'
creator = 'Tool: tern-{version}'
created = '{timestamp}'

document_name_snapshot = 'Tern SPDX JSON SBoM'
document_namespace_snapshot = 'https://spdx.org/spdxdocs/tern-report-' \
    '{timestamp}-{uuid}'


# Dictionary Formatting
def get_relationship_dict(element_id, related_element_id, relationship_type):
    '''Given two SPDX element IDs and their relationship type, return a
    dictionary that represents the relationship. Assume that the element_id
    inputs are provided as SPDXRefs.
    {
      "spdxElementId" : "SPDXRef-element_id",
      "relatedSpdxElement" : "SPDXRef-related_element_id",
      "relationshipType" : "relationship_type"
    }'''
    return {
        "spdxElementId": element_id,
        "relatedSpdxElement": related_element_id,
        "relationshipType": relationship_type
    }


def get_extracted_text_dict(extracted_text, license_ref):
    '''Given a plain text license string and the corresponding license_ref,
    return a dictionary that describes the key-value pair:
        {
            "extractedText" : "extracted_text"
            "licenseId": "license_ref"
        }'''
    return {
        "extractedText": extracted_text,
        "licenseId": license_ref
    }
