# Release 2.5.0

## Summary
This release contains a mix of features, bug fixes and resolved technical debt. It also includes an update to a vulnerable package, urllib3, which addresses CVE-2021-28363. This release adds support for distroless containers and adds a new CLI option, `-y [LAYER_NUMBER]/--layer [LAYER_NUMBER]`, which will generate a default report SBoM for a specific layer instead of the entire container image. There is also a `-li/--layer_inclusive` flag that was added to the CLI which, when used in conjunction with the `-y/--layer` option, will include all of the preceding layers in the SBoM up until the specified layer number argument. This `-y/--layer` feature is currently only enabled for the default report format.

A number of bugs were also resolved in this release. Namely, a bug where Tern was crashing when running on squashed images and an issue where Tern was incorrectly parsing image strings when the docker image name contained registry information about images hosted on a different port. Notable technical debt cleanup includes replacing npm parsing with the `jq` utility which drastically speeds up npm package metadata collection.

## Security
* [CVE-2021-28363](https://github.com/advisories/GHSA-5phf-pp7p-vc2r): v2.5.0 updated a vulnerable package, urllib3, to address a security concern. v2.4.0 and below contain a vulnerable package and we recommend updating to v2.5.0.

## New Features
* [Add support for distroless containers](https://github.com/tern-tools/tern/issues/864): Tern can now detect and report on packages in distroless containers.
* [Generate SBoM for/until specific layer](https://github.com/tern-tools/tern/issues/840): Tern can now generate an SBoM for a specific layer of a container image. It can print the report for one specific layer, or a cumulitive report of all the layers up until a specific layer.

## Bug Fixes
* [Bug fix for Debian dockerfiles reporting duplicate packages](https://github.com/tern-tools/tern/issues/899)
* [Fix image parsing for docker registries hosted on a different port](https://github.com/tern-tools/tern/issues/890)
* [Correct parsing for Dockerfile enviornment variables that contain '{}'](https://github.com/tern-tools/tern/issues/913)
* [Tern crashes with squashed images](https://github.com/tern-tools/tern/issues/838)
* [Fix execution path for raw image tarballs](https://github.com/tern-tools/tern/pull/898)
* [Fix go module collection](https://github.com/tern-tools/tern/issues/924)

## Resolved Technical Debt
* [Replace npm parsing with jq](https://github.com/tern-tools/tern/issues/903): This *significantly* speeds up the detection time for npm packages by removing the overhead of spinning up Node.js individually for each package. Thanks to @JamieMagee for his work on this!
* [Use GitPython instead of subprocess](https://github.com/tern-tools/tern/issues/619)
* [Increase timeout for pulling larger images](https://github.com/tern-tools/tern/pull/904)
* [Pass arguments as a single object](https://github.com/tern-tools/tern/issues/868)

## Future Work
* "Live" analysis of a container image.
* Enabling a distributed cache and database for Tern
* Continuing code cleanup.

## Changelog
Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.4.0..main`

```
2693eeb fix: Include information about layer's created_by
83fa293 Use deepcopy to find key listing dictionary
728f619 Fix duplicate OS notices
911e368 Set WORKDIR directory to collect go modules
98a12fc Refactor: Combine distroless into generic "host"
e7a4a0a bugfix: Escape empty braces when parsing snippets
452ab48 Add jq dependency to Dockerfiles and README
e0785a0 Use jq to detect npm components
9fa0a19 Add GitPython as a runtime dependency
2405feb Update community meeting time to UTC time zone
380e7e8 Add initial support for distroless containers
d391f68 Compare ordered pkg_licenses for Package objects
e01f826 Use GitPython for all git operations
551a4e4 Timeout for pulling large images
66822ef Fix execution path for raw image tarball
1097ad3 Fix for docker registries hosted on different port
733eb12 Refactor: pass arguments as a single object
141b9b0 Fix error msg when no created_by info for layers
29d16f6 Minimize complexity of do_main
11fc8a3 Generate SBoM for single layer
bae951f Warn user when he sets --layer too large
06a16f9 Fix docstring in cache.py
20ed612 Add layer support to default reporter
c2d3817 Implement partial analysis
46e6898 Add print_inclusive parameter to generate()
e342cdd Add -li --layer-inclusive CLI argument
580413b Prepare Image class for partial image loading
d204d96 Add -y --layer option to command line
```

## Contributors
```
Alexander Mazuruk a.mazuruk@samsung.com
Dhairya Jain jaindhairya2001@gmail.com
Jamie Magee jamagee@microsoft.com
Jeroen Knoops jeroen.knoops@philips.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
