# Release 2.4.0

## Summary
This mini release contains a small mix of features, bug fixes, refactors and technical debt cleanup. It adds support for an SPDX JSON format and adds a new `debug` subcommand that makes debugging issues related to package reporting easier. Most importantly, this release fixes a bug where Tern was failing to scan images that didn't have repository or tag metadata associated with them. Other notable bug fixes include a patch for missing notices in the cache and incorrect package reporting in alpine images when package names had non-alphanumeric characters. 

As always, we would like to thank our community for contributing to this release.

## New Features
* [Support for SPDX JSON format](https://github.com/tern-tools/tern/issues/839): Tern now can generate valid SPDX JSON documents for container images and Dockerfiles.
* [Addition of 'debug' subcommand](https://github.com/tern-tools/tern/issues/660): This new `debug` CLI option enables users to test out scripts in `base.yml` and to inspect the filesystem at a given layer index. Previously, this functionality was only available in the `verify_invoke.py` and `container_debug.py` scripts.

## Bug Fixes
* [Bug fix for images that don't have repos or tags](https://github.com/tern-tools/tern/issues/874)
* [Fix for not retrieving cached notices](https://github.com/tern-tools/tern/issues/875)
* [Fix duplicate package reporting for alpine images](https://github.com/tern-tools/tern/issues/881)
* [Fix "Invalid element reference in relationship" error for spdxtagvalue reports](https://github.com/tern-tools/tern/issues/867)
* [Fix "Invalid download location" error for spdxtagvalue reports](https://github.com/tern-tools/tern/issues/855)

## Resolved Technical Debt
* [Enable SPDX document validation for CI checks](https://github.com/tern-tools/tern/issues/713)
* [Remove repotag:PackageDownloadLocation mapping for SPDX formats](https://github.com/tern-tools/tern/issues/855)
* Small refactor of shared code for SPDX formatting
* Refactor `get_os_style()` to set the right properties
* `master` branch renamed to `main`

##  Future Work
* "Live" analysis of a container image.
* Generating output reports by layer.
* Analysis for OCI style images.
* Continuing code cleanup.

The next release is targeted to be a Beta release 3.0.0 in March or April. Watch the [Beta Release Milestone](https://github.com/tern-tools/tern/milestone/13) for progress. We're really excited about this release!

## Changelog
Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.3.0..main`

```
1c8d031 Fix duplicate package reporting for alpine images
52b4e29 Enabled SPDX document validation for CI
e1d00f8 Bug fix for images that don't have repos or tags
73af8ba Added run_extension_layer for ImageLayer object
523bdfb Fix for not retrieving cached notices
d1996b7 Load notices from cache for each layer
8137ffc Refactor get_os_style to set the right properties
683ba98 Fix tests for human readable id creation
4a820cf Fix image human readable id formatting
3ffe9f0 Update tests to refer to the main branch
8d98d41 Add community meeting info to README
b649f4c Make scancode use more processes
d6ca178 Set SPDX PackageDownloadLocation to valid value
61fae79 Remove repotag:PackageDownloadLocation mapping
07b868f Set spdxtagvalue PackageDownloadLocation to NONE
2762e30 Set spdxjson image downloadLocation to NOASSERTION
3ee14a8 Add File support for JSON SPDX Documents
d443caf Only include fileType if it exists
8b316d2 Add extractedText licenseRef info to spdxjson docs
bf53a5a Add new function get_extracted_text_dict()
b76d74b Use LicenseRef for spdxjson File licenses
5fe5561 Update spdxtagvalue file-related functions
fb8dfa3 Add spdxjson information to README
6ceee2e Add support for SPDX JSON format
bca41a2 Add support for SPDX JSON format
87f1c29 Refactor: move common functions to spdx_common.py
e51d361 Create spdx_common.py for common functions
64064c0 Move spdx/formats.py to spdxtagvalue directory
a54c71f Add spdxjson command line format option
ca74c3e main: Fix formatting for -wd option
9b498c8 Change vagrant box to generic/ubuntu1804
d591676 Add libvirt provider support to Vagrantfile
30c993a Change Vagrant box to generic/ubuntu1804
7ed5a02 Add info about Discussions in CONTRIBUTING.md
4107298 Introduce debug subcommand
f09fa05 Updated documentation with tern debug instructions
01618a0 Move container_debug script into debug subcommand
2c7efbf Add subcommand debug to replace verify_invoke
```

## Contributors

```
Alexander Mazuruk a.mazuruk@samsung.com
m1-key shubhamtiwari.tiwari84@gmail.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
