# Release 2.3.0

## Summary
This release contains a big code refactor which fixed a good number of technical debt issues. It also delivers support for [multistage Dockerfiles](https://docs.docker.com/develop/develop-images/multistage-build/#use-multi-stage-builds), which is valuable as Docker removes the intermediate stages leaving only the final deploy container image to analyze. Teams building applications using this method can now get a Sofware Bill of Materials for each stage. A special thanks to Junlai Wang (@ForgetMe17 on GitHub) for laying the groundwork to finally implement this feature. We also have a Dockerfile for building Tern with Scancode-Toolkit. To build this image, simply run `docker built -t ternscancode -f docker/Dockerfile.scancode .` and then `docker_run.sh ternscancode "report -x scancode -i <image:tag>"`. Thanks to Jeroen Knoops (@JeroenKnoops on GitHub) for contributing this Dockerfile.

A note about this release: Although this is a minor version bump, the short `-d` for `--driver` is now `-dr` to prevent confusion between `-d` for passing a Dockerfile.

As always, we would like to thank our community for contributing to this release.

## New Features
* [Preliminary support for multistage Dockerfiles](https://github.com/tern-tools/tern/issues/612): Tern can now generate reports in HTML, JSON, YAML and human-readable formats for multistage Dockerfiles. Note that this is the case only for Dockerfiles, not container images that may have been built using Dockerfiles. We think this is pretty cool!

## Bug Fixes
* [Fix crash when an image is not found by the Docker API](https://github.com/tern-tools/tern/issues/828)
* [Fix crash when a script invocation fails](https://github.com/tern-tools/tern/issues/822)
* [Fix parsing tabs in a Docker image's created_by value](https://github.com/tern-tools/tern/issues/812)
* Many bugs were fixed as a result of the code refactor.


## Resolved Technical Debt
* Parts of a larger code refactor:
  * [Move container pull and dump operations to a new module](https://github.com/tern-tools/tern/issues/802)
  * [Move setup and teardown checks into a new module](https://github.com/tern-tools/tern/issues/808)
  * [Re-organize tern/analyze folder](https://github.com/tern-tools/tern/issues/803)
* [Resolving all code complexity debt](https://github.com/tern-tools/tern/issues/789)

## Future Work
* A "step" subcommand to step through container image layers and analyze them individually.
* Analysis for OCI style images.
* Continuing code cleanup

The next release will be a Beta release 3.0.0. Since it will be the first in 2021, and the US holidays are upon us, expect the next release by March or April. Watch the [Beta Release Milestone](https://github.com/tern-tools/tern/milestone/13) for progress. We're really excited about this release!

## Changelog

Note: This changelog will not include these release notes

Changelog generated by command: `git log --pretty=format:"%h %s" v2.1.0..master`

```
bb38e14 merge: Enable analysis for multistage Dockerfiles
906edac Fix ci build for locking a Dockerfile
24b4e51 Fixes for reading and writing Dockerfiles
daab1d4 Fix Dockerfile build with context
142c74e Enable multistage Dockerfile analysis
453fad6 Replace the short driver option with -dr
4ca9b88 Add subroutine to analyze multistage Dockerfiles
3e2325e Update code navigation document
a8ec222 Add Dockerfile for scancode
ad2b97c Add 'apt' Snippet In Command Library
e420355 Fix crash when a chroot command fails
e33357d Fix Dockerfile analysis if no base image is found
1621437 Gracefully exit if there is no image to analyze
222a138 Fix unbound local error when repo digest is given
cfb8d10 Recognize assignments before command in script
14c2dca merge: Organize code under tern/analyze
85bbd09 Fix tests after refactor
e7b3b6a Shorten fill_package_metadata function
0c0d587 Re-enable Dockerfile lock
f0ff818 Fix operation errors after refactor
fe1de25 Refactor functions with too many branches
716b1e0 Complete Dockerfile analysis
a991b0f Fix multi-layer container analysis
c2e8dfa Fix single layer analysis
5f24e3e More moving of code into logical places
43f64af Organized code in the analyze folder
2f5f4c6 Move multi-layer analysis to default
e8a8228 Move command_lib into default and organize
4b67c87 Create new folder for default operation
9b181d3 merge: Move external interactions to load directory
21156d0 Remove container.py and some deprecated functions
5681dac Fix checksum parsing and Dockerfile building
5f4b0f5 Fixed tests and linting for common.py and Package
90cd6cb Fix loading package files from cache
5706b2b Hook up docker_api to setup and teardown
70fdc09 classes: Use load functions in DockerImage
c5cc233 load: New code section for external interactions
338fde3 merge: Map layer files to packages
056c309 Fix error caused by tabs in ENV
bebbb18 Add file info for packages
2d29c8d Extract file info for packages
d561fce docs: Add GitHub Action link in README
1139109 ci: Update python version for GHA
7f6ab45 Refactor Dockerfiles
```

## Contributors

```
asifjoardar mrsparrow04@gmail.com
HeroicHitesh hiteshkumar_1mv17cs042@sirmvit.edu
Isac Sund isac@isacsund.com
Jeroen Knoops jeroen.knoops@philips.com
PrajwalM2212 prajwalmmath@gmail.com
WangJL hazard15020@gmail.com
Yann Jorelle yann.jorelle@nokia.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
