# Release 2.1.0

## Summary
A handful of significant features were added to increase the amount of information Tern is able to collect and provide to the user. Some of these features include metadata collection for pip, npm and gem, as well as license reporting in the default report for Debian-based images.

In addition to the new features mentioned above, we have also included bug fixes and resolved some technical debt.

We are still in Alpha development mode and hope to transition to Beta within the next 6-8 months. The successful transition to Beta will happen when the following features are completed:
* Enable Tern to run natively in a container for Mac and Windows.
* Golang package manager support.
* Replacement of cache.yml with a backend database.

We'd like to thank all those who contributed to this release.

## New Features
* [Enable pip package listing](https://github.com/tern-tools/tern/issues/149): Tern now collects package metadata information for pip packages installed in an image.
* [Enable gem and npm package listing](https://github.com/tern-tools/tern/issues/609): Tern now collects package metadata information for gem and npm packages installed in an image. Note: npm package metadata collection times can be rather long due to the often large number of modules installed.
* [License reporting for Debian](https://github.com/tern-tools/tern/issues/499): Debian license information is embedded in the copyright text. Before this enhancement, license metadata for Debian images was not reported in the default report and the only way to see it was to use an alternative format like SPDX. Debian license metadata information will now be provided in the default report.
* [Update SPDX format to include file level analysis](https://github.com/tern-tools/tern/issues/586): File level metadata collected using the Scancode plugin will now be represented in spdxtagvalue-formatted reports.

## Bug Fixes
* [Tern fails when image has no created_by key](https://github.com/tern-tools/tern/issues/636)
* [Tern fails to perform analysis for Buildpack images](https://github.com/tern-tools/tern/issues/684)
* [--redo flag does not redo file level analysis](https://github.com/tern-tools/tern/issues/653)
* [Teardown fails for raw container images](https://github.com/tern-tools/tern/issues/628)
* [Return new lines in Dockerfile lock feature](https://github.com/tern-tools/tern/issues/596)
* [Fixed error: chroot: failed to run command '/bin/bash'](https://github.com/tern-tools/tern/issues/644)
* [error in dockerfile lock when ADDed file is not found](https://github.com/tern-tools/tern/issues/642)
* [Fix timeout error for large images](https://github.com/tern-tools/tern/issues/630)
* [cve-bin-tool errors out in Tern but prints report accurately without it](https://github.com/tern-tools/tern/issues/689)
* [Dockerfile lock gets confused when installing pip packages](https://github.com/tern-tools/tern/issues/702)


## Resolved Technical Debt
* Fix "too-many-branches" prospector errors for [generator.py](https://github.com/tern-tools/tern/issues/648) and [helpers.py](https://github.com/tern-tools/tern/issues/647)
* [Resolved Scancode header in generated documents](https://github.com/tern-tools/tern/issues/643)
* [Update warning messages to be more helpful](https://github.com/tern-tools/tern/issues/687)

## Future Work
* We will be focusing on how to run Tern natively in a container on Windows and Mac.
* We will add a debug feature to Tern that can be used by contributors.
* We will create an option to view JSON report output in a web interface UI.
* We will start to look at enabling Tern to run for OCI images.
* Google Summer of Code Interns will begin contributing to Tern full time at the beginning of June.
* As usual, we will be refactoring code, addressing technical debt, and fixing bugs.

The next planned release will take place at the end of July 2020. Watch the [project roadmap](/docs/project-roadmap.md) for updates.

## Changelog

Note: This changelog will not include these release notes

Changelog produced by command: `git log --pretty=format:"%h %s" v2.0.0..master`

```
202c4c8 Fix package pinning when package is also pkg mngr
6ed1f0c extensions: scancode: Fix file type reporting
c9b2261 extensions: cve-bin-tool: Print error and result
0d05d53 Fix error with missing keys in cache
fd901e5 classes: Set digest when instantiating DockerImage
20504e0 formats: spdxtagvalue: Update to SPDX 2.2
4c79585 Update warning message to be more helpful
dd6a864 formats: spdxtagvalue: Add extension_info headers
8716e12 Add Scancode header in generated documents
1f6dd29 Get Debian package licenses from copyrights
ce7b963 Parse Debian copyright texts to get licenses
5031cd6 classes: package: Add property pkg_licenses
33b2190 Enable -r--/redo option for extensions
db83e03 Enable npm and yarn package listing
54b5cb7 extensions: scancode: Increase timeout limit
2c84a13 Let GNU tar extract leading forwardslash members
161c512 Bug fix if image has no created_by key
59a6b60 analyze: Reduce branches in analyze_first_layer
c7ccaab Look for shell in filesystem
cc71316 Adding support for bundler
e2a82b7 Update base.yml to echo debian copyright file path
843d78a Run prospector on all files for CI tests
edafcf0 formats: spdx: add PackageComment for layers
3193a17 Revert "Update base.yml to echo debian copyrig..."
869d605 command_lib: Remove shell listing from base.yml
b8e3d4d analyze: Update finding and using a shell binary
3ad5fd8 command_lib: Add new file common.yml
44ae447 Update base.yml to echo debian copyright file path
ef23604 Enable gem package listing
85dd0df Undo mount operation in event of errors
6c2bee2 Enable pip package listing
92f5301 Fix infinite loop in container_debug.py
ee515be utils: Exclude whiteout files when extracting
0bed397 Combine RUN commands in Tern's Dockerfile
32db7df tools: Update container_debug and verify_invoke
1482bd7 Fix prospector too-many-branches error for plugins
2558db0 Fix linting error for helper.py
2d1963a Fix linting error for generator.py
7bee629 Use absolute path for ADDed Dockerfile files
a6fde9e Add CI test for Dockerfile lock
a01047b docs: Update the project roadmap for 2020
797b2c6 Include file level data into SPDX documents
f02f363 spdxtagvalue: Fix SPDX validation errors
442ffe8 spdxtagvalue: Create valid doc with file data
15315f0 scancode: Include file_type and checksums
290c4a3 classes: Modify checksums data structure
262c893 tools: Hash only non-empty files
1dffe27 formats: spdx: Use helpers in generator
e90c118 formats: spdx: Move image level SPDX to a new file
9e594a4 formats: spdx: Move layer functions to new file
a5fc985 classes: Get checksum for docker images
340900c formats: spdx: Move package format to new file
d83a83f formats: spdx: Add Package Verification Code
5db1e33 formats: spdx: Add file block functions
2e9cd35 classes: Add short_file_type to FileData class
e0f6108 Point to new code hosting link
bdec7a7 Add docs to create a dev env. when using vagrant
9a4de19 Increase timeout for pulling large images
f0c396f Add exception for raw container image teardown
bcc1686 Find Git Project URL
120876a Fixed some typos and grammar in docs
3f1bb7a Add documentation about Dockerfile lock
dd47575 Preserve newline characters in Dockerfile.lock
d1c846d Add ‘checksums’ properties to Image and ImageLayer
e1698ac Add test to validate cache behavior on layers
```

## Contributors

```
abhaykatheria abhaykatehria01@gmail.com
Miguel Angel G miguel@gordian.dev
mukultaneja mtaneja@vmware.com
WangJL hazard15020@gmail.com
```

## Contact the Maintainers

Nisha Kumar: nishak@vmware.com
Rose Judge: rjudge@vmware.com
