# Tern Governance

This document defines the project governance for Tern.

## Overview

**Tern**, an open source project, is committed to building an open, inclusive, productive and self-governing open source community focused on building a high-quality and high performance container inspection tool. The community is governed by this document with the goal of defining how community should work together to achieve this goal.

## Community Roles

* **Users:** Members that engage with the Tern community via any medium (Slack, GitHub, mailing lists, etc.).
* **Contributors:** Regular contributions to projects (documentation, code reviews, responding to issues, participation in proposal discussions, contributing code, etc.). 
* **Maintainers**: The Tern project leaders. They are responsible for the overall health and direction of the project; final reviewers of PRs and responsible for releases. Maintainers are expected to contribute code and documentation, review PRs including ensuring quality of code, triage issues, proactively fix bugs, and perform maintenance tasks for Tern.

### Maintainers

New maintainers must be nominated by an existing maintainer and must be elected by a supermajority of existing maintainers. Likewise, maintainers can be removed by a supermajority of the existing maintainers or can resign by notifying one of the other maintainers.

### Decision Making

Ideally, all project decisions are resolved by consensus. If impossible, any maintainer may call a vote. Unless otherwise specified in this document, any vote will be decided by a supermajority of maintainers.

## Proposal Process

One of the most important aspects in any open source community is the concept of proposals. Large changes to the codebase and / or new features should be preceded by a proposal in the Tern repo via issue. This process allows for all members of the community to weigh in on the concept (including the technical details), share their comments and ideas, and offer to help. It also ensures that members are not duplicating work or inadvertently stepping on toes by making large conflicting changes.

The project roadmap is defined by accepted proposals.

Proposals should cover the high-level objectives, use cases, and technical recommendations on how to implement. In general, the community member(s) interested in implementing the proposal should be either deeply engaged in the proposal process or be an author of the proposal.


## Lazy Consensus

To maintain velocity in the Tern project, the concept of [Lazy Consensus](http://en.osswiki.info/concepts/lazy_consensus) is practiced. Lazy Consensus is practiced for all projects and decisions in the `tern-tools` org.

Lazy consensus does _not_ apply to the process of:
* Removal of maintainers from Tern
* Governance changes
* Adding new maintainers to Tern

For the above mentioned processes, consensus between @rnjudge and @nishakm is required until there are enough maintainers for a supermajority vote.

## Updating Governance

All substantive changes in Governance require a supermajority agreement by all maintainers.
