import setuptools
requires = ['numpy>=1.19.3']
from codecs import open
from os import path

here = path.abspath(path.dirname(__file__))
#with open("README.md", "r") as fh:
#    long_description = fh.read()

with open(path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setuptools.setup(
    name="Shape4D", # one's own name
    version="0.2.3",
    author="Liqun He, WanZheng He, Jun Hu",
    author_email="heliqun@ustc.edu.cn",
    description="A small library for visible 3D shapes",
    long_description=long_description,
    long_description_content_type='text/markdown',
    url="",
    include_package_data = True,
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
)