# PEP0440 compatible formatted version, see:
# https://www.python.org/dev/peps/pep-0440/
#
# Generic release markers:
#   X.Y.0   # For first release after an increment in Y
#   X.Y.Z   # For bugfix releases
#
# Admissible pre-release markers:
#   X.Y.ZaN   # Alpha release
#   X.Y.ZbN   # Beta release
#   X.Y.ZrcN  # Release Candidate
#   X.Y.Z     # Final release
#
# Dev branch marker is: 'X.Y.dev' or 'X.Y.devN' where N is an integer.
# 'X.Y.dev0' is the canonical version of 'X.Y.dev'
#
__version__ = "0.0.1"


__all__ = [
    'base', 'data', 'features_extractor', 'layers', 'ml_model', 'nn',
    'pipeline', 'plotting', 'preprocessing', 'utils', 'metrics'
]

from . import (
    base,
    data,
    features_extractor,
    layers,
    ml_model,
    nn,
    pipeline,
    plotting,
    preprocessing,
    utils,
    metrics
)
