## Python package *x3d*

This project creates the [Python X3D Package](https://www.web3d.org/x3d/stylesheets/python/python.html) which is available for import via [PyPi](https://pypi.org/project/x3d).

[Web3D Consortium](https://www.web3D.org) maintains this package under a BSD-style [open-source license](https://www.web3d.org/x3d/content/license.html).

### Package installation (choose one)

* *pip install x3d*
* *python -m pip install x3d*

### Package upgrade (choose one)
* *pip install x3d --upgrade*
* *python -m pip install x3d --upgrade*

### Developer Notes

* Package [x3d.py](http://www.web3d.org/x3d/stylesheets/python/x3d.py) provides full support for the [Extensible 3D (X3D) Graphics](https://www.web3D.org/x3d/what-x3d) International Standard.

* This package is also known as [X3DPSAIL, X3D Python Scene Access Interface Library](https://www.web3d.org/x3d/stylesheets/python/python.html).

* Code is autogenerated from [X3D Unified Object Model (X3DUOM)](http://www.web3d.org/specifications/X3DUOM.html) matching next-generation [X3D4](https://www.web3D.org/x3d4).


### Contact

* Package maintainers: [Don Brutzman and Loren Peitso NPS](mailto:brutzman@__nps.edu(Don%20Brutzman),lepeitso@__nps.edu(Loren%20Peitso)?subject=x3d.py%20package%20inquiry)

* Mail list: [x3d-public@web3D.org](mailto:x3d-public@__web3D.org?subject=x3d.py%20package%20inquiry) ([subscribe](http://www.web3d.org/mailman/listinfo/x3d-public_web3d.org))

* Designers: Don Brutzman and Loren Peitso, with contributions from John Carlson, Masaki Aono, and Myeong Won Lee
