# -*- coding: utf-8 -*-
# Generated by Django 1.11.26 on 2020-02-07 12:58
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('security', '0020_migration'),
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.CeleryTaskLog')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
            },
        ),
        migrations.CreateModel(
            name='CommandLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
            ],
            options={
                'db_tablespace': '',
            },
        ),
        migrations.CreateModel(
            name='InputLoggedRequestGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
            ],
            options={
                'db_tablespace': '',
            },
        ),
        migrations.CreateModel(
            name='OutputLoggedRequestGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
            },
        ),
        migrations.RemoveField(
            model_name='outputloggedrequestrelatedobjects',
            name='content_type',
        ),
        migrations.RemoveField(
            model_name='outputloggedrequestrelatedobjects',
            name='output_logged_request',
        ),
        migrations.AddField(
            model_name='celerytaskrunlog',
            name='time',
            field=models.FloatField(blank=True, null=True, verbose_name='time'),
        ),
        migrations.AddField(
            model_name='commandlog',
            name='time',
            field=models.FloatField(blank=True, null=True, verbose_name='time'),
        ),
        migrations.AddField(
            model_name='inputloggedrequest',
            name='response_time',
            field=models.FloatField(blank=True, null=True, verbose_name='response time'),
        ),
        migrations.AddField(
            model_name='outputloggedrequest',
            name='response_time',
            field=models.FloatField(blank=True, null=True, verbose_name='response time'),
        ),
        migrations.DeleteModel(
            name='OutputLoggedRequestRelatedObjects',
        ),
        migrations.AddField(
            model_name='outputloggedrequestgenericmanytomanyrelation',
            name='output_logged_request',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                    related_query_name='related_objects', to='security.OutputLoggedRequest'),
        ),
        migrations.AddField(
            model_name='inputloggedrequestgenericmanytomanyrelation',
            name='input_logged_request',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                    related_query_name='related_objects', to='security.InputLoggedRequest'),
        ),
        migrations.AddField(
            model_name='inputloggedrequestgenericmanytomanyrelation',
            name='object_ct',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                    verbose_name='content type of the related object'),
        ),
        migrations.AddField(
            model_name='commandloggenericmanytomanyrelation',
            name='command_log',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                    related_query_name='related_objects', to='security.CommandLog'),
        ),
        migrations.AddField(
            model_name='commandloggenericmanytomanyrelation',
            name='object_ct',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                    verbose_name='content type of the related object'),
        ),
        migrations.AlterUniqueTogether(
            name='outputloggedrequestgenericmanytomanyrelation',
            unique_together=set([('output_logged_request', 'object_ct', 'object_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='inputloggedrequestgenericmanytomanyrelation',
            unique_together=set([('input_logged_request', 'object_ct', 'object_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='commandloggenericmanytomanyrelation',
            unique_together=set([('command_log', 'object_ct', 'object_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='celerytaskloggenericmanytomanyrelation',
            unique_together=set([('celery_task_log', 'object_ct', 'object_id')]),
        ),
    ]
