# -*- coding: utf-8 -*-
# Generated by Django 1.11.24 on 2019-10-30 13:15
from __future__ import unicode_literals

from django.db.models import F
from django.db.models.functions import Cast
from django.db import migrations, models
import django.utils.timezone

import jsonfield.fields


def set_estimated_time_and_celery_task_id_fields(apps, schema_editor):
    CeleryTaskLog = apps.get_model('security', 'CeleryTaskLog')
    CeleryTaskLog.objects.all().update(
        estimated_time_of_arrival=F('created_at'),
        celery_task_id=Cast('id', models.CharField(max_length=250))
    )


class Migration(migrations.Migration):

    dependencies = [
        ('security', '0015_migration'),
    ]

    operations = [
        migrations.AddField(
            model_name='celerytasklog',
            name='estimated_time_of_arrival',
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name='estimated time of arrival'
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='retries',
            field=models.PositiveSmallIntegerField(default=0, verbose_name='retries'),
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='expires',
            field=models.DateTimeField(
                verbose_name='time of expiration', null=True, blank=True
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='task_args',
            field=jsonfield.fields.JSONField(blank=True, null=True, verbose_name='task args'),
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='task_kwargs',
            field=jsonfield.fields.JSONField(blank=True, null=True, verbose_name='task kwargs'),
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='celery_task_id',
            field=models.CharField(null=True, blank=True, max_length=250, verbose_name='celery ID'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='celerytasklog',
            name='stale',
            field=models.DateTimeField(blank=True, null=True, verbose_name='stale task time'),
        ),
        migrations.RunPython(set_estimated_time_and_celery_task_id_fields),
    ]
