"""Add client_type to Client

Revision ID: 1e8b2bc327a0
Revises: 8fca070a47d3
Create Date: 2022-04-04 09:41:41.201333

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

import fief

# revision identifiers, used by Alembic.
revision = "1e8b2bc327a0"
down_revision = "8fca070a47d3"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    try:
        client_type = postgresql.ENUM("public", "confidential", name="clienttype")
        client_type.create(op.get_bind(), checkfirst=True)
    except AttributeError:
        pass

    op.add_column(
        "fief_clients",
        sa.Column(
            "client_type",
            sa.Enum("public", "confidential", name="clienttype"),
            server_default="confidential",
            nullable=False,
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("fief_clients", "client_type")
    op.execute("DROP TYPE clienttype")
    # ### end Alembic commands ###
